/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.AbstractSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;

public class MethodSourceSinkDefinition
extends AbstractSourceSinkDefinition
implements IAccessPathBasedSourceSinkDefinition {
    private static MethodSourceSinkDefinition BASE_OBJ_SOURCE;
    private static MethodSourceSinkDefinition BASE_OBJ_SINK;
    private static MethodSourceSinkDefinition[] PARAM_OBJ_SOURCE;
    protected final SootMethodAndClass method;
    protected final CallType callType;
    protected Set<AccessPathTuple> baseObjects;
    protected Set<AccessPathTuple>[] parameters;
    protected Set<AccessPathTuple> returnValues;

    public MethodSourceSinkDefinition(Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues, CallType callType) {
        this(null, baseObjects, parameters, returnValues, callType);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am) {
        this(am, null, null, null, CallType.MethodCall);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am, CallType callType) {
        this(am, null, null, null, callType);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am, Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues, CallType callType) {
        this(am, baseObjects, parameters, returnValues, callType, null);
    }

    public MethodSourceSinkDefinition(SootMethodAndClass am, Set<AccessPathTuple> baseObjects, Set<AccessPathTuple>[] parameters, Set<AccessPathTuple> returnValues, CallType callType, ISourceSinkCategory category) {
        super(category);
        this.method = am;
        this.baseObjects = baseObjects == null || baseObjects.isEmpty() ? null : baseObjects;
        this.parameters = parameters;
        this.returnValues = returnValues == null || returnValues.isEmpty() ? null : returnValues;
        this.callType = callType;
    }

    public SootMethodAndClass getMethod() {
        return this.method;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public Set<AccessPathTuple> getBaseObjects() {
        return this.baseObjects;
    }

    public int getBaseObjectCount() {
        return this.baseObjects == null ? 0 : this.baseObjects.size();
    }

    public Set<AccessPathTuple>[] getParameters() {
        return this.parameters;
    }

    public int getParameterCount() {
        if (this.parameters == null || this.parameters.length == 0) {
            return 0;
        }
        int cnt = 0;
        for (Set<AccessPathTuple> apt : this.parameters) {
            cnt += apt.size();
        }
        return cnt;
    }

    public Set<AccessPathTuple> getReturnValues() {
        return this.returnValues;
    }

    public int getReturnValueCount() {
        return this.returnValues == null ? 0 : this.returnValues.size();
    }

    @Override
    public boolean isEmpty() {
        boolean parametersEmpty = true;
        if (this.parameters != null) {
            for (Set<AccessPathTuple> paramSet : this.parameters) {
                if (paramSet == null || paramSet.isEmpty()) continue;
                parametersEmpty = false;
                break;
            }
        }
        return !(this.baseObjects != null && !this.baseObjects.isEmpty() || !parametersEmpty || this.returnValues != null && !this.returnValues.isEmpty());
    }

    public String toString() {
        return this.method == null ? "<no method>" : this.method.getSignature();
    }

    @Override
    public MethodSourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> baseSources = null;
        if (this.baseObjects != null) {
            baseSources = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.getSourceSinkType().isSource()) continue;
                baseSources.add(apt);
            }
        }
        Set[] paramSources = null;
        if (this.parameters != null && this.parameters.length > 0) {
            paramSources = new Set[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                HashSet<AccessPathTuple> thisParam;
                Set<AccessPathTuple> aptSet = this.parameters[i];
                if (aptSet == null) continue;
                paramSources[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
                for (AccessPathTuple apt : aptSet) {
                    if (!apt.getSourceSinkType().isSource()) continue;
                    thisParam.add(apt);
                }
            }
        }
        HashSet<AccessPathTuple> returnSources = null;
        if (this.returnValues != null) {
            returnSources = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.getSourceSinkType().isSource()) continue;
                returnSources.add(apt);
            }
        }
        MethodSourceSinkDefinition mssd = this.buildNewDefinition(baseSources, paramSources, returnSources);
        return mssd;
    }

    @Override
    public MethodSourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> baseSinks = null;
        if (this.baseObjects != null) {
            baseSinks = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple apt : this.baseObjects) {
                if (!apt.getSourceSinkType().isSink()) continue;
                baseSinks.add(apt);
            }
        }
        Set[] paramSinks = null;
        if (this.parameters != null) {
            paramSinks = new Set[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                HashSet<AccessPathTuple> thisParam;
                Set<AccessPathTuple> aptSet = this.parameters[i];
                if (aptSet == null) continue;
                paramSinks[i] = thisParam = new HashSet<AccessPathTuple>(aptSet.size());
                for (AccessPathTuple apt : aptSet) {
                    if (!apt.getSourceSinkType().isSink()) continue;
                    thisParam.add(apt);
                }
            }
        }
        HashSet<AccessPathTuple> returnSinks = null;
        if (this.returnValues != null) {
            returnSinks = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple apt : this.returnValues) {
                if (!apt.getSourceSinkType().isSink()) continue;
                returnSinks.add(apt);
            }
        }
        MethodSourceSinkDefinition mssd = this.buildNewDefinition(baseSinks, paramSinks, returnSinks);
        return mssd;
    }

    protected MethodSourceSinkDefinition buildNewDefinition(Set<AccessPathTuple> baseAPTs, Set<AccessPathTuple>[] paramAPTs, Set<AccessPathTuple> returnAPTs) {
        MethodSourceSinkDefinition def = this.buildNewDefinition(this.method, baseAPTs, paramAPTs, returnAPTs, this.callType);
        def.category = this.category;
        def.conditions = this.conditions;
        return def;
    }

    protected MethodSourceSinkDefinition buildNewDefinition(SootMethodAndClass methodAndclass, Set<AccessPathTuple> filteredBaseObjects, Set<AccessPathTuple>[] filteredParameters, Set<AccessPathTuple> filteredReturnValues, CallType callType) {
        return new MethodSourceSinkDefinition(methodAndclass, filteredBaseObjects, filteredParameters, filteredReturnValues, callType);
    }

    public void addParameterDefinition(int paramIdx, Set<AccessPathTuple> paramDefs) {
        if (paramDefs != null && !paramDefs.isEmpty()) {
            Set<AccessPathTuple> aps;
            Set<AccessPathTuple>[] oldSet = this.parameters;
            if (oldSet.length <= paramIdx) {
                Set[] newSet = new Set[paramIdx + 1];
                System.arraycopy(oldSet, 0, newSet, 0, paramIdx);
                this.parameters = newSet;
            }
            if ((aps = this.parameters[paramIdx]) == null) {
                this.parameters[paramIdx] = aps = new HashSet<AccessPathTuple>(paramDefs.size());
            }
            aps.addAll(paramDefs);
        }
    }

    public MethodSourceSinkDefinition getBaseObjectSource() {
        if (BASE_OBJ_SOURCE == null) {
            BASE_OBJ_SOURCE = new MethodSourceSinkDefinition(Collections.singleton(AccessPathTuple.getBlankSourceTuple()), null, null, CallType.MethodCall);
        }
        return BASE_OBJ_SOURCE;
    }

    public MethodSourceSinkDefinition getBaseObjectSink() {
        if (BASE_OBJ_SINK == null) {
            BASE_OBJ_SINK = new MethodSourceSinkDefinition(Collections.singleton(AccessPathTuple.getBlankSinkTuple()), null, null, CallType.MethodCall);
        }
        return BASE_OBJ_SINK;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseObjects == null ? 0 : this.baseObjects.hashCode());
        result = 31 * result + (this.callType == null ? 0 : this.callType.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + (this.returnValues == null ? 0 : this.returnValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSourceSinkDefinition other = (MethodSourceSinkDefinition)obj;
        if (this.baseObjects == null ? other.baseObjects != null : !this.baseObjects.equals(other.baseObjects)) {
            return false;
        }
        if (this.callType != other.callType) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (!Arrays.equals(this.parameters, other.parameters)) {
            return false;
        }
        return !(this.returnValues == null ? other.returnValues != null : !this.returnValues.equals(other.returnValues));
    }

    public static MethodSourceSinkDefinition createParameterSource(int index, CallType callType) {
        if (index < 5 && callType == CallType.MethodCall) {
            MethodSourceSinkDefinition def = PARAM_OBJ_SOURCE[index];
            if (def == null) {
                Set[] params = new Set[index + 1];
                params[index] = Collections.singleton(AccessPathTuple.getBlankSourceTuple());
                MethodSourceSinkDefinition.PARAM_OBJ_SOURCE[index] = def = new MethodSourceSinkDefinition(null, params, null, callType);
            }
            return def;
        }
        return new MethodSourceSinkDefinition(null, new Set[]{Collections.singleton(AccessPathTuple.getBlankSourceTuple())}, null, callType);
    }

    public static MethodSourceSinkDefinition createReturnSource(CallType callType) {
        return new MethodSourceSinkDefinition(null, null, Collections.singleton(AccessPathTuple.getBlankSourceTuple()), callType);
    }

    public MethodSourceSinkDefinition simplify() {
        MethodSourceSinkDefinition baseObjSource = this.getBaseObjectSource();
        MethodSourceSinkDefinition baseObjSink = this.getBaseObjectSink();
        if (this.equals(baseObjSource)) {
            return baseObjSource;
        }
        if (this.equals(baseObjSink)) {
            return baseObjSink;
        }
        for (int i = 0; i < PARAM_OBJ_SOURCE.length; ++i) {
            MethodSourceSinkDefinition def = MethodSourceSinkDefinition.createParameterSource(i, this.getCallType());
            if (!this.equals(def)) continue;
            return def;
        }
        return this;
    }

    @Override
    public Set<AccessPathTuple> getAllAccessPaths() {
        HashSet<AccessPathTuple> aps = new HashSet<AccessPathTuple>();
        if (this.baseObjects != null && !this.baseObjects.isEmpty()) {
            aps.addAll(this.baseObjects);
        }
        if (this.returnValues != null && !this.returnValues.isEmpty()) {
            aps.addAll(this.returnValues);
        }
        if (this.parameters != null && this.parameters.length > 0) {
            for (Set<AccessPathTuple> paramAPs : this.parameters) {
                if (paramAPs == null || paramAPs.isEmpty()) continue;
                aps.addAll(paramAPs);
            }
        }
        return aps;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodSourceSinkDefinition filter(Collection<AccessPathTuple> accessPaths) {
        void var4_9;
        HashSet<AccessPathTuple> filteredBaseObjects = null;
        if (this.baseObjects != null && !this.baseObjects.isEmpty()) {
            filteredBaseObjects = new HashSet<AccessPathTuple>(this.baseObjects.size());
            for (AccessPathTuple accessPathTuple : this.baseObjects) {
                if (!accessPaths.contains(accessPathTuple)) continue;
                filteredBaseObjects.add(accessPathTuple);
            }
        }
        HashSet<AccessPathTuple> filteredReturnValues = null;
        if (this.returnValues != null && !this.returnValues.isEmpty()) {
            filteredReturnValues = new HashSet<AccessPathTuple>(this.returnValues.size());
            for (AccessPathTuple ap : this.returnValues) {
                if (!accessPaths.contains(ap)) continue;
                filteredReturnValues.add(ap);
            }
        }
        Object var4_7 = null;
        if (this.parameters != null && this.parameters.length > 0) {
            Set[] setArray = new Set[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null || this.parameters[i].isEmpty()) continue;
                setArray[i] = new HashSet();
                for (AccessPathTuple ap : this.parameters[i]) {
                    if (!accessPaths.contains(ap)) continue;
                    setArray[i].add(ap);
                }
            }
        }
        MethodSourceSinkDefinition def = this.buildNewDefinition(this.method, (Set<AccessPathTuple>)filteredBaseObjects, (Set<AccessPathTuple>[])var4_9, (Set<AccessPathTuple>)filteredReturnValues, this.callType);
        def.setCategory(this.category);
        def.setConditions(this.conditions);
        return def;
    }

    static {
        PARAM_OBJ_SOURCE = new MethodSourceSinkDefinition[5];
    }

    public static enum CallType {
        MethodCall,
        Callback,
        Return;

    }
}

