/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.sparseSolver.propagation;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.sparseSolver.propagation.IPropagationStrategy;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public abstract class AbstractSparsePropagation
implements IPropagationStrategy<Unit, Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>> {
    protected final BiDiInterproceduralCFG<Unit, SootMethod> iCfg;
    protected final AbstractInfoflowProblem problem;
    private final ConcurrentHashMap<SCFGNode, Collection<Unit>> sparseCfg = new ConcurrentHashMap();

    protected AbstractSparsePropagation(AbstractInfoflowProblem problem) {
        this.problem = problem;
        this.iCfg = problem.interproceduralCFG();
    }

    private Collection<Unit> computeSuccessors(SCFGNode node) {
        HashSet<Unit> succs = new HashSet<Unit>();
        ArrayDeque<Unit> stack = new ArrayDeque<Unit>();
        HashSet<Unit> visited = new HashSet<Unit>();
        for (Unit succ : this.iCfg.getSuccsOf(node.unit)) {
            stack.push(succ);
        }
        while (!stack.isEmpty()) {
            Unit current = (Unit)stack.pop();
            if (!visited.add(current)) continue;
            Stmt stmt = (Stmt)current;
            if (node.isAffectedBy(current)) {
                succs.add(stmt);
                continue;
            }
            for (Unit succ : this.iCfg.getSuccsOf(current)) {
                stack.push(succ);
            }
        }
        return succs;
    }

    protected Collection<Unit> getSuccessors(SCFGNode node) {
        return this.sparseCfg.computeIfAbsent(node, this::computeSuccessors);
    }

    protected abstract class SCFGNode {
        protected final Unit unit;
        protected final Local local;
        protected final SootField field;
        protected final Unit activationUnit;
        protected final Unit turnUnit;

        protected SCFGNode(Unit unit, Local local, SootField field, Unit activationUnit, Unit turnUnit) {
            this.unit = unit;
            this.local = local;
            this.field = field;
            this.activationUnit = activationUnit;
            this.turnUnit = turnUnit;
        }

        public boolean isAffectedBy(Unit unit) {
            if (this.requiredForFlowSensitivity(unit)) {
                return true;
            }
            if (AbstractSparsePropagation.this.iCfg.isExitStmt(unit)) {
                return true;
            }
            return this.isAffectedByInternal(unit);
        }

        protected abstract boolean isAffectedByInternal(Unit var1);

        protected boolean requiredForFlowSensitivity(Unit unit) {
            SootMethod turnM;
            boolean forwardFlowSensitivity;
            boolean bl = forwardFlowSensitivity = this.activationUnit != null && (this.activationUnit == unit || AbstractSparsePropagation.this.problem.isCallSiteActivatingTaint(unit, this.activationUnit));
            if (forwardFlowSensitivity) {
                return true;
            }
            boolean backwardFlowSensitivity = this.turnUnit != null && (turnM = (SootMethod)AbstractSparsePropagation.this.iCfg.getMethodOf(this.turnUnit)) != null && (this.turnUnit == unit || AbstractSparsePropagation.this.iCfg.getCalleesOfCallAt(unit).stream().anyMatch(sm -> sm == turnM));
            return backwardFlowSensitivity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SCFGNode SCFGNode2 = (SCFGNode)o;
            return Objects.equals(this.unit, SCFGNode2.unit) && Objects.equals(this.local, SCFGNode2.local) && Objects.equals(this.field, SCFGNode2.field) && Objects.equals(this.activationUnit, SCFGNode2.activationUnit) && Objects.equals(this.turnUnit, SCFGNode2.turnUnit);
        }

        public int hashCode() {
            return Objects.hash(this.unit, this.local, this.field, this.activationUnit, this.turnUnit);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.local != null) {
                sb.append(this.local);
            }
            if (this.local != null && this.field != null) {
                sb.append(".");
            }
            if (this.field != null) {
                sb.append(this.field);
            }
            sb.append(" @ ").append(this.unit);
            return sb.toString();
        }
    }

    protected class SCFGExceptionNode
    extends SCFGNode {
        protected SCFGExceptionNode(Unit unit, Abstraction abs) {
            super(unit, null, null, abs.getActivationUnit(), abs.getTurnUnit());
        }

        @Override
        protected boolean isAffectedByInternal(Unit unit) {
            if (this.turnUnit == null) {
                return unit instanceof IdentityStmt && ((IdentityStmt)unit).getRightOp() instanceof CaughtExceptionRef;
            }
            return unit instanceof InvokeStmt || unit instanceof ThrowStmt;
        }
    }
}

