/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver.fpc;

import heros.solver.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import soot.SootMethod;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.solver.gcSolver.fpc.IGraph;

public class AbstrationDependencyGraph<D>
implements IGraph<Pair<SootMethod, D>> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Set<Pair<SootMethod, D>> nodes = new ConcurrentHashSet<Pair<SootMethod, D>>();
    private final Map<Pair<SootMethod, D>, Set<Pair<SootMethod, D>>> succMap = new ConcurrentHashMap<Pair<SootMethod, D>, Set<Pair<SootMethod, D>>>();
    private final Map<Pair<SootMethod, D>, Set<Pair<SootMethod, D>>> predMap = new ConcurrentHashMap<Pair<SootMethod, D>, Set<Pair<SootMethod, D>>>();

    @Override
    public Set<Pair<SootMethod, D>> getNodes() {
        return this.nodes;
    }

    @Override
    public Set<Pair<SootMethod, D>> succsOf(Pair<SootMethod, D> node) {
        return this.succMap.getOrDefault(node, Collections.emptySet());
    }

    @Override
    public Set<Pair<SootMethod, D>> predsOf(Pair<SootMethod, D> node) {
        return this.predMap.getOrDefault(node, Collections.emptySet());
    }

    @Override
    public void addNode(Pair<SootMethod, D> node) {
        this.nodes.add(node);
    }

    @Override
    public void addEdge(Pair<SootMethod, D> n1, Pair<SootMethod, D> n2) {
        this.addNode(n1);
        this.addNode(n2);
        this.succMap.computeIfAbsent(n1, k -> new ConcurrentHashSet()).add(n2);
        this.predMap.computeIfAbsent(n2, k -> new ConcurrentHashSet()).add(n1);
    }

    @Override
    public boolean contains(Pair<SootMethod, D> node) {
        return this.nodes.contains(node);
    }

    @Override
    public void removeEdge(Pair<SootMethod, D> n1, Pair<SootMethod, D> n2) {
        this.succsOf(n1).remove(n2);
        this.predsOf(n2).remove(n1);
    }

    @Override
    public void remove(Pair<SootMethod, D> node) {
        this.nodes.remove(node);
        for (Pair<SootMethod, D> pred : this.predsOf(node)) {
            this.removeEdge(pred, node);
        }
        for (Pair<SootMethod, D> succ : this.succsOf(node)) {
            this.removeEdge(node, succ);
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public int nodeSize() {
        return this.nodes.size();
    }

    public int edgeSize() {
        int ret = 0;
        for (Set<Pair<SootMethod, D>> vs : this.succMap.values()) {
            ret += vs.size();
        }
        return ret;
    }

    public Set<Pair<SootMethod, D>> reachableClosure(Pair<SootMethod, D> source) {
        ConcurrentHashSet visited = new ConcurrentHashSet();
        ArrayDeque<Pair<SootMethod, D>> stack = new ArrayDeque<Pair<SootMethod, D>>();
        stack.push(source);
        while (!stack.isEmpty()) {
            Pair node = (Pair)stack.pop();
            visited.add(node);
            this.succsOf(node).stream().filter(n -> !visited.contains(n)).forEach(stack::push);
        }
        return visited;
    }
}

