/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import heros.solver.PathEdge;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.infoflow.collect.ConcurrentCountingMap;
import soot.jimple.infoflow.solver.gcSolver.AbstractReferenceCountingGarbageCollector;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.infoflow.solver.gcSolver.OnDemandReferenceProvider;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class MethodLevelReferenceCountingGarbageCollector<N, D>
extends AbstractReferenceCountingGarbageCollector<N, D, SootMethod> {
    public MethodLevelReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions, IGCReferenceProvider<SootMethod> referenceProvider) {
        super(icfg, jumpFunctions, referenceProvider);
    }

    public MethodLevelReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions) {
        super(icfg, jumpFunctions);
    }

    private boolean hasActiveDependencies(SootMethod method, ConcurrentCountingMap<SootMethod> referenceCounter) {
        int changeCounter = -1;
        do {
            changeCounter = referenceCounter.getChangeCounter();
            if (referenceCounter.get(method) > 0) {
                return true;
            }
            Set<SootMethod> references = this.referenceProvider.getAbstractionReferences(method);
            for (SootMethod ref : references) {
                if (referenceCounter.get(ref) <= 0) continue;
                return true;
            }
        } while (this.checkChangeCounter && changeCounter != referenceCounter.getChangeCounter());
        return false;
    }

    @Override
    public boolean hasActiveDependencies(SootMethod method) {
        return this.hasActiveDependencies(method, this.jumpFnCounter);
    }

    @Override
    protected SootMethod genAbstraction(PathEdge<N, D> edge) {
        return (SootMethod)this.icfg.getMethodOf(edge.getTarget());
    }

    @Override
    public void gc() {
    }

    @Override
    public void notifySolverTerminated() {
    }

    @Override
    protected IGCReferenceProvider<SootMethod> createReferenceProvider() {
        return new OnDemandReferenceProvider(this.icfg);
    }
}

