/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import heros.solver.PathEdge;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.SootMethod;
import soot.jimple.infoflow.collect.ConcurrentCountingMap;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.solver.gcSolver.AbstractGarbageCollector;
import soot.jimple.infoflow.solver.gcSolver.GarbageCollectionTrigger;
import soot.jimple.infoflow.solver.gcSolver.GarbageCollectorPeerGroup;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.infoflow.solver.gcSolver.IGarbageCollectorPeer;
import soot.jimple.infoflow.util.ExtendedAtomicInteger;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public abstract class AbstractReferenceCountingGarbageCollector<N, D, A>
extends AbstractGarbageCollector<N, D, A>
implements IGarbageCollectorPeer<A> {
    protected ConcurrentCountingMap<A> jumpFnCounter = new ConcurrentCountingMap();
    protected final Set<A> gcScheduleSet = new ConcurrentHashSet<A>();
    protected final AtomicInteger gcedAbstractions = new AtomicInteger();
    protected final AtomicInteger gcedEdges = new AtomicInteger();
    protected final ExtendedAtomicInteger edgeCounterForThreshold = new ExtendedAtomicInteger();
    protected GarbageCollectionTrigger trigger = GarbageCollectionTrigger.Immediate;
    protected GarbageCollectorPeerGroup<A> peerGroup = null;
    protected boolean checkChangeCounter = false;
    protected boolean validateEdges = false;
    protected Set<PathEdge<N, D>> oldEdges = new HashSet<PathEdge<N, D>>();
    protected int methodThreshold = 0;
    protected int edgeThreshold = 0;

    public AbstractReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<A, PathEdge<N, D>> jumpFunctions, IGCReferenceProvider<A> referenceProvider) {
        super(icfg, jumpFunctions, referenceProvider);
    }

    public AbstractReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<A, PathEdge<N, D>> jumpFunctions) {
        super(icfg, jumpFunctions);
    }

    protected abstract A genAbstraction(PathEdge<N, D> var1);

    @Override
    public void notifyEdgeSchedule(PathEdge<N, D> edge) {
        A abstraction = this.genAbstraction(edge);
        this.jumpFnCounter.increment(abstraction);
        this.gcScheduleSet.add(abstraction);
        if (this.trigger == GarbageCollectionTrigger.EdgeThreshold) {
            this.edgeCounterForThreshold.incrementAndGet();
        }
        if (this.validateEdges && this.oldEdges.contains(edge)) {
            System.out.println("Edge re-scheduled");
        }
    }

    @Override
    public void notifyTaskProcessed(PathEdge<N, D> edge) {
        A abstraction = this.genAbstraction(edge);
        this.jumpFnCounter.decrement(abstraction);
    }

    protected void gcImmediate() {
        if (this.gcScheduleSet != null && !this.gcScheduleSet.isEmpty()) {
            boolean gc = this.trigger == GarbageCollectionTrigger.Immediate;
            gc |= this.trigger == GarbageCollectionTrigger.MethodThreshold && this.gcScheduleSet.size() > this.methodThreshold;
            if (gc |= this.trigger == GarbageCollectionTrigger.EdgeThreshold && this.edgeCounterForThreshold.get() > this.edgeThreshold) {
                this.onBeforeRemoveEdges();
                for (A abst : this.gcScheduleSet) {
                    if (this.peerGroup == null ? this.hasActiveDependencies(abst) : this.peerGroup.hasActiveDependencies(abst)) continue;
                    Set oldFunctions = this.jumpFunctions.get(abst);
                    if (oldFunctions != null) {
                        int gcedSize = oldFunctions.size();
                        this.gcedEdges.addAndGet(gcedSize);
                        if (this.trigger == GarbageCollectionTrigger.EdgeThreshold) {
                            this.edgeCounterForThreshold.subtract(gcedSize);
                        }
                    }
                    this.gcScheduleSet.remove(abst);
                    if (!this.jumpFunctions.remove(abst)) continue;
                    this.gcedAbstractions.incrementAndGet();
                    if (!this.validateEdges) continue;
                    this.oldEdges.addAll(oldFunctions);
                }
                this.onAfterRemoveEdges();
            }
        }
    }

    protected void onBeforeRemoveEdges() {
    }

    protected void onAfterRemoveEdges() {
    }

    @Override
    public int getGcedAbstractions() {
        return this.gcedAbstractions.get();
    }

    @Override
    public int getGcedEdges() {
        return this.gcedEdges.get();
    }

    public void setMethodThreshold(int threshold) {
        this.methodThreshold = threshold;
    }

    public void setEdgeThreshold(int threshold) {
        this.edgeThreshold = threshold;
    }

    public void setTrigger(GarbageCollectionTrigger trigger) {
        this.trigger = trigger;
    }

    public void setPeerGroup(GarbageCollectorPeerGroup<A> peerGroup) {
        this.peerGroup = peerGroup;
        peerGroup.addGarbageCollector(this);
    }

    public void setCheckChangeCounter(boolean checkChangeCounter) {
        this.checkChangeCounter = checkChangeCounter;
    }
}

