/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.river;

import heros.solver.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.Stmt;
import soot.jimple.infoflow.results.DataFlowResult;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.river.ConditionalSecondarySourceDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkCondition;
import soot.util.MultiMap;

public class AdditionalFlowCondition
extends SourceSinkCondition {
    private final Set<String> classNamesOnPath;
    private final Set<String> signaturesOnPath;
    private final Set<String> excludedClassNames;
    private Set<SootMethod> methodsOnPath = null;
    private Set<SootClass> classesOnPath = null;
    private Set<SootClass> excludedClasses = null;

    public AdditionalFlowCondition(Set<String> classNamesOnPath, Set<String> signaturesOnPath, Set<String> excludedClassNames) {
        this.classNamesOnPath = classNamesOnPath;
        this.signaturesOnPath = signaturesOnPath;
        this.excludedClassNames = excludedClassNames;
    }

    @Override
    public boolean evaluate(DataFlowResult result, InfoflowResults results) {
        if (this.isEmpty()) {
            return true;
        }
        MultiMap<ResultSinkInfo, ResultSourceInfo> additionalResults = results.getAdditionalResults();
        if (additionalResults == null || additionalResults.isEmpty()) {
            return false;
        }
        Stmt sinkStmt = result.getSink().getStmt();
        Type baseType = result.getSource().getAccessPath().getBaseType();
        this.ensureSootClassesOfExcludedClasses();
        if (this.classMatches(baseType.toString(), this.excludedClasses)) {
            return false;
        }
        Pair<Set<String>, Set<String>> flows = this.getSignaturesAndClassNamesReachedFromSink(additionalResults, sinkStmt);
        this.ensureSootMethodsOnPath();
        boolean sigMatch = this.signaturesOnPath == null || this.signaturesOnPath.isEmpty() || flows.getO1().stream().anyMatch(this::signatureMatches);
        this.ensureSootClassesOnPath();
        boolean classMatch = this.classesOnPath == null || this.classesOnPath.isEmpty() || flows.getO2().stream().anyMatch(c -> this.classMatches((String)c, this.classesOnPath));
        return sigMatch && classMatch;
    }

    private boolean signatureMatches(String sig) {
        SootMethod sm = Scene.v().grabMethod(sig);
        if (sm == null) {
            return false;
        }
        if (this.methodsOnPath.contains(sm)) {
            return true;
        }
        for (SootClass ifc : sm.getDeclaringClass().getInterfaces()) {
            SootMethod superMethod = ifc.getMethodUnsafe(sm.getSubSignature());
            if (superMethod == null || !this.methodsOnPath.contains(superMethod)) continue;
            return true;
        }
        for (SootClass superClass = sm.getDeclaringClass().getSuperclassUnsafe(); superClass != null; superClass = superClass.getSuperclassUnsafe()) {
            SootMethod superMethod = superClass.getMethodUnsafe(sm.getSubSignature());
            if (superMethod == null || !this.methodsOnPath.contains(superMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean classMatches(String sig, Set<SootClass> classes) {
        SootClass sc = Scene.v().getSootClassUnsafe(sig);
        if (sc == null) {
            return false;
        }
        if (classes.contains(sc)) {
            return true;
        }
        for (SootClass ifc : sc.getInterfaces()) {
            if (!classes.contains(ifc)) continue;
            return true;
        }
        for (SootClass superClass = sc.getSuperclassUnsafe(); superClass != null; superClass = superClass.getSuperclassUnsafe()) {
            if (!classes.contains(superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<SootMethod> getReferencedMethods() {
        this.ensureSootMethodsOnPath();
        return this.methodsOnPath;
    }

    @Override
    public Set<SootClass> getReferencedClasses() {
        this.ensureSootClassesOnPath();
        return this.classesOnPath;
    }

    @Override
    public Set<SootClass> getExcludedClasses() {
        this.ensureSootClassesOfExcludedClasses();
        return this.excludedClasses;
    }

    public Set<String> getSignaturesOnPath() {
        return Collections.unmodifiableSet(this.signaturesOnPath);
    }

    public Set<String> getClassNamesOnPath() {
        return Collections.unmodifiableSet(this.classNamesOnPath);
    }

    public Set<String> getExcludedClassNames() {
        return Collections.unmodifiableSet(this.excludedClassNames);
    }

    private void ensureSootMethodsOnPath() {
        if (this.methodsOnPath == null) {
            this.methodsOnPath = new HashSet<SootMethod>();
            if (this.signaturesOnPath != null && !this.signaturesOnPath.isEmpty()) {
                for (String sig : this.signaturesOnPath) {
                    SootMethod sm = Scene.v().grabMethod(sig);
                    if (sm == null) continue;
                    this.methodsOnPath.add(sm);
                }
            }
        }
    }

    private void ensureSootClassesOnPath() {
        if (this.classesOnPath == null) {
            this.classesOnPath = this.resolveSootClassesToSet(this.classNamesOnPath);
        }
    }

    private void ensureSootClassesOfExcludedClasses() {
        if (this.excludedClasses == null) {
            this.excludedClasses = this.resolveSootClassesToSet(this.excludedClassNames);
        }
    }

    private Set<SootClass> resolveSootClassesToSet(Set<String> classNameSet) {
        HashSet<SootClass> resolved = new HashSet<SootClass>();
        if (classNameSet != null && !classNameSet.isEmpty()) {
            for (String className : classNameSet) {
                SootClass sc = Scene.v().getSootClassUnsafe(className);
                if (sc == null) continue;
                resolved.add(sc);
            }
        }
        return resolved;
    }

    private Pair<Set<String>, Set<String>> getSignaturesAndClassNamesReachedFromSink(MultiMap<ResultSinkInfo, ResultSourceInfo> additionalResults, Stmt primarySinkStmt) {
        HashSet<String> sigSet = new HashSet<String>();
        HashSet<String> classSet = new HashSet<String>();
        for (ResultSinkInfo secondarySinkInfo : additionalResults.keySet()) {
            for (ResultSourceInfo secondarySourceInfo : additionalResults.get(secondarySinkInfo)) {
                Stmt[] path;
                if (secondarySourceInfo.getStmt() != primarySinkStmt || !(secondarySourceInfo.getDefinition() instanceof ConditionalSecondarySourceDefinition)) continue;
                if (secondarySourceInfo.getPath() == null) {
                    SootMethod callee = secondarySinkInfo.getStmt().getInvokeExpr().getMethod();
                    sigSet.add(callee.getSignature());
                    classSet.add(callee.getDeclaringClass().getName());
                    continue;
                }
                for (Stmt stmt : path = secondarySourceInfo.getPath()) {
                    if (!stmt.containsInvokeExpr()) continue;
                    SootMethod callee = stmt.getInvokeExpr().getMethod();
                    sigSet.add(callee.getSignature());
                    classSet.add(callee.getDeclaringClass().getName());
                }
            }
        }
        return new Pair<Set<String>, Set<String>>(sigSet, classSet);
    }

    public boolean isEmpty() {
        return !(this.classNamesOnPath != null && !this.classNamesOnPath.isEmpty() || this.signaturesOnPath != null && !this.signaturesOnPath.isEmpty());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classNamesOnPath == null ? 0 : this.classNamesOnPath.hashCode());
        result = 31 * result + (this.signaturesOnPath == null ? 0 : this.signaturesOnPath.hashCode());
        result = 31 * result + (this.excludedClassNames == null ? 0 : this.excludedClassNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdditionalFlowCondition other = (AdditionalFlowCondition)obj;
        if (this.classNamesOnPath == null ? other.classNamesOnPath != null : !this.classNamesOnPath.equals(other.classNamesOnPath)) {
            return false;
        }
        if (this.signaturesOnPath == null ? other.signaturesOnPath != null : !this.signaturesOnPath.equals(other.signaturesOnPath)) {
            return false;
        }
        return !(this.excludedClassNames == null ? other.excludedClassNames != null : !this.excludedClassNames.equals(other.excludedClassNames));
    }

    public String toString() {
        return "AdditionalFlowCondition: classNamesOnPath=" + this.classNamesOnPath + ", signaturesOnPath=" + this.signaturesOnPath + ", excludedClasses=" + this.excludedClassNames;
    }
}

