/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import heros.solver.Pair;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.results.DataFlowResult;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.river.SecondarySinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class InfoflowResults {
    public static final int TERMINATION_SUCCESS = 0;
    public static final int TERMINATION_DATA_FLOW_TIMEOUT = 1;
    public static final int TERMINATION_DATA_FLOW_OOM = 2;
    public static final int TERMINATION_PATH_RECONSTRUCTION_TIMEOUT = 4;
    public static final int TERMINATION_PATH_RECONSTRUCTION_OOM = 8;
    private static final Logger logger = LoggerFactory.getLogger(InfoflowResults.class);
    protected volatile MultiMap<ResultSinkInfo, ResultSourceInfo> results = null;
    protected volatile MultiMap<ResultSinkInfo, ResultSourceInfo> additionalResults = null;
    protected volatile InfoflowPerformanceData performanceData = null;
    protected volatile List<String> exceptions = null;
    protected int terminationState = 0;
    protected volatile boolean pathAgnosticResults = true;

    public InfoflowResults() {
    }

    public InfoflowResults(boolean pathAgnosticResults) {
        this.pathAgnosticResults = pathAgnosticResults;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(String ex) {
        if (this.exceptions == null) {
            InfoflowResults infoflowResults = this;
            synchronized (infoflowResults) {
                if (this.exceptions == null) {
                    this.exceptions = new ArrayList<String>();
                }
            }
        }
        this.exceptions.add(ex);
    }

    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    public int numConnections() {
        int num = 0;
        if (this.results != null) {
            for (ResultSinkInfo sink : this.results.keySet()) {
                num += this.results.get(sink).size();
            }
        }
        return num;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public boolean containsSink(Stmt sink) {
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getStmt().equals(sink)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSinkMethod(String sinkSignature) {
        return !this.findSinkByMethodSignature(sinkSignature).isEmpty();
    }

    public void addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt) {
        for (ISourceSinkDefinition sourceDefinition : sourceDefinitions) {
            for (ISourceSinkDefinition sinkDefinition : sinkDefinitions) {
                this.addResult(new ResultSinkInfo(sinkDefinition, sink, sinkStmt), new ResultSourceInfo(sourceDefinition, source, sourceStmt, this.pathAgnosticResults));
            }
        }
    }

    public Collection<Pair<ResultSourceInfo, ResultSinkInfo>> addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt, Object userData, List<Abstraction> propagationPath, InfoflowManager manager) {
        ArrayList<Stmt> stmtPath = null;
        ArrayList<AccessPath> apPath = null;
        ArrayList<Stmt> csPath = null;
        if (propagationPath != null) {
            stmtPath = new ArrayList<Stmt>(propagationPath.size());
            apPath = new ArrayList<AccessPath>(propagationPath.size());
            if (!manager.getConfig().getPathAgnosticResults()) {
                csPath = new ArrayList<Stmt>(propagationPath.size());
            }
            for (Abstraction pathAbs : propagationPath) {
                if (pathAbs.getCurrentStmt() == null) continue;
                stmtPath.add(pathAbs.getCurrentStmt());
                apPath.add(pathAbs.getAccessPath());
                if (csPath == null) continue;
                csPath.add(pathAbs.getCorrespondingCallSite());
            }
        }
        return this.addResult(sinkDefinitions, sink, sinkStmt, sourceDefinitions, source, sourceStmt, userData, stmtPath, apPath, csPath, manager);
    }

    public Collection<Pair<ResultSourceInfo, ResultSinkInfo>> addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath, List<AccessPath> propagationAccessPath, List<Stmt> propagationCallSites) {
        return this.addResult(sinkDefinitions, sink, sinkStmt, sourceDefinitions, source, sourceStmt, userData, propagationPath, propagationAccessPath, propagationCallSites, null);
    }

    public Collection<Pair<ResultSourceInfo, ResultSinkInfo>> addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath, List<AccessPath> propagationAccessPath, List<Stmt> propagationCallSites, InfoflowManager manager) {
        HashSet<Pair<ResultSourceInfo, ResultSinkInfo>> results = new HashSet<Pair<ResultSourceInfo, ResultSinkInfo>>(sinkDefinitions.size() * sourceDefinitions.size());
        for (ISourceSinkDefinition sourceDefinition : sourceDefinitions) {
            for (ISourceSinkDefinition sinkDefinition : sinkDefinitions) {
                ResultSourceInfo sourceObj = new ResultSourceInfo(sourceDefinition, source, sourceStmt, userData, propagationPath, propagationAccessPath, propagationCallSites, this.pathAgnosticResults);
                ResultSinkInfo sinkObj = new ResultSinkInfo(sinkDefinition, sink, sinkStmt);
                this.addResult(sinkObj, sourceObj);
                results.add(new Pair<ResultSourceInfo, ResultSinkInfo>(sourceObj, sinkObj));
            }
        }
        return results;
    }

    public void addResult(DataFlowResult res) {
        if (res != null) {
            this.addResult(res.getSink(), res.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(ResultSinkInfo sink, ResultSourceInfo source) {
        boolean put;
        if (sink.getDefinition() instanceof SecondarySinkDefinition) {
            if (this.additionalResults == null) {
                InfoflowResults infoflowResults = this;
                synchronized (infoflowResults) {
                    if (this.additionalResults == null) {
                        this.additionalResults = new ConcurrentHashMultiMap<ResultSinkInfo, ResultSourceInfo>();
                    }
                }
            }
            put = !this.additionalResults.put(sink, source);
        } else {
            if (this.results == null) {
                InfoflowResults infoflowResults = this;
                synchronized (infoflowResults) {
                    if (this.results == null) {
                        this.results = new ConcurrentHashMultiMap<ResultSinkInfo, ResultSourceInfo>();
                    }
                }
            }
            put = this.results.put(sink, source);
        }
        if (!put) {
            logger.debug("Found two equal paths");
        }
    }

    public void addAll(InfoflowResults results) {
        if (results == null) {
            return;
        }
        if (results.getExceptions() != null) {
            for (String e : results.getExceptions()) {
                this.addException(e);
            }
        }
        if (!results.isEmpty() && !results.getResults().isEmpty()) {
            for (ResultSinkInfo sink : results.getResults().keySet()) {
                for (ResultSourceInfo source : results.getResults().get(sink)) {
                    this.addResult(sink, source);
                }
            }
        }
        if (!results.getAdditionalResults().isEmpty()) {
            for (ResultSinkInfo sink : results.getAdditionalResults().keySet()) {
                for (ResultSourceInfo source : results.getAdditionalResults().get(sink)) {
                    this.addResult(sink, source);
                }
            }
        }
        if (results.performanceData != null) {
            if (this.performanceData == null) {
                this.performanceData = results.performanceData;
            } else {
                this.performanceData.add(results.performanceData);
            }
        }
        this.terminationState |= results.terminationState;
    }

    public void addAll(Set<DataFlowResult> results) {
        if (results == null || results.isEmpty()) {
            return;
        }
        for (DataFlowResult res : results) {
            this.addResult(res);
        }
    }

    public MultiMap<ResultSinkInfo, ResultSourceInfo> getResults() {
        return this.results;
    }

    public MultiMap<ResultSinkInfo, ResultSourceInfo> getAdditionalResults() {
        return this.additionalResults == null ? new ConcurrentHashMultiMap() : this.additionalResults;
    }

    public Set<DataFlowResult> getResultSet() {
        if (this.results == null || this.results.isEmpty()) {
            return null;
        }
        HashSet<DataFlowResult> set = new HashSet<DataFlowResult>(this.results.size() * 10);
        for (ResultSinkInfo sink : this.results.keySet()) {
            for (ResultSourceInfo source : this.results.get(sink)) {
                set.add(new DataFlowResult(source, sink));
            }
        }
        return set;
    }

    public Set<DataFlowResult> getAdditionalResultSet() {
        if (this.additionalResults == null || this.additionalResults.isEmpty()) {
            return null;
        }
        HashSet<DataFlowResult> set = new HashSet<DataFlowResult>(this.additionalResults.size() * 10);
        for (ResultSinkInfo sink : this.additionalResults.keySet()) {
            for (ResultSourceInfo source : this.additionalResults.get(sink)) {
                set.add(new DataFlowResult(source, sink));
            }
        }
        return set;
    }

    public boolean isPathBetween(Stmt sink, Stmt source) {
        if (this.results == null) {
            return false;
        }
        Set<ResultSourceInfo> sources = null;
        for (ResultSinkInfo sI : this.results.keySet()) {
            if (!sI.getStmt().equals(sink)) continue;
            sources = this.results.get(sI);
            break;
        }
        if (sources == null) {
            return false;
        }
        for (ResultSourceInfo src : sources) {
            if (!src.getAccessPath().equals(source)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathBetween(String sink, String source) {
        if (this.results == null) {
            return false;
        }
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getAccessPath().getPlainValue().toString().equals(sink)) continue;
            Set<ResultSourceInfo> sources = this.results.get(si);
            for (ResultSourceInfo src : sources) {
                if (!src.getStmt().toString().contains(source)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathBetweenMethods(String sinkSignature, String sourceSignature) {
        List<ResultSinkInfo> sinkVals = this.findSinkByMethodSignature(sinkSignature);
        for (ResultSinkInfo si : sinkVals) {
            Set<ResultSourceInfo> sources = this.results.get(si);
            if (sources == null) {
                return false;
            }
            for (ResultSourceInfo src : sources) {
                InvokeExpr expr;
                if (!src.getStmt().containsInvokeExpr() || !(expr = src.getStmt().getInvokeExpr()).getMethod().getSignature().equals(sourceSignature)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ResultSinkInfo> findSinkByMethodSignature(String sinkSignature) {
        if (this.results == null) {
            return Collections.emptyList();
        }
        ArrayList<ResultSinkInfo> sinkVals = new ArrayList<ResultSinkInfo>();
        for (ResultSinkInfo si : this.results.keySet()) {
            InvokeExpr expr;
            if (!si.getStmt().containsInvokeExpr() || !(expr = si.getStmt().getInvokeExpr()).getMethod().getSignature().equals(sinkSignature)) continue;
            sinkVals.add(si);
        }
        return sinkVals;
    }

    public void printResults() {
        if (this.results == null) {
            return;
        }
        for (ResultSinkInfo sink : this.results.keySet()) {
            logger.info("Found a flow to sink {}, from the following sources:", (Object)sink);
            for (ResultSourceInfo source : this.results.get(sink)) {
                logger.info("\t- {}", (Object)source.getStmt());
                if (source.getPath() == null) continue;
                logger.info("\t\ton Path {}", (Object)Arrays.toString(source.getPath()));
            }
        }
    }

    public void printResults(Writer wr) throws IOException {
        if (this.results == null) {
            return;
        }
        for (ResultSinkInfo sink : this.results.keySet()) {
            wr.write("Found a flow to sink " + sink + ", from the following sources:\n");
            for (ResultSourceInfo source : this.results.get(sink)) {
                wr.write("\t- " + source.getStmt() + "\n");
                if (source.getPath() == null) continue;
                wr.write("\t\ton Path " + Arrays.toString(source.getPath()) + "\n");
            }
        }
    }

    public void clear() {
        this.results = null;
    }

    public int getTerminationState() {
        return this.terminationState;
    }

    public void setTerminationState(int terminationState) {
        this.terminationState = terminationState;
    }

    public boolean wasAbortedTimeout() {
        return (this.terminationState & 1) == 1 || (this.terminationState & 4) == 4;
    }

    public boolean wasTerminatedOutOfMemory() {
        return (this.terminationState & 2) == 2 || (this.terminationState & 8) == 8;
    }

    public InfoflowPerformanceData getPerformanceData() {
        return this.performanceData;
    }

    public void setPerformanceData(InfoflowPerformanceData performanceData) {
        this.performanceData = performanceData;
    }

    public void addPerformanceData(InfoflowPerformanceData performanceData) {
        if (performanceData == this.performanceData) {
            return;
        }
        if (this.performanceData == null) {
            this.performanceData = performanceData;
        } else {
            this.performanceData.add(performanceData);
        }
    }

    public void remove(DataFlowResult result) {
        this.results.remove(result.getSink(), result.getSource());
    }

    public void remove(ResultSourceInfo source, ResultSinkInfo sink) {
        this.results.remove(sink, source);
    }

    public void remove(ResultSinkInfo sink) {
        this.results.remove(sink);
    }

    public void removeAll(Collection<ResultSinkInfo> sinks) {
        for (ResultSinkInfo sink : sinks) {
            this.remove(sink);
        }
    }

    public String toString() {
        if (this.results == null) {
            return "<no results>";
        }
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (ResultSinkInfo sink : this.results.keySet()) {
            for (ResultSourceInfo source : this.results.get(sink)) {
                if (!isFirst) {
                    sb.append(", ");
                }
                isFirst = false;
                sb.append(source);
                sb.append(" -> ");
                sb.append(sink);
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
        result = 31 * result + (this.performanceData == null ? 0 : this.performanceData.hashCode());
        result = 31 * result + (this.results == null ? 0 : ((Object)this.results).hashCode());
        result = 31 * result + this.terminationState;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoflowResults other = (InfoflowResults)obj;
        if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
            return false;
        }
        if (this.performanceData == null ? other.performanceData != null : !this.performanceData.equals(other.performanceData)) {
            return false;
        }
        if (this.results == null ? other.results != null : !((Object)this.results).equals(other.results)) {
            return false;
        }
        return this.terminationState == other.terminationState;
    }
}

