/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.preanalyses.SingleLiveVariableAnalysis;

public class BackwardsWrapperRule
extends AbstractTaintPropagationRule {
    private static final Set<String> excludeList = BackwardsWrapperRule.parseExcludeList();

    public BackwardsWrapperRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        ITaintPropagationWrapper wrapper = this.manager.getTaintWrapper();
        if (wrapper != null && wrapper.isExclusive(stmt, source)) {
            killAll.value = true;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        SinkInfo sourceInfo;
        if (source == this.zeroValue) {
            return null;
        }
        if (this.manager.getTaintWrapper() == null || !(this.manager.getTaintWrapper() instanceof IReversibleTaintWrapper)) {
            return null;
        }
        IReversibleTaintWrapper wrapper = (IReversibleTaintWrapper)this.manager.getTaintWrapper();
        Aliasing aliasing = this.getAliasing();
        if (aliasing == null) {
            return null;
        }
        AccessPath sourceAp = source.getAccessPath();
        boolean isTainted = false;
        boolean retValTainted = false;
        Value leftOp = null;
        if (!sourceAp.isStaticFieldRef() && !sourceAp.isEmpty()) {
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            if (stmt instanceof AssignStmt) {
                leftOp = ((AssignStmt)stmt).getLeftOp();
                killSource.value = isTainted = aliasing.mayAlias(leftOp, (Value)sourceAp.getPlainValue());
                retValTainted = isTainted;
            }
            if (!isTainted && invokeExpr instanceof InstanceInvokeExpr) {
                isTainted = aliasing.mayAlias(((InstanceInvokeExpr)invokeExpr).getBase(), (Value)sourceAp.getPlainValue());
            }
            if (!isTainted) {
                isTainted = wrapper instanceof EasyTaintWrapper && invokeExpr.getArgCount() >= 3 ? aliasing.mayAlias(invokeExpr.getArg(2), (Value)sourceAp.getPlainValue()) : invokeExpr.getArgs().stream().anyMatch(arg -> !(arg.getType() instanceof PrimType) && !TypeUtils.isStringType(arg.getType()) && aliasing.mayAlias((Value)arg, (Value)sourceAp.getPlainValue()));
            }
        }
        if (!isTainted) {
            return null;
        }
        if (!this.getManager().getConfig().getInspectSources() && this.manager.getSourceSinkManager() != null && this.manager.getSourceSinkManager() instanceof IReversibleSourceSinkManager && (sourceInfo = ((IReversibleSourceSinkManager)this.manager.getSourceSinkManager()).getInverseSourceInfo(stmt, this.manager, null)) != null) {
            return null;
        }
        Set<Abstraction> res = wrapper.getInverseTaintsForMethod(stmt, d1, source);
        if (res != null) {
            HashSet<Abstraction> resWAliases = new HashSet<Abstraction>();
            SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf(stmt);
            boolean intraTurnUnit = source.getTurnUnit() != null && this.manager.getICFG().getMethodOf(source.getTurnUnit()) == sm;
            for (Abstraction abs : res) {
                Value rightOp;
                boolean localNotReused;
                AccessPath absAp = abs.getAccessPath();
                boolean addAbstraction = true;
                if (leftOp != null && aliasing.mayAlias(leftOp, (Value)absAp.getPlainValue()) && (localNotReused = (rightOp = ((AssignStmt)stmt).getRightOp()).getUseBoxes().stream().noneMatch(box -> aliasing.mayAlias(box.getValue(), (Value)absAp.getPlainValue())))) {
                    addAbstraction = false;
                }
                boolean performAliasSearch = true;
                if (retValTainted && leftOp != null) {
                    boolean setTurnUnit;
                    Type t = leftOp instanceof FieldRef ? ((FieldRef)leftOp).getField().getType() : leftOp.getType();
                    boolean bl = setTurnUnit = t instanceof PrimType || TypeUtils.isStringType(t) && !absAp.getCanHaveImmutableAliases();
                    if (setTurnUnit) {
                        abs = abs.deriveNewAbstractionWithTurnUnit(stmt);
                        performAliasSearch = false;
                    }
                }
                if (!(!performAliasSearch || absAp.equals(sourceAp) || absAp.isEmpty() || retValTainted && intraTurnUnit && this.canOmitAliasing(abs, stmt, sm))) {
                    boolean taintsStaticField;
                    boolean isBasicString = TypeUtils.isStringType(absAp.getBaseType()) && !absAp.getCanHaveImmutableAliases() && !this.getAliasing().isStringConstructorCall(stmt);
                    boolean taintsObjectValue = absAp.getBaseType() instanceof RefType && !isBasicString && (absAp.getFragmentCount() > 0 || absAp.getTaintSubFields());
                    boolean bl = taintsStaticField = this.getManager().getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && abs.getAccessPath().isStaticFieldRef() && !(absAp.getFirstFieldType() instanceof PrimType) && !TypeUtils.isStringType(absAp.getFirstFieldType());
                    if (taintsObjectValue || taintsStaticField || aliasing.canHaveAliasesRightSide(stmt, abs.getAccessPath().getPlainValue(), abs)) {
                        for (Unit unit : this.manager.getICFG().getPredsOf(stmt)) {
                            aliasing.computeAliases(d1, (Stmt)unit, absAp.getPlainValue(), resWAliases, (SootMethod)this.getManager().getICFG().getMethodOf(unit), abs);
                        }
                    } else {
                        abs = abs.deriveNewAbstractionWithTurnUnit(stmt);
                    }
                }
                if (!addAbstraction) continue;
                resWAliases.add(abs);
            }
            res = resWAliases;
        }
        killSource.value |= wrapper.isExclusive(stmt, source);
        if (res != null) {
            for (Abstraction abs : res) {
                if (abs == source) continue;
                abs.setCorrespondingCallSite(stmt);
            }
        }
        return res;
    }

    private static Set<String> parseExcludeList() {
        try {
            return Files.lines(Paths.get("BackwardsWrapperExcludeList.txt", new String[0])).filter(p -> !p.startsWith("#")).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    private boolean canOmitAliasing(Abstraction abs, Stmt callStmt, SootMethod sm) {
        if (!(callStmt instanceof AssignStmt)) {
            return false;
        }
        AssignStmt assignStmt = (AssignStmt)callStmt;
        if (!(assignStmt.getRightOp() instanceof InstanceInvokeExpr)) {
            return false;
        }
        InstanceInvokeExpr ie = (InstanceInvokeExpr)assignStmt.getRightOp();
        if (ie.getBase() == assignStmt.getLeftOp()) {
            return false;
        }
        if (!this.getAliasing().mayAlias(ie.getBase(), (Value)abs.getAccessPath().getPlainValue())) {
            return false;
        }
        if (!excludeList.contains(ie.getMethod().getSignature())) {
            return false;
        }
        SingleLiveVariableAnalysis slva = new SingleLiveVariableAnalysis(this.manager.getICFG().getOrCreateUnitGraph(sm), (Local)ie.getBase(), abs.getTurnUnit());
        return slva.canOmitAlias(callStmt);
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

