/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import java.util.Collection;
import java.util.Collections;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.river.IAdditionalFlowSinkPropagationRule;
import soot.jimple.infoflow.river.SecondarySinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsSourcePropagationRule
extends AbstractTaintPropagationRule
implements IAdditionalFlowSinkPropagationRule {
    private boolean killState = false;

    public BackwardsSourcePropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (stmt instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            this.checkForSource(d1, source, stmt, returnStmt.getOp());
        } else if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            this.checkForSource(d1, source, stmt, ifStmt.getCondition());
        } else if (stmt instanceof LookupSwitchStmt) {
            LookupSwitchStmt switchStmt = (LookupSwitchStmt)stmt;
            this.checkForSource(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof TableSwitchStmt) {
            TableSwitchStmt switchStmt = (TableSwitchStmt)stmt;
            this.checkForSource(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)stmt;
            this.checkForSource(d1, source, stmt, assignStmt.getRightOp());
        } else if (stmt instanceof IdentityStmt) {
            IdentityStmt identityStmt = (IdentityStmt)stmt;
            this.checkForSource(d1, source, stmt, identityStmt.getLeftOp());
        }
        return null;
    }

    private void checkForSource(Abstraction d1, Abstraction source, Stmt stmt, Value retVal) {
        AccessPath ap = source.getAccessPath();
        if (!(this.manager.getSourceSinkManager() instanceof IReversibleSourceSinkManager)) {
            return;
        }
        IReversibleSourceSinkManager ssm = (IReversibleSourceSinkManager)this.manager.getSourceSinkManager();
        Aliasing aliasing = this.getAliasing();
        if (ap != null && ssm != null && aliasing != null && source.isAbstractionActive()) {
            for (Value val : BaseSelector.selectBaseList(retVal, false)) {
                SinkInfo sourceInfo;
                if (!aliasing.mayAlias(val, (Value)ap.getPlainValue()) || (sourceInfo = ssm.getInverseSourceInfo(stmt, this.getManager(), source.getAccessPath())) == null || this.getResults().addResult(new AbstractionAtSink(sourceInfo.getDefinitions(), source, stmt))) continue;
                this.killState = true;
            }
        }
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    protected boolean isTaintVisibleInCallee(Stmt stmt, Abstraction source) {
        InvokeExpr iexpr = stmt.getInvokeExpr();
        Aliasing aliasing = this.getAliasing();
        Local apBaseValue = source.getAccessPath().getPlainValue();
        if (apBaseValue != null && aliasing != null) {
            for (int i = 0; i < iexpr.getArgCount(); ++i) {
                if (!aliasing.mayAlias(iexpr.getArg(i), (Value)apBaseValue) || !source.getAccessPath().getTaintSubFields() && !source.getAccessPath().isLocal()) continue;
                return true;
            }
        }
        if (iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == source.getAccessPath().getPlainValue()) {
            return true;
        }
        return stmt instanceof AssignStmt && aliasing != null && aliasing.mayAlias(apBaseValue, ((AssignStmt)stmt).getLeftOp());
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        boolean result;
        SinkInfo sourceInfo;
        if (!(this.manager.getSourceSinkManager() instanceof IReversibleSourceSinkManager)) {
            return null;
        }
        IReversibleSourceSinkManager ssm = (IReversibleSourceSinkManager)this.manager.getSourceSinkManager();
        if (!(!source.isAbstractionActive() || source.getAccessPath().isStaticFieldRef() || source.getAccessPath().isEmpty() || stmt.containsInvokeExpr() && !this.isTaintVisibleInCallee(stmt, source) || (sourceInfo = ssm.getInverseSourceInfo(stmt, this.getManager(), source.getAccessPath())) == null || (result = this.getResults().addResult(new AbstractionAtSink(sourceInfo.getDefinitions(), source, stmt))))) {
            this.killState = true;
        }
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    @Override
    public void processSecondaryFlowSink(Abstraction d1, Abstraction source, Stmt stmt) {
        if (!source.isAbstractionActive() || source.getAccessPath().isStaticFieldRef()) {
            return;
        }
        if (!stmt.containsInvokeExpr() || !this.isTaintVisibleInCallee(stmt, source)) {
            return;
        }
        this.getResults().addResult(new AbstractionAtSink(Collections.singleton(SecondarySinkDefinition.INSTANCE), source, stmt));
    }
}

