/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.SwitchStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsImplicitFlowRule
extends AbstractTaintPropagationRule {
    private final MyConcurrentHashMap<Unit, Set<Abstraction>> implicitTargets = new MyConcurrentHashMap();

    public BackwardsImplicitFlowRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        boolean taintAffectedByStatement;
        assert (!source.getAccessPath().isEmpty() || source.getDominator() != null);
        if (source == this.getZeroValue()) {
            return null;
        }
        if (source.isDominator(stmt)) {
            Value condition;
            if (!source.getAccessPath().isEmpty()) {
                Abstraction abs = source.removeDominator(stmt);
                if (abs != null) {
                    this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, stmt, abs));
                }
                killAll.value = true;
                return null;
            }
            killSource.value = true;
            if (stmt instanceof IfStmt) {
                condition = ((IfStmt)stmt).getCondition();
            } else if (stmt instanceof SwitchStmt) {
                condition = ((SwitchStmt)stmt).getKey();
            } else {
                return null;
            }
            IInfoflowCFG.UnitContainer condUnit = this.manager.getICFG().getDominatorOf(stmt);
            HashSet<Abstraction> res = new HashSet<Abstraction>();
            if (condition instanceof Local) {
                AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(condition, false);
                Abstraction abs = source.deriveCondition(ap, stmt);
                res.add(abs);
                if (condUnit.getUnit() != null) {
                    res.add(abs.deriveNewAbstractionWithDominator(condUnit.getUnit()));
                }
                return res;
            }
            for (ValueBox box : condition.getUseBoxes()) {
                if (box.getValue() instanceof Constant) continue;
                AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(box.getValue(), false);
                Abstraction abs = source.deriveCondition(ap, stmt);
                res.add(abs);
                if (condUnit.getUnit() == null) continue;
                res.add(abs.deriveNewAbstractionWithDominator(condUnit.getUnit()));
            }
            return res;
        }
        if (source.getAccessPath().isEmpty() && this.manager.getICFG().isExceptionalEdgeBetween(stmt, destStmt)) {
            if (destStmt instanceof AssignStmt) {
                AccessPath ap = this.manager.getAccessPathFactory().createAccessPath(((AssignStmt)destStmt).getLeftOp(), false);
                Abstraction abs = source.deriveNewAbstraction(ap, stmt);
                return Collections.singleton(abs);
            }
            return null;
        }
        if (source.getAccessPath().isEmpty()) {
            return null;
        }
        IInfoflowCFG.UnitContainer dominator = this.manager.getICFG().getDominatorOf(stmt);
        boolean bl = taintAffectedByStatement = stmt instanceof DefinitionStmt && this.getAliasing().mayAlias(((DefinitionStmt)stmt).getLeftOp(), (Value)source.getAccessPath().getPlainValue());
        if (dominator.getUnit() != null && dominator.getUnit() != destStmt && !taintAffectedByStatement) {
            killSource.value = true;
            Abstraction abs = source.deriveNewAbstractionWithDominator(dominator.getUnit(), stmt);
            return Collections.singleton(abs);
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        assert (!source.getAccessPath().isEmpty() || source.getDominator() != null);
        if (source == this.getZeroValue()) {
            return null;
        }
        Aliasing aliasing = this.getAliasing();
        if (aliasing == null) {
            return null;
        }
        if (source.isDominator(stmt)) {
            Abstraction abs;
            killAll.value = true;
            if (!source.getAccessPath().isEmpty() && (abs = source.removeDominator(stmt)) != null) {
                this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, stmt, abs));
            }
            return null;
        }
        if (this.implicitTargets.containsKey(stmt) && (d1 == null || ((Set)this.implicitTargets.get(stmt)).contains(d1))) {
            if (killAll != null) {
                killAll.value = true;
            }
            return null;
        }
        if (source.getAccessPath().isEmpty()) {
            killAll.value = true;
            return null;
        }
        if (stmt instanceof AssignStmt) {
            boolean isImplicit;
            AssignStmt assignStmt = (AssignStmt)stmt;
            Value left = assignStmt.getLeftOp();
            boolean bl = isImplicit = source.getDominator() != null;
            if (aliasing.mayAlias(left, (Value)source.getAccessPath().getPlainValue()) && !isImplicit) {
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                for (Unit unit : dest.getActiveBody().getUnits()) {
                    ReturnStmt returnStmt;
                    Value retVal;
                    if (!(unit instanceof ReturnStmt) || !((retVal = (returnStmt = (ReturnStmt)unit).getOp()) instanceof Constant)) continue;
                    Abstraction abs = source.deriveConditionalUpdate(stmt);
                    abs = abs.deriveNewAbstractionWithTurnUnit(stmt);
                    List<Unit> condUnits = this.manager.getICFG().getConditionalBranchIntraprocedural(returnStmt);
                    for (Unit condUnit : condUnits) {
                        Abstraction intraRet = abs.deriveNewAbstractionWithDominator(condUnit);
                        res.add(intraRet);
                    }
                }
                return res;
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (source == this.getZeroValue() && this.manager.getSourceSinkManager() instanceof IReversibleSourceSinkManager) {
            Iterator<AccessPath> iterator;
            killSource.value = true;
            IReversibleSourceSinkManager ssm = (IReversibleSourceSinkManager)this.manager.getSourceSinkManager();
            SourceInfo sink = ssm.getInverseSinkInfo(stmt, this.manager);
            if (sink != null && (iterator = sink.getAccessPaths().iterator()).hasNext()) {
                AccessPath ap = iterator.next();
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf(stmt);
                List<Unit> condUnits = this.manager.getICFG().getConditionalBranchesInterprocedural(stmt);
                for (Unit condUnit : condUnits) {
                    Abstraction abs = new Abstraction(sink.getAllDefinitions(), AccessPath.getEmptyAccessPath(), stmt, sink.getUserData(), false, false);
                    abs.setCorrespondingCallSite(stmt);
                    abs.setDominator(condUnit);
                    res.add(abs);
                }
                if (!sm.isStatic()) {
                    AccessPath thisAp = this.manager.getAccessPathFactory().createAccessPath(sm.getActiveBody().getThisLocal(), false);
                    Abstraction thisTaint = new Abstraction(sink.getDefinitionsForAccessPath(ap), thisAp, stmt, sink.getUserData(), false, false);
                    thisTaint.setCorrespondingCallSite(stmt);
                    res.add(thisTaint);
                }
                return res;
            }
        }
        if (source == this.getZeroValue()) {
            return null;
        }
        if (source.isDominator(stmt)) {
            Abstraction abs;
            killAll.value = true;
            if (!source.getAccessPath().isEmpty() && (abs = source.removeDominator(stmt)) != null) {
                this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, stmt, abs));
            }
            return null;
        }
        if (stmt instanceof AssignStmt && this.getAliasing().mayAlias(((AssignStmt)stmt).getLeftOp(), (Value)source.getAccessPath().getPlainValue())) {
            boolean isImplicit;
            boolean bl = isImplicit = source.getDominator() != null;
            if (isImplicit) {
                killSource.value = true;
                return Collections.singleton(source.deriveConditionalUpdate(stmt));
            }
        }
        if (source.getAccessPath().isEmpty()) {
            return null;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        InvokeExpr ie;
        assert (!source.getAccessPath().isEmpty() || source.getDominator() != null);
        if (source == this.getZeroValue()) {
            return null;
        }
        if (source.isDominator(stmt)) {
            Abstraction abs;
            killAll.value = true;
            if (!source.getAccessPath().isEmpty() && (abs = source.removeDominator(stmt)) != null) {
                this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(calleeD1, stmt, abs));
            }
            return null;
        }
        if (source.getAccessPath().isEmpty()) {
            return Collections.singleton(source.deriveNewAbstraction(source.getAccessPath(), stmt));
        }
        SootMethod callee = (SootMethod)this.manager.getICFG().getMethodOf(stmt);
        List<Local> params = callee.getActiveBody().getParameterLocals();
        InvokeExpr invokeExpr = ie = callSite.containsInvokeExpr() ? callSite.getInvokeExpr() : null;
        if (ie != null) {
            for (int i = 0; i < params.size() && i < ie.getArgCount(); ++i) {
                if (!this.getAliasing().mayAlias(source.getAccessPath().getPlainValue(), (Value)params.get(i)) || !(ie.getArg(i) instanceof Constant)) continue;
                List<Unit> condUnits = this.manager.getICFG().getConditionalBranchIntraprocedural(callSite);
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                for (Unit condUnit : condUnits) {
                    Abstraction intraRet = source.deriveNewAbstractionWithDominator(condUnit, stmt);
                    intraRet.setCorrespondingCallSite(callSite);
                    res.add(intraRet);
                }
                return res;
            }
        }
        return null;
    }
}

