/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import soot.jimple.infoflow.methodSummary.data.sourceSink.AbstractFlowSinkSource;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class SummaryWriter {
    private final int FILE_FORMAT_VERSION = 103;

    public void write(File file, ClassSummaries summary) throws IOException, XMLStreamException {
        for (String className : summary.getClasses()) {
            String fileName = file.getAbsolutePath() + File.separatorChar + className + ".xml";
            this.write(new File(fileName), summary.getClassSummaries(className));
        }
    }

    public void write(File file, ClassMethodSummaries summary) throws XMLStreamException, IOException {
        if (summary.isEmpty()) {
            return;
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("summary");
            writer.writeAttribute("fileFormatVersion", "103");
            if (summary.hasInterfaceInfo()) {
                writer.writeAttribute("isInterface", summary.isInterface() ? "true" : "false");
            }
            MethodSummaries methodSummaries = summary.getMethodSummaries();
            if (summary.hasInterfaces()) {
                writer.writeStartElement("hierarchy");
                String superClass = summary.getSuperClass();
                if (superClass != null && !superClass.isEmpty()) {
                    writer.writeAttribute("superClass", superClass);
                }
                this.writeInterfaces(summary, writer);
                writer.writeEndElement();
            }
            writer.writeStartElement("methods");
            this.writeMethodFlows(methodSummaries, writer);
            writer.writeEndElement();
            if (methodSummaries.hasGaps()) {
                writer.writeStartElement("gaps");
                this.writeGaps(methodSummaries, writer);
                writer.writeEndElement();
            }
            writer.writeEndDocument();
            writer.close();
        }
    }

    private void writeInterfaces(ClassMethodSummaries summary, XMLStreamWriter writer) throws XMLStreamException {
        for (String intf : summary.getInterfaces()) {
            writer.writeStartElement("interface");
            writer.writeAttribute("name", intf);
            writer.writeEndElement();
        }
    }

    private void writeGaps(MethodSummaries summary, XMLStreamWriter writer) throws XMLStreamException {
        for (GapDefinition gap : summary.getGaps().values()) {
            writer.writeStartElement("gap");
            writer.writeAttribute("num", gap.getID() + "");
            writer.writeAttribute("id", gap.getSignature());
            writer.writeEndElement();
        }
    }

    private void writeMethodFlows(MethodSummaries summary, XMLStreamWriter writer) throws XMLStreamException {
        ArrayList<String> sortedMethods = new ArrayList<String>(summary.getFlows().keySet());
        sortedMethods.sort(new SortMethodsByNameComparator());
        for (String methodSig : sortedMethods) {
            writer.writeStartElement("method");
            writer.writeAttribute("id", methodSig);
            if (summary != null && summary.hasFlows()) {
                writer.writeStartElement("flows");
                ArrayList<MethodFlow> sortedMethodFlows = new ArrayList<MethodFlow>(summary.getFlows().get(methodSig));
                sortedMethodFlows.sort(new SortFlowsComparator());
                for (MethodFlow data : sortedMethodFlows) {
                    if (data.isCustom()) continue;
                    writer.writeStartElement("flow");
                    writer.writeAttribute("isAlias", data.isAlias() + "");
                    this.writeFlowSource(writer, data);
                    this.writeFlowSink(writer, data);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeFlowSink(XMLStreamWriter writer, MethodFlow data) throws XMLStreamException {
        writer.writeStartElement("to");
        this.writeAbstractFlowSinkSource(writer, data.sink(), data.methodSig());
        if (data.sink().taintSubFields()) {
            writer.writeAttribute("taintSubFields", "true");
        }
        writer.writeEndElement();
    }

    private void writeFlowSource(XMLStreamWriter writer, MethodFlow data) throws XMLStreamException {
        writer.writeStartElement("from");
        this.writeAbstractFlowSinkSource(writer, data.source(), data.methodSig());
        writer.writeEndElement();
    }

    private void writeAbstractFlowSinkSource(XMLStreamWriter writer, AbstractFlowSinkSource currentFlow, String methodSig) throws XMLStreamException {
        AccessPathFragment accessPath;
        writer.writeAttribute("sourceSinkType", currentFlow.getType().toString());
        if (!currentFlow.isField() && !currentFlow.isReturn()) {
            if (currentFlow.isParameter()) {
                writer.writeAttribute("ParameterIndex", currentFlow.getParameterIndex() + "");
            } else if (!currentFlow.isGapBaseObject()) {
                throw new RuntimeException("Unsupported source or sink type " + (Object)((Object)currentFlow.getType()));
            }
        }
        writer.writeAttribute("BaseType", currentFlow.getBaseType());
        if (currentFlow.hasAccessPath() && (accessPath = currentFlow.getAccessPath()) != null && !accessPath.isEmpty()) {
            writer.writeAttribute("AccessPath", Arrays.toString(accessPath.getFields()));
            writer.writeAttribute("AccessPathTypes", Arrays.toString(accessPath.getFieldTypes()));
        }
        if (currentFlow.getGap() != null) {
            writer.writeAttribute("gap", currentFlow.getGap().getID() + "");
        }
    }

    private static class SortMethodsByNameComparator
    implements Comparator<String> {
        private SortMethodsByNameComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            String name1 = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(o1);
            String name2 = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(o2);
            return name1.compareTo(name2);
        }
    }

    private static class SortFlowsComparator
    implements Comparator<MethodFlow> {
        private SortFlowsComparator() {
        }

        @Override
        public int compare(MethodFlow o1, MethodFlow o2) {
            if (o1.source().isParameter() && !o2.source().isParameter()) {
                return -1;
            }
            if (o1.source().isParameter() && o2.source().isParameter()) {
                return o1.source().getParameterIndex() - o2.source().getParameterIndex();
            }
            return 0;
        }
    }
}

