/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowClear;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodClear;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.xml.AbstractXMLReader;
import soot.jimple.infoflow.methodSummary.xml.SummaryXMLException;

public class SummaryReader
extends AbstractXMLReader {
    private static final String XSD_FILE_PATH = "schema/ClassSummary.xsd";
    private boolean validateSummariesOnRead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader reader, ClassMethodSummaries summaries) throws XMLStreamException, SummaryXMLException, IOException {
        try (XMLStreamReader xmlreader = null;){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            xmlreader = factory.createXMLStreamReader(reader);
            MethodSummaries summary = summaries.getMethodSummaries();
            HashMap<String, String> sourceAttributes = new HashMap<String, String>();
            HashMap<String, String> sinkAttributes = new HashMap<String, String>();
            HashMap<String, String> clearAttributes = new HashMap<String, String>();
            String currentMethod = "";
            int currentID = -1;
            boolean isAlias = false;
            Boolean typeChecking = null;
            Boolean ignoreTypes = null;
            Boolean cutSubfields = null;
            State state = State.summary;
            while (xmlreader.hasNext()) {
                xmlreader.next();
                if (!xmlreader.hasName()) continue;
                String localName = xmlreader.getLocalName();
                if (localName.equals("summary") && xmlreader.isStartElement()) {
                    String isExclusive;
                    String isInterface = this.getAttributeByName(xmlreader, "isInterface");
                    if (isInterface != null && !isInterface.isEmpty()) {
                        summaries.setInterface(isInterface.equals("true"));
                    }
                    if ((isExclusive = this.getAttributeByName(xmlreader, "isExclusive")) == null || isExclusive.isEmpty()) continue;
                    summaries.setExclusiveForClass(isExclusive.equals("true"));
                    continue;
                }
                if (localName.equals("methods") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        state = State.methods;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("method") && xmlreader.isStartElement()) {
                    if (state == State.methods) {
                        String sIsExcluded;
                        currentMethod = this.getAttributeByName(xmlreader, "id");
                        if (currentMethod.contains(":")) {
                            currentMethod = currentMethod.substring(currentMethod.indexOf(":") + 1);
                        }
                        if ((sIsExcluded = this.getAttributeByName(xmlreader, "isExcluded")) != null && sIsExcluded.equals("true")) {
                            summary.addExcludedMethod(currentMethod);
                        }
                        state = State.method;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("method") && xmlreader.isEndElement()) {
                    if (state == State.method) {
                        state = State.methods;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("flow") && xmlreader.isStartElement()) {
                    if (state == State.method) {
                        String sIgnoreTypes;
                        String sCutSubfields;
                        sourceAttributes.clear();
                        sinkAttributes.clear();
                        state = State.flow;
                        String sAlias = this.getAttributeByName(xmlreader, "isAlias");
                        isAlias = sAlias != null && sAlias.equals("true");
                        String sTypeChecking = this.getAttributeByName(xmlreader, "typeChecking");
                        if (sTypeChecking != null && !sTypeChecking.isEmpty()) {
                            typeChecking = sTypeChecking.equals("true");
                        }
                        if ((sCutSubfields = this.getAttributeByName(xmlreader, "cutSubfields")) != null && !sCutSubfields.isEmpty()) {
                            cutSubfields = sCutSubfields.equals("true");
                        }
                        if ((sIgnoreTypes = this.getAttributeByName(xmlreader, "ignoreTypes")) == null || sIgnoreTypes.isEmpty()) continue;
                        ignoreTypes = sIgnoreTypes.equals("true");
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("clear") && xmlreader.isStartElement()) {
                    if (state == State.method) {
                        clearAttributes.clear();
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            clearAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        state = State.clear;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("from") && xmlreader.isStartElement()) {
                    if (state == State.flow) {
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            sourceAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("to") && xmlreader.isStartElement()) {
                    if (state == State.flow) {
                        for (int i = 0; i < xmlreader.getAttributeCount(); ++i) {
                            sinkAttributes.put(xmlreader.getAttributeLocalName(i), xmlreader.getAttributeValue(i));
                        }
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("flow") && xmlreader.isEndElement()) {
                    if (state == State.flow) {
                        state = State.method;
                        MethodFlow flow = new MethodFlow(currentMethod, this.createSource(summary, sourceAttributes), this.createSink(summary, sinkAttributes), isAlias, typeChecking, ignoreTypes, cutSubfields);
                        summary.addFlow(flow);
                        isAlias = false;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("clear") && xmlreader.isEndElement()) {
                    if (state == State.clear) {
                        state = State.method;
                        MethodClear clear = new MethodClear(currentMethod, this.createClear(summary, clearAttributes));
                        summary.addClear(clear);
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("methods") && xmlreader.isEndElement()) {
                    if (state == State.methods) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gaps") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        state = State.gaps;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gaps") && xmlreader.isEndElement()) {
                    if (state == State.gaps) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gap") && xmlreader.isStartElement()) {
                    if (state == State.gaps) {
                        currentMethod = this.getAttributeByName(xmlreader, "id");
                        currentID = Integer.valueOf(this.getAttributeByName(xmlreader, "num"));
                        summary.getOrCreateGap(currentID, currentMethod);
                        state = State.gap;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("gap") && xmlreader.isEndElement()) {
                    if (state == State.gap) {
                        state = State.gaps;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("hierarchy") && xmlreader.isStartElement()) {
                    if (state == State.summary) {
                        summaries.setSuperClass(this.getAttributeByName(xmlreader, "superClass"));
                        state = State.hierarchy;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("hierarchy") && xmlreader.isEndElement()) {
                    if (state == State.hierarchy) {
                        state = State.summary;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (localName.equals("interface") && xmlreader.isStartElement()) {
                    if (state == State.hierarchy) {
                        summaries.addInterface(this.getAttributeByName(xmlreader, "name"));
                        state = State.intf;
                        continue;
                    }
                    throw new SummaryXMLException();
                }
                if (!localName.equals("interface") || !xmlreader.isEndElement()) continue;
                if (state == State.intf) {
                    state = State.hierarchy;
                    continue;
                }
                throw new SummaryXMLException();
            }
            if (this.validateSummariesOnRead) {
                summary.validate();
            }
        }
    }

    public void read(File fileName, ClassMethodSummaries summaries) throws XMLStreamException, SummaryXMLException, IOException {
        if (this.validateSummariesOnRead) {
            try (FileReader rdr = new FileReader(fileName);){
                if (!SummaryReader.verifyXML(rdr, XSD_FILE_PATH)) {
                    throw new RuntimeException("The XML-File isn't valid");
                }
            }
        }
        this.read(new FileReader(fileName), summaries);
    }

    private FlowSource createSource(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowSource(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isParameter(attributes)) {
            return new FlowSource(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowSource(SourceSinkType.GapBaseObject, this.getBaseType(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isReturn(attributes)) {
            GapDefinition gap = this.getGapDefinition(attributes, summary);
            if (gap == null) {
                throw new SummaryXMLException("Return values can only be sources if they have a gap specification");
            }
            return new FlowSource(SourceSinkType.Return, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        throw new SummaryXMLException("Invalid flow source definition");
    }

    private FlowSink createSink(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowSink(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isParameter(attributes)) {
            return new FlowSink(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isReturn(attributes)) {
            return new FlowSink(SourceSinkType.Return, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.taintSubFields(attributes), this.getGapDefinition(attributes, summary), this.isMatchStrict(attributes));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowSink(SourceSinkType.GapBaseObject, -1, this.getBaseType(attributes), false, this.getGapDefinition(attributes, summary), (Object)this.isMatchStrict(attributes));
        }
        throw new SummaryXMLException();
    }

    private FlowClear createClear(MethodSummaries summary, Map<String, String> attributes) throws SummaryXMLException {
        if (this.isField(attributes)) {
            return new FlowClear(SourceSinkType.Field, this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary));
        }
        if (this.isParameter(attributes)) {
            return new FlowClear(SourceSinkType.Parameter, this.parameterIdx(attributes), this.getBaseType(attributes), new AccessPathFragment(this.getAccessPath(attributes), this.getAccessPathTypes(attributes)), this.getGapDefinition(attributes, summary));
        }
        if (this.isGapBaseObject(attributes)) {
            return new FlowClear(SourceSinkType.GapBaseObject, this.getBaseType(attributes), this.getGapDefinition(attributes, summary));
        }
        throw new SummaryXMLException("Invalid flow clear definition");
    }

    private boolean isReturn(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("sourceSinkType");
            return attr != null && attr.equals(SourceSinkType.Return.toString());
        }
        return false;
    }

    private boolean isField(Map<String, String> attributes) {
        if (attributes != null) {
            String attr = attributes.get("sourceSinkType");
            return attr != null && attr.equals(SourceSinkType.Field.toString());
        }
        return false;
    }

    private String[] getAccessPath(Map<String, String> attributes) {
        String ap = attributes.get("AccessPath");
        if (ap != null && ap.length() > 3) {
            String[] res = ap.substring(1, ap.length() - 1).split(",");
            for (int i = 0; i < res.length; ++i) {
                String curElement = res[i].trim();
                if (!curElement.startsWith("<")) {
                    curElement = "<" + curElement;
                }
                if (!curElement.endsWith(">")) {
                    curElement = curElement + ">";
                }
                res[i] = curElement;
            }
            return res;
        }
        return null;
    }

    private String[] getAccessPathTypes(Map<String, String> attributes) {
        String ap = attributes.get("AccessPathTypes");
        if (ap != null && ap.length() > 3) {
            String[] res = ap.substring(1, ap.length() - 1).split(",");
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].trim();
            }
            return res;
        }
        return null;
    }

    private boolean isMatchStrict(Map<String, String> attributes) {
        String str = attributes.get("matchStrict");
        if (str != null && !str.isEmpty()) {
            return Boolean.valueOf(str);
        }
        return false;
    }

    private boolean isParameter(Map<String, String> attributes) {
        return attributes.get("sourceSinkType").equals(SourceSinkType.Parameter.toString());
    }

    private boolean isGapBaseObject(Map<String, String> attributes) {
        return attributes != null && attributes.get("sourceSinkType").equals(SourceSinkType.GapBaseObject.toString());
    }

    private int parameterIdx(Map<String, String> attributes) {
        String strIdx = attributes.get("ParameterIndex");
        if (strIdx == null || strIdx.isEmpty()) {
            throw new RuntimeException("Parameter index not specified");
        }
        return Integer.parseInt(strIdx);
    }

    private String getBaseType(Map<String, String> attributes) {
        return attributes.get("BaseType");
    }

    private boolean taintSubFields(Map<String, String> attributes) {
        String val = attributes.get("taintSubFields");
        return val != null && val.equals("true");
    }

    private GapDefinition getGapDefinition(Map<String, String> attributes, MethodSummaries summary) {
        String id = attributes.get("gap");
        if (id == null || id.isEmpty()) {
            return null;
        }
        GapDefinition gap = summary.getGap(Integer.parseInt(id));
        if (gap != null) {
            return gap;
        }
        return summary.createTemporaryGap(Integer.parseInt(id));
    }

    public void setValidateSummariesOnRead(boolean validateSummariesOnRead) {
        this.validateSummariesOnRead = validateSummariesOnRead;
    }

    private static enum State {
        summary,
        hierarchy,
        intf,
        methods,
        method,
        flow,
        clear,
        gaps,
        gap;

    }
}

