/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.xml;

import java.io.FileReader;
import java.io.IOException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import soot.jimple.infoflow.util.ResourceUtils;

abstract class AbstractXMLReader {
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    AbstractXMLReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean verifyXML(FileReader reader, String xsdFilePath) throws IOException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource xsdFile = new StreamSource(ResourceUtils.getResourceStream(xsdFilePath));
        StreamSource xmlFile = new StreamSource(reader);
        boolean validXML = false;
        try {
            Schema schema = sf.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(xmlFile);
                validXML = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!validXML) {
                new IOException("File isn't  valid against the xsd");
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            xsdFile.getInputStream().close();
            if (xmlFile.getInputStream() != null) {
                xmlFile.getInputStream().close();
            }
        }
        return validXML;
    }

    protected String getAttributeByName(XMLStreamReader reader, String id) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeLocalName(i).equals(id)) continue;
            return reader.getAttributeValue(i);
        }
        return "";
    }
}

