/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers.resolvers;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.Hierarchy;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.taintWrappers.resolvers.SummaryQuery;
import soot.jimple.infoflow.methodSummary.taintWrappers.resolvers.SummaryResponse;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class SummaryResolver {
    private static final int MAX_HIERARCHY_DEPTH = 10;
    protected final LoadingCache<SummaryQuery, SummaryResponse> methodToImplFlows = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SummaryQuery, SummaryResponse>(){

        @Override
        public SummaryResponse load(SummaryQuery query) throws Exception {
            SootClass calleeClass = query.calleeClass;
            SootClass declaredClass = query.declaredClass;
            String methodSig = query.subsignature;
            ClassSummaries classSummaries = new ClassSummaries();
            boolean directHit = false;
            ByReferenceBoolean isClassSupported = new ByReferenceBoolean(false);
            if (calleeClass != null) {
                directHit = this.getSummaries(methodSig, classSummaries, calleeClass, isClassSupported);
            }
            if (declaredClass != null && !directHit) {
                directHit = this.getSummaries(methodSig, classSummaries, declaredClass, isClassSupported);
            }
            if (!directHit && calleeClass != null) {
                directHit = this.getSummariesHierarchy(methodSig, classSummaries, calleeClass, isClassSupported);
            }
            if (declaredClass != null && !directHit) {
                directHit = this.getSummariesHierarchy(methodSig, classSummaries, declaredClass, isClassSupported);
            }
            if (directHit && !classSummaries.isEmpty()) {
                return new SummaryResponse(classSummaries, true);
            }
            if (directHit || isClassSupported.value) {
                return SummaryResponse.EMPTY_BUT_SUPPORTED;
            }
            return SummaryResponse.NOT_SUPPORTED;
        }

        private void updateClassExclusive(ByReferenceBoolean classSupported, SootClass sc, String subsig) {
            if (classSupported.value) {
                return;
            }
            if (sc.getMethodUnsafe(subsig) == null) {
                return;
            }
            ClassMethodSummaries cms = SummaryResolver.this.flows.getClassFlows(sc.getName());
            classSupported.value = classSupported.value | (cms != null && cms.isExclusiveForClass());
        }

        private boolean getSummaries(String methodSig, ClassSummaries summaries, SootClass clazz, ByReferenceBoolean classSupported) {
            if (summaries.merge(SummaryResolver.this.flows.getMethodFlows(clazz, methodSig))) {
                return true;
            }
            if (this.checkInterfaces(methodSig, summaries, clazz, classSupported)) {
                return true;
            }
            this.updateClassExclusive(classSupported, clazz, methodSig);
            SootMethod targetMethod = clazz.getMethodUnsafe(methodSig);
            if (!clazz.isConcrete() || targetMethod == null || !targetMethod.isConcrete()) {
                for (SootClass parentClass : SummaryResolver.this.getAllParentClasses(clazz)) {
                    if (summaries.merge(SummaryResolver.this.flows.getMethodFlows(parentClass, methodSig))) {
                        return true;
                    }
                    if (this.checkInterfaces(methodSig, summaries, parentClass, classSupported)) {
                        return true;
                    }
                    this.updateClassExclusive(classSupported, parentClass, methodSig);
                }
            }
            return false;
        }

        private boolean getSummariesHierarchy(String methodSig, ClassSummaries summaries, SootClass clazz, ByReferenceBoolean classSupported) {
            if (clazz.getName().equals("java.lang.Object")) {
                return false;
            }
            SootMethod targetMethod = clazz.getMethodUnsafe(methodSig);
            if (!clazz.isConcrete() || targetMethod == null || !targetMethod.isConcrete()) {
                int found = 0;
                Set childClasses = SummaryResolver.this.getAllChildClasses(clazz);
                for (SootClass childClass : childClasses) {
                    if (summaries.merge(SummaryResolver.this.flows.getMethodFlows(childClass, methodSig))) {
                        ++found;
                    }
                    if (this.checkInterfaces(methodSig, summaries, childClass, classSupported)) {
                        ++found;
                    }
                    this.updateClassExclusive(classSupported, childClass, methodSig);
                    if (found <= 10) continue;
                    return false;
                }
                return found > 0;
            }
            return false;
        }

        private boolean checkInterfaces(String methodSig, ClassSummaries summaries, SootClass clazz, ByReferenceBoolean classSupported) {
            for (SootClass intf : clazz.getInterfaces()) {
                if (summaries.merge(SummaryResolver.this.flows.getMethodFlows(intf, methodSig))) {
                    return true;
                }
                for (SootClass parent : SummaryResolver.this.getAllParentClasses(intf)) {
                    if (summaries.merge(SummaryResolver.this.flows.getMethodFlows(parent, methodSig))) {
                        return true;
                    }
                    this.updateClassExclusive(classSupported, parent, methodSig);
                }
            }
            return false;
        }
    });
    protected final IMethodSummaryProvider flows;
    private final Hierarchy hierarchy;

    public SummaryResolver(IMethodSummaryProvider flows) {
        this.flows = flows;
        this.hierarchy = Scene.v().getActiveHierarchy();
    }

    private Set<SootClass> getAllChildClasses(SootClass sc) {
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        HashSet<SootClass> classes = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                List<SootClass> hierarchyImplementers = this.hierarchy.getImplementersOf(curClass);
                workList.addAll(hierarchyImplementers);
                List<SootClass> subinterfaces = this.hierarchy.getSubinterfacesOf(curClass);
                workList.addAll(subinterfaces);
                continue;
            }
            List<SootClass> hierarchyClasses = this.hierarchy.getSubclassesOf(curClass);
            workList.addAll(hierarchyClasses);
            classes.add(curClass);
        }
        return classes;
    }

    private Set<SootClass> getAllParentClasses(SootClass sc) {
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        HashSet<SootClass> classes = new HashSet<SootClass>();
        while (!workList.isEmpty()) {
            List<SootClass> hierarchyClasses;
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isInterface()) {
                hierarchyClasses = this.hierarchy.getSuperinterfacesOf(curClass);
                workList.addAll(hierarchyClasses);
                continue;
            }
            hierarchyClasses = this.hierarchy.getSuperclassesOf(curClass);
            workList.addAll(hierarchyClasses);
            classes.add(curClass);
        }
        return classes;
    }

    public SummaryResponse resolve(SummaryQuery query) {
        return this.methodToImplFlows.getUnchecked(query);
    }
}

