/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SequentialEntryPointCreator;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.methodSummary.DefaultSummaryConfig;
import soot.jimple.infoflow.methodSummary.data.factory.SourceSinkFactory;
import soot.jimple.infoflow.methodSummary.data.provider.EagerSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.LazySummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.MemorySummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.MergingSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.MethodFlow;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.generator.IClassSummaryHandler;
import soot.jimple.infoflow.methodSummary.generator.ISummaryInfoflow;
import soot.jimple.infoflow.methodSummary.generator.SummaryGenerationTaintWrapper;
import soot.jimple.infoflow.methodSummary.generator.SummaryGeneratorConfiguration;
import soot.jimple.infoflow.methodSummary.generator.SummaryInfoflow;
import soot.jimple.infoflow.methodSummary.generator.SummaryNativeCallHandler;
import soot.jimple.infoflow.methodSummary.generator.gaps.GapManager;
import soot.jimple.infoflow.methodSummary.generator.gaps.IGapManager;
import soot.jimple.infoflow.methodSummary.handler.SummaryTaintPropagationHandler;
import soot.jimple.infoflow.methodSummary.postProcessor.InfoflowResultPostProcessor;
import soot.jimple.infoflow.methodSummary.postProcessor.SummaryFlowCompactor;
import soot.jimple.infoflow.methodSummary.source.SummarySourceSinkManager;
import soot.jimple.infoflow.methodSummary.taintWrappers.AccessPathFragment;
import soot.jimple.infoflow.methodSummary.taintWrappers.SummaryTaintWrapper;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.options.Options;

public class SummaryGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SummaryGenerator.class);
    public static final String DUMMY_MAIN_SIG = "<dummyMainClass: void dummyMainMethod(java.lang.String[])>";
    protected boolean debug = false;
    protected INativeCallHandler nativeCallHandler;
    protected IInfoflowConfig sootConfig;
    protected SummaryGeneratorConfiguration config = new SummaryGeneratorConfiguration();
    protected List<String> substitutedWith = new LinkedList<String>();
    protected SummaryTaintWrapper summaryTaintWrapper;
    protected boolean summaryTaintWrapperInitialized = false;
    protected MemorySummaryProvider onFlySummaryProvider = null;

    protected void initializeSummaryTaintWrapper() {
        if (this.summaryTaintWrapperInitialized) {
            return;
        }
        this.summaryTaintWrapperInitialized = true;
        try {
            Set<String> additionalSummaryDirs;
            ArrayList<IMethodSummaryProvider> innerProviders = new ArrayList<IMethodSummaryProvider>();
            if (this.config.getApplySummariesOnTheFly()) {
                this.onFlySummaryProvider = new MemorySummaryProvider();
                innerProviders.add(this.onFlySummaryProvider);
            }
            if ((additionalSummaryDirs = this.config.getAdditionalSummaryDirectories()) != null && !additionalSummaryDirs.isEmpty()) {
                LazySummaryProvider lazySummaryProvider = new LazySummaryProvider(additionalSummaryDirs.stream().map(d -> new File((String)d)).collect(Collectors.toList()));
                innerProviders.add(lazySummaryProvider);
            }
            if (this.config.isUseDefaultSummaries()) {
                innerProviders.add(new EagerSummaryProvider("/summariesManual"));
            }
            MergingSummaryProvider provider = new MergingSummaryProvider(innerProviders);
            this.summaryTaintWrapper = new SummaryTaintWrapper(provider);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("An error occurred while loading the fallback taint wrapper, proceeding without fallback", e);
        }
    }

    public void releaseSummaryTaintWrapper() {
        this.summaryTaintWrapper = null;
        this.summaryTaintWrapperInitialized = false;
    }

    public ClassSummaries createMethodSummaries(String classpath, Collection<String> classNames) {
        return this.createMethodSummaries(classpath, classNames, null);
    }

    public ClassSummaries createMethodSummaries(String classpath, Collection<String> classNames, IClassSummaryHandler handler) {
        G.reset();
        boolean hasWildcard = false;
        for (String className : classNames) {
            if (!className.endsWith(".*")) continue;
            hasWildcard = true;
            break;
        }
        if (this.config.getWriteOutputFiles()) {
            Options.v().set_output_format(1);
        } else {
            Options.v().set_output_format(12);
        }
        if (hasWildcard || this.config.getLoadFullJAR() || this.config.getSummarizeFullJAR()) {
            Options.v().set_process_dir(Arrays.asList(classpath.split(File.pathSeparator)));
        } else {
            Options.v().set_soot_classpath(classpath);
        }
        Options.v().set_whole_program(false);
        Options.v().set_allow_phantom_refs(true);
        for (String className : classNames) {
            if (className.endsWith(".*")) continue;
            Scene.v().addBasicClass(className, 2);
        }
        if (classpath.toLowerCase().endsWith(".apk")) {
            Options.v().set_src_prec(5);
            Options.v().set_process_multiple_dex(true);
            if (this.config.getAndroidPlatformDir() != null) {
                Options.v().set_android_jars(this.config.getAndroidPlatformDir());
            }
        } else {
            Options.v().set_src_prec(1);
        }
        Scene.v().loadNecessaryClasses();
        HashSet<ClassAnalysisTask> realClasses = new HashSet<ClassAnalysisTask>(classNames.size());
        if (this.config.getSummarizeFullJAR()) {
            Iterator<Object> scIt = Scene.v().getApplicationClasses().snapshotIterator();
            while (scIt.hasNext()) {
                SootClass sootClass = (SootClass)scIt.next();
                Scene.v().forceResolve(sootClass.getName(), 2);
                if (!sootClass.isConcrete()) continue;
                this.checkAndAdd(realClasses, sootClass.getName());
            }
        }
        for (String string : classNames) {
            if (string.endsWith(".*")) {
                String prefix = string.substring(0, string.length() - 1);
                Iterator<Object> scIt = Scene.v().getClasses().snapshotIterator();
                while (scIt.hasNext()) {
                    SootClass sootClass = (SootClass)scIt.next();
                    if (!sootClass.getName().startsWith(prefix)) continue;
                    Scene.v().forceResolve(sootClass.getName(), 2);
                    if (!sootClass.isConcrete()) continue;
                    this.checkAndAdd(realClasses, sootClass.getName());
                }
                continue;
            }
            SootClass sc3 = Scene.v().getSootClass(string);
            if (!sc3.isConcrete()) {
                for (String string2 : this.getImplementorsOf(sc3)) {
                    this.checkAndAdd(realClasses, string2);
                }
                continue;
            }
            this.checkAndAdd(realClasses, string);
        }
        ArrayList<ClassAnalysisTask> sortedTasks = new ArrayList<ClassAnalysisTask>(realClasses);
        if (this.config.getApplySummariesOnTheFly()) {
            sortedTasks.sort(new AnalysisTasksComparator());
        }
        for (ClassAnalysisTask analysisTask : sortedTasks) {
            HashSet<String> doneMethods = new HashSet<String>();
            SootClass sootClass = Scene.v().getSootClass(analysisTask.className);
            for (SootMethod sm : sootClass.getMethods()) {
                if (!this.checkAndAdd(analysisTask, sm)) continue;
                doneMethods.add(sm.getSubSignature());
            }
            ArrayList<SootClass> parentClasses = new ArrayList<SootClass>();
            if (sootClass.hasSuperclass()) {
                parentClasses.add(sootClass.getSuperclassUnsafe());
            }
            parentClasses.addAll(sootClass.getInterfaces());
            HashSet<SootClass> doneClasses = new HashSet<SootClass>();
            while (!parentClasses.isEmpty()) {
                SootClass curClass = (SootClass)parentClasses.remove(0);
                if (curClass == null || curClass.getName().equals("java.lang.Object") || doneClasses.contains(curClass)) continue;
                for (SootMethod sm : curClass.getMethods()) {
                    if (doneMethods.contains(sm.getSubSignature()) || !this.checkAndAdd(analysisTask, sm)) continue;
                    doneMethods.add(sm.getSubSignature());
                }
                doneClasses.add(curClass);
                if (curClass.hasSuperclass()) {
                    parentClasses.add(curClass.getSuperclassUnsafe());
                }
                parentClasses.addAll(curClass.getInterfaces());
            }
        }
        G.reset();
        GapManager gapManager = new GapManager();
        ClassSummaries summaries = new ClassSummaries();
        for (ClassAnalysisTask classAnalysisTask : sortedTasks) {
            String className = classAnalysisTask.className;
            if (handler != null && !handler.onBeforeAnalyzeClass(className)) {
                logger.info(String.format("Skipping over class %s", className));
                continue;
            }
            ClassMethodSummaries curSummaries = null;
            for (int i = 0; i < this.config.getRepeatCount(); ++i) {
                System.gc();
                long nanosBeforeClass = System.nanoTime();
                System.out.println(String.format("Analyzing class %s", className));
                curSummaries = new ClassMethodSummaries(className);
                for (String methodSig : classAnalysisTask.methods) {
                    MethodSummaries newSums = this.createMethodSummary(classpath, methodSig, className, gapManager, new SummaryHierarchyGenerator(curSummaries));
                    if (handler != null) {
                        handler.onMethodFinished(methodSig, newSums);
                        if (this.onFlySummaryProvider != null) {
                            this.onFlySummaryProvider.addSummary(new ClassMethodSummaries(className, newSums));
                        }
                    }
                    curSummaries.merge(newSums);
                    if (this.config.getClassSummaryTimeout() <= 0L || !((double)(System.nanoTime() - nanosBeforeClass) / 1.0E9 > (double)this.config.getClassSummaryTimeout())) continue;
                    logger.info(String.format("Class summaries for %s aborted after %.2f seconds. Still got %d summaries.", className, (double)(System.nanoTime() - nanosBeforeClass) / 1.0E9, curSummaries.getFlowCount()));
                    break;
                }
                logger.info(String.format("Class summaries for %s done in %.2f seconds for %d summaries", className, (double)(System.nanoTime() - nanosBeforeClass) / 1.0E9, curSummaries.getFlowCount()));
            }
            if (handler != null) {
                handler.onClassFinished(curSummaries);
            }
            summaries.merge(curSummaries);
            new SummaryFlowCompactor(curSummaries.getMethodSummaries()).compact();
        }
        this.calculateDependencies(summaries);
        return summaries;
    }

    private boolean checkAndAdd(ClassAnalysisTask analysisTask, SootMethod sm) {
        if (!sm.isConcrete()) {
            return false;
        }
        if (!sm.isPublic() && !sm.isProtected()) {
            return false;
        }
        String subSig = sm.getSubSignature();
        if (!this.config.getSummarizeHashCodeEquals() && (subSig.equals("int hashCode()") || subSig.equals("boolean equals(java.lang.Object)"))) {
            return false;
        }
        analysisTask.addMethod(sm.getSignature());
        return true;
    }

    private void checkAndAdd(Set<ClassAnalysisTask> classes, String className) {
        if (this.config.getExcludes() != null) {
            for (String excl : this.config.getExcludes()) {
                String baseName;
                if (excl.equals(className)) {
                    return;
                }
                if (!excl.endsWith(".*") || !className.startsWith(baseName = excl.substring(0, excl.length() - 1))) continue;
                return;
            }
        }
        classes.add(new ClassAnalysisTask(className));
    }

    private Collection<? extends String> getImplementorsOf(SootClass sc) {
        HashSet<String> classes = new HashSet<String>();
        HashSet<SootClass> doneSet = new HashSet<SootClass>();
        ArrayList<SootClass> workList = new ArrayList<SootClass>();
        workList.add(sc);
        while (!workList.isEmpty()) {
            SootClass curClass = (SootClass)workList.remove(0);
            if (!doneSet.add(curClass)) continue;
            if (curClass.isConcrete()) {
                classes.add(curClass.getName());
            }
            if (sc.isInterface()) {
                workList.addAll(Scene.v().getActiveHierarchy().getImplementersOf(sc));
                workList.addAll(Scene.v().getActiveHierarchy().getSubinterfacesOf(sc));
                continue;
            }
            for (SootClass c : Scene.v().getActiveHierarchy().getSubclassesOf(sc)) {
                classes.add(c.getName());
            }
        }
        return classes;
    }

    private void calculateDependencies(ClassSummaries summaries) {
        for (MethodFlow flow : summaries.getAllFlows()) {
            AccessPathFragment sinkAP;
            String className;
            AccessPathFragment sourceAP;
            if (flow.source().hasAccessPath() && !(sourceAP = flow.source().getAccessPath()).isEmpty()) {
                for (String apElement : sourceAP.getFields()) {
                    className = this.getTypeFromFieldDef(apElement);
                    if (summaries.hasSummariesForClass(className)) continue;
                    summaries.addDependency(className);
                }
            }
            if (!flow.sink().hasAccessPath() || (sinkAP = flow.sink().getAccessPath()).isEmpty()) continue;
            for (String apElement : sinkAP.getFields()) {
                className = this.getTypeFromFieldDef(apElement);
                if (summaries.hasSummariesForClass(className)) continue;
                summaries.addDependency(className);
            }
        }
    }

    private String getTypeFromFieldDef(String apElement) {
        apElement = apElement.substring(apElement.indexOf(":") + 1).trim();
        apElement = apElement.substring(0, apElement.indexOf(" "));
        while (apElement.endsWith("[]")) {
            apElement = apElement.substring(0, apElement.length() - 2);
        }
        return apElement;
    }

    public MethodSummaries createMethodSummary(String classpath, String methodSig) {
        return this.createMethodSummary(classpath, methodSig, "", new GapManager());
    }

    private MethodSummaries createMethodSummary(String classpath, String methodSig, String parentClass, GapManager gapManager) {
        return this.createMethodSummary(classpath, methodSig, parentClass, gapManager, null);
    }

    protected MethodSummaries createMethodSummary(String classpath, final String methodSig, String parentClass, final IGapManager gapManager, final ResultsAvailableHandler resultHandler) {
        this.initializeSummaryTaintWrapper();
        logger.info(String.format("Computing method summary for %s...", methodSig));
        long nanosBeforeMethod = System.nanoTime();
        final SummarySourceSinkManager sourceSinkManager = this.createSourceSinkManager(methodSig, parentClass);
        final MethodSummaries summaries = new MethodSummaries();
        final ISummaryInfoflow infoflow = this.initInfoflow(summaries, gapManager);
        final SummaryTaintPropagationHandler listener = new SummaryTaintPropagationHandler(methodSig, parentClass, gapManager);
        infoflow.setTaintPropagationHandler(listener);
        infoflow.addPreprocessor(new PreAnalysisHandler(){

            @Override
            public void onBeforeCallgraphConstruction() {
            }

            @Override
            public void onAfterCallgraphConstruction() {
                listener.addExcludedMethod(Scene.v().getMethod(SummaryGenerator.DUMMY_MAIN_SIG));
            }
        });
        infoflow.addResultsAvailableHandler(new ResultsAvailableHandler(){

            @Override
            public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
                InfoflowResultPostProcessor processor = infoflow.getManager() != null ? new InfoflowResultPostProcessor(listener.getResult(), infoflow.getManager(), methodSig, sourceSinkManager.getSourceSinkFactory(), gapManager) : new InfoflowResultPostProcessor(listener.getResult(), infoflow.getConfig(), methodSig, sourceSinkManager.getSourceSinkFactory(), gapManager);
                processor.postProcess(summaries);
                if (resultHandler != null) {
                    resultHandler.onResultsAvailable(cfg, results);
                }
            }
        });
        try {
            infoflow.computeInfoflow(null, classpath, this.createEntryPoint(Collections.singletonList(methodSig), parentClass), (ISourceSinkManager)sourceSinkManager);
        }
        catch (Exception e) {
            logger.error(String.format("Could not generate summary for method %s", methodSig, e));
            throw e;
        }
        logger.info("Method summary for " + methodSig + " done in " + (double)(System.nanoTime() - nanosBeforeMethod) / 1.0E9 + " seconds");
        return summaries;
    }

    protected SummarySourceSinkManager createSourceSinkManager(String methodSig, String parentClass) {
        SourceSinkFactory sourceSinkFactory = new SourceSinkFactory(this.config.getAccessPathConfiguration().getAccessPathLength());
        return new SummarySourceSinkManager(methodSig, parentClass, sourceSinkFactory);
    }

    private BaseEntryPointCreator createEntryPoint(Collection<String> entryPoints, String parentClass) {
        SequentialEntryPointCreator dEntryPointCreater = new SequentialEntryPointCreator(entryPoints);
        ArrayList<String> substClasses = new ArrayList<String>(this.substitutedWith);
        if (parentClass != null && !parentClass.isEmpty()) {
            substClasses.add(parentClass);
        }
        dEntryPointCreater.setSubstituteClasses(substClasses);
        dEntryPointCreater.setSubstituteCallParams(true);
        dEntryPointCreater.setIgnoreSystemClassParams(false);
        return dEntryPointCreater;
    }

    protected ISummaryInfoflow getInfoflowInstance() {
        SummaryInfoflow infoflow = new SummaryInfoflow();
        infoflow.setPathBuilderFactory(new DefaultPathBuilderFactory(this.config.getPathConfiguration()){

            @Override
            public boolean supportsPathReconstruction() {
                return true;
            }
        });
        return infoflow;
    }

    protected SummaryGenerationTaintWrapper createTaintWrapper(MethodSummaries summaries, IGapManager gapManager) {
        return new SummaryGenerationTaintWrapper(summaries, gapManager);
    }

    protected ISummaryInfoflow initInfoflow(MethodSummaries summaries, IGapManager gapManager) {
        ISummaryInfoflow iFlow = this.getInfoflowInstance();
        InfoflowConfiguration.setMergeNeighbors(true);
        iFlow.setConfig(this.config);
        if (this.nativeCallHandler == null) {
            iFlow.setNativeCallHandler(new SummaryNativeCallHandler());
        } else {
            iFlow.setNativeCallHandler(new SummaryNativeCallHandler(this.nativeCallHandler));
        }
        SummaryGenerationTaintWrapper summaryGenWrapper = this.createTaintWrapper(summaries, gapManager);
        this.summaryTaintWrapper.setFallbackTaintWrapper(summaryGenWrapper);
        iFlow.setTaintWrapper(this.summaryTaintWrapper);
        if (this.sootConfig == null) {
            iFlow.setSootConfig(new DefaultSummaryConfig());
        } else {
            iFlow.setSootConfig(this.sootConfig);
        }
        return iFlow;
    }

    public void setNativeCallHandler(INativeCallHandler nativeCallHandler) {
        this.nativeCallHandler = nativeCallHandler;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    public List<String> getSubstitutedWith() {
        return this.substitutedWith;
    }

    public void setSubstitutedWith(List<String> substitutedWith) {
        this.substitutedWith = substitutedWith;
    }

    public SummaryGeneratorConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(SummaryGeneratorConfiguration config) {
        this.config = config;
    }

    private static class AnalysisTasksComparator
    implements Comparator<ClassAnalysisTask> {
        private AnalysisTasksComparator() {
        }

        @Override
        public int compare(ClassAnalysisTask o1, ClassAnalysisTask o2) {
            SootClass sc1 = Scene.v().getSootClassUnsafe(o1.className);
            SootClass sc2 = Scene.v().getSootClassUnsafe(o2.className);
            if (sc1 != null && sc2 != null) {
                int numDeps1 = this.getDependencyCount(sc1);
                int numDeps2 = this.getDependencyCount(sc2);
                return numDeps1 - numDeps2;
            }
            return 0;
        }

        private int getDependencyCount(SootClass sc) {
            HashSet<SootClass> dependencies = new HashSet<SootClass>();
            for (SootMethod sm : new ArrayList<SootMethod>(sc.getMethods())) {
                if (!sm.isConcrete()) continue;
                for (Unit u : sm.retrieveActiveBody().getUnits()) {
                    SootMethod callee;
                    SootField fld;
                    Stmt stmt = (Stmt)u;
                    if (stmt.containsFieldRef() && (fld = stmt.getFieldRef().getField()).getDeclaringClass() != sc) {
                        dependencies.add(fld.getDeclaringClass());
                    }
                    if (!stmt.containsInvokeExpr() || (callee = stmt.getInvokeExpr().getMethod()).getDeclaringClass() == sc) continue;
                    dependencies.add(callee.getDeclaringClass());
                }
            }
            return dependencies.size();
        }
    }

    private static class ClassAnalysisTask {
        private final String className;
        private final Set<String> methods = new HashSet<String>();

        public ClassAnalysisTask(String className) {
            this.className = className;
        }

        public void addMethod(String signature) {
            this.methods.add(signature);
        }
    }

    private static class SummaryHierarchyGenerator
    implements ResultsAvailableHandler {
        private final ClassMethodSummaries summaries;

        public SummaryHierarchyGenerator(ClassMethodSummaries summaries) {
            this.summaries = summaries;
        }

        @Override
        public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
            SootClass sc = Scene.v().getSootClassUnsafe(this.summaries.getClassName());
            if (sc != null) {
                if (sc.hasSuperclass()) {
                    this.summaries.setSuperClass(sc.getSuperclass().getName());
                }
                for (SootClass intf : sc.getInterfaces()) {
                    this.summaries.addInterface(intf.getName());
                }
            }
        }
    }
}

