/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.Map;
import soot.RefType;
import soot.Scene;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSink;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.AbstractMethodSummary;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class MethodFlow
extends AbstractMethodSummary {
    private final FlowSource from;
    private final FlowSink to;
    private final boolean isAlias;
    private final Boolean typeChecking;
    private final Boolean ignoreTypes;
    private final Boolean cutSubFields;

    public MethodFlow(String methodSig, FlowSource from, FlowSink to, boolean isAlias, Boolean typeChecking, Boolean ignoreTypes, Boolean cutSubFields) {
        super(methodSig);
        this.from = from;
        this.to = to;
        this.isAlias = isAlias;
        this.typeChecking = typeChecking;
        this.ignoreTypes = ignoreTypes;
        this.cutSubFields = cutSubFields;
    }

    public FlowSource source() {
        return this.from;
    }

    public FlowSink sink() {
        return this.to;
    }

    public boolean isCoarserThan(MethodFlow flow) {
        if (flow.equals(this)) {
            return true;
        }
        return this.from.isCoarserThan(flow.source()) && this.to.isCoarserThan(flow.sink());
    }

    public MethodFlow reverse() {
        boolean taintSubFields = this.to.taintSubFields();
        SourceSinkType fromType = this.to.getType();
        SourceSinkType toType = this.from.getType();
        if (this.from.getType() == SourceSinkType.Field && !this.from.hasAccessPath() && this.from.hasGap()) {
            toType = SourceSinkType.GapBaseObject;
            taintSubFields = false;
        }
        if (this.to.isGapBaseObject()) {
            fromType = SourceSinkType.Field;
            taintSubFields = true;
        }
        FlowSource reverseSource = new FlowSource(fromType, this.to.getParameterIndex(), this.to.getBaseType(), this.to.getAccessPath(), this.to.getGap(), this.to.isMatchStrict());
        FlowSink reverseSink = new FlowSink(toType, this.from.getParameterIndex(), this.from.getBaseType(), this.from.getAccessPath(), taintSubFields, this.from.getGap(), this.from.isMatchStrict());
        return new MethodFlow(this.methodSig, reverseSource, reverseSink, this.isAlias, this.typeChecking, this.ignoreTypes, this.cutSubFields);
    }

    public boolean isAlias() {
        return this.isAlias;
    }

    public Boolean getTypeChecking() {
        return this.typeChecking;
    }

    public Boolean getCutSubFields() {
        return this.cutSubFields;
    }

    public boolean isCustom() {
        return this.from.isCustom() || this.to.isCustom();
    }

    @Override
    public MethodFlow replaceGaps(Map<Integer, GapDefinition> replacementMap) {
        if (replacementMap == null) {
            return this;
        }
        return new MethodFlow(this.methodSig, (FlowSource)this.from.replaceGaps((Map)replacementMap), (FlowSink)this.to.replaceGaps((Map)replacementMap), this.isAlias, this.typeChecking, this.ignoreTypes, this.cutSubFields);
    }

    public void validate() {
        this.source().validate(this.methodSig);
        this.sink().validate(this.methodSig);
        if (this.sink().getType() == SourceSinkType.GapBaseObject && this.sink().getGap() != null) {
            String sinkType = SootMethodRepresentationParser.v().parseSootMethodString(this.sink().getGap().getSignature()).getClassName();
            RefType t1 = RefType.v(this.sink().getBaseType());
            RefType t2 = RefType.v(sinkType);
            if (!Scene.v().getFastHierarchy().canStoreType(t1, t2) && !Scene.v().getFastHierarchy().canStoreType(t2, t1)) {
                throw new RuntimeException("Target type of gap base flow is invalid");
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodFlow other = (MethodFlow)obj;
        if (this.cutSubFields == null ? other.cutSubFields != null : !this.cutSubFields.equals(other.cutSubFields)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.isAlias != other.isAlias) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        return !(this.typeChecking == null ? other.typeChecking != null : !this.typeChecking.equals(other.typeChecking));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cutSubFields == null ? 0 : this.cutSubFields.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.isAlias ? 1231 : 1237);
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.typeChecking == null ? 0 : this.typeChecking.hashCode());
        return result;
    }

    public String toString() {
        return "{" + this.methodSig + " Source: [" + this.from.toString() + "] Sink: [" + this.to.toString() + "]}";
    }

    public boolean getIgnoreTypes() {
        if (this.ignoreTypes == null) {
            return this.typeChecking != null && this.typeChecking == false && "java.lang.Object[]".equals(this.to.getLastFieldType());
        }
        return this.ignoreTypes;
    }
}

