/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.provider.AbstractMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;

public class MemorySummaryProvider
extends AbstractMethodSummaryProvider {
    private final ClassSummaries summaries;

    public MemorySummaryProvider() {
        this.summaries = new ClassSummaries();
    }

    public MemorySummaryProvider(ClassSummaries summaries) {
        this.summaries = summaries;
    }

    @Override
    public Set<String> getSupportedClasses() {
        return this.summaries.getClasses();
    }

    @Override
    public boolean supportsClass(String clazz) {
        return this.summaries.hasSummariesForClass(clazz);
    }

    @Override
    public ClassMethodSummaries getMethodFlows(String className, String methodSubSignature) {
        ClassMethodSummaries methodSummaries = this.summaries.getClassSummaries(className);
        if (methodSummaries == null) {
            return null;
        }
        return methodSummaries.filterForMethod(methodSubSignature);
    }

    @Override
    public ClassSummaries getMethodFlows(Set<String> classes, String methodSignature) {
        return this.summaries.filterForMethod(classes, methodSignature);
    }

    @Override
    public ClassMethodSummaries getClassFlows(String clazz) {
        return this.summaries.getClassSummaries(clazz);
    }

    @Override
    public boolean mayHaveSummaryForMethod(String subsig) {
        return true;
    }

    @Override
    public ClassSummaries getSummaries() {
        return this.summaries;
    }

    public void addSummary(ClassMethodSummaries summaries) {
        summaries.merge(summaries);
    }

    @Override
    public boolean isMethodExcluded(String className, String subSignature) {
        ClassMethodSummaries classSummaries = this.summaries.getClassSummaries(className);
        if (classSummaries == null) {
            return false;
        }
        return classSummaries.getMethodSummaries().isExcluded(subSignature);
    }

    @Override
    public Set<String> getAllClassesWithSummaries() {
        return this.summaries.getClasses();
    }
}

