/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.memory;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.memory.ISolversTerminatedCallback;
import soot.jimple.infoflow.memory.MemoryWarningSystem;
import soot.jimple.infoflow.memory.reasons.OutOfMemoryReason;
import soot.jimple.infoflow.results.InfoflowResults;

public class FlowDroidMemoryWatcher {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MemoryWarningSystem warningSystem = new MemoryWarningSystem();
    private final Set<IMemoryBoundedSolver> solvers = new ConcurrentHashSet<IMemoryBoundedSolver>();
    private final InfoflowResults results;
    private ISolversTerminatedCallback terminationCallback = null;

    public FlowDroidMemoryWatcher() {
        this(null);
    }

    public FlowDroidMemoryWatcher(double threshold) {
        this(null, threshold);
    }

    public FlowDroidMemoryWatcher(InfoflowResults res) {
        this(res, 0.9);
    }

    public FlowDroidMemoryWatcher(InfoflowResults res, double threshold) {
        this.warningSystem.addListener(new MemoryWarningSystem.OnMemoryThresholdReached(){

            @Override
            public void onThresholdReached(long usedMemory, long maxMemory) {
                if (FlowDroidMemoryWatcher.this.results != null) {
                    FlowDroidMemoryWatcher.this.results.addException("Memory threshold reached");
                }
                FlowDroidMemoryWatcher.this.forceTerminate();
                FlowDroidMemoryWatcher.this.logger.warn("Running out of memory, solvers terminated");
                if (FlowDroidMemoryWatcher.this.terminationCallback != null) {
                    FlowDroidMemoryWatcher.this.terminationCallback.onSolversTerminated();
                }
            }
        });
        this.warningSystem.setWarningThreshold(threshold);
        this.results = res;
    }

    public void addSolver(IMemoryBoundedSolver solver) {
        this.solvers.add(solver);
    }

    public boolean removeSolver(IMemoryBoundedSolver solver) {
        return this.solvers.remove(solver);
    }

    public void clearSolvers() {
        this.solvers.clear();
    }

    public void close() {
        this.clearSolvers();
        this.warningSystem.close();
    }

    public void forceTerminate() {
        Runtime runtime = Runtime.getRuntime();
        long usedMem = runtime.totalMemory() - runtime.freeMemory();
        this.forceTerminate(new OutOfMemoryReason(usedMem));
    }

    public void forceTerminate(ISolverTerminationReason reason) {
        for (IMemoryBoundedSolver solver : this.solvers) {
            solver.forceTerminate(reason);
        }
    }

    public void setTerminationCallback(ISolversTerminatedCallback terminationCallback) {
        this.terminationCallback = terminationCallback;
    }
}

