/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.IntType;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.EqExpr;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.toolkits.scalar.NopEliminator;

public class DefaultEntryPointCreator
extends BaseEntryPointCreator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntryPointCreator.class);
    private final Collection<String> methodsToCall;

    public DefaultEntryPointCreator(Collection<String> methodsToCall) {
        this.methodsToCall = methodsToCall;
        this.setAllowNonPublicConstructors(true);
    }

    @Override
    protected SootMethod createDummyMainInternal() {
        HashMap<String, Set<String>> classMap = SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false);
        HashMap<String, Local> localVarsForClasses = new HashMap<String, Local>();
        for (String className : classMap.keySet()) {
            SootClass createdClass = Scene.v().forceResolve(className, 3);
            createdClass.setApplicationClass();
            Local localVal = this.generateClassConstructor(createdClass);
            if (localVal == null) {
                logger.warn("Cannot generate constructor for class: {}", (Object)createdClass);
                continue;
            }
            localVarsForClasses.put(className, localVal);
        }
        int conditionCounter = 0;
        Jimple jimple = Jimple.v();
        NopStmt startStmt = jimple.newNopStmt();
        NopStmt endStmt = jimple.newNopStmt();
        Local intCounter = this.generator.generateLocal((Type)IntType.v());
        this.body.getUnits().add(startStmt);
        for (Map.Entry entry : classMap.entrySet()) {
            Local classLocal = (Local)localVarsForClasses.get(entry.getKey());
            for (String method : (Set)entry.getValue()) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(method);
                SootMethod currentMethod = this.findMethod(Scene.v().getSootClass(methodAndClass.getClassName()), methodAndClass.getSubSignature());
                if (currentMethod == null) {
                    logger.warn("Entry point not found: {}", (Object)method);
                    continue;
                }
                EqExpr cond = jimple.newEqExpr(intCounter, IntConstant.v(conditionCounter));
                ++conditionCounter;
                NopStmt thenStmt = jimple.newNopStmt();
                IfStmt ifStmt = jimple.newIfStmt((Value)cond, thenStmt);
                this.body.getUnits().add(ifStmt);
                this.buildMethodCall(currentMethod, classLocal);
                this.body.getUnits().add(thenStmt);
            }
        }
        this.body.getUnits().add(endStmt);
        GotoStmt gotoStart = jimple.newGotoStmt(startStmt);
        this.body.getUnits().add(gotoStart);
        this.body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(this.body);
        this.eliminateSelfLoops();
        return this.mainMethod;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        return SootMethodRepresentationParser.v().parseClassNames(this.methodsToCall, false).keySet();
    }

    @Override
    public Collection<SootMethod> getAdditionalMethods() {
        return null;
    }

    @Override
    public Collection<SootField> getAdditionalFields() {
        return null;
    }
}

