/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import gnu.trove.set.hash.TCustomHashSet;
import gnu.trove.strategy.HashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.ConcreteRef;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.typing.TypeUtils;

public class AccessPathFactory {
    protected static final Logger logger = LoggerFactory.getLogger(AccessPathFactory.class);
    private final InfoflowConfiguration config;
    private final TypeUtils typeUtils;
    private MyConcurrentHashMap<Type, Set<AccessPathFragment[]>> baseRegister = new MyConcurrentHashMap();

    public AccessPathFactory(InfoflowConfiguration config, TypeUtils typeUtils) {
        this.config = config;
        this.typeUtils = typeUtils;
    }

    public AccessPath createAccessPath(Value val, boolean taintSubFields) {
        return this.createAccessPath(val, null, null, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, Type valType, boolean taintSubFields, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, valType, null, taintSubFields, false, true, arrayTaintType);
    }

    public AccessPath createAccessPath(Value val, SootField[] appendingFields, boolean taintSubFields) {
        return this.createAccessPath(val, null, AccessPathFragment.createFragmentArray(appendingFields, null), taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, AccessPathFragment[] appendingFragments, boolean taintSubFields) {
        return this.createAccessPath(val, null, appendingFragments, taintSubFields, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
    }

    public AccessPath createAccessPath(Value val, Type valType, AccessPathFragment[] fragments, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType) {
        return this.createAccessPath(val, valType, fragments, taintSubFields, cutFirstField, reduceBases, arrayTaintType, false);
    }

    public AccessPath createAccessPath(Value val, Type valType, AccessPathFragment[] appendingFragments, boolean taintSubFields, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        boolean cutOffApproximation;
        ArrayType at;
        Object[] fragments;
        Type baseType;
        Local value;
        ConcreteRef ref;
        if (val != null && !AccessPath.canContainValue(val)) {
            logger.error("Access paths cannot be rooted in values of type {}", (Object)val.getClass().getName());
            return null;
        }
        if (val == null && appendingFragments == null) {
            return null;
        }
        InfoflowConfiguration.AccessPathConfiguration accessPathConfig = this.config.getAccessPathConfiguration();
        if (!this.config.getEnableTypeChecking()) {
            valType = null;
        }
        if (val instanceof FieldRef) {
            ref = (FieldRef)val;
            if (val instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)val;
                value = (Local)iref.getBase();
                baseType = value.getType();
            } else {
                value = null;
                baseType = null;
            }
            fragments = new AccessPathFragment[(appendingFragments == null ? 0 : appendingFragments.length) + 1];
            fragments[0] = new AccessPathFragment(ref.getField(), null);
            if (appendingFragments != null) {
                System.arraycopy(appendingFragments, 0, fragments, 1, appendingFragments.length);
            }
        } else if (val instanceof ArrayRef) {
            ref = (ArrayRef)val;
            value = (Local)ref.getBase();
            baseType = valType == null ? value.getType() : valType;
            fragments = appendingFragments == null ? null : Arrays.copyOf(appendingFragments, appendingFragments.length);
        } else {
            value = (Local)val;
            baseType = valType == null ? (value == null ? null : value.getType()) : valType;
            Object[] objectArray = fragments = appendingFragments == null ? null : Arrays.copyOf(appendingFragments, appendingFragments.length);
        }
        if (accessPathConfig.getAccessPathLength() == 0) {
            fragments = null;
        }
        if (cutFirstField && fragments != null && fragments.length > 0) {
            AccessPathFragment[] newFragments = new AccessPathFragment[fragments.length - 1];
            System.arraycopy(fragments, 1, newFragments, 0, newFragments.length);
            Object object = fragments = newFragments.length > 0 ? newFragments : null;
        }
        if (this.config.getAccessPathConfiguration().getUseSameFieldReduction() && fragments != null && fragments.length > 1) {
            for (int bucketStart = fragments.length - 2; bucketStart >= 0; --bucketStart) {
                int repeatPos = -1;
                for (int i = bucketStart + 1; i < fragments.length; ++i) {
                    if (fragments[i].getField() != fragments[bucketStart].getField()) continue;
                    repeatPos = i;
                    break;
                }
                int repeatLen = repeatPos - bucketStart;
                if (repeatPos < 0) continue;
                boolean matches = true;
                for (int i = 0; i < repeatPos - bucketStart; ++i) {
                    matches &= repeatPos + i < fragments.length && ((AccessPathFragment)fragments[bucketStart + i]).getField() == ((AccessPathFragment)fragments[repeatPos + i]).getField();
                }
                if (!matches) continue;
                AccessPathFragment[] newFragments = new AccessPathFragment[fragments.length - repeatLen];
                System.arraycopy(fragments, 0, newFragments, 0, bucketStart + 1);
                System.arraycopy(fragments, repeatPos + 1, newFragments, bucketStart + 1, fragments.length - repeatPos - 1);
                fragments = newFragments;
                break;
            }
        }
        if (this.config.getEnableTypeChecking()) {
            if (value != null && value.getType() != baseType) {
                if ((baseType = this.typeUtils.getMorePreciseType(baseType, value.getType())) == null) {
                    return null;
                }
                if (fragments != null && fragments.length > 0 && !(baseType instanceof ArrayType)) {
                    baseType = this.typeUtils.getMorePreciseType(baseType, fragments[0].getField().getDeclaringClass().getType());
                }
                if (baseType == null) {
                    return null;
                }
            }
            if (fragments != null && fragments.length > 0) {
                for (int i = 0; i < fragments.length - 1; ++i) {
                    Type curType;
                    AccessPathFragment curFragment = fragments[i];
                    Type oldType = curType = curFragment.getFieldType();
                    if (!(curType instanceof ArrayType)) {
                        curType = this.typeUtils.getMorePreciseType(curType, fragments[i + 1].getField().getDeclaringClass().getType());
                    }
                    if (curType == oldType) continue;
                    fragments[i] = curFragment.copyWithNewType(curType);
                }
            }
        }
        if (fragments != null && Arrays.stream(fragments).anyMatch(f -> !f.isValid())) {
            return null;
        }
        if (value != null && value.getType() instanceof ArrayType && !((at = (ArrayType)value.getType()).getArrayElementType() instanceof RefLikeType) && fragments != null && fragments.length > 0) {
            return null;
        }
        if (accessPathConfig.getUseThisChainReduction() && reduceBases && fragments != null) {
            for (int i = 0; i < fragments.length; ++i) {
                SootField curField = fragments[i].getField();
                if (!curField.getName().startsWith("this$")) continue;
                String outerClassName = ((RefType)curField.getType()).getClassName();
                int startIdx = -1;
                if (value != null && value.getType() instanceof RefType && ((RefType)value.getType()).getClassName().equals(outerClassName)) {
                    startIdx = 0;
                } else {
                    for (int j = 0; j < i; ++j) {
                        SootField nextField = ((AccessPathFragment)fragments[j]).getField();
                        if (!(nextField.getType() instanceof RefType) || !((RefType)nextField.getType()).getClassName().equals(outerClassName)) continue;
                        startIdx = j;
                        break;
                    }
                }
                if (startIdx < 0) continue;
                AccessPathFragment[] newFragments = new AccessPathFragment[fragments.length - (i - startIdx) - 1];
                System.arraycopy(fragments, 0, newFragments, 0, startIdx);
                System.arraycopy(fragments, i + 1, newFragments, startIdx, fragments.length - i - 1);
                fragments = newFragments;
                break;
            }
        }
        boolean recursiveCutOff = false;
        if (accessPathConfig.getUseRecursiveAccessPaths() && reduceBases && fragments != null) {
            int ei;
            int n = ei = val instanceof StaticFieldRef ? 1 : 0;
            while (ei < fragments.length) {
                Type eiType = ei == 0 ? baseType : fragments[ei - 1].getFieldType();
                int ej = ei;
                while (ej < fragments.length) {
                    if (((AccessPathFragment)fragments[ej]).getFieldType() == eiType || ((AccessPathFragment)fragments[ej]).getField().getType() == eiType) {
                        AccessPathFragment[] newFragments = new AccessPathFragment[fragments.length - (ej - ei) - 1];
                        System.arraycopy(fragments, 0, newFragments, 0, ei);
                        if (fragments.length > ej) {
                            System.arraycopy(fragments, ej + 1, newFragments, ei, fragments.length - ej - 1);
                        }
                        AccessPathFragment[] base = new AccessPathFragment[ej - ei + 1];
                        System.arraycopy(fragments, ei, base, 0, base.length);
                        this.registerBase(eiType, base);
                        fragments = newFragments;
                        recursiveCutOff = true;
                        continue;
                    }
                    ++ej;
                }
                ++ei;
            }
        }
        if (fragments != null) {
            int maxAccessPathLength = accessPathConfig.getAccessPathLength();
            if (maxAccessPathLength >= 0) {
                int fieldNum = Math.min(maxAccessPathLength, fragments.length);
                if (fragments.length > fieldNum) {
                    taintSubFields = true;
                    cutOffApproximation = true;
                } else {
                    cutOffApproximation = recursiveCutOff;
                }
                if (fieldNum == 0) {
                    fragments = null;
                } else {
                    AccessPathFragment[] newFragments = new AccessPathFragment[fieldNum];
                    System.arraycopy(fragments, 0, newFragments, 0, fieldNum);
                    fragments = newFragments;
                }
            } else {
                cutOffApproximation = recursiveCutOff;
            }
        } else {
            cutOffApproximation = false;
            fragments = null;
        }
        assert (value == null || baseType instanceof ArrayType || TypeUtils.isObjectLikeType(baseType) || !(value.getType() instanceof ArrayType));
        assert (value == null || !(baseType instanceof ArrayType) || value.getType() instanceof ArrayType || TypeUtils.isObjectLikeType(value.getType())) : "Type mismatch. Type was " + baseType + ", value was: " + (value == null ? null : value.getType());
        if (baseType instanceof PrimType && fragments != null && fragments.length > 0) {
            logger.warn("Primitive types cannot have fields: baseType={} fields={}", (Object)baseType, (Object)Arrays.toString(fragments));
            return null;
        }
        if (fragments != null) {
            for (int i = 0; i < fragments.length - 2; ++i) {
                SootField f2 = ((AccessPathFragment)fragments[i]).getField();
                Type fieldType = f2.getType();
                if (!(fieldType instanceof PrimType)) continue;
                logger.warn("Primitive types cannot have fields: field={} type={}", (Object)f2, (Object)fieldType);
                return null;
            }
        }
        return new AccessPath(value, baseType, (AccessPathFragment[])fragments, taintSubFields, cutOffApproximation, arrayTaintType, canHaveImmutableAliases);
    }

    private void registerBase(Type eiType, AccessPathFragment[] base) {
        Set bases = this.baseRegister.computeIfAbsent(eiType, t -> Collections.synchronizedSet(new TCustomHashSet<AccessPathFragment[]>(new HashingStrategy<AccessPathFragment[]>(){
            private static final long serialVersionUID = 3017690689067651070L;

            @Override
            public int computeHashCode(AccessPathFragment[] arg0) {
                return Arrays.hashCode(arg0);
            }

            @Override
            public boolean equals(AccessPathFragment[] arg0, AccessPathFragment[] arg1) {
                return Arrays.equals(arg0, arg1);
            }
        })));
        bases.add(base);
    }

    public Collection<AccessPathFragment[]> getBaseForType(Type tp) {
        return (Collection)this.baseRegister.get(tp);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val) {
        return this.copyWithNewValue(original, val, original.getBaseType(), false);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField) {
        return this.copyWithNewValue(original, val, newType, cutFirstField, true);
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField, boolean reduceBases) {
        return this.copyWithNewValue(original, val, newType, cutFirstField, reduceBases, original.getArrayTaintType());
    }

    public AccessPath copyWithNewValue(AccessPath original, Value val, Type newType, boolean cutFirstField, boolean reduceBases, AccessPath.ArrayTaintType arrayTaintType) {
        if (original.getPlainValue() != null && original.getPlainValue().equals(val) && original.getBaseType().equals(newType) && original.getArrayTaintType() == arrayTaintType) {
            return original;
        }
        AccessPath newAP = this.createAccessPath(val, newType, original.getFragments(), original.getTaintSubFields(), cutFirstField, reduceBases, arrayTaintType, original.getCanHaveImmutableAliases());
        if (newAP != null && newAP.equals(original)) {
            return original;
        }
        return newAP;
    }

    public AccessPath merge(AccessPath ap1, AccessPath ap2) {
        return this.appendFields(ap1, ap2.getFragments(), ap2.getTaintSubFields());
    }

    public AccessPath appendFields(AccessPath original, AccessPathFragment[] toAppend, boolean taintSubFields) {
        if (toAppend == null || toAppend.length == 0) {
            return original;
        }
        int offset = original.getFragmentCount();
        AccessPathFragment[] fragments = new AccessPathFragment[offset + (toAppend == null ? 0 : toAppend.length)];
        if (offset > 0) {
            System.arraycopy(original.getFragments(), 0, fragments, 0, offset);
        }
        System.arraycopy(toAppend, 0, fragments, offset, toAppend.length);
        return this.createAccessPath(original.getPlainValue(), original.getBaseType(), fragments, taintSubFields, false, true, original.getArrayTaintType());
    }

    public static class BasePair {
        private final SootField[] fields;
        private final Type[] types;
        private int hashCode = 0;

        private BasePair(SootField[] fields, Type[] types) {
            this.fields = fields;
            this.types = types;
            if (fields == null || fields.length == 0) {
                throw new RuntimeException("A base must contain at least one field");
            }
        }

        public SootField[] getFields() {
            return this.fields;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.fields);
                this.hashCode = result = 31 * result + Arrays.hashCode(this.types);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasePair other = (BasePair)obj;
            if (!Arrays.equals(this.fields, other.fields)) {
                return false;
            }
            return Arrays.equals(this.types, other.types);
        }

        public String toString() {
            return Arrays.toString(this.fields);
        }
    }
}

