/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.codeOptimization;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.codeOptimization.DeadCodeEliminator;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.UnconditionalBranchFolder;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.exceptions.UnitThrowAnalysis;
import soot.toolkits.scalar.UnusedLocalEliminator;
import soot.util.queue.QueueReader;

public class InterproceduralConstantValuePropagator
extends SceneTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InfoflowManager manager;
    private final Set<SootMethod> excludedMethods;
    private final ISourceSinkManager sourceSinkManager;
    private final ITaintPropagationWrapper taintWrapper;
    private boolean removeSideEffectFreeMethods = true;
    private boolean excludeSystemClasses = true;
    protected final Map<SootMethod, Boolean> methodSideEffects = new ConcurrentHashMap<SootMethod, Boolean>();
    protected final LoadingCache<SootMethod, Boolean> methodSinks = CacheBuilder.newBuilder().build(new CacheLoader<SootMethod, Boolean>(){

        @Override
        public Boolean load(SootMethod key) throws Exception {
            if (InterproceduralConstantValuePropagator.this.sourceSinkManager != null && key.hasActiveBody()) {
                for (Unit u : key.getActiveBody().getUnits()) {
                    Stmt stmt = (Stmt)u;
                    if (!stmt.containsInvokeExpr() || InterproceduralConstantValuePropagator.this.sourceSinkManager.getSinkInfo(stmt, InterproceduralConstantValuePropagator.this.manager, null) == null) continue;
                    return true;
                }
            }
            return false;
        }
    });
    protected SootClass exceptionClass = null;
    protected final Map<SootClass, SootMethod> exceptionThrowers = new HashMap<SootClass, SootMethod>();
    private final List<SootMethod> propagationWorklist = new ArrayList<SootMethod>();
    private final Set<Pair<SootMethod, Integer>> propagatedParameters = new HashSet<Pair<SootMethod, Integer>>();

    public InterproceduralConstantValuePropagator(InfoflowManager manager) {
        this.manager = manager;
        this.excludedMethods = null;
        this.sourceSinkManager = null;
        this.taintWrapper = null;
    }

    public InterproceduralConstantValuePropagator(InfoflowManager manager, Collection<SootMethod> excludedMethods, ISourceSinkManager sourceSinkManager, ITaintPropagationWrapper taintWrapper) {
        this.manager = manager;
        this.excludedMethods = new HashSet<SootMethod>(excludedMethods);
        this.sourceSinkManager = sourceSinkManager;
        this.taintWrapper = taintWrapper;
    }

    public void setRemoveSideEffectFreeMethods(boolean removeSideEffectFreeMethods) {
        this.removeSideEffectFreeMethods = removeSideEffectFreeMethods;
    }

    public void setExcludeSystemClasses(boolean excludeSystemClasses) {
        this.excludeSystemClasses = excludeSystemClasses;
    }

    private void checkAndAddMethod(SootMethod sm) {
        if (sm == null || !sm.hasActiveBody()) {
            return;
        }
        if (this.excludedMethods != null && this.excludedMethods.contains(sm)) {
            return;
        }
        if (this.excludeSystemClasses && SystemClassHandler.v().isClassInSystemPackage(sm.getDeclaringClass())) {
            return;
        }
        if (!(sm.getReturnType() == VoidType.v() && sm.getParameterCount() <= 0 || this.propagationWorklist.contains(sm))) {
            this.propagationWorklist.add(sm);
        }
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        SootMethod sm;
        MethodOrMethodContext mom;
        this.logger.info("Removing side-effect free methods is " + (this.removeSideEffectFreeMethods ? "enabled" : "disabled"));
        this.propagationWorklist.clear();
        this.propagatedParameters.clear();
        QueueReader<MethodOrMethodContext> rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            mom = rdr.next();
            sm = mom.method();
            this.checkAndAddMethod(sm);
        }
        while (!this.propagationWorklist.isEmpty()) {
            SootMethod sm2 = this.propagationWorklist.remove(0);
            if (sm2.getParameterCount() > 0) {
                this.propagateConstantsIntoCallee(sm2);
            }
            if (!this.typeSupportsConstants(sm2.getReturnType())) continue;
            this.propagateReturnValueIntoCallers(sm2);
        }
        rdr = Scene.v().getReachableMethods().listener();
        while (rdr.hasNext()) {
            mom = rdr.next();
            sm = mom.method();
            if (!sm.hasActiveBody()) continue;
            List<Unit> oldCallSites = DeadCodeEliminator.getCallsInMethod(sm);
            Body body = sm.retrieveActiveBody();
            ConditionalBranchFolder.v().transform(body);
            UnconditionalBranchFolder.v().transform(body);
            DeadAssignmentEliminator.v().transform(body);
            UnreachableCodeEliminator.v().transform(body);
            UnusedLocalEliminator.v().transform(body);
            DeadCodeEliminator.removeDeadCallgraphEdges(sm, oldCallSites);
        }
        if (this.removeSideEffectFreeMethods) {
            int callEdgesRemoved = 0;
            QueueReader<MethodOrMethodContext> rdr2 = Scene.v().getReachableMethods().listener();
            while (rdr2.hasNext()) {
                MethodOrMethodContext mom2 = rdr2.next();
                SootMethod sm3 = mom2.method();
                if (sm3 == null || !sm3.hasActiveBody() || this.excludedMethods != null && this.excludedMethods.contains(sm3)) continue;
                Iterator unitIt = sm3.getActiveBody().getUnits().snapshotIterator();
                while (unitIt.hasNext()) {
                    Stmt s2 = (Stmt)unitIt.next();
                    if (!sm3.getActiveBody().getUnits().contains(s2) || !(s2 instanceof InvokeStmt) || this.exceptionClass != null && s2.getInvokeExpr().getMethod().getDeclaringClass() == this.exceptionClass || this.getNonConstParamCount(s2) > 0) continue;
                    boolean allCalleesRemoved = true;
                    HashSet<SootClass> exceptions = new HashSet<SootClass>();
                    Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(s2);
                    while (edgeIt.hasNext()) {
                        Edge edge = edgeIt.next();
                        SootMethod callee = edge.tgt();
                        boolean remove = callee.getReturnType() == VoidType.v() && !this.hasSideEffectsOrReadsThis(callee);
                        if (remove &= !this.hasSideEffectsOrCallsSink(callee)) {
                            Scene.v().getCallGraph().removeEdge(edge);
                            ++callEdgesRemoved;
                            this.fixExceptions(sm3, s2, exceptions);
                            continue;
                        }
                        if (sm3.getName().equals("<clinit>")) continue;
                        allCalleesRemoved = false;
                    }
                    if (!allCalleesRemoved || this.isSourceSinkOrTaintWrapped(s2)) continue;
                    this.removeCallSite(s2, sm3);
                }
            }
            this.logger.info("Removed %d call edges", (Object)callEdgesRemoved);
        }
        if (this.exceptionClass != null) {
            Scene.v().releaseActiveHierarchy();
            Scene.v().releaseFastHierarchy();
            Scene.v().getOrMakeFastHierarchy();
        }
    }

    private int getNonConstParamCount(Stmt s2) {
        int cnt = 0;
        for (Value val : s2.getInvokeExpr().getArgs()) {
            if (val instanceof Constant) continue;
            ++cnt;
        }
        return cnt;
    }

    private boolean isSourceSinkOrTaintWrapped(Stmt callSite) {
        if (!callSite.containsInvokeExpr()) {
            return false;
        }
        SootMethod method = callSite.getInvokeExpr().getMethod();
        if (this.sourceSinkManager != null && this.sourceSinkManager.getSourceInfo(callSite, this.manager) != null) {
            return true;
        }
        if (this.sourceSinkManager != null && this.sourceSinkManager.getSinkInfo(callSite, this.manager, null) != null) {
            return true;
        }
        if (this.taintWrapper != null && this.taintWrapper.supportsCallee(method)) {
            this.methodSideEffects.put(method, true);
            return true;
        }
        return false;
    }

    private void removeCallSite(Stmt callSite, SootMethod caller) {
        if (!caller.getActiveBody().getUnits().contains(callSite)) {
            return;
        }
        if (!callSite.containsInvokeExpr()) {
            return;
        }
        caller.getActiveBody().getUnits().remove(callSite);
        if (Scene.v().hasCallGraph()) {
            Scene.v().getCallGraph().removeAllEdgesOutOf(callSite);
        }
        this.manager.getICFG().notifyMethodChanged(caller);
    }

    private boolean typeSupportsConstants(Type returnType) {
        if (returnType == IntType.v() || returnType == LongType.v() || returnType == FloatType.v() || returnType == DoubleType.v()) {
            return true;
        }
        return returnType instanceof RefType && ((RefType)returnType).getClassName().equals("java.lang.String");
    }

    private void propagateReturnValueIntoCallers(SootMethod sm) {
        IInfoflowCFG icfg = this.manager.getICFG();
        Constant value = null;
        for (Unit retSite : icfg.getEndPointsOf(sm)) {
            if (!(retSite instanceof ReturnStmt)) continue;
            ReturnStmt retStmt = (ReturnStmt)retSite;
            if (!(retStmt.getOp() instanceof Constant)) {
                return;
            }
            if (value != null && retStmt.getOp() != value) {
                return;
            }
            value = (Constant)retStmt.getOp();
        }
        if (value != null) {
            for (Unit callSite : icfg.getCallersOf(sm)) {
                Collection callees;
                SootMethod caller;
                if (!(callSite instanceof AssignStmt)) continue;
                AssignStmt assign = (AssignStmt)callSite;
                if (this.taintWrapper != null && this.taintWrapper.supportsCallee(assign) || this.sourceSinkManager != null && this.sourceSinkManager.getSourceInfo(assign, this.manager) != null || (caller = (SootMethod)icfg.getMethodOf(assign)) == null || !caller.getActiveBody().getUnits().contains(assign) || (callees = icfg.getCalleesOfCallAt(callSite)) != null && callees.size() > 1) continue;
                AssignStmt assignConst = Jimple.v().newAssignStmt(assign.getLeftOp(), value);
                if (!this.hasSideEffectsOrCallsSink(sm)) {
                    this.fixExceptions(caller, callSite);
                    caller.getActiveBody().getUnits().swapWith(assign, assignConst);
                    if (this.excludedMethods == null || !this.excludedMethods.contains(caller)) {
                        ConstantPropagatorAndFolder.v().transform(caller.getActiveBody());
                        this.checkAndAddMethod(caller);
                    }
                    if (!Scene.v().hasCallGraph()) continue;
                    Scene.v().getCallGraph().removeAllEdgesOutOf(assign);
                    continue;
                }
                caller.getActiveBody().getUnits().insertAfter(assignConst, assign);
                if (this.excludedMethods == null || !this.excludedMethods.contains(caller)) {
                    ConstantPropagatorAndFolder.v().transform(caller.getActiveBody());
                    this.checkAndAddMethod(caller);
                }
                caller.getActiveBody().getUnits().remove(assignConst);
                InvokeStmt inv = Jimple.v().newInvokeStmt(assign.getInvokeExpr());
                caller.getActiveBody().getUnits().swapWith(assign, inv);
                if (Scene.v().hasCallGraph()) {
                    Scene.v().getCallGraph().swapEdgesOutOf(assign, inv);
                }
                icfg.notifyMethodChanged(caller);
            }
        }
    }

    private void fixExceptions(SootMethod caller, Unit callSite) {
        this.fixExceptions(caller, callSite, new HashSet<SootClass>());
    }

    private void fixExceptions(SootMethod caller, Unit callSite, Set<SootClass> doneSet) {
        UnitThrowAnalysis ta = Options.v().src_prec() == 5 ? DalvikThrowAnalysis.v() : UnitThrowAnalysis.v();
        ThrowableSet throwSet = ta.mightThrow(callSite);
        for (final Trap t : caller.getActiveBody().getTraps()) {
            if (!doneSet.add(t.getException()) || !throwSet.catchableAs(t.getException().getType())) continue;
            SootMethod thrower = this.exceptionThrowers.get(t.getException());
            if (thrower == null) {
                if (this.exceptionClass == null) {
                    this.exceptionClass = Scene.v().makeSootClass("FLOWDROID_EXCEPTIONS", 1);
                    this.exceptionClass.setSuperclass(Scene.v().getSootClass("java.lang.Object"));
                    this.exceptionClass.addTag(SimulatedCodeElementTag.TAG);
                    Scene.v().addClass(this.exceptionClass);
                }
                BaseEntryPointCreator epc = new BaseEntryPointCreator(){

                    @Override
                    public Collection<String> getRequiredClasses() {
                        return Collections.emptySet();
                    }

                    @Override
                    protected SootMethod createDummyMainInternal() {
                        LocalGenerator generator = Scene.v().createLocalGenerator(this.body);
                        int conditionCounter = 0;
                        Local intCounter = generator.generateLocal((Type)IntType.v());
                        AssignStmt assignStmt = Jimple.v().newAssignStmt(intCounter, IntConstant.v(conditionCounter));
                        this.body.getUnits().add(assignStmt);
                        ReturnVoidStmt afterEx = Jimple.v().newReturnVoidStmt();
                        IfStmt ifStmt = Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(intCounter, IntConstant.v(conditionCounter)), afterEx);
                        this.body.getUnits().add(ifStmt);
                        ++conditionCounter;
                        Local lcEx = generator.generateLocal((Type)t.getException().getType());
                        AssignStmt assignNewEx = Jimple.v().newAssignStmt(lcEx, Jimple.v().newNewExpr(t.getException().getType()));
                        this.body.getUnits().add(assignNewEx);
                        InvokeStmt consNewEx = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(lcEx, Scene.v().makeConstructorRef(InterproceduralConstantValuePropagator.this.exceptionClass, Collections.emptyList())));
                        this.body.getUnits().add(consNewEx);
                        ThrowStmt throwNewEx = Jimple.v().newThrowStmt(lcEx);
                        this.body.getUnits().add(throwNewEx);
                        this.body.getUnits().add(afterEx);
                        this.mainMethod.addTag(SimulatedCodeElementTag.TAG);
                        return this.mainMethod;
                    }

                    @Override
                    protected void createEmptyMainMethod() {
                        String methodName;
                        int methodIdx = InterproceduralConstantValuePropagator.this.exceptionThrowers.size();
                        String baseName = "throw_" + t.getException().getName().replaceAll("\\W+", "_") + "_";
                        while (InterproceduralConstantValuePropagator.this.exceptionClass.declaresMethodByName(methodName = baseName + methodIdx++)) {
                        }
                        SootMethod thrower = Scene.v().makeSootMethod(methodName, Collections.emptyList(), VoidType.v());
                        thrower.setModifiers(9);
                        JimpleBody body = Jimple.v().newBody(thrower);
                        thrower.setActiveBody(body);
                        InterproceduralConstantValuePropagator.this.exceptionThrowers.put(t.getException(), thrower);
                        InterproceduralConstantValuePropagator.this.exceptionClass.addMethod(thrower);
                        this.mainMethod = thrower;
                    }

                    @Override
                    public Collection<SootMethod> getAdditionalMethods() {
                        return null;
                    }

                    @Override
                    public Collection<SootField> getAdditionalFields() {
                        return null;
                    }
                };
                epc.createDummyMain();
                thrower = epc.getGeneratedMainMethod();
            }
            InvokeStmt throwCall = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(thrower.makeRef()));
            throwCall.addTag(SimulatedCodeElementTag.TAG);
            caller.getActiveBody().getUnits().insertBefore(throwCall, callSite);
        }
    }

    private boolean hasSideEffectsOrCallsSink(SootMethod method) {
        return this.hasSideEffectsOrCallsSink(method, new HashSet<SootMethod>());
    }

    private boolean hasSideEffectsOrCallsSink(SootMethod method, Set<SootMethod> runList) {
        if (!method.hasActiveBody()) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null && hasSideEffects.booleanValue()) {
            return hasSideEffects;
        }
        Boolean hasSink = this.methodSinks.getUnchecked(method);
        if (hasSink != null && hasSink.booleanValue()) {
            return hasSink;
        }
        if (!runList.add(method)) {
            return false;
        }
        if (this.methodIsAndroidStub(method)) {
            this.methodSideEffects.put(method, false);
            return false;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && ((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef || assign.getLeftOp() instanceof ArrayRef)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            Stmt s2 = (Stmt)u;
            if (this.taintWrapper != null && this.taintWrapper.supportsCallee(s2)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            if (!s2.containsInvokeExpr()) continue;
            if (this.sourceSinkManager != null && this.sourceSinkManager.getSinkInfo((Stmt)u, this.manager, null) != null) {
                this.methodSinks.put(method, true);
                return true;
            }
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.hasSideEffectsOrCallsSink(e.getTgt().method(), runList)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    private boolean hasSideEffectsOrReadsThis(SootMethod method) {
        return this.hasSideEffectsOrReadsThis(method, new HashSet<SootMethod>());
    }

    private boolean hasSideEffectsOrReadsThis(SootMethod method, Set<SootMethod> runList) {
        if (!method.hasActiveBody()) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null && hasSideEffects.booleanValue()) {
            return hasSideEffects;
        }
        if (!runList.add(method)) {
            return false;
        }
        if (this.methodIsAndroidStub(method)) {
            this.methodSideEffects.put(method, false);
            return false;
        }
        Local thisLocal = method.isStatic() ? null : method.getActiveBody().getThisLocal();
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && ((assign = (AssignStmt)u).getLeftOp() instanceof FieldRef || assign.getLeftOp() instanceof ArrayRef)) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            Stmt s2 = (Stmt)u;
            if (thisLocal != null) {
                for (ValueBox vb : s2.getUseBoxes()) {
                    if (vb.getValue() != thisLocal) continue;
                    return true;
                }
            }
            if (!s2.containsInvokeExpr()) continue;
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.hasSideEffectsOrReadsThis(e.getTgt().method(), runList)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    private boolean methodIsAndroidStub(SootMethod method) {
        if (Options.v().src_prec() != 5 || !method.getDeclaringClass().isLibraryClass() || !SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass())) {
            return false;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            InvokeStmt stmt;
            SootMethod callee;
            DefinitionStmt defStmt;
            if (!(u instanceof DefinitionStmt ? !((defStmt = (DefinitionStmt)u).getRightOp() instanceof ThisRef) && !(defStmt.getRightOp() instanceof ParameterRef) && !(defStmt.getRightOp() instanceof NewExpr) : (u instanceof InvokeStmt ? !(callee = (stmt = (InvokeStmt)u).getInvokeExpr().getMethod()).getSubSignature().equals("void <init>(java.lang.String)") && (!method.getDeclaringClass().hasSuperclass() || callee.getDeclaringClass() != method.getDeclaringClass().getSuperclass() || !callee.isConstructor()) : !(u instanceof ThrowStmt)))) continue;
            return false;
        }
        return true;
    }

    private void propagateConstantsIntoCallee(SootMethod sm) {
        IInfoflowCFG icfg = this.manager.getICFG();
        Collection callSites = icfg.getCallersOf(sm);
        if (callSites.isEmpty()) {
            return;
        }
        boolean[] isConstant = new boolean[sm.getParameterCount()];
        Constant[] values = new Constant[sm.getParameterCount()];
        for (int i = 0; i < isConstant.length; ++i) {
            isConstant[i] = true;
        }
        boolean hasCallSites = false;
        for (Unit callSite : callSites) {
            int i;
            SootMethod sootMethod;
            if (this.excludedMethods != null && icfg.isReachable(callSite) && (this.excludedMethods.contains(sootMethod = (SootMethod)icfg.getMethodOf(callSite)) || sootMethod.hasTag("SimulatedCodeElementTag"))) {
                this.logger.trace("Ignoring calls from {}", (Object)sootMethod);
                continue;
            }
            InvokeExpr invokeExpr = ((Stmt)callSite).getInvokeExpr();
            if (invokeExpr.getArgCount() != sm.getParameterCount()) continue;
            hasCallSites = true;
            if (icfg.isReflectiveCallSite(callSite)) {
                for (i = 0; i < isConstant.length; ++i) {
                    isConstant[i] = false;
                }
                continue;
            }
            for (i = 0; i < isConstant.length; ++i) {
                if (!isConstant[i]) continue;
                Value argVal = invokeExpr.getArg(i);
                if (argVal instanceof Constant) {
                    if (values[i] != null && !values[i].equals(argVal)) {
                        isConstant[i] = false;
                        continue;
                    }
                    values[i] = (Constant)argVal;
                    continue;
                }
                isConstant[i] = false;
            }
        }
        if (hasCallSites) {
            ArrayList<AssignStmt> inserted = null;
            for (int i = 0; i < isConstant.length; ++i) {
                if (!isConstant[i] || values[i] == null || !this.propagatedParameters.add(new Pair<SootMethod, Integer>(sm, i))) continue;
                Local local = sm.getActiveBody().getParameterLocal(i);
                Unit point = this.getFirstNonIdentityStmt(sm);
                AssignStmt assignConst = Jimple.v().newAssignStmt(local, values[i]);
                sm.getActiveBody().getUnits().insertBefore(assignConst, point);
                if (inserted == null) {
                    inserted = new ArrayList<AssignStmt>();
                }
                inserted.add(assignConst);
            }
            if (inserted != null) {
                ConstantPropagatorAndFolder.v().transform(sm.getActiveBody());
                for (Unit unit : inserted) {
                    sm.getActiveBody().getUnits().remove(unit);
                }
                for (Unit unit : sm.getActiveBody().getUnits()) {
                    for (SootMethod callee : icfg.getCalleesOfCallAt(unit)) {
                        this.checkAndAddMethod(callee);
                    }
                }
            }
        }
    }

    private Unit getFirstNonIdentityStmt(SootMethod sm) {
        for (Unit u : sm.getActiveBody().getUnits()) {
            if (!(u instanceof IdentityStmt)) {
                return u;
            }
            IdentityStmt id = (IdentityStmt)u;
            if (id.getRightOp() instanceof ThisRef || id.getRightOp() instanceof ParameterRef) continue;
            return u;
        }
        return null;
    }
}

