/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.codeOptimization;

import java.util.Collection;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.codeOptimization.ICodeOptimizer;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.util.queue.QueueReader;

public class AddNopStmt
implements ICodeOptimizer {
    InfoflowConfiguration config;

    @Override
    public void initialize(InfoflowConfiguration config) {
        this.config = config;
    }

    @Override
    public void run(InfoflowManager manager, Collection<SootMethod> entryPoints, ISourceSinkManager sourcesSinks, ITaintPropagationWrapper taintWrapper) {
        for (SootMethod entryPoint : entryPoints) {
            if (!entryPoint.hasActiveBody()) continue;
            for (Unit unit : entryPoint.getActiveBody().getUnits()) {
                InvokeExpr iExpr;
                if (!(unit instanceof InvokeStmt) || !((iExpr = ((InvokeStmt)unit).getInvokeExpr()) instanceof StaticInvokeExpr) || iExpr.getArgCount() != 0) continue;
                Collection callees = manager.getICFG().getCalleesOfCallAt(unit);
                for (SootMethod callee : callees) {
                    UnitPatchingChain units;
                    if (!callee.hasActiveBody() || !((units = callee.getActiveBody().getUnits()).getFirst() instanceof AssignStmt)) continue;
                    NopStmt nop = Jimple.v().newNopStmt();
                    nop.addTag(SimulatedCodeElementTag.TAG);
                    units.addFirst(nop);
                }
            }
        }
        ReachableMethods rm = Scene.v().getReachableMethods();
        QueueReader<MethodOrMethodContext> iter = rm.listener();
        while (iter.hasNext()) {
            UnitPatchingChain units;
            SootMethod sm = ((MethodOrMethodContext)iter.next()).method();
            if (!sm.hasActiveBody() || !sm.getSubSignature().contains("void <clinit>()") || !((units = sm.getActiveBody().getUnits()).getFirst() instanceof AssignStmt)) continue;
            NopStmt nop = Jimple.v().newNopStmt();
            nop.addTag(SimulatedCodeElementTag.TAG);
            units.addFirst(nop);
        }
    }
}

