/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.callbacks.CallbackDefinition;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.BaseSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.IOneSourceAtATimeManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.Tag;

public class AndroidSourceSinkManager
extends BaseSourceSinkManager
implements ISourceSinkManager,
IOneSourceAtATimeManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String Activity_FindViewById = "<android.app.Activity: android.view.View findViewById(int)>";
    protected static final String View_FindViewById = "<android.view.View: android.view.View findViewById(int)>";
    protected SootMethod smActivityFindViewById;
    protected SootMethod smViewFindViewById;
    protected final Map<Integer, AndroidLayoutControl> layoutControls;
    protected List<ARSCFileParser.ResPackage> resourcePackages;
    protected String appPackageName = "";
    protected final Set<SootMethod> analyzedLayoutMethods = new HashSet<SootMethod>();
    protected SootClass[] iccBaseClasses = null;
    protected AndroidEntryPointUtils entryPointUtils = new AndroidEntryPointUtils();

    public AndroidSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, InfoflowAndroidConfiguration config) {
        this(sources, sinks, Collections.emptySet(), config, null);
    }

    public AndroidSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, Set<AndroidCallbackDefinition> callbackMethods, InfoflowAndroidConfiguration config, Map<Integer, AndroidLayoutControl> layoutControls) {
        super(sources, sinks, callbackMethods, config);
        this.layoutControls = layoutControls;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.smActivityFindViewById = Scene.v().grabMethod(Activity_FindViewById);
        this.smViewFindViewById = Scene.v().grabMethod(View_FindViewById);
        if (this.iccBaseClasses == null) {
            this.iccBaseClasses = new SootClass[]{Scene.v().getSootClass("android.content.Context"), Scene.v().getSootClass("android.content.ContentResolver"), Scene.v().getSootClass("android.app.Activity")};
        }
    }

    private ARSCFileParser.AbstractResource findResource(String resName, String resID, String packageName) {
        for (ARSCFileParser.ResPackage pkg : this.resourcePackages) {
            boolean matches;
            boolean bl = matches = (packageName == null || packageName.isEmpty()) && pkg.getPackageName().equals(this.appPackageName);
            if (!(matches |= pkg.getPackageName().equals(packageName))) continue;
            for (ARSCFileParser.ResType type : pkg.getDeclaredTypes()) {
                if (!type.getTypeName().equals(resID)) continue;
                ARSCFileParser.AbstractResource res = type.getFirstResource(resName);
                return res;
            }
        }
        return null;
    }

    private Integer findLastResIDAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> cfg, Set<Stmt> doneSet) {
        AssignStmt assign;
        if (!doneSet.add(stmt)) {
            return null;
        }
        if (stmt instanceof AssignStmt && (assign = (AssignStmt)stmt).getLeftOp() == local) {
            InvokeExpr inv;
            if (assign.getRightOp() instanceof IntConstant) {
                return ((IntConstant)assign.getRightOp()).value;
            }
            if (assign.getRightOp() instanceof FieldRef) {
                SootField field = ((FieldRef)assign.getRightOp()).getField();
                for (Tag tag : field.getTags()) {
                    if (tag instanceof IntegerConstantValueTag) {
                        return ((IntegerConstantValueTag)tag).getIntValue();
                    }
                    this.logger.error(String.format("Constant %s was of unexpected type", field.toString()));
                }
            } else if (assign.getRightOp() instanceof InvokeExpr && (inv = (InvokeExpr)assign.getRightOp()).getMethod().getName().equals("getIdentifier") && inv.getMethod().getDeclaringClass().getName().equals("android.content.res.Resources") && this.resourcePackages != null) {
                Value thirdArg;
                if (inv.getArgCount() != 3) {
                    this.logger.error(String.format("Invalid parameter count (%d) for call to getIdentifier", inv.getArgCount()));
                    return null;
                }
                String resName = "";
                String resID = "";
                String packageName = "";
                if (inv.getArg(0) instanceof StringConstant) {
                    resName = ((StringConstant)inv.getArg((int)0)).value;
                }
                if (inv.getArg(1) instanceof StringConstant) {
                    resID = ((StringConstant)inv.getArg((int)1)).value;
                }
                if ((thirdArg = inv.getArg(2)) instanceof StringConstant) {
                    packageName = ((StringConstant)thirdArg).value;
                } else if (thirdArg instanceof Local) {
                    packageName = this.findLastStringAssignment(stmt, (Local)thirdArg, cfg);
                } else {
                    if (thirdArg instanceof NullConstant) {
                        return null;
                    }
                    this.logger.error(String.format("Unknown parameter type %s in call to getIdentifier", inv.getArg(2).getClass().getName()));
                    return null;
                }
                ARSCFileParser.AbstractResource res = this.findResource(resName, resID, packageName);
                if (res != null) {
                    return res.getResourceID();
                }
            }
        }
        for (Unit pred : cfg.getPredsOf(stmt)) {
            Integer lastAssignment;
            if (!(pred instanceof Stmt) || (lastAssignment = this.findLastResIDAssignment((Stmt)pred, local, cfg, doneSet)) == null) continue;
            return lastAssignment;
        }
        return null;
    }

    public void setResourcePackages(List<ARSCFileParser.ResPackage> resourcePackages) {
        this.resourcePackages = resourcePackages;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
    }

    private String findLastStringAssignment(Stmt stmt, Local local, BiDiInterproceduralCFG<Unit, SootMethod> cfg) {
        LinkedList<Stmt> workList = new LinkedList<Stmt>();
        HashSet<Stmt> seen = new HashSet<Stmt>();
        workList.add(stmt);
        while (!workList.isEmpty()) {
            AssignStmt assign;
            stmt = (Stmt)workList.removeFirst();
            if (stmt instanceof AssignStmt && (assign = (AssignStmt)stmt).getLeftOp() == local && assign.getRightOp() instanceof StringConstant) {
                return ((StringConstant)assign.getRightOp()).value;
            }
            for (Unit pred : cfg.getPredsOf(stmt)) {
                Stmt s2;
                if (!(pred instanceof Stmt) || !seen.add(s2 = (Stmt)pred)) continue;
                workList.add(s2);
            }
        }
        return null;
    }

    protected AndroidLayoutControl getLayoutControl(Stmt sCallSite, IInfoflowCFG cfg) {
        InvokeExpr iexpr;
        if (this.layoutControls == null) {
            return null;
        }
        SootMethod uiMethod = (SootMethod)cfg.getMethodOf(sCallSite);
        if (this.analyzedLayoutMethods.add(uiMethod)) {
            ConstantPropagatorAndFolder.v().transform(uiMethod.getActiveBody());
        }
        if ((iexpr = sCallSite.getInvokeExpr()).getArgCount() != 1) {
            this.logger.error("Framework method call with unexpected number of arguments");
            return null;
        }
        Integer id = this.valueProvider.getValue(uiMethod, sCallSite, iexpr.getArg(0), Integer.class);
        if (id == null && iexpr.getArg(0) instanceof Local) {
            id = this.findLastResIDAssignment(sCallSite, (Local)iexpr.getArg(0), cfg, new HashSet<Stmt>(((SootMethod)cfg.getMethodOf(sCallSite)).getActiveBody().getUnits().size()));
        }
        if (id == null) {
            this.logger.debug("Could not find assignment to local " + ((Local)iexpr.getArg(0)).getName() + " in method " + ((SootMethod)cfg.getMethodOf(sCallSite)).getSignature());
            return null;
        }
        AndroidLayoutControl control = this.layoutControls.get(id);
        if (control == null) {
            return null;
        }
        return control;
    }

    @Override
    protected ISourceSinkDefinition getUISourceDefinition(Stmt sCallSite, IInfoflowCFG cfg) {
        boolean isResourceCall;
        if (this.sourceSinkConfig.getLayoutMatchingMode() == InfoflowConfiguration.LayoutMatchingMode.NoMatch || !sCallSite.containsInvokeExpr()) {
            return null;
        }
        if (!(sCallSite instanceof AssignStmt)) {
            return null;
        }
        InvokeExpr ie = sCallSite.getInvokeExpr();
        SootMethod callee = ie.getMethod();
        boolean bl = isResourceCall = callee == this.smActivityFindViewById || callee == this.smViewFindViewById;
        if (!isResourceCall) {
            for (SootMethod cfgCallee : cfg.getCalleesOfCallAt(sCallSite)) {
                if (cfgCallee != this.smActivityFindViewById && cfgCallee != this.smViewFindViewById) continue;
                isResourceCall = true;
                break;
            }
        }
        if (!isResourceCall && (callee.getDeclaringClass().getName().startsWith("android.support.v") || callee.getDeclaringClass().getName().startsWith("androidx.")) && callee.getSubSignature().equals(this.smActivityFindViewById.getSubSignature())) {
            isResourceCall = true;
        }
        if (isResourceCall) {
            if (this.sourceSinkConfig.getLayoutMatchingMode() == InfoflowConfiguration.LayoutMatchingMode.MatchAll) {
                return MethodSourceSinkDefinition.createReturnSource(MethodSourceSinkDefinition.CallType.MethodCall);
            }
            AndroidLayoutControl control = this.getLayoutControl(sCallSite, cfg);
            if (control != null && this.sourceSinkConfig.getLayoutMatchingMode() == InfoflowConfiguration.LayoutMatchingMode.MatchSensitiveOnly && control.isSensitive()) {
                return control.getSourceDefinition();
            }
        }
        return null;
    }

    @Override
    protected boolean isEntryPointMethod(SootMethod method) {
        return this.entryPointUtils.isEntryPointMethod(method);
    }

    @Override
    protected Collection<ISourceSinkDefinition> getSinkDefinitions(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        Collection<ISourceSinkDefinition> definitions = super.getSinkDefinitions(sCallSite, manager, ap);
        if (definitions.size() > 0) {
            return definitions;
        }
        HashSet<ISourceSinkDefinition> sinkDefs = new HashSet<ISourceSinkDefinition>();
        if (sCallSite.containsInvokeExpr()) {
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            String subSig = callee.getSubSignature();
            SootClass sc = callee.getDeclaringClass();
            boolean isParamTainted = false;
            if (ap != null && !sc.isInterface() && !ap.isStaticFieldRef()) {
                for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                    if (sCallSite.getInvokeExpr().getArg(i) != ap.getPlainValue()) continue;
                    isParamTainted = true;
                    break;
                }
            }
            if (isParamTainted || ap == null) {
                for (SootClass clazz : this.iccBaseClasses) {
                    SootMethod sm;
                    if (!Scene.v().getOrMakeFastHierarchy().isSubclass(sc, clazz) || (sm = clazz.getMethodUnsafe(subSig)) == null) continue;
                    Set defs = this.sinkMethods.get(sm);
                    sinkDefs.addAll(defs);
                    break;
                }
            }
        }
        return sinkDefs;
    }

    @Override
    protected Collection<ISourceSinkDefinition> getInverseSinkDefinition(Stmt sCallSite, IInfoflowCFG cfg) {
        Collection<ISourceSinkDefinition> definition = super.getInverseSinkDefinition(sCallSite, cfg);
        if (definition.size() > 0) {
            return definition;
        }
        HashSet<ISourceSinkDefinition> sinkDefs = new HashSet<ISourceSinkDefinition>();
        if (sCallSite.containsInvokeExpr()) {
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            String subSig = callee.getSubSignature();
            SootClass sc = callee.getDeclaringClass();
            for (SootClass clazz : this.iccBaseClasses) {
                SootMethod sm;
                if (!Scene.v().getOrMakeFastHierarchy().isSubclass(sc, clazz) || (sm = clazz.getMethodUnsafe(subSig)) == null) continue;
                Set adefs = this.sinkMethods.get(sm);
                sinkDefs.addAll(adefs);
                break;
            }
        }
        return sinkDefs;
    }

    @Override
    protected CallbackDefinition getCallbackDefinition(SootMethod method) {
        AndroidCallbackDefinition d;
        CallbackDefinition def = super.getCallbackDefinition(method);
        if (def instanceof AndroidCallbackDefinition && (d = (AndroidCallbackDefinition)def).getCallbackType() == AndroidCallbackDefinition.CallbackType.Widget && this.sourceSinkConfig.getLayoutMatchingMode() != InfoflowConfiguration.LayoutMatchingMode.MatchAll) {
            return null;
        }
        return def;
    }
}

