/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import heros.solver.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.StatementSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.SystemClassHandler;

public class AccessPathBasedSourceSinkManager
extends AndroidSourceSinkManager {
    public AccessPathBasedSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, InfoflowAndroidConfiguration config) {
        super(sources, sinks, config);
    }

    public AccessPathBasedSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, Set<AndroidCallbackDefinition> callbackMethods, InfoflowAndroidConfiguration config, Map<Integer, AndroidLayoutControl> layoutControls) {
        super(sources, sinks, callbackMethods, config, layoutControls);
    }

    @Override
    protected Collection<Pair<AccessPath, ISourceSinkDefinition>> createSourceInfoPairs(Stmt sCallSite, InfoflowManager manager, Collection<ISourceSinkDefinition> defs) {
        HashSet<ISourceSinkDefinition> delegateToSuper = new HashSet<ISourceSinkDefinition>();
        HashSet<Pair<AccessPath, ISourceSinkDefinition>> matchingDefs = new HashSet<Pair<AccessPath, ISourceSinkDefinition>>();
        for (ISourceSinkDefinition def : defs) {
            HashSet<AccessPathTuple> apTuples;
            HashSet<AccessPath> aps;
            IAccessPathBasedSourceSinkDefinition apDef;
            block26: {
                StatementSourceSinkDefinition ssdef;
                block25: {
                    if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                        delegateToSuper.add(def);
                        continue;
                    }
                    apDef = (IAccessPathBasedSourceSinkDefinition)def;
                    if (apDef.isEmpty()) {
                        delegateToSuper.add(def);
                        continue;
                    }
                    aps = new HashSet<AccessPath>();
                    apTuples = new HashSet<AccessPathTuple>();
                    if (!(def instanceof MethodSourceSinkDefinition)) break block25;
                    MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                    switch (methodDef.getCallType()) {
                        case Callback: {
                            IdentityStmt is;
                            if (sCallSite instanceof IdentityStmt && (is = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
                                Iterator<AccessPathTuple> paramRef = (ParameterRef)is.getRightOp();
                                if (methodDef.getParameters() != null && methodDef.getParameters().length > ((ParameterRef)((Object)paramRef)).getIndex()) {
                                    for (AccessPathTuple apt : methodDef.getParameters()[((ParameterRef)((Object)paramRef)).getIndex()]) {
                                        aps.add(apt.toAccessPath(is.getLeftOp(), manager, false));
                                        apTuples.add(apt);
                                    }
                                }
                            }
                            break block26;
                        }
                        case MethodCall: {
                            if (sCallSite instanceof InvokeStmt && sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && methodDef.getBaseObjects() != null) {
                                Value baseVal = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                                for (AccessPathTuple apt : methodDef.getBaseObjects()) {
                                    if (!apt.getSourceSinkType().isSource()) continue;
                                    aps.add(apt.toAccessPath(baseVal, manager, true));
                                    apTuples.add(apt);
                                }
                            }
                            if (sCallSite instanceof DefinitionStmt && methodDef.getReturnValues() != null) {
                                Value returnVal = ((DefinitionStmt)sCallSite).getLeftOp();
                                for (AccessPathTuple apt : methodDef.getReturnValues()) {
                                    if (!apt.getSourceSinkType().isSource()) continue;
                                    aps.add(apt.toAccessPath(returnVal, manager, false));
                                    apTuples.add(apt);
                                }
                            }
                            if (sCallSite.containsInvokeExpr() && methodDef.getParameters() != null && methodDef.getParameters().length > 0) {
                                for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                                    if (methodDef.getParameters().length <= i) continue;
                                    for (AccessPathTuple apt : methodDef.getParameters()[i]) {
                                        if (!apt.getSourceSinkType().isSource()) continue;
                                        aps.add(apt.toAccessPath(sCallSite.getInvokeExpr().getArg(i), manager, true));
                                        apTuples.add(apt);
                                    }
                                }
                            }
                            break block26;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                if (def instanceof FieldSourceSinkDefinition) {
                    FieldSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                    if (sCallSite instanceof AssignStmt && fieldDef.getAccessPaths() != null) {
                        AssignStmt assignStmt = (AssignStmt)sCallSite;
                        for (AccessPathTuple apt : fieldDef.getAccessPaths()) {
                            if (!apt.getSourceSinkType().isSource()) continue;
                            aps.add(apt.toAccessPath(assignStmt.getLeftOp(), manager, false));
                            apTuples.add(apt);
                        }
                    }
                } else if (def instanceof StatementSourceSinkDefinition && (ssdef = (StatementSourceSinkDefinition)def).getAccessPaths() != null) {
                    for (AccessPathTuple apt : ssdef.getAccessPaths()) {
                        if (!apt.getSourceSinkType().isSource()) continue;
                        aps.add(apt.toAccessPath(ssdef.getLocal(), manager, true));
                        apTuples.add(apt);
                    }
                }
            }
            if (aps.isEmpty()) {
                return Collections.emptySet();
            }
            apDef = apDef.filter(apTuples);
            for (AccessPath ap : aps) {
                matchingDefs.add(new Pair<AccessPath, IAccessPathBasedSourceSinkDefinition>(ap, apDef));
            }
        }
        matchingDefs.addAll(super.createSourceInfoPairs(sCallSite, manager, delegateToSuper));
        return matchingDefs;
    }

    @Override
    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath sourceAccessPath) {
        Collection<ISourceSinkDefinition> defs = this.getSinkDefinitions(sCallSite, manager, sourceAccessPath);
        HashSet<ISourceSinkDefinition> sinkDefs = new HashSet<ISourceSinkDefinition>();
        for (ISourceSinkDefinition def : defs) {
            if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                SinkInfo superSinkInfo = super.getSinkInfo(sCallSite, manager, sourceAccessPath);
                sinkDefs.addAll(superSinkInfo.getDefinitions());
                continue;
            }
            IAccessPathBasedSourceSinkDefinition apDef = (IAccessPathBasedSourceSinkDefinition)def;
            if (apDef.isEmpty() && sCallSite.containsInvokeExpr()) {
                if (!SystemClassHandler.v().isTaintVisible(sourceAccessPath, sCallSite.getInvokeExpr().getMethod())) continue;
                sinkDefs.add(def);
                continue;
            }
            if (sourceAccessPath == null) {
                sinkDefs.add(def);
                continue;
            }
            if (def instanceof MethodSourceSinkDefinition) {
                InstanceInvokeExpr iiexpr;
                MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                if (methodDef.getCallType() == MethodSourceSinkDefinition.CallType.Return) {
                    sinkDefs.add(def);
                    continue;
                }
                InvokeExpr iexpr = sCallSite.getInvokeExpr();
                if (iexpr instanceof InstanceInvokeExpr && methodDef.getBaseObjects() != null && (iiexpr = (InstanceInvokeExpr)iexpr).getBase() == sourceAccessPath.getPlainValue()) {
                    boolean addedDef = false;
                    for (AccessPathTuple apt : methodDef.getBaseObjects()) {
                        if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                        sinkDefs.add(apDef.filter(Collections.singleton(apt)));
                        addedDef = true;
                        break;
                    }
                    if (addedDef) continue;
                }
                if (methodDef.getParameters() == null || methodDef.getParameters().length <= 0) continue;
                boolean addedDef = false;
                block2: for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                    if (sCallSite.getInvokeExpr().getArg(i) != sourceAccessPath.getPlainValue() || methodDef.getParameters().length <= i) continue;
                    for (AccessPathTuple apt : methodDef.getParameters()[i]) {
                        if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                        sinkDefs.add(apDef.filter(Collections.singleton(apt)));
                        addedDef = true;
                        continue block2;
                    }
                }
                if (!addedDef) continue;
                continue;
            }
            if (def instanceof FieldSourceSinkDefinition) {
                FieldSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                if (!(sCallSite instanceof AssignStmt) || fieldDef.getAccessPaths() == null) continue;
                boolean addedDef = false;
                for (AccessPathTuple apt : fieldDef.getAccessPaths()) {
                    if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                    sinkDefs.add(apDef.filter(Collections.singleton(apt)));
                    addedDef = true;
                    break;
                }
                if (!addedDef) continue;
                continue;
            }
            if (!(def instanceof StatementSourceSinkDefinition)) continue;
            StatementSourceSinkDefinition ssdef = (StatementSourceSinkDefinition)def;
            boolean addedDef = false;
            for (AccessPathTuple apt : ssdef.getAccessPaths()) {
                if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                sinkDefs.add(apDef.filter(Collections.singleton(apt)));
                addedDef = true;
                break;
            }
            if (!addedDef) continue;
        }
        return sinkDefs.size() > 0 ? new SinkInfo(sinkDefs) : null;
    }

    private boolean accessPathMatches(AccessPath sourceAccessPath, AccessPathTuple apt) {
        if (apt.getFields() == null || apt.getFields().length == 0 || sourceAccessPath == null) {
            return true;
        }
        for (int i = 0; i < apt.getFields().length; ++i) {
            if (i >= sourceAccessPath.getFragmentCount()) {
                return sourceAccessPath.getTaintSubFields();
            }
            if (sourceAccessPath.getFragments()[i].getField().getName().equals(apt.getFields()[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
        Collection<ISourceSinkDefinition> defs = this.getInverseSinkDefinition(sCallSite, manager.getICFG());
        HashSet<ISourceSinkDefinition> delegateToSuper = new HashSet<ISourceSinkDefinition>();
        HashSet<Pair<AccessPath, ISourceSinkDefinition>> matchingDefs = new HashSet<Pair<AccessPath, ISourceSinkDefinition>>();
        block0: for (ISourceSinkDefinition def : defs) {
            HashSet<AccessPathTuple> apts;
            HashSet<AccessPath> aps;
            if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                delegateToSuper.add(def);
                continue;
            }
            IAccessPathBasedSourceSinkDefinition apDef = (IAccessPathBasedSourceSinkDefinition)def;
            if (apDef.isEmpty()) {
                delegateToSuper.add(def);
                continue;
            }
            if (def instanceof MethodSourceSinkDefinition) {
                IAccessPathBasedSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                if (((MethodSourceSinkDefinition)methodDef).getCallType() == MethodSourceSinkDefinition.CallType.Return) {
                    aps = new HashSet();
                    apts = new HashSet();
                    for (SootMethod sootMethod : manager.getICFG().getCalleesOfCallAt(sCallSite)) {
                        if (!sootMethod.hasActiveBody()) continue;
                        for (Unit unit : sootMethod.getActiveBody().getUnits()) {
                            if (!(unit instanceof ReturnStmt)) continue;
                            for (AccessPathTuple apt : ((MethodSourceSinkDefinition)methodDef).getReturnValues()) {
                                if (!apt.getSourceSinkType().isSink()) continue;
                                aps.add(apt.toAccessPath(((ReturnStmt)unit).getOp(), manager, false));
                                apts.add(apt);
                            }
                        }
                    }
                    methodDef = ((MethodSourceSinkDefinition)methodDef).filter(apts);
                    for (AccessPath accessPath : aps) {
                        matchingDefs.add(new Pair<AccessPath, IAccessPathBasedSourceSinkDefinition>(accessPath, methodDef));
                    }
                    continue;
                }
                if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && ((MethodSourceSinkDefinition)methodDef).getBaseObjects() != null) {
                    for (AccessPathTuple apt : ((MethodSourceSinkDefinition)methodDef).getBaseObjects()) {
                        if (!apt.getSourceSinkType().isSink()) continue;
                        AccessPath ap = apt.toAccessPath(((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase(), manager, true);
                        matchingDefs.add(new Pair<AccessPath, ISourceSinkDefinition>(ap, def));
                        continue block0;
                    }
                    continue;
                }
                if (((MethodSourceSinkDefinition)methodDef).getParameters() == null || ((MethodSourceSinkDefinition)methodDef).getParameters().length <= 0) continue;
                aps = new HashSet<AccessPath>();
                apts = new HashSet();
                for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                    if (sCallSite.getInvokeExpr().getArg(i) instanceof Constant || ((MethodSourceSinkDefinition)methodDef).getParameters().length <= i) continue;
                    for (AccessPathTuple apt : ((MethodSourceSinkDefinition)methodDef).getParameters()[i]) {
                        if (!apt.getSourceSinkType().isSink()) continue;
                        AccessPath ap = apt.toAccessPath(sCallSite.getInvokeExpr().getArg(i), manager, true);
                        aps.add(ap);
                        apts.add(apt);
                    }
                }
                methodDef = ((MethodSourceSinkDefinition)methodDef).filter(apts);
                for (AccessPath accessPath : aps) {
                    matchingDefs.add(new Pair<AccessPath, IAccessPathBasedSourceSinkDefinition>(accessPath, methodDef));
                }
                continue;
            }
            if (def instanceof FieldSourceSinkDefinition) {
                IAccessPathBasedSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                aps = new HashSet();
                apts = new HashSet<AccessPathTuple>();
                if (!(sCallSite instanceof AssignStmt) || fieldDef.getAccessPaths() == null) continue;
                for (AccessPathTuple accessPathTuple : fieldDef.getAccessPaths()) {
                    if (!accessPathTuple.getSourceSinkType().isSink()) continue;
                    aps.add(accessPathTuple.toAccessPath(sCallSite.getFieldRef(), manager, false));
                }
                fieldDef = fieldDef.filter(apts);
                for (AccessPath accessPath : aps) {
                    matchingDefs.add(new Pair<AccessPath, FieldSourceSinkDefinition>(accessPath, (FieldSourceSinkDefinition)fieldDef));
                }
                continue;
            }
            if (!(def instanceof StatementSourceSinkDefinition)) continue;
            IAccessPathBasedSourceSinkDefinition ssdef = (StatementSourceSinkDefinition)def;
            aps = new HashSet();
            HashSet<AccessPathTuple> apsTuple = new HashSet<AccessPathTuple>();
            for (AccessPathTuple accessPathTuple : ssdef.getAccessPaths()) {
                if (accessPathTuple.getSourceSinkType().isSink()) {
                    apsTuple.add(accessPathTuple);
                    aps.add(accessPathTuple.toAccessPath(sCallSite.getFieldRef(), manager, true));
                }
                ssdef = ssdef.filter(apsTuple);
                for (AccessPath ap2 : aps) {
                    matchingDefs.add(new Pair<AccessPath, StatementSourceSinkDefinition>(ap2, (StatementSourceSinkDefinition)ssdef));
                }
            }
        }
        matchingDefs.addAll(super.createInverseSinkInfoPairs(sCallSite, manager, delegateToSuper));
        return matchingDefs.size() > 0 ? new SourceInfo(matchingDefs) : null;
    }

    @Override
    public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath sourceAccessPath) {
        Collection<ISourceSinkDefinition> defs = this.getInverseSourceDefinition(sCallSite, manager, sourceAccessPath);
        HashSet<ISourceSinkDefinition> matching = new HashSet<ISourceSinkDefinition>();
        for (ISourceSinkDefinition def : defs) {
            HashSet<AccessPathTuple> apTuples;
            HashSet<AccessPath> aps;
            IAccessPathBasedSourceSinkDefinition apDef;
            block27: {
                AccessPath ap;
                block26: {
                    if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                        matching.addAll(super.getInverseSourceDefinition(sCallSite, manager, sourceAccessPath));
                        continue;
                    }
                    apDef = (IAccessPathBasedSourceSinkDefinition)def;
                    if (apDef.isEmpty() && sCallSite.containsInvokeExpr()) {
                        if (!SystemClassHandler.v().isTaintVisible(sourceAccessPath, sCallSite.getInvokeExpr().getMethod())) continue;
                        matching.add(def);
                        continue;
                    }
                    if (apDef.isEmpty()) {
                        matching.addAll(super.getInverseSourceDefinition(sCallSite, manager, sourceAccessPath));
                        continue;
                    }
                    if (sourceAccessPath == null) {
                        matching.add(def);
                        continue;
                    }
                    aps = new HashSet<AccessPath>();
                    apTuples = new HashSet<AccessPathTuple>();
                    if (!(def instanceof MethodSourceSinkDefinition)) break block26;
                    MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                    switch (methodDef.getCallType()) {
                        case Callback: {
                            IdentityStmt is;
                            if (sCallSite instanceof IdentityStmt && (is = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
                                Iterator<AccessPathTuple> paramRef = (ParameterRef)is.getRightOp();
                                if (methodDef.getParameters() != null && methodDef.getParameters().length > ((ParameterRef)((Object)paramRef)).getIndex()) {
                                    for (AccessPathTuple apt : methodDef.getParameters()[((ParameterRef)((Object)paramRef)).getIndex()]) {
                                        AccessPath ap2 = apt.toAccessPath(is.getLeftOp(), manager, false);
                                        if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                                        aps.add(ap2);
                                        apTuples.add(apt);
                                    }
                                }
                            }
                            break block27;
                        }
                        case MethodCall: {
                            if (sCallSite instanceof InvokeStmt && sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && methodDef.getBaseObjects() != null) {
                                Value baseVal = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                                for (AccessPathTuple apt : methodDef.getBaseObjects()) {
                                    if (!apt.getSourceSinkType().isSource()) continue;
                                    ap = apt.toAccessPath(baseVal, manager, true);
                                    if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                                    aps.add(ap);
                                    apTuples.add(apt);
                                }
                            }
                            if (sCallSite instanceof DefinitionStmt && methodDef.getReturnValues() != null) {
                                Value returnVal = ((DefinitionStmt)sCallSite).getLeftOp();
                                for (AccessPathTuple apt : methodDef.getReturnValues()) {
                                    if (!apt.getSourceSinkType().isSource()) continue;
                                    ap = apt.toAccessPath(returnVal, manager, false);
                                    if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                                    aps.add(ap);
                                    apTuples.add(apt);
                                }
                            }
                            if (sCallSite.containsInvokeExpr() && methodDef.getParameters() != null && methodDef.getParameters().length > 0) {
                                for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                                    if (methodDef.getParameters().length <= i) continue;
                                    for (AccessPathTuple apt : methodDef.getParameters()[i]) {
                                        if (!apt.getSourceSinkType().isSource()) continue;
                                        ap = apt.toAccessPath(sCallSite.getInvokeExpr().getArg(i), manager, true);
                                        if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                                        aps.add(ap);
                                        apTuples.add(apt);
                                    }
                                }
                            }
                            break block27;
                        }
                        default: {
                            return null;
                        }
                    }
                }
                if (def instanceof FieldSourceSinkDefinition) {
                    FieldSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                    if (sCallSite instanceof AssignStmt && fieldDef.getAccessPaths() != null) {
                        AssignStmt assignStmt = (AssignStmt)sCallSite;
                        for (AccessPathTuple apt : fieldDef.getAccessPaths()) {
                            if (!apt.getSourceSinkType().isSource()) continue;
                            ap = apt.toAccessPath(assignStmt.getLeftOp(), manager, false);
                            if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                            aps.add(ap);
                            apTuples.add(apt);
                        }
                    }
                } else if (def instanceof StatementSourceSinkDefinition) {
                    StatementSourceSinkDefinition ssdef = (StatementSourceSinkDefinition)def;
                    for (AccessPathTuple apt : ssdef.getAccessPaths()) {
                        if (!apt.getSourceSinkType().isSource()) continue;
                        AccessPath ap3 = apt.toAccessPath(ssdef.getLocal(), manager, true);
                        if (!this.accessPathMatches(sourceAccessPath, apt)) continue;
                        aps.add(ap3);
                        apTuples.add(apt);
                    }
                }
            }
            if (aps.isEmpty()) {
                return null;
            }
            matching.add(apDef.filter(apTuples));
        }
        return matching.size() > 0 ? new SinkInfo(matching) : null;
    }
}

