/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParserException;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlDocument;
import soot.jimple.infoflow.android.axml.AXmlHandler;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.ApkHandler;
import soot.jimple.infoflow.android.manifest.ComponentType;
import soot.jimple.infoflow.android.manifest.IActivity;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.manifest.IBroadcastReceiver;
import soot.jimple.infoflow.android.manifest.IComponentContainer;
import soot.jimple.infoflow.android.manifest.IContentProvider;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.android.manifest.IService;
import soot.jimple.infoflow.android.manifest.binary.BinaryAndroidApplication;
import soot.jimple.infoflow.android.manifest.containers.EagerComponentContainer;
import soot.jimple.infoflow.android.manifest.containers.EmptyComponentContainer;
import soot.jimple.infoflow.android.resources.ARSCFileParser;

public abstract class BaseProcessManifest<A extends IActivity, S extends IService, C extends IContentProvider, B extends IBroadcastReceiver>
implements IManifestHandler<A, S, C, B> {
    protected ApkHandler apk = null;
    protected AXmlHandler axml;
    protected ARSCFileParser arscParser;
    protected AXmlNode manifest;
    protected AXmlNode application;
    protected List<AXmlNode> providers = null;
    protected List<AXmlNode> services = null;
    protected List<AXmlNode> activities = null;
    protected List<AXmlNode> aliasActivities = null;
    protected List<AXmlNode> receivers = null;
    protected IComponentFactory<A, S, C, B> factory = this.createComponentFactory();
    private String cache_PackageName = null;

    public BaseProcessManifest(String apkPath) throws IOException, XmlPullParserException {
        this(new File(apkPath));
    }

    public BaseProcessManifest(File apkFile) throws IOException, XmlPullParserException {
        this(apkFile, ARSCFileParser.getInstance(apkFile));
    }

    public BaseProcessManifest(File apkFile, ARSCFileParser arscParser) throws IOException, XmlPullParserException {
        if (!apkFile.exists()) {
            throw new RuntimeException(String.format("The given APK file %s does not exist", apkFile.getCanonicalPath()));
        }
        this.apk = new ApkHandler(apkFile);
        this.arscParser = arscParser;
        try (InputStream is = this.apk.getInputStream("AndroidManifest.xml");){
            if (is == null) {
                throw new FileNotFoundException(String.format("The file %s does not contain an Android Manifest", apkFile.getAbsolutePath()));
            }
            this.handle(is);
        }
    }

    public BaseProcessManifest(InputStream manifestIS, ARSCFileParser arscParser) throws IOException, XmlPullParserException {
        this.arscParser = arscParser;
        this.handle(manifestIS);
    }

    protected void handle(InputStream manifestIS) throws IOException, XmlPullParserException {
        this.axml = new AXmlHandler(manifestIS);
        AXmlDocument document = this.axml.getDocument();
        this.manifest = document.getRootNode();
        if (!this.manifest.getTag().equals("manifest")) {
            throw new RuntimeException("Root node is not a manifest node");
        }
        List<AXmlNode> applications = this.manifest.getChildrenWithTag("application");
        if (applications.isEmpty()) {
            throw new RuntimeException("Manifest contains no application node");
        }
        if (applications.size() > 1) {
            throw new RuntimeException("Manifest contains more than one application node");
        }
        this.application = applications.get(0);
        this.providers = this.axml.getNodesWithTag("provider");
        this.services = this.axml.getNodesWithTag("service");
        this.activities = this.axml.getNodesWithTag("activity");
        this.aliasActivities = this.axml.getNodesWithTag("activity-alias");
        this.receivers = this.axml.getNodesWithTag("receiver");
    }

    public AXmlHandler getAXml() {
        return this.axml;
    }

    public ApkHandler getApk() {
        return this.apk;
    }

    public AXmlNode getManifest() {
        return this.manifest;
    }

    @Override
    public IAndroidApplication getApplication() {
        return new BinaryAndroidApplication(this.application, this);
    }

    @Override
    public IComponentContainer<C> getContentProviders() {
        if (this.providers == null) {
            return EmptyComponentContainer.get();
        }
        return new EagerComponentContainer(this.providers.stream().map(p -> this.factory.createContentProvider((AXmlNode)p)).collect(Collectors.toList()));
    }

    @Override
    public IComponentContainer<S> getServices() {
        if (this.services == null) {
            return EmptyComponentContainer.get();
        }
        return new EagerComponentContainer(this.services.stream().map(s2 -> this.factory.createService((AXmlNode)s2)).collect(Collectors.toList()));
    }

    public ComponentType getComponentType(String className) {
        for (AXmlNode node : this.activities) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Activity;
        }
        for (AXmlNode node : this.services) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Service;
        }
        for (AXmlNode node : this.receivers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.BroadcastReceiver;
        }
        for (AXmlNode node : this.providers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.ContentProvider;
        }
        return null;
    }

    @Override
    public IComponentContainer<A> getActivities() {
        if (this.activities == null) {
            return EmptyComponentContainer.get();
        }
        return new EagerComponentContainer(this.activities.stream().map(a -> this.factory.createActivity((AXmlNode)a)).collect(Collectors.toList()));
    }

    public List<AXmlNode> getAliasActivities() {
        return new ArrayList<AXmlNode>(this.aliasActivities);
    }

    @Override
    public IComponentContainer<B> getBroadcastReceivers() {
        if (this.receivers == null) {
            return EmptyComponentContainer.get();
        }
        return new EagerComponentContainer(this.receivers.stream().map(r -> this.factory.createBroadcastReceiver((AXmlNode)r)).collect(Collectors.toList()));
    }

    public AXmlNode getProvider(String name) {
        return this.getNodeWithName(this.providers, name);
    }

    public AXmlNode getService(String name) {
        return this.getNodeWithName(this.services, name);
    }

    public AXmlNode getActivity(String name) {
        return this.getNodeWithName(this.activities, name);
    }

    public AXmlNode getAliasActivity(String name) {
        return this.getNodeWithName(this.aliasActivities, name);
    }

    public AXmlNode getReceiver(String name) {
        return this.getNodeWithName(this.receivers, name);
    }

    protected AXmlNode getNodeWithName(List<AXmlNode> list, String name) {
        for (AXmlNode node : list) {
            AXmlAttribute<?> attr = node.getAttributes().get("name");
            if (attr == null || !attr.getValue().equals(name)) continue;
            return node;
        }
        return null;
    }

    public AXmlNode getAliasActivityTarget(AXmlNode aliasActivity) {
        AXmlAttribute<?> targetActivityAttribute;
        if (BaseProcessManifest.isAliasActivity(aliasActivity) && (targetActivityAttribute = aliasActivity.getAttribute("targetActivity")) != null) {
            return this.getActivity((String)targetActivityAttribute.getValue());
        }
        return null;
    }

    public static boolean isAliasActivity(AXmlNode activity) {
        return activity.getTag().equals("activity-alias");
    }

    public ArrayList<AXmlNode> getAllActivities() {
        ArrayList<AXmlNode> allActivities = new ArrayList<AXmlNode>(this.activities);
        allActivities.addAll(this.aliasActivities);
        return allActivities;
    }

    public byte[] getOutput() {
        return this.axml.toByteArray();
    }

    @Override
    public String getPackageName() {
        AXmlAttribute<?> attr;
        if (this.cache_PackageName == null && (attr = this.manifest.getAttribute("package")) != null && attr.getValue() != null) {
            this.cache_PackageName = (String)attr.getValue();
        }
        return this.cache_PackageName;
    }

    public int getVersionCode() {
        AXmlAttribute<?> attr = this.manifest.getAttribute("versionCode");
        return attr == null || attr.getValue() == null ? -1 : Integer.parseInt(attr.getValue().toString());
    }

    public String getVersionName() {
        AXmlAttribute<?> attr = this.manifest.getAttribute("versionName");
        return attr == null || attr.getValue() == null ? null : attr.getValue().toString();
    }

    public int getMinSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr = usesSdk.get(0).getAttribute("minSdkVersion");
        if (attr == null || attr.getValue() == null) {
            return -1;
        }
        if (attr.getValue() instanceof Integer) {
            return (Integer)attr.getValue();
        }
        return Integer.parseInt(attr.getValue().toString());
    }

    public int getTargetSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr = usesSdk.get(0).getAttribute("targetSdkVersion");
        if (attr == null || attr.getValue() == null) {
            return -1;
        }
        if (attr.getValue() instanceof Integer) {
            return (Integer)attr.getValue();
        }
        return Integer.parseInt(attr.getValue().toString());
    }

    public Set<String> getPermissions() {
        List<AXmlNode> usesPerms = this.manifest.getChildrenWithTag("uses-permission");
        HashSet<String> permissions = new HashSet<String>();
        for (AXmlNode perm : usesPerms) {
            AXmlAttribute<?> attr = perm.getAttribute("name");
            if (attr != null) {
                permissions.add((String)attr.getValue());
                continue;
            }
            for (AXmlAttribute<?> a : perm.getAttributes().values()) {
                if (a.getType() != 3 || a.getName() != null && !a.getName().isEmpty()) continue;
                permissions.add((String)a.getValue());
            }
        }
        return permissions;
    }

    public Set<String> getIntentFilter() {
        List<AXmlNode> usesActions = this.axml.getNodesWithTag("action");
        HashSet<String> intentFilters = new HashSet<String>();
        for (AXmlNode ittft : usesActions) {
            if (!ittft.getParent().getTag().equals("intent-filter")) continue;
            AXmlAttribute<?> attr = ittft.getAttribute("name");
            if (attr != null) {
                intentFilters.add(attr.getValue().toString());
                continue;
            }
            for (AXmlAttribute<?> a : ittft.getAttributes().values()) {
                if (a.getType() != 3 || a.getName() != null && !a.getName().isEmpty()) continue;
                intentFilters.add((String)a.getValue());
            }
        }
        return intentFilters;
    }

    public Set<String> getHardware() {
        List<AXmlNode> usesHardware = this.manifest.getChildrenWithTag("uses-feature");
        HashSet<String> hardware = new HashSet<String>();
        for (AXmlNode hard : usesHardware) {
            AXmlAttribute<?> attr = hard.getAttribute("name");
            if (attr != null) {
                hardware.add(attr.getValue().toString());
                continue;
            }
            for (AXmlAttribute<?> a : hard.getAttributes().values()) {
                if (a.getType() != 3 || a.getName() != null && !a.getName().isEmpty()) continue;
                hardware.add(a.getValue().toString());
            }
        }
        return hardware;
    }

    public void addPermission(String permissionName) {
        AXmlNode permission = new AXmlNode("uses-permission", null, this.manifest, "");
        AXmlAttribute<String> permissionNameAttr = new AXmlAttribute<String>("name", permissionName, "http://schemas.android.com/apk/res/android");
        permission.addAttribute(permissionNameAttr);
    }

    public void addProvider(AXmlNode node) {
        if (this.providers.isEmpty()) {
            this.providers = new ArrayList<AXmlNode>();
        }
        this.providers.add(node);
    }

    public void addReceiver(AXmlNode node) {
        if (this.receivers.isEmpty()) {
            this.receivers = new ArrayList<AXmlNode>();
        }
        this.receivers.add(node);
    }

    public void addActivity(AXmlNode node) {
        if (this.activities.isEmpty()) {
            this.activities = new ArrayList<AXmlNode>();
        }
        this.activities.add(node);
    }

    public void addService(AXmlNode node) {
        if (this.services.isEmpty()) {
            this.services = new ArrayList<AXmlNode>();
        }
        this.services.add(node);
    }

    @Override
    public void close() {
        if (this.apk != null) {
            this.apk.close();
        }
    }

    public Set<AXmlNode> getLaunchableActivityNodes() {
        LinkedHashSet<AXmlNode> allLaunchableActivities = new LinkedHashSet<AXmlNode>();
        for (AXmlNode activity : this.getAllActivities()) {
            for (AXmlNode activityChildren : activity.getChildren()) {
                if (!activityChildren.getTag().equals("intent-filter")) continue;
                boolean actionFilter = false;
                boolean categoryFilter = false;
                for (AXmlNode intentFilter : activityChildren.getChildren()) {
                    if (intentFilter.getTag().equals("action") && intentFilter.getAttribute("name").getValue().toString().equals("android.intent.action.MAIN")) {
                        actionFilter = true;
                        continue;
                    }
                    if (!intentFilter.getTag().equals("category") || !intentFilter.getAttribute("name").getValue().toString().equals("android.intent.category.LAUNCHER")) continue;
                    categoryFilter = true;
                }
                if (!actionFilter || !categoryFilter) continue;
                allLaunchableActivities.add(activity);
            }
        }
        return allLaunchableActivities;
    }

    public String expandClassName(String className) {
        String packageName = this.getPackageName();
        if (className.startsWith(".")) {
            return packageName + className;
        }
        if (!className.contains(".")) {
            return packageName + "." + className;
        }
        return className;
    }

    public ARSCFileParser getArscParser() {
        return this.arscParser;
    }

    protected abstract IComponentFactory<A, S, C, B> createComponentFactory();

    protected static interface IComponentFactory<A extends IActivity, S extends IService, C extends IContentProvider, B extends IBroadcastReceiver> {
        public A createActivity(AXmlNode var1);

        public B createBroadcastReceiver(AXmlNode var1);

        public C createContentProvider(AXmlNode var1);

        public S createService(AXmlNode var1);
    }
}

