/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.infoflow.android.entryPointCreators.AbstractAndroidEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ActivityEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.BroadcastReceiverEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.entryPointCreators.components.ContentProviderEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.FragmentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceConnectionEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointCreator;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.Options;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class AndroidEntryPointCreator
extends AbstractAndroidEntryPointCreator
implements IEntryPointCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEBUG = false;
    protected MultiMap<SootClass, SootMethod> callbackFunctions = new HashMultiMap<SootClass, SootMethod>();
    private SootClass applicationClass = null;
    private Local applicationLocal = null;
    private MultiMap<SootClass, String> activityLifecycleCallbacks = new HashMultiMap<SootClass, String>();
    private MultiMap<SootClass, String> applicationCallbackClasses = new HashMultiMap<SootClass, String>();
    private Map<SootClass, SootField> callbackClassToField = new HashMap<SootClass, SootField>();
    private MultiMap<SootClass, SootClass> fragmentClasses = null;
    private final ComponentEntryPointCollection componentToInfo = new ComponentEntryPointCollection();
    private Collection<SootClass> components;

    public AndroidEntryPointCreator(IManifestHandler manifest, Collection<SootClass> components) {
        super(manifest);
        this.components = components;
        this.overwriteDummyMainMethod = true;
    }

    @Override
    protected SootMethod createDummyMainInternal() {
        this.reset();
        this.logger.info(String.format("Creating Android entry point for %d components...", this.components.size()));
        boolean hasContentProviders = false;
        NopStmt beforeContentProvidersStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforeContentProvidersStmt);
        for (SootClass sootClass : this.components) {
            Local localVal;
            if (this.entryPointUtils.getComponentType(sootClass) != AndroidEntryPointUtils.ComponentType.ContentProvider || (localVal = this.generateClassConstructor(sootClass)) == null) continue;
            this.localVarsForClasses.put(sootClass, localVal);
            NopStmt thenStmt = Jimple.v().newNopStmt();
            this.createIfStmt(thenStmt);
            this.searchAndBuildMethod("boolean onCreate()", sootClass, localVal);
            this.body.getUnits().add(thenStmt);
            hasContentProviders = true;
        }
        if (hasContentProviders) {
            this.createIfStmt(beforeContentProvidersStmt);
        }
        this.initializeApplicationClass();
        if (this.applicationClass != null) {
            this.applicationLocal = this.generateClassConstructor(this.applicationClass);
            this.localVarsForClasses.put(this.applicationClass, this.applicationLocal);
            if (this.applicationLocal != null) {
                boolean hasActivityLifecycleCallbacks;
                this.localVarsForClasses.put(this.applicationClass, this.applicationLocal);
                boolean hasApplicationCallbacks = this.applicationCallbackClasses != null && !this.applicationCallbackClasses.isEmpty();
                boolean bl = hasActivityLifecycleCallbacks = this.activityLifecycleCallbacks != null && !this.activityLifecycleCallbacks.isEmpty();
                if (hasApplicationCallbacks || hasActivityLifecycleCallbacks) {
                    NopStmt beforeCbCons = Jimple.v().newNopStmt();
                    this.body.getUnits().add(beforeCbCons);
                    if (hasApplicationCallbacks) {
                        this.createClassInstances(this.applicationCallbackClasses.keySet());
                    }
                    if (hasActivityLifecycleCallbacks) {
                        this.createClassInstances(this.activityLifecycleCallbacks.keySet());
                        for (SootClass sc : this.activityLifecycleCallbacks.keySet()) {
                            SootField fld = this.callbackClassToField.get(sc);
                            Local lc = (Local)this.localVarsForClasses.get(sc);
                            if (sc == null || lc == null) continue;
                            this.body.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(fld.makeRef()), lc));
                        }
                    }
                    this.createIfStmt(beforeCbCons);
                }
                this.searchAndBuildMethod("void onCreate()", this.applicationClass, this.applicationLocal);
                SootClass scApplicationHolder = LibraryClassPatcher.createOrGetApplicationHolder();
                this.body.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(scApplicationHolder.getFieldByName("application").makeRef()), this.applicationLocal));
            }
        }
        NopStmt outerStartStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(outerStartStmt);
        HashMap<SootClass, SootMethod> fragmentToMainMethod = new HashMap<SootClass, SootMethod>();
        for (SootClass sootClass : this.fragmentClasses.keySet()) {
            Set<SootClass> fragments = this.fragmentClasses.get(sootClass);
            for (SootClass fragment : fragments) {
                FragmentEntryPointCreator entryPointCreator = new FragmentEntryPointCreator(fragment, this.applicationClass, this.manifest);
                entryPointCreator.setDummyClassName(this.mainMethod.getDeclaringClass().getName());
                entryPointCreator.setCallbacks(this.callbackFunctions.get(fragment));
                SootMethod fragmentMethod = entryPointCreator.createDummyMain();
                fragmentToMainMethod.put(fragment, fragmentMethod);
                this.componentToInfo.put(fragment, fragmentMethod);
            }
        }
        for (SootClass sootClass : this.components) {
            sootClass.setApplicationClass();
            AndroidEntryPointUtils.ComponentType componentType = this.entryPointUtils.getComponentType(sootClass);
            NopStmt beforeComponentStmt = Jimple.v().newNopStmt();
            NopStmt afterComponentStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(beforeComponentStmt);
            AbstractComponentEntryPointCreator componentCreator = null;
            switch (componentType) {
                case Activity: {
                    Set<SootClass> fragments;
                    HashMap<SootClass, SootMethod> curActivityToFragmentMethod = new HashMap<SootClass, SootMethod>();
                    if (this.fragmentClasses != null && (fragments = this.fragmentClasses.get(sootClass)) != null && !fragments.isEmpty()) {
                        for (SootClass fragment : fragments) {
                            curActivityToFragmentMethod.put(fragment, (SootMethod)fragmentToMainMethod.get(fragment));
                        }
                    }
                    componentCreator = new ActivityEntryPointCreator(sootClass, this.applicationClass, this.activityLifecycleCallbacks, this.callbackClassToField, curActivityToFragmentMethod, this.manifest);
                    break;
                }
                case Service: 
                case GCMBaseIntentService: 
                case GCMListenerService: 
                case HostApduService: {
                    componentCreator = new ServiceEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case ServiceConnection: {
                    componentCreator = new ServiceConnectionEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case BroadcastReceiver: {
                    componentCreator = new BroadcastReceiverEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                case ContentProvider: {
                    componentCreator = new ContentProviderEntryPointCreator(sootClass, this.applicationClass, this.manifest);
                    break;
                }
                default: {
                    componentCreator = null;
                }
            }
            this.createIfStmt(afterComponentStmt);
            if (componentCreator != null) {
                componentCreator.setDummyClassName(this.mainMethod.getDeclaringClass().getName());
                componentCreator.setCallbacks(this.callbackFunctions.get(sootClass));
                SootMethod lifecycleMethod = componentCreator.createDummyMain();
                this.componentToInfo.put(sootClass, componentCreator.getComponentInfo());
                this.body.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(lifecycleMethod.makeRef(), Collections.singletonList(NullConstant.v()))));
            }
            this.createIfStmt(beforeComponentStmt);
            this.body.getUnits().add(afterComponentStmt);
        }
        if (this.applicationLocal != null) {
            NopStmt beforeAppCallbacks = Jimple.v().newNopStmt();
            this.body.getUnits().add(beforeAppCallbacks);
            this.addApplicationCallbackMethods();
            this.createIfStmt(beforeAppCallbacks);
        }
        this.createIfStmt(outerStartStmt);
        if (this.applicationLocal != null) {
            this.searchAndBuildMethod("void onTerminate()", this.applicationClass, this.applicationLocal);
        }
        this.body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(this.body);
        this.eliminateSelfLoops();
        this.eliminateFallthroughIfs(this.body);
        if (Options.v().validate()) {
            this.mainMethod.getActiveBody().validate();
        }
        return this.mainMethod;
    }

    private void initializeApplicationClass() {
        IAndroidApplication app = this.manifest.getApplication();
        if (app != null) {
            String applicationName = app.getName();
            if (applicationName == null || applicationName.isEmpty()) {
                return;
            }
            for (SootClass currentClass : this.components) {
                if (!this.entryPointUtils.isApplicationClass(currentClass) || !currentClass.getName().equals(applicationName)) continue;
                if (this.applicationClass != null && currentClass != this.applicationClass) {
                    throw new RuntimeException("Multiple application classes in app");
                }
                this.applicationClass = currentClass;
                break;
            }
        }
        if (this.applicationClass == null) {
            return;
        }
        SootClass scActCallbacks = Scene.v().getSootClassUnsafe("android.app.Application$ActivityLifecycleCallbacks");
        Set<SootMethod> callbacks = this.callbackFunctions.get(this.applicationClass);
        if (callbacks != null) {
            for (SootMethod smCallback : callbacks) {
                if (smCallback == null) continue;
                if (scActCallbacks != null && Scene.v().getOrMakeFastHierarchy().canStoreType(smCallback.getDeclaringClass().getType(), scActCallbacks.getType())) {
                    this.activityLifecycleCallbacks.put(smCallback.getDeclaringClass(), smCallback.getSignature());
                    continue;
                }
                this.applicationCallbackClasses.put(smCallback.getDeclaringClass(), smCallback.getSignature());
            }
        }
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            String baseName = callbackClass.getName();
            if (baseName.contains(".")) {
                baseName = baseName.substring(baseName.lastIndexOf(".") + 1);
            }
            SootClass dummyMainClass = this.mainMethod.getDeclaringClass();
            int idx = 0;
            String fieldName = baseName;
            while (dummyMainClass.declaresFieldByName(fieldName)) {
                fieldName = baseName + "_" + idx;
                ++idx;
            }
            SootField fld = Scene.v().makeSootField(fieldName, RefType.v(callbackClass), 10);
            this.mainMethod.getDeclaringClass().addField(fld);
            this.callbackClassToField.put(callbackClass, fld);
        }
    }

    private void eliminateFallthroughIfs(Body body) {
        boolean changed = false;
        do {
            changed = false;
            IfStmt ifs = null;
            Iterator unitIt = body.getUnits().snapshotIterator();
            while (unitIt.hasNext()) {
                Unit u = (Unit)unitIt.next();
                if (ifs != null && ifs.getTarget() == u) {
                    body.getUnits().remove(ifs);
                    changed = true;
                }
                ifs = null;
                if (!(u instanceof IfStmt)) continue;
                ifs = (IfStmt)u;
            }
        } while (changed);
    }

    private void addApplicationCallbackMethods() {
        if (!this.callbackFunctions.containsKey(this.applicationClass)) {
            return;
        }
        if (this.applicationClass.isAbstract()) {
            return;
        }
        if (this.applicationClass.isPhantom()) {
            this.logger.warn("Skipping possible application callbacks in phantom class %s", (Object)this.applicationClass);
            return;
        }
        List<String> lifecycleMethods = AndroidEntryPointConstants.getApplicationLifecycleMethods();
        for (SootClass sc : this.applicationCallbackClasses.keySet()) {
            for (String methodSig : this.applicationCallbackClasses.get(sc)) {
                SootMethodAndClass methodAndClass = SootMethodRepresentationParser.v().parseSootMethodString(methodSig);
                String subSig = methodAndClass.getSubSignature();
                SootMethod method = this.findMethod(Scene.v().getSootClass(sc.getName()), subSig);
                if (sc == this.applicationClass && lifecycleMethods.contains(subSig) || this.activityLifecycleCallbacks.containsKey(sc) && lifecycleMethods.contains(subSig) || method == null || SystemClassHandler.v().isClassInSystemPackage(method.getDeclaringClass().getName())) continue;
                Local local = (Local)this.localVarsForClasses.get(sc);
                if (local == null) {
                    this.logger.warn(String.format("Could not create call to application callback %s. Local was null.", method.getSignature()));
                    continue;
                }
                NopStmt thenStmt = Jimple.v().newNopStmt();
                this.createIfStmt(thenStmt);
                this.buildMethodCall(method, local);
                this.body.getUnits().add(thenStmt);
            }
        }
    }

    @Override
    public Collection<String> getRequiredClasses() {
        HashSet<String> requiredClasses = new HashSet<String>(this.components.size());
        for (SootClass sc : this.components) {
            requiredClasses.add(sc.getName());
        }
        return requiredClasses;
    }

    public void setFragments(MultiMap<SootClass, SootClass> fragments) {
        this.fragmentClasses = fragments;
    }

    @Override
    public Collection<SootMethod> getAdditionalMethods() {
        return this.componentToInfo.getLifecycleMethods();
    }

    @Override
    public Collection<SootField> getAdditionalFields() {
        return this.componentToInfo.getAdditionalFields();
    }

    public ComponentEntryPointCollection getComponentToEntryPointInfo() {
        return this.componentToInfo;
    }

    public void setCallbackFunctions(MultiMap<SootClass, SootMethod> callbackFunctions) {
        this.callbackFunctions = callbackFunctions;
    }

    public MultiMap<SootClass, SootMethod> getCallbackFunctions() {
        return this.callbackFunctions;
    }

    @Override
    public void reset() {
        super.reset();
        for (SootMethod sm : this.getAdditionalMethods()) {
            if (!sm.isDeclared()) continue;
            sm.getDeclaringClass().removeMethod(sm);
        }
        for (SootField sf : this.getAdditionalFields()) {
            if (!sf.isDeclared()) continue;
            sf.getDeclaringClass().removeField(sf);
        }
        for (SootField fld : this.callbackClassToField.values()) {
            if (!fld.isDeclared()) continue;
            fld.getDeclaringClass().removeField(fld);
        }
        this.componentToInfo.clear();
        this.callbackClassToField.clear();
    }

    public void setComponents(Collection<SootClass> components) {
        this.components = components;
    }

    public void removeGeneratedMethods(boolean removeClass) {
        SootClass mainClass = this.mainMethod.getDeclaringClass();
        if (removeClass) {
            Scene.v().removeClass(mainClass);
        } else {
            mainClass.removeMethod(this.mainMethod);
        }
        for (SootMethod sm : this.getAdditionalMethods()) {
            SootClass declaringClass;
            if (!sm.isDeclared() || !(declaringClass = sm.getDeclaringClass()).isInScene()) continue;
            declaringClass.removeMethod(sm);
        }
    }
}

