/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import java.io.IOException;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;

public class FastCallbackAnalyzer
extends AbstractCallbackAnalyzer {
    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses) throws IOException {
        super(config, entryPointClasses);
    }

    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, String callbackFile) throws IOException {
        super(config, entryPointClasses, callbackFile);
    }

    public FastCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, Set<String> androidCallbacks) throws IOException {
        super(config, entryPointClasses, androidCallbacks);
    }

    @Override
    public void collectCallbackMethods() {
        super.collectCallbackMethods();
        this.logger.info("Collecting callbacks in FAST mode...");
        this.findClassLayoutMappings();
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (!sc.isConcrete()) continue;
            for (SootMethod sm : sc.getMethods()) {
                if (!sm.isConcrete()) continue;
                this.analyzeMethodForCallbackRegistrations(null, sm);
                this.analyzeMethodForDynamicBroadcastReceiver(sm);
                this.analyzeMethodForServiceConnection(sm);
            }
            this.analyzeMethodOverrideCallbacks(sc);
        }
    }

    private void findClassLayoutMappings() {
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            if (!sc.isConcrete()) continue;
            for (SootMethod sm : sc.getMethods()) {
                if (!sm.isConcrete()) continue;
                for (Unit u : sm.retrieveActiveBody().getUnits()) {
                    InvokeExpr inv;
                    Stmt stmt;
                    if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr() || !this.invokesSetContentView(inv = stmt.getInvokeExpr())) continue;
                    for (Value val : inv.getArgs()) {
                        Integer intValue = this.valueProvider.getValue(sm, stmt, val, Integer.class);
                        if (intValue == null) continue;
                        this.layoutClasses.put(sm.getDeclaringClass(), intValue);
                    }
                }
            }
        }
    }

    @Override
    public void excludeEntryPoint(SootClass entryPoint) {
    }
}

