/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks;

import heros.solver.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.PackManager;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.callbacks.ComponentReachableMethods;
import soot.jimple.infoflow.android.callbacks.filters.ICallbackFilter;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.queue.QueueReader;

public class DefaultCallbackAnalyzer
extends AbstractCallbackAnalyzer
implements IMemoryBoundedSolver {
    private MultiMap<SootClass, SootMethod> callbackWorklist = null;
    private AndroidEntryPointUtils entryPointUtils = new AndroidEntryPointUtils();
    private Set<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification> notificationListeners = new HashSet<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification>();
    private ISolverTerminationReason isKilled = null;
    private MultiMap<SootClass, AndroidCallbackDefinition> viewCallbacks;
    QueueReader<MethodOrMethodContext> reachableChangedListener;
    Iterator<MethodOrMethodContext> rmIterator;

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses) throws IOException {
        super(config, entryPointClasses);
    }

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, MultiMap<SootClass, AndroidCallbackDefinition> viewCallbacks, String callbackFile) throws IOException {
        super(config, entryPointClasses, callbackFile);
        this.viewCallbacks = viewCallbacks;
    }

    public DefaultCallbackAnalyzer(InfoflowAndroidConfiguration config, Set<SootClass> entryPointClasses, MultiMap<SootClass, AndroidCallbackDefinition> viewCallbacks, Set<String> androidCallbacks) throws IOException {
        super(config, entryPointClasses, androidCallbacks);
        this.viewCallbacks = viewCallbacks;
    }

    @Override
    public void collectCallbackMethods() {
        super.collectCallbackMethods();
        Transform transform = new Transform("wjtp.ajc", new SceneTransformer(){

            /*
             * WARNING - void declaration
             */
            protected void internalTransform(String phaseName, Map options) {
                for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : DefaultCallbackAnalyzer.this.notificationListeners) {
                    listener.notifySolverStarted(DefaultCallbackAnalyzer.this);
                }
                if (DefaultCallbackAnalyzer.this.callbackWorklist == null) {
                    DefaultCallbackAnalyzer.this.logger.info("Collecting callbacks in DEFAULT mode...");
                    DefaultCallbackAnalyzer.this.callbackWorklist = new HashMultiMap();
                    DefaultCallbackAnalyzer.this.findClassLayoutMappings();
                    for (Object sc : DefaultCallbackAnalyzer.this.entryPointClasses) {
                        if (DefaultCallbackAnalyzer.this.isKilled != null) break;
                        ArrayList<? extends MethodOrMethodContext> methods = new ArrayList<MethodOrMethodContext>(DefaultCallbackAnalyzer.this.entryPointUtils.getLifecycleMethods((SootClass)sc));
                        DefaultCallbackAnalyzer.this.analyzeReachableMethods((SootClass)sc, methods);
                        DefaultCallbackAnalyzer.this.analyzeMethodOverrideCallbacks((SootClass)sc);
                        DefaultCallbackAnalyzer.this.analyzeClassInterfaceCallbacks((SootClass)sc, (SootClass)sc, (SootClass)sc);
                    }
                    DefaultCallbackAnalyzer.this.reachableChangedListener = Scene.v().getReachableMethods().listener();
                    DefaultCallbackAnalyzer.this.logger.info("Callback analysis done.");
                } else {
                    DefaultCallbackAnalyzer.this.findClassLayoutMappings();
                    HashMultiMap<SootMethod, SootClass> reverseViewCallbacks = new HashMultiMap<SootMethod, SootClass>();
                    for (Pair i : DefaultCallbackAnalyzer.this.viewCallbacks) {
                        reverseViewCallbacks.put(((AndroidCallbackDefinition)i.getO2()).getTargetMethod(), (SootClass)i.getO1());
                    }
                    while (DefaultCallbackAnalyzer.this.reachableChangedListener.hasNext()) {
                        SootMethod m3 = DefaultCallbackAnalyzer.this.reachableChangedListener.next().method();
                        Set o = reverseViewCallbacks.get(m3);
                        for (SootClass i : o) {
                            DefaultCallbackAnalyzer.this.callbackWorklist.put(i, m3);
                        }
                    }
                    DefaultCallbackAnalyzer.this.logger.info(String.format("Running incremental callback analysis for %d components...", DefaultCallbackAnalyzer.this.callbackWorklist.size()));
                    HashMultiMap workList = new HashMultiMap(DefaultCallbackAnalyzer.this.callbackWorklist);
                    Iterator it = workList.keySet().iterator();
                    while (it.hasNext() && DefaultCallbackAnalyzer.this.isKilled == null) {
                        SootClass componentClass = (SootClass)it.next();
                        Set callbacks = DefaultCallbackAnalyzer.this.callbackWorklist.get(componentClass);
                        DefaultCallbackAnalyzer.this.callbackWorklist.remove(componentClass);
                        Set<Object> activityComponents = DefaultCallbackAnalyzer.this.fragmentClassesRev.get(componentClass);
                        if (activityComponents == null || activityComponents.isEmpty()) {
                            activityComponents = Collections.singleton(componentClass);
                        }
                        if (DefaultCallbackAnalyzer.this.config.getCallbackConfig().getMaxCallbacksPerComponent() > 0 && callbacks.size() > DefaultCallbackAnalyzer.this.config.getCallbackConfig().getMaxCallbacksPerComponent()) {
                            DefaultCallbackAnalyzer.this.callbackMethods.remove(componentClass);
                            DefaultCallbackAnalyzer.this.entryPointClasses.remove(componentClass);
                            continue;
                        }
                        DefaultCallbackAnalyzer.this.analyzeMethodOverrideCallbacks(componentClass);
                        for (SootClass sootClass : activityComponents) {
                            void var10_14;
                            if (sootClass == null) {
                                SootClass sootClass2 = componentClass;
                            }
                            DefaultCallbackAnalyzer.this.analyzeClassInterfaceCallbacks(componentClass, componentClass, (SootClass)var10_14);
                        }
                        ArrayList<SootMethod> entryClasses = new ArrayList<SootMethod>(callbacks.size());
                        for (SootMethod sm : callbacks) {
                            if (sm == null) continue;
                            entryClasses.add(sm);
                        }
                        DefaultCallbackAnalyzer.this.analyzeReachableMethods(componentClass, entryClasses);
                    }
                    DefaultCallbackAnalyzer.this.logger.info("Incremental callback analysis done.");
                }
                for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : DefaultCallbackAnalyzer.this.notificationListeners) {
                    listener.notifySolverTerminated(DefaultCallbackAnalyzer.this);
                }
            }
        });
        PackManager.v().getPack("wjtp").add(transform);
    }

    private void analyzeReachableMethods(SootClass lifecycleElement, List<MethodOrMethodContext> methods) {
        ComponentReachableMethods rm = new ComponentReachableMethods(this.config, lifecycleElement, methods);
        rm.update();
        QueueReader<MethodOrMethodContext> reachableMethods = rm.listener();
        while (reachableMethods.hasNext() && this.isKilled == null) {
            for (ICallbackFilter filter : this.callbackFilters) {
                filter.setReachableMethods(rm);
            }
            SootMethod method = reachableMethods.next().method();
            if (!method.isConcrete()) continue;
            this.analyzeMethodForCallbackRegistrations(lifecycleElement, method);
            this.analyzeMethodForDynamicBroadcastReceiver(method);
            this.analyzeMethodForServiceConnection(method);
            this.analyzeMethodForFragmentTransaction(lifecycleElement, method);
            this.analyzeMethodForViewPagers(lifecycleElement, method);
        }
    }

    @Override
    protected boolean checkAndAddMethod(SootMethod method, SootMethod parentMethod, SootClass lifecycleClass, AndroidCallbackDefinition.CallbackType callbackType) {
        if (!this.excludedEntryPoints.contains(lifecycleClass) && super.checkAndAddMethod(method, parentMethod, lifecycleClass, callbackType)) {
            this.callbackWorklist.put(lifecycleClass, method);
            return true;
        }
        return false;
    }

    @Override
    protected void checkAndAddFragment(SootClass componentClass, SootClass fragmentClass) {
        if (!this.excludedEntryPoints.contains(componentClass)) {
            super.checkAndAddFragment(componentClass, fragmentClass);
            for (SootMethod sm : fragmentClass.getMethods()) {
                if (!sm.isConstructor() && !AndroidEntryPointConstants.getFragmentLifecycleMethods().contains(sm.getSubSignature())) continue;
                this.callbackWorklist.put(fragmentClass, sm);
            }
        }
    }

    private void findClassLayoutMappings() {
        if (this.rmIterator == null) {
            this.rmIterator = Scene.v().getReachableMethods().listener();
        }
        while (this.rmIterator.hasNext()) {
            SootMethod sm = this.rmIterator.next().method();
            if (!sm.isConcrete() || SystemClassHandler.v().isClassInSystemPackage(sm.getDeclaringClass().getName())) continue;
            for (Unit u : sm.retrieveActiveBody().getUnits()) {
                Integer intValue;
                Stmt stmt;
                if (!(u instanceof Stmt) || !(stmt = (Stmt)u).containsInvokeExpr()) continue;
                InvokeExpr inv = stmt.getInvokeExpr();
                if (this.invokesSetContentView(inv)) {
                    for (Value val : inv.getArgs()) {
                        Integer intValue2 = this.valueProvider.getValue(sm, stmt, val, Integer.class);
                        if (intValue2 == null) continue;
                        this.layoutClasses.put(sm.getDeclaringClass(), intValue2);
                    }
                }
                if (!this.invokesInflate(inv) || (intValue = this.valueProvider.getValue(sm, stmt, inv.getArg(0), Integer.class)) == null) continue;
                this.layoutClasses.put(sm.getDeclaringClass(), intValue);
            }
        }
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.isKilled = reason;
    }

    @Override
    public boolean isTerminated() {
        return this.isKilled != null;
    }

    @Override
    public boolean isKilled() {
        return this.isKilled != null;
    }

    @Override
    public void reset() {
        this.isKilled = null;
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public void excludeEntryPoint(SootClass entryPoint) {
        super.excludeEntryPoint(entryPoint);
        this.callbackWorklist.remove(entryPoint);
        this.callbackMethods.remove(entryPoint);
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.isKilled;
    }
}

