/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApkHandler
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected File apk;
    protected ZipFile zip;

    public ApkHandler(String path) throws ZipException, IOException {
        this(new File(path));
    }

    public ApkHandler(File apk) throws ZipException, IOException {
        this.apk = apk;
    }

    public String getAbsolutePath() {
        return this.apk.getAbsolutePath();
    }

    public String getPath() {
        return this.apk.getPath();
    }

    public String getFilename() {
        return this.apk.getName();
    }

    public InputStream getInputStream(String filename) throws IOException {
        InputStream is = null;
        if (this.zip == null) {
            this.zip = new ZipFile(this.apk);
        }
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.equals(filename)) continue;
            is = this.zip.getInputStream(entry);
            break;
        }
        return is;
    }

    public void addFilesToApk(List<File> files) throws IOException {
        this.addFilesToApk(files, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesToApk(List<File> files, Map<String, String> paths) throws IOException {
        if (this.zip != null) {
            this.zip.close();
            this.zip = null;
        }
        for (File file : files) {
            if (paths.containsKey(file.getPath())) continue;
            paths.put(file.getPath(), file.getName());
        }
        File tempFile = File.createTempFile(this.apk.getName(), null);
        tempFile.delete();
        boolean renameOk = this.apk.renameTo(tempFile);
        if (!renameOk) {
            try {
                Files.move(this.apk, tempFile);
            }
            catch (IOException ex) {
                throw new IOException("could not rename the file " + this.apk.getAbsolutePath() + " to " + tempFile.getAbsolutePath(), ex);
            }
        }
        byte[] buf = new byte[1024];
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.apk));){
            ZipEntry entry;
            block21: while ((entry = zin.getNextEntry()) != null) {
                int len;
                for (String path : paths.values()) {
                    if (!entry.getName().equals(path)) continue;
                    continue block21;
                }
                if (entry.getName().startsWith("META-INF/") && (entry.getName().endsWith(".RSA") || entry.getName().endsWith(".SF"))) continue;
                ZipEntry ze = new ZipEntry(entry.getName());
                ze.setMethod(entry.getMethod());
                if (entry.getTime() != -1L) {
                    ze.setTime(entry.getTime());
                }
                if (entry.getSize() != -1L) {
                    ze.setSize(entry.getSize());
                }
                if (entry.getCrc() != -1L) {
                    ze.setCrc(entry.getCrc());
                }
                out.putNextEntry(ze);
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                zin.closeEntry();
                out.closeEntry();
            }
            for (File file : files) {
                try (FileInputStream in = new FileInputStream(file);){
                    int len;
                    out.putNextEntry(new ZipEntry(paths.get(file.getPath())));
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                }
            }
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    @Override
    public void close() {
        if (this.zip != null) {
            try {
                this.zip.close();
            }
            catch (IOException e) {
                this.logger.error("Could not close apk file", e);
            }
            this.zip = null;
        }
    }
}

