/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.ImplicitFlowAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.toolkits.pointer.LocalMustAliasAnalysis;
import soot.jimple.toolkits.pointer.StrongLocalMustAliasAnalysis;
import soot.toolkits.graph.UnitGraph;

public class Aliasing {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IAliasingStrategy aliasingStrategy;
    private final IAliasingStrategy implicitFlowAliasingStrategy;
    private final InfoflowManager manager;
    private final Set<SootMethod> excludedFromMustAliasAnalysis = new HashSet<SootMethod>();
    protected final LoadingCache<SootMethod, LocalMustAliasAnalysis> strongAliasAnalysis = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, LocalMustAliasAnalysis>(){

        @Override
        public LocalMustAliasAnalysis load(SootMethod method) throws Exception {
            return new StrongLocalMustAliasAnalysis((UnitGraph)Aliasing.this.manager.getICFG().getOrCreateUnitGraph(method));
        }
    });

    public Aliasing(IAliasingStrategy aliasingStrategy, InfoflowManager manager) {
        this.aliasingStrategy = aliasingStrategy;
        this.implicitFlowAliasingStrategy = new ImplicitFlowAliasStrategy(manager);
        this.manager = manager;
    }

    public void computeAliases(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        if (!Aliasing.canHaveAliases(newAbs.getAccessPath()) && !this.isStringConstructorCall(src)) {
            return;
        }
        if (!d1.getAccessPath().isEmpty()) {
            this.aliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        } else if (targetValue instanceof InstanceFieldRef) {
            this.implicitFlowAliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        }
    }

    public AccessPath getReferencedAPBase(AccessPath taintedAP, SootField[] referencedFields) {
        return Aliasing.getReferencedAPBase(taintedAP, referencedFields, this.manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessPath getReferencedAPBase(AccessPath taintedAP, SootField[] referencedFields, InfoflowManager manager) {
        Collection<AccessPathFragment[]> bases;
        AccessPathFactory af = manager.getAccessPathFactory();
        Collection<AccessPathFragment[]> collection = bases = taintedAP.isStaticFieldRef() ? af.getBaseForType(taintedAP.getFirstFieldType()) : af.getBaseForType(taintedAP.getBaseType());
        if (bases != null && bases.size() > manager.getConfig().getMaxAliasingBases()) {
            return null;
        }
        for (int fieldIdx = 0; fieldIdx < referencedFields.length; ++fieldIdx) {
            if (fieldIdx >= taintedAP.getFragmentCount()) {
                if (taintedAP.getTaintSubFields()) {
                    return taintedAP;
                }
                return null;
            }
            if (taintedAP.getFragments()[fieldIdx].getField() == referencedFields[fieldIdx]) continue;
            if (!(bases == null || taintedAP.isStaticFieldRef() && fieldIdx == 0)) {
                Collection<AccessPathFragment[]> collection2 = bases;
                synchronized (collection2) {
                    for (AccessPathFragment[] base : bases) {
                        if (base[0].getField() != referencedFields[fieldIdx]) continue;
                        AccessPathFragment[] cutFragments = new AccessPathFragment[taintedAP.getFragmentCount() + base.length];
                        System.arraycopy(taintedAP.getFragments(), 0, cutFragments, 0, fieldIdx);
                        System.arraycopy(base, 0, cutFragments, fieldIdx, base.length);
                        System.arraycopy(taintedAP.getFragments(), fieldIdx, cutFragments, fieldIdx + base.length, taintedAP.getFragmentCount() - fieldIdx);
                        return manager.getAccessPathFactory().createAccessPath(taintedAP.getPlainValue(), taintedAP.getBaseType(), cutFragments, taintedAP.getTaintSubFields(), false, false, taintedAP.getArrayTaintType());
                    }
                }
            }
            return null;
        }
        return taintedAP;
    }

    public boolean mayAlias(Value val1, Value val2) {
        if (!AccessPath.canContainValue(val1) || !AccessPath.canContainValue(val2)) {
            return false;
        }
        if (val1 instanceof Constant || val2 instanceof Constant) {
            return false;
        }
        if (val1 == val2) {
            return true;
        }
        if (this.aliasingStrategy.isInteractive()) {
            return this.aliasingStrategy.mayAlias(this.manager.getAccessPathFactory().createAccessPath(val1, false), this.manager.getAccessPathFactory().createAccessPath(val2, false));
        }
        return false;
    }

    public AccessPath mayAlias(AccessPath ap, Value val) {
        SootField[] sootFieldArray;
        if (!AccessPath.canContainValue(val)) {
            return null;
        }
        if (val instanceof Constant) {
            return null;
        }
        if (this.aliasingStrategy.isInteractive()) {
            if (!this.aliasingStrategy.mayAlias(ap, this.manager.getAccessPathFactory().createAccessPath(val, true))) {
                return null;
            }
        } else {
            if (val instanceof Local && ap.getPlainValue() != val) {
                return null;
            }
            if (val instanceof ArrayRef && ap.getPlainValue() != ((ArrayRef)val).getBase()) {
                return null;
            }
            if (val instanceof InstanceFieldRef) {
                if (!ap.isLocal() && !ap.isInstanceFieldRef()) {
                    return null;
                }
                if (((InstanceFieldRef)val).getBase() != ap.getPlainValue()) {
                    return null;
                }
            }
        }
        if (val instanceof StaticFieldRef && !ap.isStaticFieldRef()) {
            return null;
        }
        if (val instanceof FieldRef) {
            SootField[] sootFieldArray2 = new SootField[1];
            sootFieldArray = sootFieldArray2;
            sootFieldArray2[0] = ((FieldRef)val).getField();
        } else {
            sootFieldArray = new SootField[]{};
        }
        SootField[] fields = sootFieldArray;
        return Aliasing.getReferencedAPBase(ap, fields, this.manager);
    }

    public boolean mustAlias(SootField field1, SootField field2) {
        return field1 == field2;
    }

    public boolean mustAlias(Local val1, Local val2, Stmt position) {
        if (val1 == val2) {
            return true;
        }
        if (!(val1.getType() instanceof RefLikeType) || !(val2.getType() instanceof RefLikeType)) {
            return false;
        }
        SootMethod method = (SootMethod)this.manager.getICFG().getMethodOf(position);
        if (this.excludedFromMustAliasAnalysis.contains(method)) {
            return false;
        }
        if (this.manager.isAnalysisAborted()) {
            return false;
        }
        try {
            LocalMustAliasAnalysis lmaa = this.strongAliasAnalysis.getUnchecked(method);
            return lmaa.mustAlias(val1, position, val2, position);
        }
        catch (Exception ex) {
            this.logger.error("Error in local must alias analysis", ex);
            return false;
        }
    }

    public boolean canHaveAliases(Stmt stmt, Value val, Abstraction source) {
        InstanceFieldRef instanceFieldRef;
        Value base;
        if (stmt instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)stmt;
            if (defStmt.getLeftOp() instanceof Local && defStmt.getLeftOp() == source.getAccessPath().getPlainValue()) {
                return false;
            }
            if (val instanceof ArrayRef) {
                return true;
            }
            if (val instanceof FieldRef) {
                return true;
            }
        }
        if (val instanceof InstanceFieldRef ? (base = (instanceFieldRef = (InstanceFieldRef)val).getBase()).getType() instanceof PrimType : val instanceof Local && val.getType() instanceof PrimType) {
            return false;
        }
        if (val instanceof Constant) {
            return false;
        }
        if (TypeUtils.isStringType(val.getType()) && !this.isStringConstructorCall(stmt) && !source.getAccessPath().getCanHaveImmutableAliases()) {
            return false;
        }
        AccessPath ap = source.getAccessPath();
        return val instanceof FieldRef || val instanceof Local && ((Local)val).getType() instanceof ArrayType || ap != null && ap.getTaintSubFields();
    }

    public boolean canHaveAliasesRightSide(Stmt stmt, Value val, Abstraction source) {
        InstanceFieldRef instanceFieldRef;
        Value base;
        if (stmt instanceof DefinitionStmt) {
            if (val instanceof ArrayRef) {
                return true;
            }
            if (val instanceof FieldRef) {
                return true;
            }
        }
        if (val instanceof InstanceFieldRef ? (base = (instanceFieldRef = (InstanceFieldRef)val).getBase()).getType() instanceof PrimType : val instanceof Local && val.getType() instanceof PrimType) {
            return false;
        }
        if (val instanceof Constant) {
            return false;
        }
        if (TypeUtils.isStringType(val.getType()) && !this.isStringConstructorCall(stmt) && !source.getAccessPath().getCanHaveImmutableAliases()) {
            return false;
        }
        return val instanceof FieldRef || val instanceof Local;
    }

    public boolean isStringConstructorCall(Stmt iStmt) {
        SootClass scString = Scene.v().getSootClassUnsafe("java.lang.String");
        Collection callees = this.manager.getICFG().getCalleesOfCallAt(iStmt);
        if (callees != null && !callees.isEmpty()) {
            for (SootMethod callee : callees) {
                if (callee.getDeclaringClass() != scString || !callee.isConstructor()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canHaveAliases(AccessPath ap) {
        if (TypeUtils.isStringType(ap.getBaseType()) && !ap.getCanHaveImmutableAliases()) {
            return false;
        }
        return !(ap.isStaticFieldRef() ? ap.getFirstFieldType() instanceof PrimType : ap.getBaseType() instanceof PrimType);
    }

    public static boolean baseMatches(Value baseValue, Abstraction source) {
        if (baseValue instanceof Local) {
            if (baseValue.equals(source.getAccessPath().getPlainValue())) {
                return true;
            }
        } else if (baseValue instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)baseValue;
            if (ifr.getBase().equals(source.getAccessPath().getPlainValue()) && source.getAccessPath().firstFieldMatches(ifr.getField())) {
                return true;
            }
        } else if (baseValue instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)baseValue;
            if (source.getAccessPath().firstFieldMatches(sfr.getField())) {
                return true;
            }
        }
        return false;
    }

    public static boolean baseMatchesStrict(Value baseValue, Abstraction source) {
        if (!Aliasing.baseMatches(baseValue, source)) {
            return false;
        }
        if (baseValue instanceof Local) {
            return source.getAccessPath().isLocal();
        }
        if (baseValue instanceof InstanceFieldRef || baseValue instanceof StaticFieldRef) {
            return source.getAccessPath().getFragmentCount() == 1;
        }
        throw new RuntimeException("Unexpected left side");
    }

    public void excludeMethodFromMustAlias(SootMethod method) {
        this.excludedFromMustAliasAnalysis.add(method);
    }

    public IAliasingStrategy getAliasingStrategy() {
        return this.aliasingStrategy;
    }
}

