/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class New2InitFlowAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet> {
    FlowSet emptySet = new ArraySparseSet();

    public New2InitFlowAnalysis(DirectedGraph<Unit> graph) {
        super(graph);
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(FlowSet in, Unit d, FlowSet out) {
        in.copy(out);
        if (d instanceof DefinitionStmt) {
            Value v;
            DefinitionStmt ds = (DefinitionStmt)d;
            if (ds.getRightOp() instanceof NewExpr && (v = ds.getLeftOp()) instanceof Local && in.contains(v)) {
                out.remove(v);
            }
        } else {
            for (ValueBox useBox : d.getUseBoxes()) {
                Value v = useBox.getValue();
                if (!(v instanceof Local)) continue;
                out.add(v);
            }
        }
    }

    @Override
    protected FlowSet newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected FlowSet entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void merge(FlowSet in1, FlowSet in2, FlowSet out) {
        in1.union(in2, out);
    }

    @Override
    protected void copy(FlowSet source, FlowSet dest) {
        source.copy(dest);
    }
}

