/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.StmtBox;
import soot.options.Options;

public class GrimpBody
extends StmtBody {
    private static final Logger logger = LoggerFactory.getLogger(GrimpBody.class);

    GrimpBody(SootMethod m3) {
        super(m3);
    }

    @Override
    public Object clone() {
        GrimpBody b = Grimp.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    GrimpBody(Body body) {
        super(body.getMethod());
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing GrimpBody...");
        }
        JimpleBody jBody = null;
        if (!(body instanceof JimpleBody)) {
            throw new RuntimeException("Can only construct GrimpBody's from JimpleBody's (for now)");
        }
        jBody = (JimpleBody)body;
        Iterator<Local> localIt = jBody.getLocals().iterator();
        while (localIt.hasNext()) {
            this.getLocals().add(localIt.next());
        }
        Iterator it = jBody.getUnits().iterator();
        final HashMap<Stmt, Stmt> oldToNew = new HashMap<Stmt, Stmt>(this.getUnits().size() * 2 + 1, 0.7f);
        LinkedList<Unit> updates = new LinkedList<Unit>();
        while (it.hasNext()) {
            Stmt stmt = (Stmt)it.next();
            final StmtBox newStmtBox = (StmtBox)Grimp.v().newStmtBox(null);
            final StmtBox updateStmtBox = (StmtBox)Grimp.v().newStmtBox(null);
            stmt.apply(new AbstractStmtSwitch(){

                @Override
                public void caseAssignStmt(AssignStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newAssignStmt(s2));
                }

                @Override
                public void caseIdentityStmt(IdentityStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newIdentityStmt(s2));
                }

                @Override
                public void caseBreakpointStmt(BreakpointStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newBreakpointStmt(s2));
                }

                @Override
                public void caseInvokeStmt(InvokeStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newInvokeStmt(s2));
                }

                @Override
                public void caseEnterMonitorStmt(EnterMonitorStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newEnterMonitorStmt(s2));
                }

                @Override
                public void caseExitMonitorStmt(ExitMonitorStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newExitMonitorStmt(s2));
                }

                @Override
                public void caseGotoStmt(GotoStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newGotoStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseIfStmt(IfStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newIfStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newLookupSwitchStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseNopStmt(NopStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newNopStmt(s2));
                }

                @Override
                public void caseReturnStmt(ReturnStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newReturnStmt(s2));
                }

                @Override
                public void caseReturnVoidStmt(ReturnVoidStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newReturnVoidStmt(s2));
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newTableSwitchStmt(s2));
                    updateStmtBox.setUnit(s2);
                }

                @Override
                public void caseThrowStmt(ThrowStmt s2) {
                    newStmtBox.setUnit(Grimp.v().newThrowStmt(s2));
                }
            });
            Stmt newStmt = (Stmt)newStmtBox.getUnit();
            for (ValueBox b : newStmt.getUseBoxes()) {
                b.setValue(Grimp.v().newExpr(b.getValue()));
            }
            for (ValueBox b : newStmt.getDefBoxes()) {
                b.setValue(Grimp.v().newExpr(b.getValue()));
            }
            this.getUnits().add(newStmt);
            oldToNew.put(stmt, newStmt);
            if (updateStmtBox.getUnit() != null) {
                updates.add(updateStmtBox.getUnit());
            }
            if (stmt.hasTag("LineNumberTag")) {
                newStmt.addTag(stmt.getTag("LineNumberTag"));
            }
            if (!stmt.hasTag("SourceLnPosTag")) continue;
            newStmt.addTag(stmt.getTag("SourceLnPosTag"));
        }
        for (Stmt stmt : updates) {
            stmt.apply(new AbstractStmtSwitch(){

                @Override
                public void caseGotoStmt(GotoStmt s2) {
                    GotoStmt newStmt = (GotoStmt)oldToNew.get(s2);
                    newStmt.setTarget((Unit)oldToNew.get(newStmt.getTarget()));
                }

                @Override
                public void caseIfStmt(IfStmt s2) {
                    IfStmt newStmt = (IfStmt)oldToNew.get(s2);
                    newStmt.setTarget((Unit)oldToNew.get(newStmt.getTarget()));
                }

                @Override
                public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
                    LookupSwitchStmt newStmt = (LookupSwitchStmt)oldToNew.get(s2);
                    newStmt.setDefaultTarget((Unit)oldToNew.get(newStmt.getDefaultTarget()));
                    Unit[] newTargList = new Unit[newStmt.getTargetCount()];
                    for (int i = 0; i < newStmt.getTargetCount(); ++i) {
                        newTargList[i] = (Unit)oldToNew.get(newStmt.getTarget(i));
                    }
                    newStmt.setTargets(newTargList);
                }

                @Override
                public void caseTableSwitchStmt(TableSwitchStmt s2) {
                    TableSwitchStmt newStmt = (TableSwitchStmt)oldToNew.get(s2);
                    newStmt.setDefaultTarget((Unit)oldToNew.get(newStmt.getDefaultTarget()));
                    int tc = newStmt.getHighIndex() - newStmt.getLowIndex() + 1;
                    LinkedList newTargList = new LinkedList();
                    for (int i = 0; i < tc; ++i) {
                        newTargList.add(oldToNew.get(newStmt.getTarget(i)));
                    }
                    newStmt.setTargets(newTargList);
                }
            });
        }
        for (Trap oldTrap : jBody.getTraps()) {
            this.getTraps().add(Grimp.v().newTrap(oldTrap.getException(), (Unit)oldToNew.get(oldTrap.getBeginUnit()), (Unit)oldToNew.get(oldTrap.getEndUnit()), (Unit)oldToNew.get(oldTrap.getHandlerUnit())));
        }
        PackManager.v().getPack("gb").apply(this);
    }
}

