/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.typing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class Validate {
    public static void validateArrays(Body b) {
        HashSet<DefinitionStmt> definitions = new HashSet<DefinitionStmt>();
        HashSet<Unit> unitWithArrayRef = new HashSet<Unit>();
        for (Unit u : b.getUnits()) {
            if (u instanceof DefinitionStmt) {
                DefinitionStmt s2 = (DefinitionStmt)u;
                definitions.add(s2);
            }
            List<ValueBox> uses = u.getUseBoxes();
            Iterator<ValueBox> iterator = uses.iterator();
            while (iterator.hasNext()) {
                ValueBox vb = iterator.next();
                Value v = vb.getValue();
                if (!(v instanceof ArrayRef)) continue;
                unitWithArrayRef.add(u);
            }
        }
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(b, true);
        HashSet<Unit> toReplace = new HashSet<Unit>();
        for (Unit u : unitWithArrayRef) {
            boolean ok = false;
            List<ValueBox> uses = u.getUseBoxes();
            for (ValueBox vb : uses) {
                boolean isMore;
                Value v = vb.getValue();
                if (!(v instanceof ArrayRef)) continue;
                ArrayRef ar = (ArrayRef)v;
                Local base = (Local)ar.getBase();
                List<Unit> defs = localDefs.getDefsOfAt(base, u);
                HashSet<Unit> alreadyHandled = new HashSet<Unit>();
                block4: do {
                    isMore = false;
                    for (Unit d : defs) {
                        if (alreadyHandled.contains(d) || !(d instanceof AssignStmt)) continue;
                        AssignStmt ass = (AssignStmt)d;
                        Value r = ass.getRightOp();
                        if (r instanceof Local) {
                            defs.addAll(localDefs.getDefsOfAt((Local)r, d));
                            alreadyHandled.add(d);
                            isMore = true;
                            continue block4;
                        }
                        if (!(r instanceof ArrayRef)) continue;
                        ArrayRef arrayRef = (ArrayRef)r;
                        Local l = (Local)arrayRef.getBase();
                        defs.addAll(localDefs.getDefsOfAt(l, d));
                        alreadyHandled.add(d);
                        isMore = true;
                        continue block4;
                    }
                } while (isMore);
                for (Unit def : defs) {
                    Value r = null;
                    if (def instanceof IdentityStmt) {
                        IdentityStmt idstmt = (IdentityStmt)def;
                        r = idstmt.getRightOp();
                    } else if (def instanceof AssignStmt) {
                        AssignStmt assStmt = (AssignStmt)def;
                        r = assStmt.getRightOp();
                    } else {
                        throw new RuntimeException("error: definition statement not an IdentityStmt nor an AssignStmt! " + def);
                    }
                    Type t = null;
                    if (r instanceof InvokeExpr) {
                        InvokeExpr ie = (InvokeExpr)r;
                        t = ie.getType();
                        if (t instanceof ArrayType) {
                            ok = true;
                        }
                    } else if (r instanceof FieldRef) {
                        FieldRef ref = (FieldRef)r;
                        t = ref.getType();
                        if (t instanceof ArrayType) {
                            ok = true;
                        }
                    } else if (r instanceof IdentityRef) {
                        IdentityRef ir = (IdentityRef)r;
                        t = ir.getType();
                        if (t instanceof ArrayType) {
                            ok = true;
                        }
                    } else if (r instanceof CastExpr) {
                        CastExpr c = (CastExpr)r;
                        t = c.getType();
                        if (t instanceof ArrayType) {
                            ok = true;
                        }
                    } else if (!(r instanceof ArrayRef)) {
                        if (r instanceof NewArrayExpr) {
                            ok = true;
                        } else if (!(r instanceof Local) && !(r instanceof Constant)) {
                            throw new RuntimeException("error: unknown right hand side of definition stmt " + def);
                        }
                    }
                    if (!ok) continue;
                    break;
                }
                if (!ok) continue;
                break;
            }
            if (ok) continue;
            toReplace.add(u);
        }
        int i = 0;
        for (Unit u : toReplace) {
            System.out.println("warning: incorrect array def, replacing unit " + u);
            RefType throwableType = RefType.v("java.lang.Throwable");
            Local ttt = Jimple.v().newLocal("ttt_" + ++i, throwableType);
            b.getLocals().add(ttt);
            NewExpr r = Jimple.v().newNewExpr(throwableType);
            AssignStmt initLocalUnit = Jimple.v().newAssignStmt(ttt, r);
            ArrayList<String> pTypes = new ArrayList<String>();
            pTypes.add("java.lang.String");
            boolean isStatic = false;
            SootMethodRef mRef = Validate.makeMethodRef("java.lang.Throwable", "<init>", "", pTypes, isStatic);
            ArrayList<StringConstant> parameters = new ArrayList<StringConstant>();
            parameters.add(StringConstant.v("Soot updated this instruction"));
            SpecialInvokeExpr ie = Jimple.v().newSpecialInvokeExpr(ttt, mRef, parameters);
            InvokeStmt initMethod = Jimple.v().newInvokeStmt(ie);
            ThrowStmt newUnit = Jimple.v().newThrowStmt(ttt);
            b.getUnits().swapWith(u, newUnit);
            b.getUnits().insertBefore(initMethod, newUnit);
            b.getUnits().insertBefore(initLocalUnit, initMethod);
        }
        DeadAssignmentEliminator.v().transform(b);
        UnusedLocalEliminator.v().transform(b);
        NopEliminator.v().transform(b);
        UnreachableCodeEliminator.v().transform(b);
    }

    public static SootMethodRef makeMethodRef(String cName, String mName, String rType, List<String> pTypes, boolean isStatic) {
        SootClass sc = SootResolver.v().makeClassRef(cName);
        Type returnType = null;
        returnType = rType == "" ? VoidType.v() : RefType.v(rType);
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        for (String p : pTypes) {
            parameterTypes.add(RefType.v(p));
        }
        return Scene.v().makeMethodRef(sc, mName, parameterTypes, returnType, isStatic);
    }
}

