/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.scalar.LocalCreation;

public class Util {
    public static String dottedClassName(String typeDescriptor) {
        int idx;
        if (!Util.isByteCodeClassName(typeDescriptor)) {
            int idx2;
            String t = typeDescriptor;
            for (idx2 = 0; idx2 < t.length() && t.charAt(idx2) == '['; ++idx2) {
            }
            String c = t.substring(idx2);
            if (c.length() == 1 && (c.startsWith("I") || c.startsWith("B") || c.startsWith("C") || c.startsWith("S") || c.startsWith("J") || c.startsWith("D") || c.startsWith("F") || c.startsWith("Z"))) {
                Type ty = Util.getType(t);
                return ty == null ? "" : Util.getType(t).toString();
            }
            throw new IllegalArgumentException("typeDescriptor is not a class typedescriptor: '" + typeDescriptor + "'");
        }
        String t = typeDescriptor;
        for (idx = 0; idx < t.length() && t.charAt(idx) == '['; ++idx) {
        }
        String className = typeDescriptor.substring(idx);
        className = className.substring(className.indexOf(76) + 1, className.indexOf(59));
        className = className.replace('/', '.');
        return className;
    }

    public static Type getType(String type) {
        int idx = 0;
        int arraySize = 0;
        Type returnType = null;
        boolean notFound = true;
        block13: while (idx < type.length() && notFound) {
            switch (type.charAt(idx)) {
                case '[': {
                    while (idx < type.length() && type.charAt(idx) == '[') {
                        ++arraySize;
                        ++idx;
                    }
                    continue block13;
                }
                case 'L': {
                    String objectName = type.replaceAll("^[^L]*L", "").replaceAll(";$", "");
                    returnType = RefType.v(objectName.replace("/", "."));
                    notFound = false;
                    break;
                }
                case 'J': {
                    returnType = LongType.v();
                    notFound = false;
                    break;
                }
                case 'S': {
                    returnType = ShortType.v();
                    notFound = false;
                    break;
                }
                case 'D': {
                    returnType = DoubleType.v();
                    notFound = false;
                    break;
                }
                case 'I': {
                    returnType = IntType.v();
                    notFound = false;
                    break;
                }
                case 'F': {
                    returnType = FloatType.v();
                    notFound = false;
                    break;
                }
                case 'B': {
                    returnType = ByteType.v();
                    notFound = false;
                    break;
                }
                case 'C': {
                    returnType = CharType.v();
                    notFound = false;
                    break;
                }
                case 'V': {
                    returnType = VoidType.v();
                    notFound = false;
                    break;
                }
                case 'Z': {
                    returnType = BooleanType.v();
                    notFound = false;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown type: '" + type + "'");
                }
            }
            ++idx;
        }
        if (returnType != null && arraySize > 0) {
            returnType = ArrayType.v(returnType, arraySize);
        }
        return returnType;
    }

    public static boolean isByteCodeClassName(String className) {
        return !(!className.startsWith("L") && !className.startsWith("[") || !className.endsWith(";") || className.indexOf(47) == -1 && className.indexOf(46) != -1);
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static boolean isFloatLike(Type t) {
        return t.equals(FloatType.v()) || t.equals(DoubleType.v()) || t.equals(RefType.v("java.lang.Float")) || t.equals(RefType.v("java.lang.Double"));
    }

    public static void emptyBody(Body jBody) {
        ArrayList<Unit> idStmts = new ArrayList<Unit>();
        ArrayList<Local> idLocals = new ArrayList<Local>();
        for (Object u : jBody.getUnits()) {
            IdentityStmt i;
            if (!(u instanceof IdentityStmt) || !((i = (IdentityStmt)u).getRightOp() instanceof ParameterRef) && !(i.getRightOp() instanceof ThisRef)) continue;
            idStmts.add((Unit)u);
            idLocals.add((Local)i.getLeftOp());
        }
        jBody.getUnits().clear();
        jBody.getLocals().clear();
        jBody.getTraps().clear();
        LocalGenerator lg = new LocalGenerator(jBody);
        for (Unit u : idStmts) {
            jBody.getUnits().add(u);
        }
        for (Local l : idLocals) {
            jBody.getLocals().add(l);
        }
        Type rType = jBody.getMethod().getReturnType();
        jBody.getUnits().add(Jimple.v().newNopStmt());
        if (rType instanceof VoidType) {
            jBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        } else {
            Type t = jBody.getMethod().getReturnType();
            Local l = lg.generateLocal(t);
            AssignStmt ass = null;
            if (t instanceof RefType || t instanceof ArrayType) {
                ass = Jimple.v().newAssignStmt(l, NullConstant.v());
            } else if (t instanceof LongType) {
                ass = Jimple.v().newAssignStmt(l, LongConstant.v(0L));
            } else if (t instanceof FloatType) {
                ass = Jimple.v().newAssignStmt(l, FloatConstant.v(0.0f));
            } else if (t instanceof IntType) {
                ass = Jimple.v().newAssignStmt(l, IntConstant.v(0));
            } else if (t instanceof DoubleType) {
                ass = Jimple.v().newAssignStmt(l, DoubleConstant.v(0.0));
            } else if (t instanceof BooleanType || t instanceof ByteType || t instanceof CharType || t instanceof ShortType) {
                ass = Jimple.v().newAssignStmt(l, IntConstant.v(0));
            } else {
                throw new RuntimeException("error: return type unknown: " + t + " class: " + t.getClass());
            }
            jBody.getUnits().add(ass);
            jBody.getUnits().add(Jimple.v().newReturnStmt(l));
        }
    }

    public static void addExceptionAfterUnit(Body b, String exceptionType, Unit u, String m3) {
        LocalCreation lc = new LocalCreation(b.getLocals());
        Local l = lc.newLocal(RefType.v(exceptionType));
        ArrayList<Stmt> newUnits = new ArrayList<Stmt>();
        AssignStmt u1 = Jimple.v().newAssignStmt(l, Jimple.v().newNewExpr(RefType.v(exceptionType)));
        InvokeStmt u2 = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(l, Scene.v().makeMethodRef(Scene.v().getSootClass(exceptionType), "<init>", Collections.singletonList(RefType.v("java.lang.String")), VoidType.v(), false), (Value)StringConstant.v(m3)));
        ThrowStmt u3 = Jimple.v().newThrowStmt(l);
        newUnits.add(u1);
        newUnits.add(u2);
        newUnits.add(u3);
        b.getUnits().insertBefore(newUnits, u);
    }

    public static List<String> splitParameters(String parameters) {
        ArrayList<String> pList = new ArrayList<String>();
        boolean object = false;
        String curr = "";
        block5: for (int idx = 0; idx < parameters.length(); ++idx) {
            char c = parameters.charAt(idx);
            curr = curr + c;
            switch (c) {
                case '[': {
                    continue block5;
                }
                case ';': {
                    object = false;
                    pList.add(curr);
                    curr = "";
                    continue block5;
                }
                case 'L': {
                    object = true;
                    continue block5;
                }
                default: {
                    if (object) continue block5;
                    pList.add(curr);
                    curr = "";
                }
            }
        }
        return pList;
    }
}

