/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.dexpler.AbstractNullTransformer;
import soot.dexpler.DexDefUseAnalysis;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LengthExpr;
import soot.jimple.NeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.AbstractInvokeExpr;

public class DexIfTransformer
extends AbstractNullTransformer {
    private boolean usedAsObject;
    private boolean doBreak = false;
    Local l = null;

    public static DexIfTransformer v() {
        return new DexIfTransformer();
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map<String, String> options) {
        DexDefUseAnalysis localDefs = new DexDefUseAnalysis(body);
        Set<IfStmt> ifSet = this.getNullIfCandidates(body);
        for (IfStmt ifs : ifSet) {
            ConditionExpr ifCondition = (ConditionExpr)ifs.getCondition();
            Local[] twoIfLocals = new Local[]{(Local)ifCondition.getOp1(), (Local)ifCondition.getOp2()};
            this.usedAsObject = false;
            for (Local loc : twoIfLocals) {
                Set<Unit> defs = localDefs.collectDefinitionsWithAliases(loc);
                this.doBreak = false;
                for (Unit u : defs) {
                    if (!(u instanceof DefinitionStmt)) {
                        throw new RuntimeException("ERROR: def can not be something else than Assign or Identity statement! (def: " + u + " class: " + u.getClass() + "");
                    }
                    this.l = (Local)((DefinitionStmt)u).getLeftOp();
                    u.apply(new AbstractStmtSwitch(){

                        @Override
                        public void caseAssignStmt(AssignStmt stmt) {
                            Value r = stmt.getRightOp();
                            if (r instanceof FieldRef) {
                                DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(((FieldRef)r).getFieldRef().type());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof ArrayRef) {
                                ArrayRef ar = (ArrayRef)r;
                                if (ar.getType() instanceof UnknownType) {
                                    DexIfTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                } else {
                                    DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(ar.getType());
                                }
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof StringConstant || r instanceof NewExpr || r instanceof NewArrayExpr) {
                                DexIfTransformer.this.usedAsObject = true;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof CastExpr) {
                                DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(((CastExpr)r).getCastType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof InvokeExpr) {
                                DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(((InvokeExpr)r).getType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                            if (r instanceof LengthExpr) {
                                DexIfTransformer.this.usedAsObject = false;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                        }

                        @Override
                        public void caseIdentityStmt(IdentityStmt stmt) {
                            if (stmt.getLeftOp() == DexIfTransformer.this.l) {
                                DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(stmt.getRightOp().getType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                                return;
                            }
                        }
                    });
                    if (this.doBreak) break;
                    for (Unit use : localDefs.getUsesOf(this.l)) {
                        use.apply(new AbstractStmtSwitch(){

                            private boolean examineInvokeExpr(InvokeExpr e) {
                                AbstractInstanceInvokeExpr aiiexpr;
                                Value b;
                                List<Value> args = e.getArgs();
                                List<Type> argTypes = e.getMethodRef().parameterTypes();
                                assert (args.size() == argTypes.size());
                                for (int i = 0; i < args.size(); ++i) {
                                    if (args.get(i) != DexIfTransformer.this.l || !AbstractNullTransformer.isObject(argTypes.get(i))) continue;
                                    return true;
                                }
                                SootMethodRef sm = e.getMethodRef();
                                return !sm.isStatic() && e instanceof AbstractInvokeExpr && (b = (aiiexpr = (AbstractInstanceInvokeExpr)e).getBase()) == DexIfTransformer.this.l;
                            }

                            @Override
                            public void caseInvokeStmt(InvokeStmt stmt) {
                                InvokeExpr e = stmt.getInvokeExpr();
                                DexIfTransformer.this.usedAsObject = this.examineInvokeExpr(e);
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseAssignStmt(AssignStmt stmt) {
                                Value left = stmt.getLeftOp();
                                Value r = stmt.getRightOp();
                                if (left instanceof ArrayRef && ((ArrayRef)left).getIndex() == DexIfTransformer.this.l) {
                                    return;
                                }
                                if (stmt.getRightOp() == DexIfTransformer.this.l) {
                                    Value l = stmt.getLeftOp();
                                    if (l instanceof StaticFieldRef && AbstractNullTransformer.isObject(((StaticFieldRef)l).getFieldRef().type())) {
                                        DexIfTransformer.this.usedAsObject = true;
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                    if (l instanceof InstanceFieldRef && AbstractNullTransformer.isObject(((InstanceFieldRef)l).getFieldRef().type())) {
                                        DexIfTransformer.this.usedAsObject = true;
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                    if (l instanceof ArrayRef) {
                                        Type aType = ((ArrayRef)l).getType();
                                        if (aType instanceof UnknownType) {
                                            DexIfTransformer.this.usedAsObject = stmt.hasTag("ObjectOpTag");
                                        } else {
                                            DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(aType);
                                        }
                                        if (DexIfTransformer.this.usedAsObject) {
                                            DexIfTransformer.this.doBreak = true;
                                        }
                                        return;
                                    }
                                }
                                if (r instanceof FieldRef) {
                                    DexIfTransformer.this.usedAsObject = true;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof ArrayRef) {
                                    ArrayRef ar = (ArrayRef)r;
                                    if (ar.getBase() == DexIfTransformer.this.l) {
                                        DexIfTransformer.this.usedAsObject = true;
                                    } else {
                                        DexIfTransformer.this.usedAsObject = false;
                                    }
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof StringConstant || r instanceof NewExpr) {
                                    throw new RuntimeException("NOT POSSIBLE StringConstant or NewExpr at " + stmt);
                                }
                                if (r instanceof NewArrayExpr) {
                                    DexIfTransformer.this.usedAsObject = false;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof CastExpr) {
                                    DexIfTransformer.this.usedAsObject = AbstractNullTransformer.isObject(((CastExpr)r).getCastType());
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof InvokeExpr) {
                                    DexIfTransformer.this.usedAsObject = this.examineInvokeExpr((InvokeExpr)stmt.getRightOp());
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof LengthExpr) {
                                    DexIfTransformer.this.usedAsObject = true;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                                if (r instanceof BinopExpr) {
                                    DexIfTransformer.this.usedAsObject = false;
                                    if (DexIfTransformer.this.usedAsObject) {
                                        DexIfTransformer.this.doBreak = true;
                                    }
                                    return;
                                }
                            }

                            @Override
                            public void caseIdentityStmt(IdentityStmt stmt) {
                                if (stmt.getLeftOp() == DexIfTransformer.this.l) {
                                    throw new RuntimeException("IMPOSSIBLE 0");
                                }
                            }

                            @Override
                            public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseReturnStmt(ReturnStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l && AbstractNullTransformer.isObject(body.getMethod().getReturnType());
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }

                            @Override
                            public void caseThrowStmt(ThrowStmt stmt) {
                                DexIfTransformer.this.usedAsObject = stmt.getOp() == DexIfTransformer.this.l;
                                if (DexIfTransformer.this.usedAsObject) {
                                    DexIfTransformer.this.doBreak = true;
                                }
                            }
                        });
                        if (!this.doBreak) continue;
                        break;
                    }
                    if (!this.doBreak) continue;
                    break;
                }
                if (this.doBreak) break;
            }
            if (!this.usedAsObject) continue;
            Set<Unit> defsOp1 = localDefs.collectDefinitionsWithAliases(twoIfLocals[0]);
            Set<Unit> defsOp2 = localDefs.collectDefinitionsWithAliases(twoIfLocals[1]);
            defsOp1.addAll(defsOp2);
            for (Unit u : defsOp1) {
                Stmt s2 = (Stmt)u;
                if (!s2.containsArrayRef() || !defsOp1.contains(s2.getArrayRef().getBase()) && !defsOp2.contains(s2.getArrayRef().getBase())) {
                    this.replaceWithNull(u);
                }
                Local l = (Local)((DefinitionStmt)u).getLeftOp();
                for (Unit uuse : localDefs.getUsesOf(l)) {
                    Unit use;
                    use = (Stmt)uuse;
                    if (use.containsArrayRef() && (twoIfLocals[0] == use.getArrayRef().getBase() || twoIfLocals[1] == use.getArrayRef().getBase())) continue;
                    this.replaceWithNull(use);
                }
            }
        }
    }

    private Set<IfStmt> getNullIfCandidates(Body body) {
        HashSet<IfStmt> candidates = new HashSet<IfStmt>();
        for (Unit u : body.getUnits()) {
            if (!(u instanceof IfStmt)) continue;
            ConditionExpr expr = (ConditionExpr)((IfStmt)u).getCondition();
            boolean isTargetIf = false;
            if ((expr instanceof EqExpr || expr instanceof NeExpr) && expr.getOp1() instanceof Local && expr.getOp2() instanceof Local) {
                isTargetIf = true;
            }
            if (!isTargetIf) continue;
            candidates.add((IfStmt)u);
        }
        return candidates;
    }
}

