/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Timers;
import soot.coffi.AnnotationDefault_attribute;
import soot.coffi.BootstrapMethods_attribute;
import soot.coffi.ByteCode;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_InvokeDynamic_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_MethodHandle_info;
import soot.coffi.CONSTANT_Methodref_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_collector;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.Code_attribute;
import soot.coffi.ConstantValue_attribute;
import soot.coffi.Deprecated_attribute;
import soot.coffi.EnclosingMethod_attribute;
import soot.coffi.Exception_attribute;
import soot.coffi.Generic_attribute;
import soot.coffi.InnerClasses_attribute;
import soot.coffi.Instruction;
import soot.coffi.Instruction_Unknown;
import soot.coffi.LineNumberTable_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.LocalVariableTypeTable_attribute;
import soot.coffi.RuntimeInvisibleAnnotations_attribute;
import soot.coffi.RuntimeInvisibleParameterAnnotations_attribute;
import soot.coffi.RuntimeVisibleAnnotations_attribute;
import soot.coffi.RuntimeVisibleParameterAnnotations_attribute;
import soot.coffi.Signature_attribute;
import soot.coffi.SourceFile_attribute;
import soot.coffi.Synthetic_attribute;
import soot.coffi.annotation;
import soot.coffi.annotation_element_value;
import soot.coffi.array_element_value;
import soot.coffi.attribute_info;
import soot.coffi.class_element_value;
import soot.coffi.constant_element_value;
import soot.coffi.cp_info;
import soot.coffi.element_value;
import soot.coffi.enum_constant_element_value;
import soot.coffi.exception_table_entry;
import soot.coffi.field_info;
import soot.coffi.inner_class_entry;
import soot.coffi.line_number_table_entry;
import soot.coffi.local_variable_table_entry;
import soot.coffi.local_variable_type_table_entry;
import soot.coffi.method_info;
import soot.coffi.parameter_annotation;
import soot.options.Options;

public class ClassFile {
    private static final Logger logger = LoggerFactory.getLogger(ClassFile.class);
    static final long MAGIC = 3405691582L;
    static final short ACC_PUBLIC = 1;
    static final short ACC_PRIVATE = 2;
    static final short ACC_PROTECTED = 4;
    static final short ACC_STATIC = 8;
    static final short ACC_FINAL = 16;
    static final short ACC_SUPER = 32;
    static final short ACC_VOLATILE = 64;
    static final short ACC_TRANSIENT = 128;
    static final short ACC_INTERFACE = 512;
    static final short ACC_ABSTRACT = 1024;
    static final short ACC_STRICT = 2048;
    static final short ACC_ANNOTATION = 8192;
    static final short ACC_ENUM = 16384;
    static final short ACC_UNKNOWN = 28672;
    static final String DESC_BYTE = "B";
    static final String DESC_CHAR = "C";
    static final String DESC_DOUBLE = "D";
    static final String DESC_FLOAT = "F";
    static final String DESC_INT = "I";
    static final String DESC_LONG = "J";
    static final String DESC_OBJECT = "L";
    static final String DESC_SHORT = "S";
    static final String DESC_BOOLEAN = "Z";
    static final String DESC_VOID = "V";
    static final String DESC_ARRAY = "[";
    boolean debug;
    String fn;
    long magic;
    int minor_version;
    int major_version;
    public int constant_pool_count;
    public cp_info[] constant_pool;
    public int access_flags;
    public int this_class;
    public int super_class;
    public int interfaces_count;
    public int[] interfaces;
    public int fields_count;
    public field_info[] fields;
    public int methods_count;
    public method_info[] methods;
    public int attributes_count;
    public attribute_info[] attributes;
    public BootstrapMethods_attribute bootstrap_methods_attribute;

    public ClassFile(String nfn) {
        this.fn = nfn;
    }

    public String toString() {
        return this.constant_pool[this.this_class].toString(this.constant_pool);
    }

    public boolean loadClassFile(InputStream is) {
        ByteArrayInputStream f = null;
        InputStream classFileStream = is;
        if (Options.v().time()) {
            Timers.v().readTimer.start();
        }
        try {
            DataInputStream classDataStream = new DataInputStream(classFileStream);
            byte[] data = new byte[classDataStream.available()];
            classDataStream.readFully(data);
            f = new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        if (Options.v().time()) {
            Timers.v().readTimer.end();
        }
        DataInputStream d = new DataInputStream(f);
        boolean b = this.readClass(d);
        try {
            classFileStream.close();
            d.close();
            if (f != null) {
                ((InputStream)f).close();
            }
        }
        catch (IOException e) {
            logger.debug("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    boolean saveClassFile() {
        FileOutputStream f;
        try {
            f = new FileOutputStream(this.fn);
        }
        catch (FileNotFoundException e) {
            if (this.fn.indexOf(".class") >= 0) {
                logger.debug("Can't find " + this.fn);
                return false;
            }
            this.fn = this.fn + ".class";
            try {
                f = new FileOutputStream(this.fn);
            }
            catch (FileNotFoundException ee) {
                logger.debug("Can't find " + this.fn);
                return false;
            }
        }
        DataOutputStream d = new DataOutputStream(f);
        boolean b = this.writeClass(d);
        try {
            d.close();
            f.close();
        }
        catch (IOException e) {
            logger.debug("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return b;
    }

    static String access_string(int af, String separator) {
        boolean hasone = false;
        String s2 = "";
        if ((af & 1) != 0) {
            s2 = "public";
            hasone = true;
        }
        if ((af & 2) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "private";
        }
        if ((af & 4) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "protected";
        }
        if ((af & 8) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "static";
        }
        if ((af & 0x10) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "final";
        }
        if ((af & 0x20) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "super";
        }
        if ((af & 0x40) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "volatile";
        }
        if ((af & 0x80) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "transient";
        }
        if ((af & 0x200) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "interface";
        }
        if ((af & 0x400) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "abstract";
        }
        if ((af & 0x800) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "strict";
        }
        if ((af & 0x2000) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "annotation";
        }
        if ((af & 0x4000) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "enum";
        }
        if ((af & 0x7000) != 0) {
            if (hasone) {
                s2 = s2 + separator;
            } else {
                hasone = true;
            }
            s2 = s2 + "unknown";
        }
        return s2;
    }

    public boolean readClass(DataInputStream d) {
        try {
            this.magic = (long)d.readInt() & 0xFFFFFFFFL;
            if (this.magic != 3405691582L) {
                logger.debug("Wrong magic number in " + this.fn + ": " + this.magic);
                return false;
            }
            this.minor_version = d.readUnsignedShort();
            this.major_version = d.readUnsignedShort();
            this.constant_pool_count = d.readUnsignedShort();
            if (!this.readConstantPool(d)) {
                return false;
            }
            this.access_flags = d.readUnsignedShort();
            this.this_class = d.readUnsignedShort();
            this.super_class = d.readUnsignedShort();
            this.interfaces_count = d.readUnsignedShort();
            if (this.interfaces_count > 0) {
                this.interfaces = new int[this.interfaces_count];
                for (int j = 0; j < this.interfaces_count; ++j) {
                    this.interfaces[j] = d.readUnsignedShort();
                }
            }
            if (Options.v().time()) {
                Timers.v().fieldTimer.start();
            }
            this.fields_count = d.readUnsignedShort();
            this.readFields(d);
            if (Options.v().time()) {
                Timers.v().fieldTimer.end();
            }
            if (Options.v().time()) {
                Timers.v().methodTimer.start();
            }
            this.methods_count = d.readUnsignedShort();
            this.readMethods(d);
            if (Options.v().time()) {
                Timers.v().methodTimer.end();
            }
            if (Options.v().time()) {
                Timers.v().attributeTimer.start();
            }
            this.attributes_count = d.readUnsignedShort();
            if (this.attributes_count > 0) {
                this.attributes = new attribute_info[this.attributes_count];
                this.readAttributes(d, this.attributes_count, this.attributes);
            }
            if (Options.v().time()) {
                Timers.v().attributeTimer.end();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException with " + this.fn + ": " + e.getMessage(), e);
        }
        return true;
    }

    protected boolean readConstantPool(DataInputStream d) throws IOException {
        this.constant_pool = new cp_info[this.constant_pool_count];
        boolean skipone = false;
        for (int i = 1; i < this.constant_pool_count; ++i) {
            cp_info cp;
            if (skipone) {
                skipone = false;
                continue;
            }
            byte tag = (byte)d.readUnsignedByte();
            switch (tag) {
                case 7: {
                    cp = new CONSTANT_Class_info();
                    ((CONSTANT_Class_info)cp).name_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Class");
                    break;
                }
                case 9: {
                    cp = new CONSTANT_Fieldref_info();
                    ((CONSTANT_Fieldref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_Fieldref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Fieldref");
                    break;
                }
                case 10: {
                    cp = new CONSTANT_Methodref_info();
                    ((CONSTANT_Methodref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_Methodref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Methodref");
                    break;
                }
                case 11: {
                    cp = new CONSTANT_InterfaceMethodref_info();
                    ((CONSTANT_InterfaceMethodref_info)cp).class_index = d.readUnsignedShort();
                    ((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: MethodHandle");
                    break;
                }
                case 8: {
                    cp = new CONSTANT_String_info();
                    ((CONSTANT_String_info)cp).string_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: String");
                    break;
                }
                case 3: {
                    cp = new CONSTANT_Integer_info();
                    ((CONSTANT_Integer_info)cp).bytes = d.readInt();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Integer = " + ((CONSTANT_Integer_info)cp).bytes);
                    break;
                }
                case 4: {
                    cp = new CONSTANT_Float_info();
                    ((CONSTANT_Float_info)cp).bytes = d.readInt();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Float = " + ((CONSTANT_Float_info)cp).convert());
                    break;
                }
                case 5: {
                    cp = new CONSTANT_Long_info();
                    ((CONSTANT_Long_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                    ((CONSTANT_Long_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                    if (this.debug) {
                        String temp = cp.toString(this.constant_pool);
                        logger.debug("Constant pool[" + i + "]: Long = " + temp);
                    }
                    skipone = true;
                    break;
                }
                case 6: {
                    cp = new CONSTANT_Double_info();
                    ((CONSTANT_Double_info)cp).high = (long)d.readInt() & 0xFFFFFFFFL;
                    ((CONSTANT_Double_info)cp).low = (long)d.readInt() & 0xFFFFFFFFL;
                    if (this.debug) {
                        logger.debug("Constant pool[" + i + "]: Double = " + ((CONSTANT_Double_info)cp).convert());
                    }
                    skipone = true;
                    break;
                }
                case 12: {
                    cp = new CONSTANT_NameAndType_info();
                    ((CONSTANT_NameAndType_info)cp).name_index = d.readUnsignedShort();
                    ((CONSTANT_NameAndType_info)cp).descriptor_index = d.readUnsignedShort();
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Name and Type");
                    break;
                }
                case 1: {
                    CONSTANT_Utf8_info cputf8 = new CONSTANT_Utf8_info(d);
                    cp = CONSTANT_Utf8_collector.v().add(cputf8);
                    if (!this.debug) break;
                    logger.debug("Constant pool[" + i + "]: Utf8 = \"" + cputf8.convert() + "\"");
                    break;
                }
                case 15: {
                    cp = new CONSTANT_MethodHandle_info();
                    ((CONSTANT_MethodHandle_info)cp).kind = d.readByte();
                    ((CONSTANT_MethodHandle_info)cp).target_index = d.readUnsignedShort();
                    break;
                }
                case 18: {
                    cp = new CONSTANT_InvokeDynamic_info();
                    ((CONSTANT_InvokeDynamic_info)cp).bootstrap_method_index = d.readUnsignedShort();
                    ((CONSTANT_InvokeDynamic_info)cp).name_and_type_index = d.readUnsignedShort();
                    break;
                }
                default: {
                    logger.debug("Unknown tag in constant pool: " + tag + " at entry " + i);
                    return false;
                }
            }
            cp.tag = tag;
            this.constant_pool[i] = cp;
        }
        return true;
    }

    private void readAllBytes(byte[] dest, DataInputStream d) throws IOException {
        int curr_read;
        int total_len = dest.length;
        for (int read_len = 0; read_len < total_len; read_len += curr_read) {
            int to_read = total_len - read_len;
            curr_read = d.read(dest, read_len, to_read);
        }
    }

    protected boolean readAttributes(DataInputStream d, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        for (int i = 0; i < attributes_count; ++i) {
            int k;
            attribute_info ra;
            attribute_info da;
            attribute_info ia;
            attribute_info la;
            attribute_info ea;
            attribute_info ca;
            int j = d.readUnsignedShort();
            long len = (long)d.readInt() & 0xFFFFFFFFL;
            String s2 = ((CONSTANT_Utf8_info)this.constant_pool[j]).convert();
            if (s2.compareTo("SourceFile") == 0) {
                SourceFile_attribute sa = new SourceFile_attribute();
                sa.sourcefile_index = d.readUnsignedShort();
                a = sa;
            } else if (s2.compareTo("ConstantValue") == 0) {
                ca = new ConstantValue_attribute();
                ca.constantvalue_index = d.readUnsignedShort();
                a = ca;
            } else if (s2.compareTo("Code") == 0) {
                ca = new Code_attribute();
                ((Code_attribute)ca).max_stack = d.readUnsignedShort();
                ((Code_attribute)ca).max_locals = d.readUnsignedShort();
                ((Code_attribute)ca).code_length = (long)d.readInt() & 0xFFFFFFFFL;
                ((Code_attribute)ca).code = new byte[(int)((Code_attribute)ca).code_length];
                this.readAllBytes(((Code_attribute)ca).code, d);
                ((Code_attribute)ca).exception_table_length = d.readUnsignedShort();
                ((Code_attribute)ca).exception_table = new exception_table_entry[((Code_attribute)ca).exception_table_length];
                for (int k2 = 0; k2 < ((Code_attribute)ca).exception_table_length; ++k2) {
                    exception_table_entry e = new exception_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.end_pc = d.readUnsignedShort();
                    e.handler_pc = d.readUnsignedShort();
                    e.catch_type = d.readUnsignedShort();
                    ((Code_attribute)ca).exception_table[k2] = e;
                }
                ((Code_attribute)ca).attributes_count = d.readUnsignedShort();
                ((Code_attribute)ca).attributes = new attribute_info[((Code_attribute)ca).attributes_count];
                this.readAttributes(d, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                a = ca;
            } else if (s2.compareTo("Exceptions") == 0) {
                ea = new Exception_attribute();
                ea.number_of_exceptions = d.readUnsignedShort();
                if (ea.number_of_exceptions > 0) {
                    ea.exception_index_table = new int[ea.number_of_exceptions];
                    for (int k3 = 0; k3 < ea.number_of_exceptions; ++k3) {
                        ea.exception_index_table[k3] = d.readUnsignedShort();
                    }
                }
                a = ea;
            } else if (s2.compareTo("LineNumberTable") == 0) {
                la = new LineNumberTable_attribute();
                la.line_number_table_length = d.readUnsignedShort();
                la.line_number_table = new line_number_table_entry[la.line_number_table_length];
                for (int k4 = 0; k4 < la.line_number_table_length; ++k4) {
                    line_number_table_entry e = new line_number_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.line_number = d.readUnsignedShort();
                    la.line_number_table[k4] = e;
                }
                a = la;
            } else if (s2.compareTo("LocalVariableTable") == 0) {
                la = new LocalVariableTable_attribute();
                ((LocalVariableTable_attribute)la).local_variable_table_length = d.readUnsignedShort();
                ((LocalVariableTable_attribute)la).local_variable_table = new local_variable_table_entry[((LocalVariableTable_attribute)la).local_variable_table_length];
                for (int k5 = 0; k5 < ((LocalVariableTable_attribute)la).local_variable_table_length; ++k5) {
                    local_variable_table_entry e = new local_variable_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.length = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.descriptor_index = d.readUnsignedShort();
                    e.index = d.readUnsignedShort();
                    ((LocalVariableTable_attribute)la).local_variable_table[k5] = e;
                }
                a = la;
            } else if (s2.compareTo("LocalVariableTypeTable") == 0) {
                la = new LocalVariableTypeTable_attribute();
                ((LocalVariableTypeTable_attribute)la).local_variable_type_table_length = d.readUnsignedShort();
                ((LocalVariableTypeTable_attribute)la).local_variable_type_table = new local_variable_type_table_entry[((LocalVariableTypeTable_attribute)la).local_variable_type_table_length];
                for (int k6 = 0; k6 < ((LocalVariableTypeTable_attribute)la).local_variable_type_table_length; ++k6) {
                    local_variable_type_table_entry e = new local_variable_type_table_entry();
                    e.start_pc = d.readUnsignedShort();
                    e.length = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.signature_index = d.readUnsignedShort();
                    e.index = d.readUnsignedShort();
                    ((LocalVariableTypeTable_attribute)la).local_variable_type_table[k6] = e;
                }
                a = la;
            } else if (s2.compareTo("Synthetic") == 0) {
                ia = new Synthetic_attribute();
                a = ia;
            } else if (s2.compareTo("Signature") == 0) {
                ia = new Signature_attribute();
                ((Signature_attribute)ia).signature_index = d.readUnsignedShort();
                a = ia;
            } else if (s2.compareTo("Deprecated") == 0) {
                da = new Deprecated_attribute();
                a = da;
            } else if (s2.compareTo("EnclosingMethod") == 0) {
                ea = new EnclosingMethod_attribute();
                ((EnclosingMethod_attribute)ea).class_index = d.readUnsignedShort();
                ((EnclosingMethod_attribute)ea).method_index = d.readUnsignedShort();
                a = ea;
            } else if (s2.compareTo("InnerClasses") == 0) {
                ia = new InnerClasses_attribute();
                ((InnerClasses_attribute)ia).inner_classes_length = d.readUnsignedShort();
                ((InnerClasses_attribute)ia).inner_classes = new inner_class_entry[((InnerClasses_attribute)ia).inner_classes_length];
                for (int k7 = 0; k7 < ((InnerClasses_attribute)ia).inner_classes_length; ++k7) {
                    inner_class_entry e = new inner_class_entry();
                    e.inner_class_index = d.readUnsignedShort();
                    e.outer_class_index = d.readUnsignedShort();
                    e.name_index = d.readUnsignedShort();
                    e.access_flags = d.readUnsignedShort();
                    ((InnerClasses_attribute)ia).inner_classes[k7] = e;
                }
                a = ia;
            } else if (s2.compareTo("RuntimeVisibleAnnotations") == 0) {
                ra = new RuntimeVisibleAnnotations_attribute();
                ra.number_of_annotations = d.readUnsignedShort();
                ra.annotations = new annotation[ra.number_of_annotations];
                for (int k8 = 0; k8 < ra.number_of_annotations; ++k8) {
                    annotation annot = new annotation();
                    annot.type_index = d.readUnsignedShort();
                    annot.num_element_value_pairs = d.readUnsignedShort();
                    annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                    ra.annotations[k8] = annot;
                }
                a = ra;
            } else if (s2.compareTo("RuntimeInvisibleAnnotations") == 0) {
                ra = new RuntimeInvisibleAnnotations_attribute();
                ((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations = d.readUnsignedShort();
                ((RuntimeInvisibleAnnotations_attribute)ra).annotations = new annotation[((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations];
                for (int k9 = 0; k9 < ((RuntimeInvisibleAnnotations_attribute)ra).number_of_annotations; ++k9) {
                    annotation annot = new annotation();
                    annot.type_index = d.readUnsignedShort();
                    annot.num_element_value_pairs = d.readUnsignedShort();
                    annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                    ((RuntimeInvisibleAnnotations_attribute)ra).annotations[k9] = annot;
                }
                a = ra;
            } else if (s2.compareTo("RuntimeVisibleParameterAnnotations") == 0) {
                ra = new RuntimeVisibleParameterAnnotations_attribute();
                ((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters = d.readUnsignedByte();
                ((RuntimeVisibleParameterAnnotations_attribute)ra).parameter_annotations = new parameter_annotation[((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters];
                for (int x = 0; x < ((RuntimeVisibleParameterAnnotations_attribute)ra).num_parameters; ++x) {
                    parameter_annotation pAnnot = new parameter_annotation();
                    pAnnot.num_annotations = d.readUnsignedShort();
                    pAnnot.annotations = new annotation[pAnnot.num_annotations];
                    for (k = 0; k < pAnnot.num_annotations; ++k) {
                        annotation annot = new annotation();
                        annot.type_index = d.readUnsignedShort();
                        annot.num_element_value_pairs = d.readUnsignedShort();
                        annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                        pAnnot.annotations[k] = annot;
                    }
                    ((RuntimeVisibleParameterAnnotations_attribute)ra).parameter_annotations[x] = pAnnot;
                }
                a = ra;
            } else if (s2.compareTo("RuntimeInvisibleParameterAnnotations") == 0) {
                ra = new RuntimeInvisibleParameterAnnotations_attribute();
                ((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters = d.readUnsignedByte();
                ((RuntimeInvisibleParameterAnnotations_attribute)ra).parameter_annotations = new parameter_annotation[((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters];
                for (int x = 0; x < ((RuntimeInvisibleParameterAnnotations_attribute)ra).num_parameters; ++x) {
                    parameter_annotation pAnnot = new parameter_annotation();
                    pAnnot.num_annotations = d.readUnsignedShort();
                    pAnnot.annotations = new annotation[pAnnot.num_annotations];
                    for (k = 0; k < pAnnot.num_annotations; ++k) {
                        annotation annot = new annotation();
                        annot.type_index = d.readUnsignedShort();
                        annot.num_element_value_pairs = d.readUnsignedShort();
                        annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                        pAnnot.annotations[k] = annot;
                    }
                    ((RuntimeInvisibleParameterAnnotations_attribute)ra).parameter_annotations[x] = pAnnot;
                }
                a = ra;
            } else if (s2.compareTo("AnnotationDefault") == 0) {
                da = new AnnotationDefault_attribute();
                element_value[] result = this.readElementValues(1, d, false, 0);
                ((AnnotationDefault_attribute)da).default_value = result[0];
                a = da;
            } else if (s2.equals("BootstrapMethods")) {
                BootstrapMethods_attribute bsma = new BootstrapMethods_attribute();
                int count = d.readUnsignedShort();
                bsma.method_handles = new short[count];
                bsma.arg_indices = new short[count][];
                for (int num = 0; num < count; ++num) {
                    short index;
                    bsma.method_handles[num] = index = (short)d.readUnsignedShort();
                    int argCount = d.readUnsignedShort();
                    bsma.arg_indices[num] = new short[argCount];
                    for (int numArg = 0; numArg < argCount; ++numArg) {
                        short indexArg;
                        bsma.arg_indices[num][numArg] = indexArg = (short)d.readUnsignedShort();
                    }
                }
                assert (this.bootstrap_methods_attribute == null) : "More than one bootstrap methods attribute!";
                this.bootstrap_methods_attribute = bsma;
                a = this.bootstrap_methods_attribute;
            } else {
                Generic_attribute ga = new Generic_attribute();
                if (len > 0L) {
                    ga.info = new byte[(int)len];
                    this.readAllBytes(ga.info, d);
                }
                a = ga;
            }
            a.attribute_name = j;
            a.attribute_length = len;
            ai[i] = a;
        }
        return true;
    }

    private element_value[] readElementValues(int count, DataInputStream d, boolean needName, int name_index) throws IOException {
        element_value[] list = new element_value[count];
        for (int x = 0; x < count; ++x) {
            element_value elem;
            int tag;
            char kind;
            if (needName) {
                name_index = d.readUnsignedShort();
            }
            if ((kind = (char)(tag = d.readUnsignedByte())) == 'B' || kind == 'C' || kind == 'D' || kind == 'F' || kind == 'I' || kind == 'J' || kind == 'S' || kind == 'Z' || kind == 's') {
                elem = new constant_element_value();
                elem.name_index = name_index;
                elem.tag = kind;
                elem.constant_value_index = d.readUnsignedShort();
                list[x] = elem;
                continue;
            }
            if (kind == 'e') {
                elem = new enum_constant_element_value();
                ((enum_constant_element_value)elem).name_index = name_index;
                ((enum_constant_element_value)elem).tag = kind;
                ((enum_constant_element_value)elem).type_name_index = d.readUnsignedShort();
                ((enum_constant_element_value)elem).constant_name_index = d.readUnsignedShort();
                list[x] = elem;
                continue;
            }
            if (kind == 'c') {
                elem = new class_element_value();
                ((class_element_value)elem).name_index = name_index;
                ((class_element_value)elem).tag = kind;
                ((class_element_value)elem).class_info_index = d.readUnsignedShort();
                list[x] = elem;
                continue;
            }
            if (kind == '[') {
                elem = new array_element_value();
                ((array_element_value)elem).name_index = name_index;
                ((array_element_value)elem).tag = kind;
                ((array_element_value)elem).num_values = d.readUnsignedShort();
                ((array_element_value)elem).values = this.readElementValues(((array_element_value)elem).num_values, d, false, name_index);
                list[x] = elem;
                continue;
            }
            if (kind == '@') {
                elem = new annotation_element_value();
                ((annotation_element_value)elem).name_index = name_index;
                ((annotation_element_value)elem).tag = kind;
                annotation annot = new annotation();
                annot.type_index = d.readUnsignedShort();
                annot.num_element_value_pairs = d.readUnsignedShort();
                annot.element_value_pairs = this.readElementValues(annot.num_element_value_pairs, d, true, 0);
                ((annotation_element_value)elem).annotation_value = annot;
                list[x] = elem;
                continue;
            }
            throw new RuntimeException("Unknown element value pair kind: " + kind);
        }
        return list;
    }

    protected boolean readFields(DataInputStream d) throws IOException {
        this.fields = new field_info[this.fields_count];
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = new field_info();
            fi.access_flags = d.readUnsignedShort();
            fi.name_index = d.readUnsignedShort();
            fi.descriptor_index = d.readUnsignedShort();
            fi.attributes_count = d.readUnsignedShort();
            if (fi.attributes_count > 0) {
                fi.attributes = new attribute_info[fi.attributes_count];
                this.readAttributes(d, fi.attributes_count, fi.attributes);
            }
            this.fields[i] = fi;
        }
        return true;
    }

    protected boolean readMethods(DataInputStream d) throws IOException {
        this.methods = new method_info[this.methods_count];
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = new method_info();
            mi.access_flags = d.readUnsignedShort();
            mi.name_index = d.readUnsignedShort();
            mi.descriptor_index = d.readUnsignedShort();
            mi.attributes_count = d.readUnsignedShort();
            if (mi.attributes_count > 0) {
                mi.attributes = new attribute_info[mi.attributes_count];
                this.readAttributes(d, mi.attributes_count, mi.attributes);
                for (int j = 0; j < mi.attributes_count; ++j) {
                    if (!(mi.attributes[j] instanceof Code_attribute)) continue;
                    mi.code_attr = (Code_attribute)mi.attributes[j];
                    break;
                }
            }
            this.methods[i] = mi;
        }
        return true;
    }

    protected boolean writeConstantPool(DataOutputStream dd) throws IOException {
        boolean skipone = false;
        block13: for (int i = 1; i < this.constant_pool_count; ++i) {
            if (skipone) {
                skipone = false;
                continue;
            }
            cp_info cp = this.constant_pool[i];
            dd.writeByte(cp.tag);
            switch (cp.tag) {
                case 7: {
                    dd.writeShort(((CONSTANT_Class_info)cp).name_index);
                    continue block13;
                }
                case 9: {
                    dd.writeShort(((CONSTANT_Fieldref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_Fieldref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 10: {
                    dd.writeShort(((CONSTANT_Methodref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_Methodref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 11: {
                    dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).class_index);
                    dd.writeShort(((CONSTANT_InterfaceMethodref_info)cp).name_and_type_index);
                    continue block13;
                }
                case 8: {
                    dd.writeShort(((CONSTANT_String_info)cp).string_index);
                    continue block13;
                }
                case 3: {
                    dd.writeInt((int)((CONSTANT_Integer_info)cp).bytes);
                    continue block13;
                }
                case 4: {
                    dd.writeInt((int)((CONSTANT_Float_info)cp).bytes);
                    continue block13;
                }
                case 5: {
                    dd.writeInt((int)((CONSTANT_Long_info)cp).high);
                    dd.writeInt((int)((CONSTANT_Long_info)cp).low);
                    skipone = true;
                    continue block13;
                }
                case 6: {
                    dd.writeInt((int)((CONSTANT_Double_info)cp).high);
                    dd.writeInt((int)((CONSTANT_Double_info)cp).low);
                    skipone = true;
                    continue block13;
                }
                case 12: {
                    dd.writeShort(((CONSTANT_NameAndType_info)cp).name_index);
                    dd.writeShort(((CONSTANT_NameAndType_info)cp).descriptor_index);
                    continue block13;
                }
                case 1: {
                    ((CONSTANT_Utf8_info)cp).writeBytes(dd);
                    continue block13;
                }
                default: {
                    logger.debug("Unknown tag in constant pool: " + cp.tag);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean writeAttributes(DataOutputStream dd, int attributes_count, attribute_info[] ai) throws IOException {
        attribute_info a = null;
        for (int i = 0; i < attributes_count; ++i) {
            attribute_info la;
            Object e;
            int k;
            attribute_info ca;
            a = ai[i];
            dd.writeShort(a.attribute_name);
            dd.writeInt((int)a.attribute_length);
            if (a instanceof SourceFile_attribute) {
                SourceFile_attribute sa = (SourceFile_attribute)a;
                dd.writeShort(sa.sourcefile_index);
                continue;
            }
            if (a instanceof ConstantValue_attribute) {
                ca = (ConstantValue_attribute)a;
                dd.writeShort(ca.constantvalue_index);
                continue;
            }
            if (a instanceof Code_attribute) {
                ca = (Code_attribute)a;
                dd.writeShort(((Code_attribute)ca).max_stack);
                dd.writeShort(((Code_attribute)ca).max_locals);
                dd.writeInt((int)((Code_attribute)ca).code_length);
                dd.write(((Code_attribute)ca).code, 0, (int)((Code_attribute)ca).code_length);
                dd.writeShort(((Code_attribute)ca).exception_table_length);
                for (k = 0; k < ((Code_attribute)ca).exception_table_length; ++k) {
                    e = ((Code_attribute)ca).exception_table[k];
                    dd.writeShort(((exception_table_entry)e).start_pc);
                    dd.writeShort(((exception_table_entry)e).end_pc);
                    dd.writeShort(((exception_table_entry)e).handler_pc);
                    dd.writeShort(((exception_table_entry)e).catch_type);
                }
                dd.writeShort(((Code_attribute)ca).attributes_count);
                if (((Code_attribute)ca).attributes_count <= 0) continue;
                this.writeAttributes(dd, ((Code_attribute)ca).attributes_count, ((Code_attribute)ca).attributes);
                continue;
            }
            if (a instanceof Exception_attribute) {
                Exception_attribute ea = (Exception_attribute)a;
                dd.writeShort(ea.number_of_exceptions);
                if (ea.number_of_exceptions <= 0) continue;
                for (k = 0; k < ea.number_of_exceptions; ++k) {
                    dd.writeShort(ea.exception_index_table[k]);
                }
                continue;
            }
            if (a instanceof LineNumberTable_attribute) {
                la = (LineNumberTable_attribute)a;
                dd.writeShort(la.line_number_table_length);
                for (k = 0; k < la.line_number_table_length; ++k) {
                    e = la.line_number_table[k];
                    dd.writeShort(((line_number_table_entry)e).start_pc);
                    dd.writeShort(((line_number_table_entry)e).line_number);
                }
                continue;
            }
            if (a instanceof LocalVariableTable_attribute) {
                la = (LocalVariableTable_attribute)a;
                dd.writeShort(((LocalVariableTable_attribute)la).local_variable_table_length);
                for (k = 0; k < ((LocalVariableTable_attribute)la).local_variable_table_length; ++k) {
                    e = ((LocalVariableTable_attribute)la).local_variable_table[k];
                    dd.writeShort(((local_variable_table_entry)e).start_pc);
                    dd.writeShort(((local_variable_table_entry)e).length);
                    dd.writeShort(((local_variable_table_entry)e).name_index);
                    dd.writeShort(((local_variable_table_entry)e).descriptor_index);
                    dd.writeShort(((local_variable_table_entry)e).index);
                }
                continue;
            }
            logger.debug("Generic/Unknown Attribute in output");
            Generic_attribute ga = (Generic_attribute)a;
            if (ga.attribute_length <= 0L) continue;
            dd.write(ga.info, 0, (int)ga.attribute_length);
        }
        return true;
    }

    protected boolean writeFields(DataOutputStream dd) throws IOException {
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = this.fields[i];
            dd.writeShort(fi.access_flags);
            dd.writeShort(fi.name_index);
            dd.writeShort(fi.descriptor_index);
            dd.writeShort(fi.attributes_count);
            if (fi.attributes_count <= 0) continue;
            this.writeAttributes(dd, fi.attributes_count, fi.attributes);
        }
        return true;
    }

    protected boolean writeMethods(DataOutputStream dd) throws IOException {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            dd.writeShort(mi.access_flags);
            dd.writeShort(mi.name_index);
            dd.writeShort(mi.descriptor_index);
            dd.writeShort(mi.attributes_count);
            if (mi.attributes_count <= 0) continue;
            this.writeAttributes(dd, mi.attributes_count, mi.attributes);
        }
        return true;
    }

    boolean writeClass(DataOutputStream dd) {
        try {
            dd.writeInt((int)this.magic);
            dd.writeShort(this.minor_version);
            dd.writeShort(this.major_version);
            dd.writeShort(this.constant_pool_count);
            if (!this.writeConstantPool(dd)) {
                return false;
            }
            dd.writeShort(this.access_flags);
            dd.writeShort(this.this_class);
            dd.writeShort(this.super_class);
            dd.writeShort(this.interfaces_count);
            if (this.interfaces_count > 0) {
                for (int j = 0; j < this.interfaces_count; ++j) {
                    dd.writeShort(this.interfaces[j]);
                }
            }
            dd.writeShort(this.fields_count);
            this.writeFields(dd);
            dd.writeShort(this.methods_count);
            this.writeMethods(dd);
            dd.writeShort(this.attributes_count);
            if (this.attributes_count > 0) {
                this.writeAttributes(dd, this.attributes_count, this.attributes);
            }
        }
        catch (IOException e) {
            logger.debug("IOException with " + this.fn + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    public Instruction parseMethod(method_info m3) {
        Instruction head = null;
        Instruction tail = null;
        ByteCode bc = new ByteCode();
        Code_attribute ca = m3.locate_code_attribute();
        if (ca == null) {
            return null;
        }
        int j = 0;
        while ((long)j < ca.code_length) {
            Instruction inst = bc.disassemble_bytecode(ca.code, j);
            inst.originalIndex = j;
            if (inst instanceof Instruction_Unknown) {
                logger.debug("Unknown instruction in \"" + m3.toName(this.constant_pool) + "\" at offset " + j);
                logger.debug(" bytecode = " + (inst.code & 0xFF));
            }
            j = inst.nextOffset(j);
            if (head == null) {
                head = inst;
            } else {
                tail.next = inst;
                inst.prev = tail;
            }
            tail = inst;
        }
        bc.build(head);
        for (j = 0; j < ca.exception_table_length; ++j) {
            exception_table_entry e = ca.exception_table[j];
            e.start_inst = bc.locateInst(e.start_pc);
            e.end_inst = (long)e.end_pc == ca.code_length ? null : bc.locateInst(e.end_pc);
            e.handler_inst = bc.locateInst(e.handler_pc);
            if (e.handler_inst == null) continue;
            e.handler_inst.labelled = true;
        }
        m3.instructions = head;
        for (attribute_info element : ca.attributes) {
            if (!(element instanceof LineNumberTable_attribute)) continue;
            LineNumberTable_attribute lntattr = (LineNumberTable_attribute)element;
            for (line_number_table_entry element0 : lntattr.line_number_table) {
                element0.start_inst = bc.locateInst(element0.start_pc);
            }
        }
        return head;
    }

    public void parse() {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            mi.instructions = this.parseMethod(mi);
        }
    }

    int relabel(Instruction i) {
        int index = 0;
        while (i != null) {
            i.label = index;
            index = i.nextOffset(index);
            i = i.next;
        }
        return index;
    }

    byte[] unparseMethod(method_info m3) {
        m3.cfg.reconstructInstructions();
        int codesize = this.relabel(m3.instructions);
        byte[] bc = new byte[codesize];
        Instruction i = m3.instructions;
        codesize = 0;
        while (i != null) {
            codesize = i.compile(bc, codesize);
            i = i.next;
        }
        if (codesize != bc.length) {
            logger.warn("code size doesn't match array length!");
        }
        return bc;
    }

    void unparse() {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info mi = this.methods[i];
            Code_attribute ca = mi.locate_code_attribute();
            if (ca == null) continue;
            byte[] bc = this.unparseMethod(mi);
            if (bc == null) {
                logger.debug("Recompile of " + mi.toName(this.constant_pool) + " failed!");
                continue;
            }
            ca.code_length = bc.length;
            ca.code = bc;
            for (int j = 0; j < ca.exception_table_length; ++j) {
                exception_table_entry e = ca.exception_table[j];
                e.start_pc = e.start_inst.label;
                e.end_pc = e.end_inst != null ? e.end_inst.label : (int)ca.code_length;
                e.handler_pc = e.handler_inst.label;
            }
        }
    }

    static String parseMethodDesc_return(String s2) {
        int j = s2.lastIndexOf(41);
        if (j >= 0) {
            return ClassFile.parseDesc(s2.substring(j + 1), ",");
        }
        return ClassFile.parseDesc(s2, ",");
    }

    static String parseMethodDesc_params(String s2) {
        int j;
        int i = s2.indexOf(40);
        if (i >= 0 && (j = s2.indexOf(41, i + 1)) >= 0) {
            return ClassFile.parseDesc(s2.substring(i + 1, j), ",");
        }
        return "<parse error>";
    }

    static String parseDesc(String desc, String sep) {
        String params = "";
        int arraylevel = 0;
        boolean didone = false;
        int len = desc.length();
        for (int i = 0; i < len; ++i) {
            String param;
            char c = desc.charAt(i);
            if (c == DESC_BYTE.charAt(0)) {
                param = "byte";
            } else if (c == DESC_CHAR.charAt(0)) {
                param = "char";
            } else if (c == DESC_DOUBLE.charAt(0)) {
                param = "double";
            } else if (c == DESC_FLOAT.charAt(0)) {
                param = "float";
            } else if (c == DESC_INT.charAt(0)) {
                param = "int";
            } else if (c == DESC_LONG.charAt(0)) {
                param = "long";
            } else if (c == DESC_SHORT.charAt(0)) {
                param = "short";
            } else if (c == DESC_BOOLEAN.charAt(0)) {
                param = "boolean";
            } else if (c == DESC_VOID.charAt(0)) {
                param = "void";
            } else {
                if (c == DESC_ARRAY.charAt(0)) {
                    ++arraylevel;
                    continue;
                }
                if (c == DESC_OBJECT.charAt(0)) {
                    int j = desc.indexOf(59, i + 1);
                    if (j < 0) {
                        logger.warn("Parse error -- can't find a ; in " + desc.substring(i + 1));
                        param = "<error>";
                    } else {
                        if (j - i > 10 && desc.substring(i + 1, i + 11).compareTo("java/lang/") == 0) {
                            i += 10;
                        }
                        param = desc.substring(i + 1, j);
                        param = param.replace('/', '.');
                        i = j;
                    }
                } else {
                    param = "???";
                }
            }
            if (didone) {
                params = params + sep;
            }
            params = params + param;
            while (arraylevel > 0) {
                params = params + "[]";
                --arraylevel;
            }
            didone = true;
        }
        return params;
    }

    method_info findMethod(String s2) {
        for (int i = 0; i < this.methods_count; ++i) {
            method_info m3 = this.methods[i];
            if (!s2.equals(m3.toName(this.constant_pool))) continue;
            return m3;
        }
        return null;
    }

    void listMethods() {
        for (int i = 0; i < this.methods_count; ++i) {
            logger.debug("" + this.methods[i].prototype(this.constant_pool));
        }
    }

    void listConstantPool() {
        for (int i = 1; i < this.constant_pool_count; ++i) {
            cp_info c = this.constant_pool[i];
            logger.debug(DESC_ARRAY + i + "] " + c.typeName() + "=" + c.toString(this.constant_pool));
            if (this.constant_pool[i].tag != 5 && this.constant_pool[i].tag != 6) continue;
            ++i;
        }
    }

    void listFields() {
        for (int i = 0; i < this.fields_count; ++i) {
            field_info fi = this.fields[i];
            logger.debug("" + fi.prototype(this.constant_pool));
            for (int j = 0; j < fi.attributes_count; ++j) {
                CONSTANT_Utf8_info cm = (CONSTANT_Utf8_info)this.constant_pool[fi.attributes[j].attribute_name];
                if (cm.convert().compareTo("ConstantValue") != 0) continue;
                ConstantValue_attribute cva = (ConstantValue_attribute)fi.attributes[j];
                logger.debug(" = " + this.constant_pool[cva.constantvalue_index].toString(this.constant_pool));
                break;
            }
            logger.debug(";");
        }
    }

    void moveMethod(String m3, int pos) {
        logger.debug("Moving " + m3 + " to position " + pos + " of " + this.methods_count);
        for (int i = 0; i < this.methods_count; ++i) {
            if (m3.compareTo(this.methods[i].toName(this.constant_pool)) != 0) continue;
            method_info mthd = this.methods[i];
            if (i > pos) {
                for (int j = i; j > pos && j > 0; --j) {
                    this.methods[j] = this.methods[j - 1];
                }
                this.methods[pos] = mthd;
            } else if (i < pos) {
                for (int j = i; j < pos && j < this.methods_count - 1; ++j) {
                    this.methods[j] = this.methods[j + 1];
                }
                this.methods[pos] = mthd;
            }
            return;
        }
    }

    boolean descendsFrom(ClassFile cf) {
        return this.descendsFrom(cf.toString());
    }

    boolean descendsFrom(String cname) {
        cp_info cf = this.constant_pool[this.super_class];
        if (cf.toString(this.constant_pool).compareTo(cname) == 0) {
            return true;
        }
        for (int i = 0; i < this.interfaces_count; ++i) {
            cf = this.constant_pool[this.interfaces[i]];
            if (cf.toString(this.constant_pool).compareTo(cname) != 0) continue;
            return true;
        }
        return false;
    }

    boolean isSterile() {
        return (this.access_flags & 1) == 0 || (this.access_flags & 0x10) != 0;
    }

    boolean sameClass(String cfn) {
        String s2 = cfn;
        int i = s2.lastIndexOf(".class");
        if (i > 0) {
            s2 = s2.substring(0, i);
        }
        return s2.compareTo(this.toString()) == 0;
    }

    String fieldName(int i) {
        return this.fields[i].toName(this.constant_pool);
    }
}

