/*
 * Decompiled with CFR 0.152.
 */
package soot.baf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.DoubleType;
import soot.Local;
import soot.LongType;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnknownType;
import soot.baf.Baf;
import soot.baf.DoubleWordType;
import soot.baf.PlaceholderInst;
import soot.baf.WordType;
import soot.baf.internal.BafLocal;
import soot.jimple.ConvertToBaf;
import soot.jimple.JimpleBody;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.options.Options;

public class BafBody
extends Body {
    private static final Logger logger = LoggerFactory.getLogger(BafBody.class);
    private JimpleToBafContext jimpleToBafContext;

    public JimpleToBafContext getContext() {
        return this.jimpleToBafContext;
    }

    @Override
    public Object clone() {
        BafBody b = new BafBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    BafBody(SootMethod m3) {
        super(m3);
    }

    public BafBody(JimpleBody body, Map<String, String> options) {
        super(body.getMethod());
        JimpleToBafContext context;
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing BafBody...");
        }
        JimpleBody jimpleBody = body;
        this.jimpleToBafContext = context = new JimpleToBafContext(jimpleBody.getLocalCount());
        for (Local l : jimpleBody.getLocals()) {
            Type t = l.getType();
            Local newLocal = Baf.v().newLocal(l.getName(), UnknownType.v());
            if (t.equals(DoubleType.v()) || t.equals(LongType.v())) {
                newLocal.setType(DoubleWordType.v());
            } else {
                newLocal.setType(WordType.v());
            }
            context.setBafLocalOfJimpleLocal(l, newLocal);
            ((BafLocal)newLocal).setOriginalLocal(l);
            this.getLocals().add(newLocal);
        }
        HashMap stmtToFirstInstruction = new HashMap();
        for (Unit u : jimpleBody.getUnits()) {
            Stmt s2 = (Stmt)u;
            ArrayList<Unit> conversionList = new ArrayList<Unit>();
            context.setCurrentUnit(s2);
            ((ConvertToBaf)((Object)s2)).convertToBaf(context, conversionList);
            stmtToFirstInstruction.put(s2, conversionList.get(0));
            this.getUnits().addAll(conversionList);
        }
        for (UnitBox box : this.getAllUnitBoxes()) {
            if (!(box.getUnit() instanceof PlaceholderInst)) continue;
            Unit source = ((PlaceholderInst)box.getUnit()).getSource();
            box.setUnit((Unit)stmtToFirstInstruction.get(source));
        }
        for (Trap trap : jimpleBody.getTraps()) {
            this.getTraps().add(Baf.v().newTrap(trap.getException(), (Unit)stmtToFirstInstruction.get(trap.getBeginUnit()), (Unit)stmtToFirstInstruction.get(trap.getEndUnit()), (Unit)stmtToFirstInstruction.get(trap.getHandlerUnit())));
        }
        PackManager.v().getPack("bb").apply(this);
    }
}

