/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LambdaMetaFactory;
import soot.Local;
import soot.LongType;
import soot.MethodSource;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.PackManager;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.asm.AsmUtil;
import soot.asm.CastAndReturnInliner;
import soot.asm.Operand;
import soot.asm.StackFrame;
import soot.asm.UnitContainer;
import soot.coffi.Util;
import soot.jimple.AddExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.ConditionExpr;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.Expr;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MethodHandle;
import soot.jimple.MethodType;
import soot.jimple.MonitorStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.StringConstant;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.options.Options;
import soot.tagkit.LineNumberTag;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.Numberable;

final class AsmMethodSource
implements MethodSource {
    private static final Logger logger = LoggerFactory.getLogger(AsmMethodSource.class);
    private static final Operand DWORD_DUMMY = new Operand(null, null);
    private final String module;
    private static final String METAFACTORY_SIGNATURE = "<java.lang.invoke.LambdaMetafactory: java.lang.invoke.CallSite metafactory(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType,java.lang.invoke.MethodType,java.lang.invoke.MethodHandle,java.lang.invoke.MethodType)>";
    private static final String ALT_METAFACTORY_SIGNATURE = "<java.lang.invoke.LambdaMetafactory: java.lang.invoke.CallSite altMetafactory(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType,java.lang.Object[])>";
    private final int maxLocals;
    private final InsnList instructions;
    private final List<LocalVariableNode> localVars;
    private final List<TryCatchBlockNode> tryCatchBlocks;
    private final Set<LabelNode> inlineExceptionLabels = new LinkedHashSet<LabelNode>();
    private final Map<LabelNode, Unit> inlineExceptionHandlers = new LinkedHashMap<LabelNode, Unit>();
    private final CastAndReturnInliner castAndReturnInliner = new CastAndReturnInliner();
    private int nextLocal;
    private Map<Integer, Local> locals;
    private Multimap<LabelNode, UnitBox> labels;
    private Map<AbstractInsnNode, Unit> units;
    private ArrayList<Operand> stack;
    private Map<AbstractInsnNode, StackFrame> frames;
    private Multimap<LabelNode, UnitBox> trapHandlers;
    private JimpleBody body;
    private int lastLineNumber = -1;
    private Table<AbstractInsnNode, AbstractInsnNode, Edge> edges;
    private ArrayDeque<Edge> conversionWorklist;

    AsmMethodSource(int maxLocals, InsnList insns, List<LocalVariableNode> localVars, List<TryCatchBlockNode> tryCatchBlocks, String module) {
        this.maxLocals = maxLocals;
        this.instructions = insns;
        this.localVars = localVars;
        this.tryCatchBlocks = tryCatchBlocks;
        this.module = module;
    }

    private StackFrame getFrame(AbstractInsnNode insn) {
        StackFrame frame = this.frames.get(insn);
        if (frame == null) {
            frame = new StackFrame(this);
            this.frames.put(insn, frame);
        }
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SootClass getClassFromScene(String className) {
        SootClass result = ModuleUtil.module_mode() ? ModuleScene.v().getSootClassUnsafe(className, Optional.fromNullable(this.module)) : Scene.v().getSootClassUnsafe(className);
        if (result == null) {
            String msg = String.format("%s was not found on classpath.", className);
            if (Options.v().allow_phantom_refs()) {
                RefType ref;
                RefType refType = ref = RefType.v(className);
                synchronized (refType) {
                    logger.warn(msg);
                    result = Scene.v().makeSootClass(className, 1);
                    Scene.v().addClass(result);
                    result.setPhantomClass();
                    return ref.getSootClass();
                }
            }
            throw new RuntimeException(msg);
        }
        return result;
    }

    private Local getLocal(int idx) {
        if (idx >= this.maxLocals) {
            throw new IllegalArgumentException("Invalid local index: " + idx);
        }
        Integer i = idx;
        Local l = this.locals.get(i);
        if (l == null) {
            String name;
            if (this.localVars != null) {
                name = null;
                for (LocalVariableNode lvn : this.localVars) {
                    if (lvn.index != idx) continue;
                    name = lvn.name;
                    break;
                }
                if (name == null) {
                    name = "l" + idx;
                }
            } else {
                name = "l" + idx;
            }
            l = Jimple.v().newLocal(name, UnknownType.v());
            this.locals.put(i, l);
        }
        return l;
    }

    private void push(Operand opr) {
        this.stack.add(opr);
    }

    private void pushDual(Operand opr) {
        this.stack.add(DWORD_DUMMY);
        this.stack.add(opr);
    }

    private Operand peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void push(Type t, Operand opr) {
        if (AsmUtil.isDWord(t)) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private Operand pop() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Stack underrun");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    private Operand popDual() {
        Operand o = this.pop();
        Operand o2 = this.pop();
        if (o2 != DWORD_DUMMY && o2 != o) {
            throw new AssertionError((Object)("Not dummy operand, " + o2.value + " -- " + o.value));
        }
        return o;
    }

    private Operand pop(Type t) {
        return AsmUtil.isDWord(t) ? this.popDual() : this.pop();
    }

    private Operand popLocal(Operand o) {
        Value v = o.value;
        Local l = o.stack;
        if (l == null && !(v instanceof Local)) {
            l = o.stack = this.newStackLocal();
            this.setUnit(o.insn, Jimple.v().newAssignStmt(l, v));
            o.updateBoxes();
        }
        return o;
    }

    private Operand popImmediate(Operand o) {
        Value v = o.value;
        Local l = o.stack;
        if (l == null && !(v instanceof Local) && !(v instanceof Constant)) {
            l = o.stack = this.newStackLocal();
            this.setUnit(o.insn, Jimple.v().newAssignStmt(l, v));
            o.updateBoxes();
        }
        return o;
    }

    private Operand popStackConst(Operand o) {
        Value v = o.value;
        Local l = o.stack;
        if (l == null && !(v instanceof Constant)) {
            l = o.stack = this.newStackLocal();
            this.setUnit(o.insn, Jimple.v().newAssignStmt(l, v));
            o.updateBoxes();
        }
        return o;
    }

    private Operand popLocal() {
        return this.popLocal(this.pop());
    }

    private Operand popLocalDual() {
        return this.popLocal(this.popDual());
    }

    private Operand popLocal(Type t) {
        return AsmUtil.isDWord(t) ? this.popLocalDual() : this.popLocal();
    }

    private Operand popImmediate() {
        return this.popImmediate(this.pop());
    }

    private Operand popImmediateDual() {
        return this.popImmediate(this.popDual());
    }

    private Operand popImmediate(Type t) {
        return AsmUtil.isDWord(t) ? this.popImmediateDual() : this.popImmediate();
    }

    private Operand popStackConst() {
        return this.popStackConst(this.pop());
    }

    private Operand popStackConstDual() {
        return this.popStackConst(this.popDual());
    }

    private Operand popStackConst(Type t) {
        return AsmUtil.isDWord(t) ? this.popStackConstDual() : this.popStackConst();
    }

    void setUnit(AbstractInsnNode insn, Unit u) {
        Unit o;
        if (Options.v().keep_line_number() && this.lastLineNumber >= 0) {
            Tag lineTag = u.getTag("LineNumberTag");
            if (lineTag == null) {
                lineTag = new LineNumberTag(this.lastLineNumber);
                u.addTag(lineTag);
            } else if (((LineNumberTag)lineTag).getLineNumber() != this.lastLineNumber) {
                throw new RuntimeException("Line tag mismatch");
            }
        }
        if ((o = this.units.put(insn, u)) != null) {
            throw new AssertionError((Object)(insn.getOpcode() + " already has a unit, " + o));
        }
    }

    void mergeUnits(AbstractInsnNode insn, Unit u) {
        Unit prev = this.units.put(insn, u);
        if (prev != null) {
            UnitContainer merged = new UnitContainer(prev, u);
            this.units.put(insn, merged);
        }
    }

    Local newStackLocal() {
        Integer idx = this.nextLocal++;
        Local l = Jimple.v().newLocal("$stack" + idx, UnknownType.v());
        this.locals.put(idx, l);
        return l;
    }

    <A extends Unit> A getUnit(AbstractInsnNode insn) {
        return (A)this.units.get(insn);
    }

    private void assignReadOps(Local l) {
        if (this.stack.isEmpty()) {
            return;
        }
        for (Operand opr : this.stack) {
            Local stack;
            if (opr == DWORD_DUMMY || opr.stack != null || l == null && opr.value instanceof Local) continue;
            if (l != null && !opr.value.equivTo(l)) {
                List<ValueBox> uses = opr.value.getUseBoxes();
                boolean noref = true;
                for (ValueBox use : uses) {
                    Value val = use.getValue();
                    if (!val.equivTo(l)) continue;
                    noref = false;
                    break;
                }
                if (noref) continue;
            }
            int op = opr.insn.getOpcode();
            if (l == null && op != 180 && op != 178 && op < 46 && op > 53) continue;
            opr.stack = stack = this.newStackLocal();
            AssignStmt as = Jimple.v().newAssignStmt(stack, opr.value);
            opr.updateBoxes();
            this.setUnit(opr.insn, as);
        }
    }

    private void convertGetFieldInsn(FieldInsnNode insn) {
        Operand opr;
        Type type;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            FieldRef val;
            SootClass declClass = this.getClassFromScene(AsmUtil.toQualifiedName(insn.owner));
            type = AsmUtil.toJimpleType(insn.desc, Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
            if (insn.getOpcode() == 178) {
                SootFieldRef ref = Scene.v().makeFieldRef(declClass, insn.name, type, true);
                val = Jimple.v().newStaticFieldRef(ref);
            } else {
                Operand base = this.popLocal();
                SootFieldRef ref = Scene.v().makeFieldRef(declClass, insn.name, type, false);
                InstanceFieldRef ifr = Jimple.v().newInstanceFieldRef(base.stackOrValue(), ref);
                val = ifr;
                base.addBox(ifr.getBaseBox());
                frame.in(base);
                frame.boxes(ifr.getBaseBox());
            }
            opr = new Operand(insn, val);
            frame.out(opr);
        } else {
            opr = out[0];
            type = ((FieldRef)opr.value()).getFieldRef().type();
            if (insn.getOpcode() == 180) {
                frame.mergeIn(this.pop());
            }
        }
        this.push(type, opr);
    }

    private void convertPutFieldInsn(FieldInsnNode insn) {
        boolean instance = insn.getOpcode() == 181;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            FieldRef val;
            SootClass declClass = this.getClassFromScene(AsmUtil.toQualifiedName(insn.owner));
            Type type = AsmUtil.toJimpleType(insn.desc, Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
            Operand rvalue = this.popImmediate(type);
            if (!instance) {
                SootFieldRef ref = Scene.v().makeFieldRef(declClass, insn.name, type, true);
                val = Jimple.v().newStaticFieldRef(ref);
                frame.in(rvalue);
            } else {
                Operand base = this.popLocal();
                SootFieldRef ref = Scene.v().makeFieldRef(declClass, insn.name, type, false);
                InstanceFieldRef ifr = Jimple.v().newInstanceFieldRef(base.stackOrValue(), ref);
                val = ifr;
                base.addBox(ifr.getBaseBox());
                frame.in(rvalue, base);
            }
            Operand opr = new Operand(insn, val);
            frame.out(opr);
            AssignStmt as = Jimple.v().newAssignStmt(val, rvalue.stackOrValue());
            rvalue.addBox(as.getRightOpBox());
            if (!instance) {
                frame.boxes(as.getRightOpBox());
            } else {
                frame.boxes(as.getRightOpBox(), ((InstanceFieldRef)val).getBaseBox());
            }
            this.setUnit(insn, as);
        } else {
            Operand opr = out[0];
            Type type = ((FieldRef)opr.value()).getFieldRef().type();
            Operand rvalue = this.pop(type);
            if (!instance) {
                frame.mergeIn(rvalue);
            } else {
                frame.mergeIn(rvalue, this.pop());
            }
        }
        this.assignReadOps(null);
    }

    private void convertFieldInsn(FieldInsnNode insn) {
        int op = insn.getOpcode();
        if (op == 178 || op == 180) {
            this.convertGetFieldInsn(insn);
        } else {
            this.convertPutFieldInsn(insn);
        }
    }

    private void convertIincInsn(IincInsnNode insn) {
        Local local = this.getLocal(insn.var);
        this.assignReadOps(local);
        if (!this.units.containsKey(insn)) {
            AddExpr add = Jimple.v().newAddExpr(local, IntConstant.v(insn.incr));
            this.setUnit(insn, Jimple.v().newAssignStmt(local, add));
        }
    }

    private void convertConstInsn(InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            Constant v;
            if (op == 1) {
                v = NullConstant.v();
            } else if (op >= 2 && op <= 8) {
                v = IntConstant.v(op - 3);
            } else if (op == 9 || op == 10) {
                v = LongConstant.v(op - 9);
            } else if (op >= 11 && op <= 13) {
                v = FloatConstant.v(op - 11);
            } else if (op == 14 || op == 15) {
                v = DoubleConstant.v(op - 14);
            } else {
                throw new AssertionError((Object)("Unknown constant opcode: " + op));
            }
            opr = new Operand(insn, v);
            frame.out(opr);
        } else {
            opr = out[0];
        }
        if (op == 9 || op == 10 || op == 14 || op == 15) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertArrayLoadInsn(InsnNode insn) {
        Operand opr;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            Operand indx = this.popImmediate();
            Operand base = this.popImmediate();
            ArrayRef ar = Jimple.v().newArrayRef(base.stackOrValue(), indx.stackOrValue());
            indx.addBox(ar.getIndexBox());
            base.addBox(ar.getBaseBox());
            opr = new Operand(insn, ar);
            frame.in(indx, base);
            frame.boxes(ar.getIndexBox(), ar.getBaseBox());
            frame.out(opr);
        } else {
            opr = out[0];
            frame.mergeIn(this.pop(), this.pop());
        }
        int op = insn.getOpcode();
        if (op == 49 || op == 47) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertArrayStoreInsn(InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 80 || op == 82;
        StackFrame frame = this.getFrame(insn);
        if (!this.units.containsKey(insn)) {
            Operand valu = dword ? this.popImmediateDual() : this.popImmediate();
            Operand indx = this.popImmediate();
            Operand base = this.popLocal();
            ArrayRef ar = Jimple.v().newArrayRef(base.stackOrValue(), indx.stackOrValue());
            indx.addBox(ar.getIndexBox());
            base.addBox(ar.getBaseBox());
            AssignStmt as = Jimple.v().newAssignStmt(ar, valu.stackOrValue());
            valu.addBox(as.getRightOpBox());
            frame.in(valu, indx, base);
            frame.boxes(as.getRightOpBox(), ar.getIndexBox(), ar.getBaseBox());
            this.setUnit(insn, as);
        } else {
            frame.mergeIn(dword ? this.popDual() : this.pop(), this.pop(), this.pop());
        }
    }

    private void convertDupInsn(InsnNode insn) {
        boolean dword;
        int op = insn.getOpcode();
        Operand dupd = this.popImmediate();
        Operand dupd2 = null;
        boolean bl = dword = op == 92 || op == 93 || op == 94;
        if (dword) {
            if (this.peek() == DWORD_DUMMY) {
                this.pop();
                dupd2 = dupd;
            } else {
                dupd2 = this.popImmediate();
            }
        }
        if (op == 89) {
            this.push(dupd);
            this.push(dupd);
        } else if (op == 90) {
            Operand o2 = this.popImmediate();
            this.push(dupd);
            this.push(o2);
            this.push(dupd);
        } else if (op == 91) {
            Operand o2 = this.popImmediate();
            Operand o3 = this.peek() == DWORD_DUMMY ? this.pop() : this.popImmediate();
            this.push(dupd);
            this.push(o3);
            this.push(o2);
            this.push(dupd);
        } else if (op == 92) {
            this.push(dupd2);
            this.push(dupd);
            this.push(dupd2);
            this.push(dupd);
        } else if (op == 93) {
            Operand o2 = this.popImmediate();
            this.push(dupd2);
            this.push(dupd);
            this.push(o2);
            this.push(dupd2);
            this.push(dupd);
        } else if (op == 94) {
            Operand o2 = this.popImmediate();
            Operand o2h = this.peek() == DWORD_DUMMY ? this.pop() : this.popImmediate();
            this.push(dupd2);
            this.push(dupd);
            this.push(o2h);
            this.push(o2);
            this.push(dupd2);
            this.push(dupd);
        }
    }

    private void convertBinopInsn(InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 99 || op == 97 || op == 103 || op == 101 || op == 107 || op == 105 || op == 111 || op == 109 || op == 115 || op == 113 || op == 121 || op == 123 || op == 125 || op == 127 || op == 129 || op == 131 || op == 148 || op == 151 || op == 152;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            BinopExpr binop;
            Operand op2 = dword && op != 121 && op != 123 && op != 125 ? this.popImmediateDual() : this.popImmediate();
            Operand op1 = dword ? this.popImmediateDual() : this.popImmediate();
            Value v1 = op1.stackOrValue();
            Value v2 = op2.stackOrValue();
            if (op >= 96 && op <= 99) {
                binop = Jimple.v().newAddExpr(v1, v2);
            } else if (op >= 100 && op <= 103) {
                binop = Jimple.v().newSubExpr(v1, v2);
            } else if (op >= 104 && op <= 107) {
                binop = Jimple.v().newMulExpr(v1, v2);
            } else if (op >= 108 && op <= 111) {
                binop = Jimple.v().newDivExpr(v1, v2);
            } else if (op >= 112 && op <= 115) {
                binop = Jimple.v().newRemExpr(v1, v2);
            } else if (op >= 120 && op <= 121) {
                binop = Jimple.v().newShlExpr(v1, v2);
            } else if (op >= 122 && op <= 123) {
                binop = Jimple.v().newShrExpr(v1, v2);
            } else if (op >= 124 && op <= 125) {
                binop = Jimple.v().newUshrExpr(v1, v2);
            } else if (op >= 126 && op <= 127) {
                binop = Jimple.v().newAndExpr(v1, v2);
            } else if (op >= 128 && op <= 129) {
                binop = Jimple.v().newOrExpr(v1, v2);
            } else if (op >= 130 && op <= 131) {
                binop = Jimple.v().newXorExpr(v1, v2);
            } else if (op == 148) {
                binop = Jimple.v().newCmpExpr(v1, v2);
            } else if (op == 149 || op == 151) {
                binop = Jimple.v().newCmplExpr(v1, v2);
            } else if (op == 150 || op == 152) {
                binop = Jimple.v().newCmpgExpr(v1, v2);
            } else {
                throw new AssertionError((Object)("Unknown binop: " + op));
            }
            op1.addBox(binop.getOp1Box());
            op2.addBox(binop.getOp2Box());
            opr = new Operand(insn, binop);
            frame.in(op2, op1);
            frame.boxes(binop.getOp2Box(), binop.getOp1Box());
            frame.out(opr);
        } else {
            opr = out[0];
            if (dword) {
                if (op != 121 && op != 123 && op != 125) {
                    frame.mergeIn(this.popDual(), this.popDual());
                } else {
                    frame.mergeIn(this.pop(), this.popDual());
                }
            } else {
                frame.mergeIn(this.pop(), this.pop());
            }
        }
        if (dword && (op < 148 || op > 152)) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertUnopInsn(InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 117 || op == 119;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            UnopExpr unop;
            Operand op1 = dword ? this.popImmediateDual() : this.popImmediate();
            Value v1 = op1.stackOrValue();
            if (op >= 116 && op <= 119) {
                unop = Jimple.v().newNegExpr(v1);
            } else if (op == 190) {
                unop = Jimple.v().newLengthExpr(v1);
            } else {
                throw new AssertionError((Object)("Unknown unop: " + op));
            }
            op1.addBox(unop.getOpBox());
            opr = new Operand(insn, unop);
            frame.in(op1);
            frame.boxes(unop.getOpBox());
            frame.out(opr);
        } else {
            opr = out[0];
            frame.mergeIn(dword ? this.popDual() : this.pop());
        }
        if (dword) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertPrimCastInsn(InsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean tod = op == 133 || op == 135 || op == 140 || op == 141 || op == 143 || op == 138;
        boolean fromd = op == 143 || op == 138 || op == 142 || op == 136 || op == 144 || op == 137;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            PrimType totype;
            if (op == 133 || op == 140 || op == 143) {
                totype = LongType.v();
            } else if (op == 136 || op == 139 || op == 142) {
                totype = IntType.v();
            } else if (op == 134 || op == 137 || op == 144) {
                totype = FloatType.v();
            } else if (op == 135 || op == 138 || op == 141) {
                totype = DoubleType.v();
            } else if (op == 145) {
                totype = ByteType.v();
            } else if (op == 147) {
                totype = ShortType.v();
            } else if (op == 146) {
                totype = CharType.v();
            } else {
                throw new AssertionError((Object)("Unknonw prim cast op: " + op));
            }
            Operand val = fromd ? this.popImmediateDual() : this.popImmediate();
            CastExpr cast = Jimple.v().newCastExpr(val.stackOrValue(), totype);
            opr = new Operand(insn, cast);
            val.addBox(cast.getOpBox());
            frame.in(val);
            frame.boxes(cast.getOpBox());
            frame.out(opr);
        } else {
            opr = out[0];
            frame.mergeIn(fromd ? this.popDual() : this.pop());
        }
        if (tod) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertReturnInsn(InsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 173 || op == 175;
        StackFrame frame = this.getFrame(insn);
        if (!this.units.containsKey(insn)) {
            Operand val = dword ? this.popImmediateDual() : this.popImmediate();
            ReturnStmt ret = Jimple.v().newReturnStmt(val.stackOrValue());
            val.addBox(ret.getOpBox());
            frame.in(val);
            frame.boxes(ret.getOpBox());
            this.setUnit(insn, ret);
        } else {
            frame.mergeIn(dword ? this.popDual() : this.pop());
        }
    }

    private void convertInsn(InsnNode insn) {
        int op = insn.getOpcode();
        if (op == 0) {
            if (!this.units.containsKey(insn)) {
                this.units.put(insn, Jimple.v().newNopStmt());
            }
        } else if (op >= 1 && op <= 15) {
            this.convertConstInsn(insn);
        } else if (op >= 46 && op <= 53) {
            this.convertArrayLoadInsn(insn);
        } else if (op >= 79 && op <= 86) {
            this.convertArrayStoreInsn(insn);
        } else if (op == 87) {
            this.popImmediate();
        } else if (op == 88) {
            this.popImmediate();
            if (this.peek() == DWORD_DUMMY) {
                this.pop();
            } else {
                this.popImmediate();
            }
        } else if (op >= 89 && op <= 94) {
            this.convertDupInsn(insn);
        } else if (op == 95) {
            Operand o1 = this.popImmediate();
            Operand o2 = this.popImmediate();
            this.push(o1);
            this.push(o2);
        } else if (op >= 96 && op <= 115 || op >= 120 && op <= 131 || op >= 148 && op <= 152) {
            this.convertBinopInsn(insn);
        } else if (op >= 116 && op <= 119 || op == 190) {
            this.convertUnopInsn(insn);
        } else if (op >= 133 && op <= 147) {
            this.convertPrimCastInsn(insn);
        } else if (op >= 172 && op <= 176) {
            this.convertReturnInsn(insn);
        } else if (op == 177) {
            if (!this.units.containsKey(insn)) {
                this.setUnit(insn, Jimple.v().newReturnVoidStmt());
            }
        } else if (op == 191) {
            Operand opr;
            StackFrame frame = this.getFrame(insn);
            if (!this.units.containsKey(insn)) {
                opr = this.popImmediate();
                ThrowStmt ts = Jimple.v().newThrowStmt(opr.stackOrValue());
                opr.addBox(ts.getOpBox());
                frame.in(opr);
                frame.out(opr);
                frame.boxes(ts.getOpBox());
                this.setUnit(insn, ts);
            } else {
                opr = this.pop();
                frame.mergeIn(opr);
            }
            this.push(opr);
        } else if (op == 194 || op == 195) {
            StackFrame frame = this.getFrame(insn);
            if (!this.units.containsKey(insn)) {
                Operand opr = this.popStackConst();
                MonitorStmt ts = op == 194 ? Jimple.v().newEnterMonitorStmt(opr.stackOrValue()) : Jimple.v().newExitMonitorStmt(opr.stackOrValue());
                opr.addBox(ts.getOpBox());
                frame.in(opr);
                frame.boxes(ts.getOpBox());
                this.setUnit(insn, ts);
            } else {
                frame.mergeIn(this.pop());
            }
        } else {
            throw new AssertionError((Object)("Unknown insn op: " + op));
        }
    }

    private void convertIntInsn(IntInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            Value v;
            if (op == 16 || op == 17) {
                v = IntConstant.v(insn.operand);
            } else {
                PrimType type;
                switch (insn.operand) {
                    case 4: {
                        type = BooleanType.v();
                        break;
                    }
                    case 5: {
                        type = CharType.v();
                        break;
                    }
                    case 6: {
                        type = FloatType.v();
                        break;
                    }
                    case 7: {
                        type = DoubleType.v();
                        break;
                    }
                    case 8: {
                        type = ByteType.v();
                        break;
                    }
                    case 9: {
                        type = ShortType.v();
                        break;
                    }
                    case 10: {
                        type = IntType.v();
                        break;
                    }
                    case 11: {
                        type = LongType.v();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unknown NEWARRAY type!");
                    }
                }
                Operand size = this.popImmediate();
                NewArrayExpr anew = Jimple.v().newNewArrayExpr(type, size.stackOrValue());
                size.addBox(anew.getSizeBox());
                frame.in(size);
                frame.boxes(anew.getSizeBox());
                v = anew;
            }
            opr = new Operand(insn, v);
            frame.out(opr);
        } else {
            opr = out[0];
            if (op == 188) {
                frame.mergeIn(this.pop());
            }
        }
        this.push(opr);
    }

    private void convertJumpInsn(JumpInsnNode insn) {
        int op = insn.getOpcode();
        if (op == 167) {
            if (!this.units.containsKey(insn)) {
                UnitBox box = Jimple.v().newStmtBox(null);
                this.labels.put(insn.label, box);
                this.setUnit(insn, Jimple.v().newGotoStmt(box));
            }
            return;
        }
        StackFrame frame = this.getFrame(insn);
        if (!this.units.containsKey(insn)) {
            ConditionExpr cond;
            Operand val = this.popImmediate();
            Value v = val.stackOrValue();
            if (op >= 159 && op <= 166) {
                Operand val1 = this.popImmediate();
                Value v1 = val1.stackOrValue();
                if (op == 159) {
                    cond = Jimple.v().newEqExpr(v1, v);
                } else if (op == 160) {
                    cond = Jimple.v().newNeExpr(v1, v);
                } else if (op == 161) {
                    cond = Jimple.v().newLtExpr(v1, v);
                } else if (op == 162) {
                    cond = Jimple.v().newGeExpr(v1, v);
                } else if (op == 163) {
                    cond = Jimple.v().newGtExpr(v1, v);
                } else if (op == 164) {
                    cond = Jimple.v().newLeExpr(v1, v);
                } else if (op == 165) {
                    cond = Jimple.v().newEqExpr(v1, v);
                } else if (op == 166) {
                    cond = Jimple.v().newNeExpr(v1, v);
                } else {
                    throw new AssertionError((Object)("Unknown if op: " + op));
                }
                val1.addBox(cond.getOp1Box());
                val.addBox(cond.getOp2Box());
                frame.boxes(cond.getOp2Box(), cond.getOp1Box());
                frame.in(val, val1);
            } else {
                if (op == 153) {
                    cond = Jimple.v().newEqExpr(v, IntConstant.v(0));
                } else if (op == 154) {
                    cond = Jimple.v().newNeExpr(v, IntConstant.v(0));
                } else if (op == 155) {
                    cond = Jimple.v().newLtExpr(v, IntConstant.v(0));
                } else if (op == 156) {
                    cond = Jimple.v().newGeExpr(v, IntConstant.v(0));
                } else if (op == 157) {
                    cond = Jimple.v().newGtExpr(v, IntConstant.v(0));
                } else if (op == 158) {
                    cond = Jimple.v().newLeExpr(v, IntConstant.v(0));
                } else if (op == 198) {
                    cond = Jimple.v().newEqExpr(v, NullConstant.v());
                } else if (op == 199) {
                    cond = Jimple.v().newNeExpr(v, NullConstant.v());
                } else {
                    throw new AssertionError((Object)("Unknown if op: " + op));
                }
                val.addBox(cond.getOp1Box());
                frame.boxes(cond.getOp1Box());
                frame.in(val);
            }
            UnitBox box = Jimple.v().newStmtBox(null);
            this.labels.put(insn.label, box);
            this.setUnit(insn, Jimple.v().newIfStmt((Value)cond, box));
        } else if (op >= 159 && op <= 166) {
            frame.mergeIn(this.pop(), this.pop());
        } else {
            frame.mergeIn(this.pop());
        }
    }

    private void convertLdcInsn(LdcInsnNode insn) {
        Operand opr;
        Object val = insn.cst;
        boolean dword = val instanceof Long || val instanceof Double;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            Value v = this.toSootValue(val);
            opr = new Operand(insn, v);
            frame.out(opr);
        } else {
            opr = out[0];
        }
        if (dword) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private Value toSootValue(Object val) throws AssertionError {
        Constant v;
        if (val instanceof Integer) {
            v = IntConstant.v((Integer)val);
        } else if (val instanceof Float) {
            v = FloatConstant.v(((Float)val).floatValue());
        } else if (val instanceof Long) {
            v = LongConstant.v((Long)val);
        } else if (val instanceof Double) {
            v = DoubleConstant.v((Double)val);
        } else if (val instanceof String) {
            v = StringConstant.v(val.toString());
        } else if (val instanceof org.objectweb.asm.Type) {
            org.objectweb.asm.Type t = (org.objectweb.asm.Type)val;
            if (t.getSort() == 11) {
                List<Type> paramTypes = AsmUtil.toJimpleDesc(((org.objectweb.asm.Type)val).getDescriptor(), Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
                Type returnType = paramTypes.remove(paramTypes.size() - 1);
                v = MethodType.v(paramTypes, returnType);
            } else {
                v = ClassConstant.v(((org.objectweb.asm.Type)val).getDescriptor());
            }
        } else if (val instanceof Handle) {
            Handle h2 = (Handle)val;
            v = MethodHandle.isMethodRef(h2.getTag()) ? MethodHandle.v(this.toSootMethodRef((Handle)val), ((Handle)val).getTag()) : MethodHandle.v(this.toSootFieldRef((Handle)val), ((Handle)val).getTag());
        } else {
            throw new AssertionError((Object)("Unknown constant type: " + val.getClass()));
        }
        return v;
    }

    private void convertLookupSwitchInsn(LookupSwitchInsnNode insn) {
        StackFrame frame = this.getFrame(insn);
        if (this.units.containsKey(insn)) {
            frame.mergeIn(this.pop());
            return;
        }
        Operand key = this.popImmediate();
        UnitBox dflt = Jimple.v().newStmtBox(null);
        ArrayList<UnitBox> targets = new ArrayList<UnitBox>(insn.labels.size());
        this.labels.put(insn.dflt, dflt);
        for (LabelNode labelNode : insn.labels) {
            UnitBox box = Jimple.v().newStmtBox(null);
            targets.add(box);
            this.labels.put(labelNode, box);
        }
        ArrayList<IntConstant> keys = new ArrayList<IntConstant>(insn.keys.size());
        for (Integer i : insn.keys) {
            keys.add(IntConstant.v(i));
        }
        LookupSwitchStmt lookupSwitchStmt = Jimple.v().newLookupSwitchStmt(key.stackOrValue(), keys, targets, dflt);
        key.addBox(lookupSwitchStmt.getKeyBox());
        frame.in(key);
        frame.boxes(lookupSwitchStmt.getKeyBox());
        this.setUnit(insn, lookupSwitchStmt);
    }

    private void convertMethodInsn(MethodInsnNode insn) {
        Operand opr;
        Type returnType;
        int op = insn.getOpcode();
        boolean instance = op != 184;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            InvokeExpr invoke;
            ValueBox[] boxes;
            Operand[] args;
            String clsName = AsmUtil.toQualifiedName(insn.owner);
            if (clsName.charAt(0) == '[') {
                clsName = "java.lang.Object";
            }
            SootClass cls = this.getClassFromScene(clsName);
            List<Type> sigTypes = AsmUtil.toJimpleDesc(insn.desc, Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
            returnType = sigTypes.remove(sigTypes.size() - 1);
            SootMethodRef ref = Scene.v().makeMethodRef(cls, insn.name, sigTypes, returnType, !instance);
            int nrArgs = sigTypes.size();
            List argList = Collections.emptyList();
            if (!instance) {
                Operand[] operandArray = args = nrArgs == 0 ? null : new Operand[nrArgs];
                if (args != null) {
                    argList = new ArrayList(nrArgs);
                }
            } else {
                args = new Operand[nrArgs + 1];
                if (nrArgs != 0) {
                    argList = new ArrayList(nrArgs);
                }
            }
            while (nrArgs-- != 0) {
                args[nrArgs] = this.popImmediate(sigTypes.get(nrArgs));
                argList.add(args[nrArgs].stackOrValue());
            }
            if (argList.size() > 1) {
                Collections.reverse(argList);
            }
            if (instance) {
                args[args.length - 1] = this.popLocal();
            }
            ValueBox[] valueBoxArray = boxes = args == null ? null : new ValueBox[args.length];
            if (!instance) {
                invoke = Jimple.v().newStaticInvokeExpr(ref, argList);
            } else {
                InstanceInvokeExpr iinvoke;
                Local base = (Local)args[args.length - 1].stackOrValue();
                if (op == 183) {
                    iinvoke = Jimple.v().newSpecialInvokeExpr(base, ref, argList);
                } else if (op == 182) {
                    iinvoke = Jimple.v().newVirtualInvokeExpr(base, ref, argList);
                } else if (op == 185) {
                    iinvoke = Jimple.v().newInterfaceInvokeExpr(base, ref, argList);
                } else {
                    throw new AssertionError((Object)("Unknown invoke op:" + op));
                }
                boxes[boxes.length - 1] = iinvoke.getBaseBox();
                args[args.length - 1].addBox(boxes[boxes.length - 1]);
                invoke = iinvoke;
            }
            if (boxes != null) {
                for (int i = 0; i != sigTypes.size(); ++i) {
                    boxes[i] = invoke.getArgBox(i);
                    args[i].addBox(boxes[i]);
                }
                frame.boxes(boxes);
                frame.in(args);
            }
            opr = new Operand(insn, invoke);
            frame.out(opr);
        } else {
            opr = out[0];
            InvokeExpr expr = (InvokeExpr)opr.value;
            List<Type> types = expr.getMethodRef().getParameterTypes();
            int nrArgs = types.size();
            Operand[] oprs = expr.getMethodRef().isStatic() ? (nrArgs == 0 ? null : new Operand[nrArgs]) : new Operand[nrArgs + 1];
            if (oprs != null) {
                while (nrArgs-- != 0) {
                    oprs[nrArgs] = this.pop(types.get(nrArgs));
                }
                if (!expr.getMethodRef().isStatic()) {
                    oprs[oprs.length - 1] = this.pop();
                }
                frame.mergeIn(oprs);
                nrArgs = types.size();
            }
            returnType = expr.getMethodRef().getReturnType();
        }
        if (AsmUtil.isDWord(returnType)) {
            this.pushDual(opr);
        } else if (!(returnType instanceof VoidType)) {
            this.push(opr);
        } else if (!this.units.containsKey(insn)) {
            this.setUnit(insn, Jimple.v().newInvokeStmt(opr.value));
        }
        this.assignReadOps(null);
    }

    private void convertInvokeDynamicInsn(InvokeDynamicInsnNode insn) {
        Operand opr;
        Type returnType;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            InvokeExpr indy;
            String bsmMethodRefStr;
            SootMethodRef bsmMethodRef = this.toSootMethodRef(insn.bsm);
            ArrayList<Value> bsmMethodArgs = new ArrayList<Value>(insn.bsmArgs.length);
            for (Object bsmArg : insn.bsmArgs) {
                bsmMethodArgs.add(this.toSootValue(bsmArg));
            }
            SootClass bclass = Scene.v().getSootClass("soot.dummy.InvokeDynamic");
            Type[] types = Util.v().jimpleTypesOfFieldOrMethodDescriptor(insn.desc);
            int nrArgs = types.length - 1;
            ArrayList<Type> parameterTypes = new ArrayList<Type>(nrArgs);
            ArrayList<Value> methodArgs = new ArrayList<Value>(nrArgs);
            Operand[] args = new Operand[nrArgs];
            ValueBox[] boxes = new ValueBox[nrArgs];
            while (nrArgs-- != 0) {
                parameterTypes.add(types[nrArgs]);
                args[nrArgs] = this.popImmediate(types[nrArgs]);
                methodArgs.add(args[nrArgs].stackOrValue());
            }
            if (methodArgs.size() > 1) {
                Collections.reverse(methodArgs);
                Collections.reverse(parameterTypes);
            }
            returnType = types[types.length - 1];
            SootMethodRef bootstrap_model = null;
            if (PhaseOptions.getBoolean(PhaseOptions.v().getPhaseOptions("jb"), "model-lambdametafactory") && ((bsmMethodRefStr = bsmMethodRef.toString()).equals(METAFACTORY_SIGNATURE) || bsmMethodRefStr.equals(ALT_METAFACTORY_SIGNATURE))) {
                SootClass enclosingClass = this.body.getMethod().getDeclaringClass();
                bootstrap_model = LambdaMetaFactory.v().makeLambdaHelper(bsmMethodArgs, insn.bsm.getTag(), insn.name, types, enclosingClass);
            }
            if (bootstrap_model != null) {
                indy = Jimple.v().newStaticInvokeExpr(bootstrap_model, methodArgs);
            } else {
                SootMethodRef methodRef = Scene.v().makeMethodRef(bclass, insn.name, parameterTypes, returnType, true);
                indy = Jimple.v().newDynamicInvokeExpr(bsmMethodRef, bsmMethodArgs, methodRef, insn.bsm.getTag(), methodArgs);
            }
            if (boxes != null) {
                for (int i = 0; i < types.length - 1; ++i) {
                    boxes[i] = indy.getArgBox(i);
                    args[i].addBox(boxes[i]);
                }
                frame.boxes(boxes);
                frame.in(args);
            }
            opr = new Operand(insn, indy);
            frame.out(opr);
        } else {
            opr = out[0];
            InvokeExpr expr = (InvokeExpr)opr.value;
            List<Type> types = expr.getMethodRef().getParameterTypes();
            int nrArgs = types.size();
            Operand[] oprs = expr.getMethodRef().isStatic() ? (nrArgs == 0 ? null : new Operand[nrArgs]) : new Operand[nrArgs + 1];
            if (oprs != null) {
                while (nrArgs-- != 0) {
                    oprs[nrArgs] = this.pop(types.get(nrArgs));
                }
                if (!expr.getMethodRef().isStatic()) {
                    oprs[oprs.length - 1] = this.pop();
                }
                frame.mergeIn(oprs);
                nrArgs = types.size();
            }
            returnType = expr.getMethodRef().getReturnType();
        }
        if (AsmUtil.isDWord(returnType)) {
            this.pushDual(opr);
        } else if (!(returnType instanceof VoidType)) {
            this.push(opr);
        } else if (!this.units.containsKey(insn)) {
            this.setUnit(insn, Jimple.v().newInvokeStmt(opr.value));
        }
        this.assignReadOps(null);
    }

    private SootMethodRef toSootMethodRef(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        SootClass bsmCls = this.getClassFromScene(bsmClsName);
        List<Type> bsmSigTypes = AsmUtil.toJimpleDesc(methodHandle.getDesc(), Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
        Type returnType = bsmSigTypes.remove(bsmSigTypes.size() - 1);
        return Scene.v().makeMethodRef(bsmCls, methodHandle.getName(), bsmSigTypes, returnType, methodHandle.getTag() == MethodHandle.Kind.REF_INVOKE_STATIC.getValue());
    }

    private SootFieldRef toSootFieldRef(Handle methodHandle) {
        String bsmClsName = AsmUtil.toQualifiedName(methodHandle.getOwner());
        SootClass bsmCls = Scene.v().getSootClass(bsmClsName);
        Type t = AsmUtil.toJimpleDesc(methodHandle.getDesc(), Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName)).get(0);
        int kind = methodHandle.getTag();
        return Scene.v().makeFieldRef(bsmCls, methodHandle.getName(), t, kind == MethodHandle.Kind.REF_GET_FIELD_STATIC.getValue() || kind == MethodHandle.Kind.REF_PUT_FIELD_STATIC.getValue());
    }

    private void convertMultiANewArrayInsn(MultiANewArrayInsnNode insn) {
        Operand opr;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            ArrayType t = (ArrayType)AsmUtil.toJimpleType(insn.desc, Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
            int dims = insn.dims;
            Operand[] sizes = new Operand[dims];
            Value[] sizeVals = new Value[dims];
            ValueBox[] boxes = new ValueBox[dims];
            while (dims-- != 0) {
                sizes[dims] = this.popImmediate();
                sizeVals[dims] = sizes[dims].stackOrValue();
            }
            NewMultiArrayExpr nm = Jimple.v().newNewMultiArrayExpr(t, Arrays.asList(sizeVals));
            for (int i = 0; i != boxes.length; ++i) {
                ValueBox vb = nm.getSizeBox(i);
                sizes[i].addBox(vb);
                boxes[i] = vb;
            }
            frame.boxes(boxes);
            frame.in(sizes);
            opr = new Operand(insn, nm);
            frame.out(opr);
        } else {
            opr = out[0];
            int dims = insn.dims;
            Operand[] sizes = new Operand[dims];
            while (dims-- != 0) {
                sizes[dims] = this.pop();
            }
            frame.mergeIn(sizes);
        }
        this.push(opr);
    }

    private void convertTableSwitchInsn(TableSwitchInsnNode insn) {
        StackFrame frame = this.getFrame(insn);
        if (this.units.containsKey(insn)) {
            frame.mergeIn(this.pop());
            return;
        }
        Operand key = this.popImmediate();
        UnitBox dflt = Jimple.v().newStmtBox(null);
        ArrayList<UnitBox> targets = new ArrayList<UnitBox>(insn.labels.size());
        this.labels.put(insn.dflt, dflt);
        for (LabelNode ln : insn.labels) {
            UnitBox box = Jimple.v().newStmtBox(null);
            targets.add(box);
            this.labels.put(ln, box);
        }
        TableSwitchStmt tss = Jimple.v().newTableSwitchStmt(key.stackOrValue(), insn.min, insn.max, targets, dflt);
        key.addBox(tss.getKeyBox());
        frame.in(key);
        frame.boxes(tss.getKeyBox());
        this.setUnit(insn, tss);
    }

    private void convertTypeInsn(TypeInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            Expr val;
            Type t = AsmUtil.toJimpleRefType(insn.desc, Optional.fromNullable(this.body.getMethod().getDeclaringClass().moduleName));
            if (op == 187) {
                val = Jimple.v().newNewExpr((RefType)t);
            } else {
                ValueBox vb;
                Operand op1 = this.popImmediate();
                Value v1 = op1.stackOrValue();
                if (op == 189) {
                    NewArrayExpr expr = Jimple.v().newNewArrayExpr(t, v1);
                    vb = expr.getSizeBox();
                    val = expr;
                } else if (op == 192) {
                    CastExpr expr = Jimple.v().newCastExpr(v1, t);
                    vb = expr.getOpBox();
                    val = expr;
                } else if (op == 193) {
                    InstanceOfExpr expr = Jimple.v().newInstanceOfExpr(v1, t);
                    vb = expr.getOpBox();
                    val = expr;
                } else {
                    throw new AssertionError((Object)("Unknown type op: " + op));
                }
                op1.addBox(vb);
                frame.in(op1);
                frame.boxes(vb);
            }
            opr = new Operand(insn, val);
            frame.out(opr);
        } else {
            opr = out[0];
            if (op != 187) {
                frame.mergeIn(this.pop());
            }
        }
        this.push(opr);
    }

    private void convertVarLoadInsn(VarInsnNode insn) {
        Operand opr;
        int op = insn.getOpcode();
        boolean dword = op == 22 || op == 24;
        StackFrame frame = this.getFrame(insn);
        Operand[] out = frame.out();
        if (out == null) {
            opr = new Operand(insn, this.getLocal(insn.var));
            frame.out(opr);
        } else {
            opr = out[0];
        }
        if (dword) {
            this.pushDual(opr);
        } else {
            this.push(opr);
        }
    }

    private void convertVarStoreInsn(VarInsnNode insn) {
        int op = insn.getOpcode();
        boolean dword = op == 55 || op == 57;
        StackFrame frame = this.getFrame(insn);
        Operand opr = dword ? this.popDual() : this.pop();
        Local local = this.getLocal(insn.var);
        if (!this.units.containsKey(insn)) {
            AssignStmt as = Jimple.v().newAssignStmt(local, opr.stackOrValue());
            opr.addBox(as.getRightOpBox());
            frame.boxes(as.getRightOpBox());
            frame.in(opr);
            this.setUnit(insn, as);
        } else {
            frame.mergeIn(opr);
        }
        this.assignReadOps(local);
    }

    private void convertVarInsn(VarInsnNode insn) {
        int op = insn.getOpcode();
        if (op >= 21 && op <= 25) {
            this.convertVarLoadInsn(insn);
        } else if (op >= 54 && op <= 58) {
            this.convertVarStoreInsn(insn);
        } else if (op == 169) {
            if (!this.units.containsKey(insn)) {
                this.setUnit(insn, Jimple.v().newRetStmt(this.getLocal(insn.var)));
            }
        } else {
            throw new AssertionError((Object)("Unknown var op: " + op));
        }
    }

    private void convertLabel(LabelNode ln) {
        Operand opr;
        if (!this.trapHandlers.containsKey(ln)) {
            return;
        }
        if (this.inlineExceptionLabels.contains(ln)) {
            if (!this.units.containsKey(ln)) {
                NopStmt nop = Jimple.v().newNopStmt();
                this.setUnit(ln, nop);
            }
            return;
        }
        StackFrame frame = this.getFrame(ln);
        Operand[] out = frame.out();
        if (out == null) {
            CaughtExceptionRef ref = Jimple.v().newCaughtExceptionRef();
            Local stack = this.newStackLocal();
            IdentityStmt as = Jimple.v().newIdentityStmt(stack, ref);
            opr = new Operand(ln, ref);
            opr.stack = stack;
            frame.out(opr);
            this.setUnit(ln, as);
        } else {
            opr = out[0];
        }
        this.push(opr);
    }

    private void convertLine(LineNumberNode ln) {
        this.lastLineNumber = ln.line;
    }

    /*
     * WARNING - void declaration
     */
    private void addEdges(AbstractInsnNode cur, AbstractInsnNode tgt1, List<LabelNode> tgts) {
        int lastIdx = tgts == null ? -1 : tgts.size() - 1;
        Object[] stackss = new ArrayList<Operand>(this.stack).toArray(new Operand[this.stack.size()]);
        AbstractInsnNode tgt = tgt1;
        int i = 0;
        block0: do {
            Edge edge;
            if ((edge = this.edges.get(cur, tgt)) == null) {
                edge = new Edge(tgt, this.lastLineNumber);
                edge.prevStacks.add((Operand[])stackss);
                this.edges.put(cur, tgt, edge);
                this.conversionWorklist.add(edge);
                continue;
            }
            if (edge.stack != null) {
                void var10_11;
                ArrayList<Operand> stackTemp = edge.stack;
                if (stackTemp.size() != stackss.length) {
                    throw new AssertionError((Object)"Multiple un-equal stacks!");
                }
                boolean bl = false;
                while (var10_11 != stackss.length) {
                    if (!stackTemp.get((int)var10_11).equivTo((Operand)stackss[var10_11])) {
                        throw new AssertionError((Object)"Multiple un-equal stacks!");
                    }
                    ++var10_11;
                }
            } else {
                for (Object[] objectArray : edge.prevStacks) {
                    if (!Arrays.equals(objectArray, stackss)) continue;
                    continue block0;
                }
                edge.stack = new ArrayList<Operand>(this.stack);
                edge.prevStacks.add((Operand[])stackss);
                this.conversionWorklist.add(edge);
            }
        } while (i <= lastIdx && (tgt = (AbstractInsnNode)tgts.get(i++)) != null);
    }

    private void convert() {
        ArrayDeque<Edge> worklist = new ArrayDeque<Edge>();
        for (LabelNode ln : this.trapHandlers.keySet()) {
            if (this.checkInlineExceptionHandler(ln)) {
                this.handleInlineExceptionHandler(ln, worklist);
                continue;
            }
            worklist.add(new Edge((AbstractInsnNode)ln, new ArrayList<Operand>()));
        }
        worklist.add(new Edge(this.instructions.getFirst(), new ArrayList<Operand>()));
        this.conversionWorklist = worklist;
        this.edges = HashBasedTable.create(1, 1);
        block1: do {
            Edge edge = worklist.pollLast();
            AbstractInsnNode insn = edge.insn;
            this.stack = edge.stack;
            this.lastLineNumber = edge.lastLineNumber == -1 ? this.lastLineNumber : edge.lastLineNumber;
            edge.stack = null;
            do {
                int type;
                if ((type = insn.getType()) == 4) {
                    this.convertFieldInsn((FieldInsnNode)insn);
                    continue;
                }
                if (type == 10) {
                    this.convertIincInsn((IincInsnNode)insn);
                    continue;
                }
                if (type == 0) {
                    this.convertInsn((InsnNode)insn);
                    int op = insn.getOpcode();
                    if ((op < 172 || op > 177) && op != 191) continue;
                    continue block1;
                }
                if (type == 1) {
                    this.convertIntInsn((IntInsnNode)insn);
                    continue;
                }
                if (type == 9) {
                    this.convertLdcInsn((LdcInsnNode)insn);
                    continue;
                }
                if (type == 7) {
                    JumpInsnNode jmp = (JumpInsnNode)insn;
                    this.convertJumpInsn(jmp);
                    int op = jmp.getOpcode();
                    if (op == 168) {
                        throw new UnsupportedOperationException("JSR!");
                    }
                    if (op != 167) {
                        AbstractInsnNode next = insn.getNext();
                        this.addEdges(insn, next, Collections.singletonList(jmp.label));
                        continue block1;
                    }
                    this.addEdges(insn, jmp.label, null);
                    continue block1;
                }
                if (type == 12) {
                    LookupSwitchInsnNode swtch = (LookupSwitchInsnNode)insn;
                    this.convertLookupSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges(insn, dflt, swtch.labels);
                    continue block1;
                }
                if (type == 5) {
                    this.convertMethodInsn((MethodInsnNode)insn);
                    continue;
                }
                if (type == 6) {
                    this.convertInvokeDynamicInsn((InvokeDynamicInsnNode)insn);
                    continue;
                }
                if (type == 13) {
                    this.convertMultiANewArrayInsn((MultiANewArrayInsnNode)insn);
                    continue;
                }
                if (type == 11) {
                    TableSwitchInsnNode swtch = (TableSwitchInsnNode)insn;
                    this.convertTableSwitchInsn(swtch);
                    LabelNode dflt = swtch.dflt;
                    this.addEdges(insn, dflt, swtch.labels);
                    continue block1;
                }
                if (type == 3) {
                    this.convertTypeInsn((TypeInsnNode)insn);
                    continue;
                }
                if (type == 2) {
                    if (insn.getOpcode() == 169) {
                        throw new UnsupportedOperationException("RET!");
                    }
                    this.convertVarInsn((VarInsnNode)insn);
                    continue;
                }
                if (type == 8) {
                    this.convertLabel((LabelNode)insn);
                    continue;
                }
                if (type == 15) {
                    this.convertLine((LineNumberNode)insn);
                    continue;
                }
                if (type == 14) continue;
                throw new RuntimeException("Unknown instruction type: " + type);
            } while ((insn = insn.getNext()) != null);
        } while (!worklist.isEmpty());
        this.conversionWorklist = null;
        this.edges = null;
    }

    private void handleInlineExceptionHandler(LabelNode ln, ArrayDeque<Edge> worklist) {
        CaughtExceptionRef ref = Jimple.v().newCaughtExceptionRef();
        Local local = this.newStackLocal();
        IdentityStmt as = Jimple.v().newIdentityStmt(local, ref);
        Operand opr = new Operand(ln, ref);
        opr.stack = local;
        ArrayList<Operand> stack = new ArrayList<Operand>();
        stack.add(opr);
        worklist.add(new Edge((AbstractInsnNode)ln, stack));
        this.inlineExceptionHandlers.put(ln, as);
    }

    private boolean checkInlineExceptionHandler(LabelNode ln) {
        for (AbstractInsnNode node : this.instructions) {
            if (node instanceof JumpInsnNode) {
                if (((JumpInsnNode)node).label != ln) continue;
                this.inlineExceptionLabels.add(ln);
                return true;
            }
            if (node instanceof LookupSwitchInsnNode) {
                if (!((LookupSwitchInsnNode)node).labels.contains(ln)) continue;
                this.inlineExceptionLabels.add(ln);
                return true;
            }
            if (!(node instanceof TableSwitchInsnNode) || !((TableSwitchInsnNode)node).labels.contains(ln)) continue;
            this.inlineExceptionLabels.add(ln);
            return true;
        }
        return false;
    }

    private void emitLocals() {
        JimpleBody jb = this.body;
        SootMethod m3 = jb.getMethod();
        Chain<Local> jbl = jb.getLocals();
        UnitPatchingChain jbu = jb.getUnits();
        int iloc = 0;
        if (!m3.isStatic()) {
            Local l = this.getLocal(iloc++);
            jbu.add(Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef(m3.getDeclaringClass().getType())));
        }
        int nrp = 0;
        Iterator<Numberable> iterator = m3.getParameterTypes().iterator();
        while (iterator.hasNext()) {
            Type ot;
            Type t = ot = iterator.next();
            Local l = this.getLocal(iloc);
            jbu.add(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(t, nrp++)));
            if (AsmUtil.isDWord(t)) {
                iloc += 2;
                continue;
            }
            ++iloc;
        }
        for (Local l : this.locals.values()) {
            jbl.add(l);
        }
    }

    private void emitTraps() {
        Chain<Trap> traps = this.body.getTraps();
        SootClass throwable = Scene.v().getSootClass("java.lang.Throwable");
        LinkedHashMap<LabelNode, Iterator<UnitBox>> handlers = new LinkedHashMap<LabelNode, Iterator<UnitBox>>(this.tryCatchBlocks.size());
        for (TryCatchBlockNode tc : this.tryCatchBlocks) {
            UnitBox start = Jimple.v().newStmtBox(null);
            UnitBox end = Jimple.v().newStmtBox(null);
            Iterator<UnitBox> hitr = (Iterator<UnitBox>)handlers.get(tc.handler);
            if (hitr == null) {
                hitr = this.trapHandlers.get(tc.handler).iterator();
                handlers.put(tc.handler, hitr);
            }
            UnitBox handler = (UnitBox)hitr.next();
            SootClass cls = tc.type == null ? throwable : this.getClassFromScene(AsmUtil.toQualifiedName(tc.type));
            Trap trap = Jimple.v().newTrap(cls, start, end, handler);
            traps.add(trap);
            this.labels.put(tc.start, start);
            this.labels.put(tc.end, end);
        }
    }

    private void emitUnits(Unit u) {
        if (u instanceof UnitContainer) {
            for (Unit uu : ((UnitContainer)u).units) {
                this.emitUnits(uu);
            }
        } else {
            this.body.getUnits().add(u);
        }
    }

    private void emitUnits() {
        Collection<UnitBox> boxes;
        LabelNode ln;
        AbstractInsnNode insn = this.instructions.getFirst();
        ArrayDeque<LabelNode> labls = new ArrayDeque<LabelNode>();
        while (insn != null) {
            Object u;
            if (insn instanceof LabelNode) {
                labls.add((LabelNode)insn);
            }
            if ((u = this.units.get(insn)) == null) {
                insn = insn.getNext();
                continue;
            }
            this.emitUnits((Unit)u);
            IdentityStmt caughtEx = null;
            if (u instanceof IdentityStmt) {
                caughtEx = (IdentityStmt)u;
            } else if (u instanceof UnitContainer) {
                caughtEx = this.getIdentityRefFromContrainer((UnitContainer)u);
            }
            if (insn instanceof LabelNode && caughtEx != null && caughtEx.getRightOp() instanceof CaughtExceptionRef) {
                Collection<UnitBox> traps = this.trapHandlers.get((LabelNode)insn);
                for (UnitBox unitBox : traps) {
                    unitBox.setUnit(caughtEx);
                }
            }
            while (!labls.isEmpty()) {
                ln = (LabelNode)labls.poll();
                boxes = this.labels.get(ln);
                if (boxes == null) continue;
                for (UnitBox unitBox : boxes) {
                    unitBox.setUnit((Unit)(u instanceof UnitContainer ? ((UnitContainer)u).getFirstUnit() : u));
                }
            }
            insn = insn.getNext();
        }
        for (LabelNode ln2 : this.inlineExceptionHandlers.keySet()) {
            Unit handler = this.inlineExceptionHandlers.get(ln2);
            this.emitUnits(handler);
            Collection<UnitBox> traps = this.trapHandlers.get(ln2);
            for (UnitBox ub : traps) {
                ub.setUnit(handler);
            }
            Unit unit = this.units.get(ln2);
            GotoStmt gotoImpl = Jimple.v().newGotoStmt(unit);
            this.body.getUnits().add(gotoImpl);
        }
        if (labls.isEmpty()) {
            return;
        }
        NopStmt end = Jimple.v().newNopStmt();
        this.body.getUnits().add(end);
        while (!labls.isEmpty()) {
            ln = (LabelNode)labls.poll();
            boxes = this.labels.get(ln);
            if (boxes == null) continue;
            for (UnitBox unitBox : boxes) {
                unitBox.setUnit(end);
            }
        }
    }

    private IdentityStmt getIdentityRefFromContrainer(UnitContainer u) {
        for (Unit uu : u.units) {
            if (uu instanceof IdentityStmt) {
                return (IdentityStmt)uu;
            }
            if (!(uu instanceof UnitContainer)) continue;
            return this.getIdentityRefFromContrainer((UnitContainer)uu);
        }
        return null;
    }

    @Override
    public Body getBody(SootMethod m3, String phaseName) {
        if (!m3.isConcrete()) {
            return null;
        }
        JimpleBody jb = Jimple.v().newBody(m3);
        int nrInsn = this.instructions.size();
        this.nextLocal = this.maxLocals;
        this.locals = new LinkedHashMap<Integer, Local>(this.maxLocals + this.maxLocals / 2);
        this.labels = LinkedListMultimap.create(4);
        this.units = new LinkedHashMap<AbstractInsnNode, Unit>(nrInsn);
        this.frames = new LinkedHashMap<AbstractInsnNode, StackFrame>(nrInsn);
        this.trapHandlers = LinkedListMultimap.create(this.tryCatchBlocks.size());
        this.body = jb;
        for (TryCatchBlockNode tc : this.tryCatchBlocks) {
            this.trapHandlers.put(tc.handler, Jimple.v().newStmtBox(null));
        }
        try {
            this.convert();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to convert " + m3, t);
        }
        this.emitLocals();
        this.emitTraps();
        this.emitUnits();
        this.locals = null;
        this.labels = null;
        this.units = null;
        this.stack = null;
        this.frames = null;
        this.body = null;
        this.castAndReturnInliner.transform(jb);
        try {
            PackManager.v().getPack("jb").apply(jb);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to apply jb to " + m3, t);
        }
        return jb;
    }

    private final class Edge {
        final AbstractInsnNode insn;
        final LinkedList<Operand[]> prevStacks;
        private int lastLineNumber = -1;
        ArrayList<Operand> stack;

        Edge(AbstractInsnNode insn, ArrayList<Operand> stack) {
            this.insn = insn;
            this.prevStacks = new LinkedList();
            this.stack = stack;
        }

        Edge(AbstractInsnNode insn, int lastLineNumber) {
            this(insn, new ArrayList<Operand>(asmMethodSource.stack));
            this.lastLineNumber = lastLineNumber;
        }
    }
}

