/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import soot.PatchingChain;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.util.Chain;

public class UnitPatchingChain
extends PatchingChain<Unit> {
    public UnitPatchingChain(Chain<Unit> aChain) {
        super(aChain);
    }

    public void insertOnEdge(Unit toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge(Arrays.asList(toInsert), point_src, point_tgt);
    }

    public void insertOnEdge(Collection<? extends Unit> toInsert, Unit point_src, Unit point_tgt) {
        if (toInsert == null) {
            throw new RuntimeException("Bad idea! You tried to insert a null object into a Chain!");
        }
        if (point_src == null && point_tgt != null) {
            point_tgt.redirectJumpsToThisTo(toInsert.iterator().next());
            this.innerChain.insertBefore(toInsert, point_tgt);
            return;
        }
        if (point_src != null && point_tgt == null) {
            this.innerChain.insertAfter(toInsert, point_src);
            return;
        }
        if (point_src == null && point_tgt == null) {
            throw new RuntimeException("insertOnEdge failed! Both source unit and target points are null.");
        }
        if (this.getSuccOf(point_src) == point_tgt) {
            List<UnitBox> boxes = point_src.getUnitBoxes();
            for (UnitBox box : boxes) {
                if (box.getUnit() != point_tgt) continue;
                box.setUnit(toInsert.iterator().next());
            }
            this.innerChain.insertAfter(toInsert, point_src);
            return;
        }
        boolean validEdgeFound = false;
        Unit originalPred = this.getPredOf(point_tgt);
        List<UnitBox> boxes = point_src.getUnitBoxes();
        for (UnitBox box : boxes) {
            if (box.getUnit() != point_tgt) continue;
            if (point_src instanceof GotoStmt) {
                box.setUnit(toInsert.iterator().next());
                this.innerChain.insertAfter(toInsert, point_src);
                GotoStmt goto_unit = Jimple.v().newGotoStmt(point_tgt);
                if (toInsert instanceof List) {
                    List l = (List)toInsert;
                    this.innerChain.insertAfter(goto_unit, l.get(l.size() - 1));
                } else {
                    this.innerChain.insertAfter(goto_unit, (Unit)toInsert.toArray()[toInsert.size() - 1]);
                }
                return;
            }
            box.setUnit(toInsert.iterator().next());
            validEdgeFound = true;
        }
        if (validEdgeFound) {
            this.innerChain.insertBefore(toInsert, point_tgt);
            if (originalPred != point_src) {
                if (originalPred instanceof GotoStmt) {
                    return;
                }
                GotoStmt goto_unit = Jimple.v().newGotoStmt(point_tgt);
                this.innerChain.insertBefore(Arrays.asList(goto_unit), toInsert.iterator().next());
            }
            return;
        }
        Unit succ = this.getSuccOf(point_src);
        if (succ instanceof GotoStmt && succ.getUnitBoxes().get(0).getUnit() == point_tgt) {
            succ.redirectJumpsToThisTo(toInsert.iterator().next());
            this.innerChain.insertBefore(toInsert, succ);
            return;
        }
        throw new RuntimeException("insertOnEdge failed! No such edge found. The edge on which you want to insert an instrumentation is invalid.");
    }

    public void insertOnEdge(List<Unit> toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge((Collection<? extends Unit>)toInsert, point_src, point_tgt);
    }

    public void insertOnEdge(Chain<Unit> toInsert, Unit point_src, Unit point_tgt) {
        this.insertOnEdge((Collection<? extends Unit>)toInsert, point_src, point_tgt);
    }
}

