/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.AnonymousDecl;
import soot.JastAddJ.Block;
import soot.JastAddJ.ClassDecl;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.Opt;
import soot.JastAddJ.ParameterDeclaration;
import soot.JastAddJ.ParameterDeclarationSubstituted;
import soot.JastAddJ.Parameterization;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.VariableArityParameterDeclaration;
import soot.JastAddJ.VariableArityParameterDeclarationSubstituted;

public class List<T extends ASTNode>
extends ASTNode<T>
implements Cloneable {
    private boolean list$touched = true;

    @Override
    public void flushCache() {
        super.flushCache();
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public List<T> clone() throws CloneNotSupportedException {
        List node = (List)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public List<T> copy() {
        try {
            ASTNode node = this.clone();
            ((List)node).parent = null;
            if (this.children != null) {
                ((List)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public List<T> fullCopy() {
        ASTNode tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public List substitute(Parameterization parTypeDecl) {
        List<ASTNode> list = new List<ASTNode>();
        for (int i = 0; i < this.getNumChild(); ++i) {
            ParameterDeclaration p;
            Object node = this.getChild(i);
            if (node instanceof Access) {
                Access a = (Access)node;
                list.add(a.type().substitute(parTypeDecl));
                continue;
            }
            if (node instanceof VariableArityParameterDeclaration) {
                p = (VariableArityParameterDeclaration)node;
                list.add(new VariableArityParameterDeclarationSubstituted(((VariableArityParameterDeclaration)p).getModifiers().fullCopy(), ((VariableArityParameterDeclaration)p).getTypeAccess().type().substituteParameterType(parTypeDecl), ((VariableArityParameterDeclaration)p).getID(), (VariableArityParameterDeclaration)p));
                continue;
            }
            if (node instanceof ParameterDeclaration) {
                p = (ParameterDeclaration)node;
                list.add(new ParameterDeclarationSubstituted(p.getModifiers().fullCopy(), p.type().substituteParameterType(parTypeDecl), p.getID(), p));
                continue;
            }
            throw new Error("Can only substitute lists of access nodes but node number " + i + " is of type " + node.getClass().getName());
        }
        return list;
    }

    @Override
    public void init$Children() {
    }

    public List<T> add(T node) {
        this.addChild(node);
        return this;
    }

    @Override
    public void insertChild(ASTNode node, int i) {
        this.list$touched = true;
        super.insertChild(node, i);
    }

    @Override
    public void addChild(T node) {
        this.list$touched = true;
        super.addChild(node);
    }

    @Override
    public void removeChild(int i) {
        this.list$touched = true;
        super.removeChild(i);
    }

    @Override
    public int getNumChild() {
        if (this.list$touched) {
            for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
                this.getChild(i);
            }
            this.list$touched = false;
        }
        return this.getNumChildNoTransform();
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    public boolean requiresDefaultConstructor() {
        ASTNode$State state = this.state();
        if (this.getParent() instanceof ClassDecl) {
            ClassDecl c = (ClassDecl)this.getParent();
            return c.noConstructor() && c.getBodyDeclListNoTransform() == this && !(c instanceof AnonymousDecl);
        }
        return false;
    }

    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        return this.getParent().definesLabel();
    }

    @Override
    public ASTNode rewriteTo() {
        if (this.list$touched) {
            for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
                this.getChild(i);
            }
            this.list$touched = false;
            return this;
        }
        if (this.requiresDefaultConstructor()) {
            ++this.state().duringImplicitConstructor;
            List result = this.rewriteRule0();
            --this.state().duringImplicitConstructor;
            return result;
        }
        return super.rewriteTo();
    }

    private List rewriteRule0() {
        ClassDecl c = (ClassDecl)this.getParent();
        Modifiers m3 = new Modifiers();
        if (c.isPublic()) {
            m3.addModifier(new Modifier("public"));
        } else if (c.isProtected()) {
            m3.addModifier(new Modifier("protected"));
        } else if (c.isPrivate()) {
            m3.addModifier(new Modifier("private"));
        }
        ConstructorDecl constructor = new ConstructorDecl(m3, c.name(), new List<ParameterDeclaration>(), new List<Access>(), new Opt<Stmt>(), new Block());
        constructor.setDefaultConstructor();
        c.addBodyDecl(constructor);
        return this;
    }
}

