/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.NumericLiteral;
import soot.JastAddJ.TypeDecl;
import soot.Value;
import soot.jimple.FloatConstant;

public class FloatingPointLiteral
extends NumericLiteral
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;
    protected boolean isZero_computed = false;
    protected boolean isZero_value;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
        this.isZero_computed = false;
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public FloatingPointLiteral clone() throws CloneNotSupportedException {
        FloatingPointLiteral node = (FloatingPointLiteral)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.isZero_computed = false;
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public FloatingPointLiteral copy() {
        try {
            FloatingPointLiteral node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public FloatingPointLiteral fullCopy() {
        FloatingPointLiteral tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void typeCheck() {
        if (!this.isZero() && this.constant().floatValue() == 0.0f) {
            this.error("It is an error for nonzero floating-point " + this.getLITERAL() + " to round to zero");
        }
        if (this.constant().floatValue() == Float.NEGATIVE_INFINITY || this.constant().floatValue() == Float.POSITIVE_INFINITY) {
            this.error("It is an error for floating-point " + this.getLITERAL() + " to round to an infinity");
        }
    }

    @Override
    public Value eval(Body b) {
        return FloatConstant.v(this.constant().floatValue());
    }

    public FloatingPointLiteral() {
    }

    @Override
    public void init$Children() {
    }

    public FloatingPointLiteral(String p0) {
        this.setLITERAL(p0);
    }

    public FloatingPointLiteral(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return true;
    }

    @Override
    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    @Override
    public void setLITERAL(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol2.value;
        this.LITERALstart = symbol2.getStart();
        this.LITERALend = symbol2.getEnd();
    }

    @Override
    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    @Override
    public void toString(StringBuffer s2) {
        super.toString(s2);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeFloat();
    }

    public boolean isZero() {
        if (this.isZero_computed) {
            return this.isZero_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.isZero_value = this.isZero_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isZero_computed = true;
        }
        return this.isZero_value;
    }

    private boolean isZero_compute() {
        char c;
        for (int i = 0; i < this.digits.length() && (c = this.digits.charAt(i)) != 'e' && c != 'p'; ++i) {
            if (c == '0' || c == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        try {
            return Constant.create(Float.parseFloat(this.getDigits()));
        }
        catch (NumberFormatException e) {
            Constant c = Constant.create(0.0f);
            c.error = true;
            return c;
        }
    }

    @Override
    public boolean needsRewrite() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

