/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.AssignSimpleExpr;
import soot.JastAddJ.Block;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.BoundFieldAccess;
import soot.JastAddJ.Constant;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.ExprStmt;
import soot.JastAddJ.FieldDecl;
import soot.JastAddJ.FieldDeclarationSubstituted;
import soot.JastAddJ.InstanceInitializer;
import soot.JastAddJ.List;
import soot.JastAddJ.MemberDecl;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.Modifiers;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Opt;
import soot.JastAddJ.ParameterDeclaration;
import soot.JastAddJ.Parameterization;
import soot.JastAddJ.PrimitiveType;
import soot.JastAddJ.ReturnStmt;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.StaticInitializer;
import soot.JastAddJ.ThisAccess;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.VarAccess;
import soot.JastAddJ.Variable;
import soot.Scene;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;

public class FieldDeclaration
extends MemberDecl
implements Cloneable,
SimpleSet,
Iterator,
Variable {
    private FieldDeclaration iterElem;
    private FieldDecl fieldDecl = null;
    public SootField sootField;
    protected String tokenString_ID;
    public int IDstart;
    public int IDend;
    protected Map accessibleFrom_TypeDecl_values;
    protected boolean exceptions_computed = false;
    protected Collection exceptions_value;
    protected Map isDAafter_Variable_values;
    protected Map isDUafter_Variable_values;
    protected boolean constant_computed = false;
    protected Constant constant_value;
    protected boolean usesTypeVariable_computed = false;
    protected boolean usesTypeVariable_value;
    protected boolean sourceVariableDecl_computed = false;
    protected Variable sourceVariableDecl_value;
    protected boolean sootRef_computed = false;
    protected SootFieldRef sootRef_value;
    protected boolean throwTypes_computed = false;
    protected Collection<TypeDecl> throwTypes_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.accessibleFrom_TypeDecl_values = null;
        this.exceptions_computed = false;
        this.exceptions_value = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.constant_computed = false;
        this.constant_value = null;
        this.usesTypeVariable_computed = false;
        this.sourceVariableDecl_computed = false;
        this.sourceVariableDecl_value = null;
        this.sootRef_computed = false;
        this.sootRef_value = null;
        this.throwTypes_computed = false;
        this.throwTypes_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public FieldDeclaration clone() throws CloneNotSupportedException {
        FieldDeclaration node = (FieldDeclaration)super.clone();
        node.accessibleFrom_TypeDecl_values = null;
        node.exceptions_computed = false;
        node.exceptions_value = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.constant_computed = false;
        node.constant_value = null;
        node.usesTypeVariable_computed = false;
        node.sourceVariableDecl_computed = false;
        node.sourceVariableDecl_value = null;
        node.sootRef_computed = false;
        node.sootRef_value = null;
        node.throwTypes_computed = false;
        node.throwTypes_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public FieldDeclaration copy() {
        try {
            FieldDeclaration node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public FieldDeclaration fullCopy() {
        FieldDeclaration tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    public Access createQualifiedBoundAccess() {
        if (this.isStatic()) {
            return this.hostType().createQualifiedAccess().qualifiesAccess(new BoundFieldAccess(this));
        }
        return new ThisAccess("this").qualifiesAccess(new BoundFieldAccess(this));
    }

    public Access createBoundFieldAccess() {
        return this.createQualifiedBoundAccess();
    }

    @Override
    public SimpleSet add(Object o) {
        return new SimpleSet.SimpleSetImpl().add(this).add(o);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isSingleton(Object o) {
        return this.contains(o);
    }

    @Override
    public Iterator iterator() {
        this.iterElem = this;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterElem != null;
    }

    public Object next() {
        FieldDeclaration o = this.iterElem;
        this.iterElem = null;
        return o;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void definiteAssignment() {
        FieldDeclaration f;
        int i;
        super.definiteAssignment();
        if (this.isBlank() && this.isFinal() && this.isClassVariable()) {
            boolean found = false;
            TypeDecl typeDecl = this.hostType();
            for (i = 0; i < typeDecl.getNumBodyDecl(); ++i) {
                if (typeDecl.getBodyDecl(i) instanceof StaticInitializer) {
                    StaticInitializer s2 = (StaticInitializer)typeDecl.getBodyDecl(i);
                    if (!s2.isDAafter(this)) continue;
                    found = true;
                    continue;
                }
                if (!(typeDecl.getBodyDecl(i) instanceof FieldDeclaration) || !(f = (FieldDeclaration)typeDecl.getBodyDecl(i)).isStatic() || !f.isDAafter(this)) continue;
                found = true;
            }
            if (!found) {
                this.error("blank final class variable " + this.name() + " in " + this.hostType().typeName() + " is not definitely assigned in static initializer");
            }
        }
        if (this.isBlank() && this.isFinal() && this.isInstanceVariable()) {
            TypeDecl typeDecl = this.hostType();
            boolean found = false;
            for (i = 0; !found && i < typeDecl.getNumBodyDecl(); ++i) {
                InstanceInitializer ii;
                if (typeDecl.getBodyDecl(i) instanceof FieldDeclaration) {
                    f = (FieldDeclaration)typeDecl.getBodyDecl(i);
                    if (f.isStatic() || !f.isDAafter(this)) continue;
                    found = true;
                    continue;
                }
                if (!(typeDecl.getBodyDecl(i) instanceof InstanceInitializer) || !(ii = (InstanceInitializer)typeDecl.getBodyDecl(i)).getBlock().isDAafter(this)) continue;
                found = true;
            }
            Iterator iter = typeDecl.constructors().iterator();
            while (!found && iter.hasNext()) {
                ConstructorDecl c = (ConstructorDecl)iter.next();
                if (c.isDAafter(this)) continue;
                this.error("blank final instance variable " + this.name() + " in " + this.hostType().typeName() + " is not definitely assigned after " + c.signature());
            }
        }
        if (this.isBlank() && this.hostType().isInterfaceDecl()) {
            this.error("variable  " + this.name() + " in " + this.hostType().typeName() + " which is an interface must have an initializer");
        }
    }

    @Override
    public void checkModifiers() {
        super.checkModifiers();
        if (this.hostType().isInterfaceDecl()) {
            if (this.isProtected()) {
                this.error("an interface field may not be protected");
            }
            if (this.isPrivate()) {
                this.error("an interface field may not be private");
            }
            if (this.isTransient()) {
                this.error("an interface field may not be transient");
            }
            if (this.isVolatile()) {
                this.error("an interface field may not be volatile");
            }
        }
    }

    @Override
    public void nameCheck() {
        super.nameCheck();
        Iterator iter = this.hostType().memberFields(this.name()).iterator();
        while (iter.hasNext()) {
            Variable v = (Variable)iter.next();
            if (v == this || v.hostType() != this.hostType()) continue;
            this.error("field named " + this.name() + " is multiply declared in type " + this.hostType().typeName());
        }
    }

    public FieldDeclaration(Modifiers m3, Access type, String name) {
        this(m3, type, name, new Opt<Expr>());
    }

    public FieldDeclaration(Modifiers m3, Access type, String name, Expr init) {
        this(m3, type, name, new Opt<Expr>(init));
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.indent());
        this.getModifiers().toString(s2);
        this.getTypeAccess().toString(s2);
        s2.append(" " + this.name());
        if (this.hasInit()) {
            s2.append(" = ");
            this.getInit().toString(s2);
        }
        s2.append(";");
    }

    @Override
    public void typeCheck() {
        TypeDecl dest;
        TypeDecl source;
        if (this.hasInit() && !(source = this.getInit().type()).assignConversionTo(dest = this.type(), this.getInit())) {
            this.error("can not assign field " + this.name() + " of type " + dest.typeName() + " a value of type " + source.typeName());
        }
    }

    public FieldDecl getFieldDecl() {
        return this.fieldDecl;
    }

    public void setFieldDecl(FieldDecl fieldDecl) {
        this.fieldDecl = fieldDecl;
    }

    @Override
    public BodyDecl substitutedBodyDecl(Parameterization parTypeDecl) {
        FieldDeclarationSubstituted f = new FieldDeclarationSubstituted(this.getModifiers().fullCopy(), this.getTypeAccess().type().substituteReturnType(parTypeDecl), this.getID(), new Opt<Expr>(), this);
        return f;
    }

    public MethodDecl createAccessor(TypeDecl fieldQualifier) {
        MethodDecl m3 = (MethodDecl)fieldQualifier.getAccessor(this, "field_read");
        if (m3 != null) {
            return m3;
        }
        int accessorIndex = fieldQualifier.accessorCounter++;
        Modifiers modifiers = new Modifiers(new List<Modifier>());
        modifiers.addModifier(new Modifier("static"));
        modifiers.addModifier(new Modifier("synthetic"));
        modifiers.addModifier(new Modifier("public"));
        List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
        if (!this.isStatic()) {
            parameters.add(new ParameterDeclaration(fieldQualifier.createQualifiedAccess(), "that"));
        }
        m3 = new MethodDecl(modifiers, this.type().createQualifiedAccess(), "get$" + this.name() + "$access$" + accessorIndex, parameters, new List<Access>(), new Opt<Block>(new Block(new List<ReturnStmt>().add(new ReturnStmt(this.createAccess())))));
        m3 = fieldQualifier.addMemberMethod(m3);
        fieldQualifier.addAccessor(this, "field_read", m3);
        return m3;
    }

    public MethodDecl createAccessorWrite(TypeDecl fieldQualifier) {
        MethodDecl m3 = (MethodDecl)fieldQualifier.getAccessor(this, "field_write");
        if (m3 != null) {
            return m3;
        }
        int accessorIndex = fieldQualifier.accessorCounter++;
        Modifiers modifiers = new Modifiers(new List<Modifier>());
        modifiers.addModifier(new Modifier("static"));
        modifiers.addModifier(new Modifier("synthetic"));
        modifiers.addModifier(new Modifier("public"));
        List<ParameterDeclaration> parameters = new List<ParameterDeclaration>();
        if (!this.isStatic()) {
            parameters.add(new ParameterDeclaration(fieldQualifier.createQualifiedAccess(), "that"));
        }
        parameters.add(new ParameterDeclaration(this.type().createQualifiedAccess(), "value"));
        m3 = new MethodDecl(modifiers, this.type().createQualifiedAccess(), "set$" + this.name() + "$access$" + accessorIndex, parameters, new List<Access>(), new Opt<Block>(new Block(new List<ExprStmt>().add(new ExprStmt(new AssignSimpleExpr(this.createAccess(), new VarAccess("value")))).add((ExprStmt)((Object)new ReturnStmt(new Opt<Expr>(new VarAccess("value"))))))));
        m3 = fieldQualifier.addMemberMethod(m3);
        fieldQualifier.addAccessor(this, "field_write", m3);
        return m3;
    }

    private Access createAccess() {
        BoundFieldAccess fieldAccess = new BoundFieldAccess(this);
        return this.isStatic() ? fieldAccess : new VarAccess("that").qualifiesAccess(fieldAccess);
    }

    @Override
    public void jimplify1phase2() {
        String name = this.name();
        Type type = this.type().getSootType();
        int modifiers = this.sootTypeModifiers();
        if (!this.hostType().getSootClassDecl().declaresFieldByName(name)) {
            SootField f = Scene.v().makeSootField(name, type, modifiers);
            this.hostType().getSootClassDecl().addField(f);
            if (this.isStatic() && this.isFinal() && this.isConstant() && (this.type().isPrimitive() || this.type().isString())) {
                if (this.type().isString()) {
                    f.addTag(new StringConstantValueTag(this.constant().stringValue()));
                } else if (this.type().isLong()) {
                    f.addTag(new LongConstantValueTag(this.constant().longValue()));
                } else if (this.type().isDouble()) {
                    f.addTag(new DoubleConstantValueTag(this.constant().doubleValue()));
                } else if (this.type().isFloat()) {
                    f.addTag(new FloatConstantValueTag(this.constant().floatValue()));
                } else if (this.type().isIntegralType()) {
                    f.addTag(new IntegerConstantValueTag(this.constant().intValue()));
                }
            }
            this.sootField = f;
        } else {
            this.sootField = this.hostType().getSootClassDecl().getFieldByName(name);
        }
        this.addAttributes();
    }

    @Override
    public void addAttributes() {
        super.addAttributes();
        ArrayList c = new ArrayList();
        this.getModifiers().addRuntimeVisibleAnnotationsAttribute(c);
        this.getModifiers().addRuntimeInvisibleAnnotationsAttribute(c);
        this.getModifiers().addSourceOnlyAnnotations(c);
        for (Tag tag : c) {
            this.sootField.addTag(tag);
        }
    }

    @Override
    public void checkWarnings() {
        if (this.hasInit() && !this.suppressWarnings("unchecked")) {
            this.checkUncheckedConversion(this.getInit().type(), this.type());
        }
    }

    public FieldDeclaration() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[3];
        this.setChild(new Opt(), 2);
    }

    public FieldDeclaration(Modifiers p0, Access p1, String p2, Opt<Expr> p3) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setID(p2);
        this.setChild(p3, 2);
    }

    public FieldDeclaration(Modifiers p0, Access p1, Symbol p2, Opt<Expr> p3) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
        this.setID(p2);
        this.setChild(p3, 2);
    }

    @Override
    protected int numChildren() {
        return 3;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setModifiers(Modifiers node) {
        this.setChild(node, 0);
    }

    @Override
    public Modifiers getModifiers() {
        return (Modifiers)this.getChild(0);
    }

    public Modifiers getModifiersNoTransform() {
        return (Modifiers)this.getChildNoTransform(0);
    }

    public void setTypeAccess(Access node) {
        this.setChild(node, 1);
    }

    public Access getTypeAccess() {
        return (Access)this.getChild(1);
    }

    public Access getTypeAccessNoTransform() {
        return (Access)this.getChildNoTransform(1);
    }

    public void setID(String value) {
        this.tokenString_ID = value;
    }

    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setInitOpt(Opt<Expr> opt) {
        this.setChild(opt, 2);
    }

    @Override
    public boolean hasInit() {
        return this.getInitOpt().getNumChild() != 0;
    }

    @Override
    public Expr getInit() {
        return (Expr)this.getInitOpt().getChild(0);
    }

    public void setInit(Expr node) {
        this.getInitOpt().setChild(node, 0);
    }

    public Opt<Expr> getInitOpt() {
        return (Opt)this.getChild(2);
    }

    public Opt<Expr> getInitOptNoTransform() {
        return (Opt)this.getChildNoTransform(2);
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        return this.isFinal() && this.hasInit() && this.getInit().isConstant() && (this.type() instanceof PrimitiveType || this.type().isString());
    }

    public boolean accessibleFrom(TypeDecl type) {
        TypeDecl _parameters = type;
        if (this.accessibleFrom_TypeDecl_values == null) {
            this.accessibleFrom_TypeDecl_values = new HashMap(4);
        }
        if (this.accessibleFrom_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.accessibleFrom_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean accessibleFrom_TypeDecl_value = this.accessibleFrom_compute(type);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.accessibleFrom_TypeDecl_values.put(_parameters, accessibleFrom_TypeDecl_value);
        }
        return accessibleFrom_TypeDecl_value;
    }

    private boolean accessibleFrom_compute(TypeDecl type) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isProtected()) {
            if (this.hostPackage().equals(type.hostPackage())) {
                return true;
            }
            return type.withinBodyThatSubclasses(this.hostType()) != null;
        }
        if (this.isPrivate()) {
            return this.hostType().topLevelType() == type.topLevelType();
        }
        return this.hostPackage().equals(type.hostPackage());
    }

    public Collection exceptions() {
        if (this.exceptions_computed) {
            return this.exceptions_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.exceptions_value = this.exceptions_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.exceptions_computed = true;
        }
        return this.exceptions_value;
    }

    private Collection exceptions_compute() {
        HashSet set = new HashSet();
        if (this.isInstanceVariable() && this.hasInit()) {
            this.collectExceptions(set, this);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                TypeDecl typeDecl = (TypeDecl)iter.next();
                if (this.getInit().reachedException(typeDecl)) continue;
                iter.remove();
            }
        }
        return set;
    }

    @Override
    public int size() {
        ASTNode$State state = this.state();
        return 1;
    }

    @Override
    public boolean isEmpty() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean contains(Object o) {
        ASTNode$State state = this.state();
        return this == o;
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        if (v == this) {
            return this.hasInit();
        }
        return this.hasInit() ? this.getInit().isDAafter(v) : this.isDAbefore(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        if (v == this) {
            return !this.hasInit();
        }
        return this.hasInit() ? this.getInit().isDUafter(v) : this.isDUbefore(v);
    }

    @Override
    public boolean isSynthetic() {
        ASTNode$State state = this.state();
        return this.getModifiers().isSynthetic();
    }

    public boolean isPublic() {
        ASTNode$State state = this.state();
        return this.getModifiers().isPublic() || this.hostType().isInterfaceDecl();
    }

    public boolean isPrivate() {
        ASTNode$State state = this.state();
        return this.getModifiers().isPrivate();
    }

    public boolean isProtected() {
        ASTNode$State state = this.state();
        return this.getModifiers().isProtected();
    }

    @Override
    public boolean isStatic() {
        ASTNode$State state = this.state();
        return this.getModifiers().isStatic() || this.hostType().isInterfaceDecl();
    }

    @Override
    public boolean isFinal() {
        ASTNode$State state = this.state();
        return this.getModifiers().isFinal() || this.hostType().isInterfaceDecl();
    }

    public boolean isTransient() {
        ASTNode$State state = this.state();
        return this.getModifiers().isTransient();
    }

    @Override
    public boolean isVolatile() {
        ASTNode$State state = this.state();
        return this.getModifiers().isVolatile();
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getID() + "]";
    }

    @Override
    public TypeDecl type() {
        ASTNode$State state = this.state();
        return this.getTypeAccess().type();
    }

    @Override
    public boolean isVoid() {
        ASTNode$State state = this.state();
        return this.type().isVoid();
    }

    @Override
    public boolean isParameter() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean isClassVariable() {
        ASTNode$State state = this.state();
        return this.isStatic() || this.hostType().isInterfaceDecl();
    }

    @Override
    public boolean isInstanceVariable() {
        ASTNode$State state = this.state();
        return (this.hostType().isClassDecl() || this.hostType().isAnonymous()) && !this.isStatic();
    }

    @Override
    public boolean isMethodParameter() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean isConstructorParameter() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean isExceptionHandlerParameter() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean isLocalVariable() {
        ASTNode$State state = this.state();
        return false;
    }

    @Override
    public boolean isBlank() {
        ASTNode$State state = this.state();
        return !this.hasInit();
    }

    @Override
    public String name() {
        ASTNode$State state = this.state();
        return this.getID();
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        return this.type().cast(this.getInit().constant());
    }

    @Override
    public boolean hasAnnotationSuppressWarnings(String s2) {
        ASTNode$State state = this.state();
        return this.getModifiers().hasAnnotationSuppressWarnings(s2);
    }

    @Override
    public boolean isDeprecated() {
        ASTNode$State state = this.state();
        return this.getModifiers().hasDeprecatedAnnotation();
    }

    @Override
    public boolean usesTypeVariable() {
        if (this.usesTypeVariable_computed) {
            return this.usesTypeVariable_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.usesTypeVariable_value = this.usesTypeVariable_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.usesTypeVariable_computed = true;
        }
        return this.usesTypeVariable_value;
    }

    private boolean usesTypeVariable_compute() {
        return this.getTypeAccess().usesTypeVariable();
    }

    @Override
    public Variable sourceVariableDecl() {
        if (this.sourceVariableDecl_computed) {
            return this.sourceVariableDecl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sourceVariableDecl_value = this.sourceVariableDecl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sourceVariableDecl_computed = true;
        }
        return this.sourceVariableDecl_value;
    }

    private Variable sourceVariableDecl_compute() {
        return this;
    }

    @Override
    public boolean visibleTypeParameters() {
        ASTNode$State state = this.state();
        return !this.isStatic();
    }

    public int sootTypeModifiers() {
        ASTNode$State state = this.state();
        int result = 0;
        if (this.isPublic()) {
            result |= 1;
        }
        if (this.isProtected()) {
            result |= 4;
        }
        if (this.isPrivate()) {
            result |= 2;
        }
        if (this.isFinal()) {
            result |= 0x10;
        }
        if (this.isStatic()) {
            result |= 8;
        }
        return result;
    }

    public SootFieldRef sootRef() {
        if (this.sootRef_computed) {
            return this.sootRef_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.sootRef_value = this.sootRef_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.sootRef_computed = true;
        }
        return this.sootRef_value;
    }

    private SootFieldRef sootRef_compute() {
        return Scene.v().makeFieldRef(this.hostType().getSootClassDecl(), this.name(), this.type().getSootType(), this.isStatic());
    }

    public FieldDeclaration erasedField() {
        ASTNode$State state = this.state();
        return this;
    }

    @Override
    public Collection<TypeDecl> throwTypes() {
        if (this.throwTypes_computed) {
            return this.throwTypes_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.throwTypes_value = this.throwTypes_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.throwTypes_computed = true;
        }
        return this.throwTypes_value;
    }

    private Collection<TypeDecl> throwTypes_compute() {
        LinkedList<TypeDecl> tts = new LinkedList<TypeDecl>();
        tts.add(this.type());
        return tts;
    }

    @Override
    public boolean hasAnnotationSafeVarargs() {
        ASTNode$State state = this.state();
        return this.getModifiers().hasAnnotationSafeVarargs();
    }

    public boolean suppressWarnings(String type) {
        ASTNode$State state = this.state();
        return this.hasAnnotationSuppressWarnings(type) || this.withinSuppressWarnings(type);
    }

    public boolean handlesException(TypeDecl exceptionType) {
        ASTNode$State state = this.state();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        return handlesException_TypeDecl_value;
    }

    public boolean withinSuppressWarnings(String s2) {
        ASTNode$State state = this.state();
        boolean withinSuppressWarnings_String_value = this.getParent().Define_boolean_withinSuppressWarnings(this, null, s2);
        return withinSuppressWarnings_String_value;
    }

    @Override
    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        if (caller == this.getInitOptNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getInitOptNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getInitOptNoTransform()) {
            if (this.hostType().isAnonymous()) {
                return true;
            }
            if (!exceptionType.isUncheckedException()) {
                return true;
            }
            for (ConstructorDecl decl : this.hostType().constructors()) {
                if (decl.throwsException(exceptionType)) continue;
                return false;
            }
            return true;
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeStatic(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeFinal(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeTransient(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeTransient(this, caller);
    }

    @Override
    public boolean Define_boolean_mayBeVolatile(ASTNode caller, ASTNode child) {
        if (caller == this.getModifiersNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_mayBeVolatile(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getTypeAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        if (caller == this.getInitOptNoTransform()) {
            return this.type();
        }
        return this.getParent().Define_TypeDecl_declType(this, caller);
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        if (caller == this.getInitOptNoTransform()) {
            return this.isStatic() || this.hostType().isInterfaceDecl();
        }
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    @Override
    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        if (caller == this.getModifiersNoTransform()) {
            return name.equals("FIELD");
        }
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    @Override
    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        if (caller == this.getInitOptNoTransform()) {
            return this.type();
        }
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    @Override
    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        if (caller == this.getInitOptNoTransform()) {
            return this.type().componentType();
        }
        return this.getParent().Define_TypeDecl_expectedType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

