/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Access;
import soot.JastAddJ.AnnotationDecl;
import soot.JastAddJ.AnnotationMethodDecl;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.ElementConstantValue;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.ElementValuePair;
import soot.JastAddJ.List;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.Modifier;
import soot.JastAddJ.NameType;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationTag;

public class Annotation
extends Modifier
implements Cloneable {
    protected boolean decl_computed = false;
    protected TypeDecl decl_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.decl_computed = false;
        this.decl_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Annotation clone() throws CloneNotSupportedException {
        Annotation node = (Annotation)super.clone();
        node.decl_computed = false;
        node.decl_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public Annotation copy() {
        try {
            Annotation node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    @Override
    public Annotation fullCopy() {
        Annotation tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void checkModifiers() {
        ElementValue v;
        AnnotationDecl T;
        Annotation m3;
        super.checkModifiers();
        if (this.decl() instanceof AnnotationDecl && (m3 = (T = (AnnotationDecl)this.decl()).annotation(this.lookupType("java.lang.annotation", "Target"))) != null && m3.getNumElementValuePair() == 1 && m3.getElementValuePair(0).getName().equals("value") && !(v = m3.getElementValuePair(0).getElementValue()).validTarget(this)) {
            this.error("annotation type " + T.typeName() + " is not applicable to this kind of declaration");
        }
    }

    @Override
    public void typeCheck() {
        if (!this.decl().isAnnotationDecl()) {
            if (!this.decl().isUnknown()) {
                this.error(this.decl().typeName() + " is not an annotation type");
            }
        } else {
            int i;
            TypeDecl typeDecl = this.decl();
            if (this.lookupAnnotation(typeDecl) != this) {
                this.error("duplicate annotation " + typeDecl.typeName());
            }
            for (i = 0; i < typeDecl.getNumBodyDecl(); ++i) {
                MethodDecl decl;
                if (!(typeDecl.getBodyDecl(i) instanceof MethodDecl) || this.elementValueFor((decl = (MethodDecl)typeDecl.getBodyDecl(i)).name()) != null || decl instanceof AnnotationMethodDecl && ((AnnotationMethodDecl)decl).hasDefaultValue()) continue;
                this.error("missing value for " + decl.name());
            }
            for (i = 0; i < this.getNumElementValuePair(); ++i) {
                ElementValuePair pair = this.getElementValuePair(i);
                if (!typeDecl.memberMethods(pair.getName()).isEmpty()) continue;
                this.error("can not find element named " + pair.getName() + " in " + typeDecl.typeName());
            }
        }
        this.checkOverride();
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append("@");
        this.getAccess().toString(s2);
        s2.append("(");
        for (int i = 0; i < this.getNumElementValuePair(); ++i) {
            if (i != 0) {
                s2.append(", ");
            }
            this.getElementValuePair(i).toString(s2);
        }
        s2.append(")");
    }

    public void appendAsAttributeTo(Collection list) {
        AnnotationTag tag = new AnnotationTag(this.decl().typeDescriptor(), this.getNumElementValuePair());
        ArrayList<AnnotationElem> elements = new ArrayList<AnnotationElem>(this.getNumElementValuePair());
        for (int i = 0; i < this.getNumElementValuePair(); ++i) {
            String name = this.getElementValuePair(i).getName();
            ElementValue value = this.getElementValuePair(i).getElementValue();
            value.appendAsAttributeTo(elements, name);
        }
        tag.setElems(elements);
        list.add(tag);
    }

    public Annotation() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
        this.setChild(new List(), 1);
    }

    public Annotation(String p0, Access p1, List<ElementValuePair> p2) {
        this.setID(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    public Annotation(Symbol p0, Access p1, List<ElementValuePair> p2) {
        this.setID(p0);
        this.setChild(p1, 0);
        this.setChild(p2, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setID(String value) {
        this.tokenString_ID = value;
    }

    @Override
    public void setID(Symbol symbol2) {
        if (symbol2.value != null && !(symbol2.value instanceof String)) {
            throw new UnsupportedOperationException("setID is only valid for String lexemes");
        }
        this.tokenString_ID = (String)symbol2.value;
        this.IDstart = symbol2.getStart();
        this.IDend = symbol2.getEnd();
    }

    @Override
    public String getID() {
        return this.tokenString_ID != null ? this.tokenString_ID : "";
    }

    public void setAccess(Access node) {
        this.setChild(node, 0);
    }

    public Access getAccess() {
        return (Access)this.getChild(0);
    }

    public Access getAccessNoTransform() {
        return (Access)this.getChildNoTransform(0);
    }

    public void setElementValuePairList(List<ElementValuePair> list) {
        this.setChild(list, 1);
    }

    public int getNumElementValuePair() {
        return this.getElementValuePairList().getNumChild();
    }

    public int getNumElementValuePairNoTransform() {
        return this.getElementValuePairListNoTransform().getNumChildNoTransform();
    }

    public ElementValuePair getElementValuePair(int i) {
        return (ElementValuePair)this.getElementValuePairList().getChild(i);
    }

    public void addElementValuePair(ElementValuePair node) {
        List<ElementValuePair> list = this.parent == null || state == null ? this.getElementValuePairListNoTransform() : this.getElementValuePairList();
        list.addChild(node);
    }

    public void addElementValuePairNoTransform(ElementValuePair node) {
        List<ElementValuePair> list = this.getElementValuePairListNoTransform();
        list.addChild(node);
    }

    public void setElementValuePair(ElementValuePair node, int i) {
        List<ElementValuePair> list = this.getElementValuePairList();
        list.setChild(node, i);
    }

    public List<ElementValuePair> getElementValuePairs() {
        return this.getElementValuePairList();
    }

    public List<ElementValuePair> getElementValuePairsNoTransform() {
        return this.getElementValuePairListNoTransform();
    }

    public List<ElementValuePair> getElementValuePairList() {
        List list = (List)this.getChild(1);
        list.getNumChild();
        return list;
    }

    public List<ElementValuePair> getElementValuePairListNoTransform() {
        return (List)this.getChildNoTransform(1);
    }

    public void checkOverride() {
        if (this.decl().fullName().equals("java.lang.Override") && this.enclosingBodyDecl() instanceof MethodDecl) {
            TypeDecl typeObject;
            SimpleSet overrides;
            MethodDecl method = (MethodDecl)this.enclosingBodyDecl();
            TypeDecl host = method.hostType();
            SimpleSet ancestors = host.ancestorMethods(method.signature());
            boolean found = false;
            Iterator iter = ancestors.iterator();
            while (iter.hasNext()) {
                MethodDecl decl = (MethodDecl)iter.next();
                if (!method.overrides(decl)) continue;
                found = true;
                break;
            }
            if (!(found || !(overrides = (typeObject = this.lookupType("java.lang", "Object")).localMethodsSignature(method.signature())).isEmpty() && ((MethodDecl)overrides.iterator().next()).isPublic())) {
                this.error("method does not override a method from a supertype");
            }
        }
    }

    public TypeDecl decl() {
        if (this.decl_computed) {
            return this.decl_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.decl_value = this.decl_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.decl_computed = true;
        }
        return this.decl_value;
    }

    private TypeDecl decl_compute() {
        return this.getAccess().type();
    }

    public ElementValue elementValueFor(String name) {
        ASTNode$State state = this.state();
        for (int i = 0; i < this.getNumElementValuePair(); ++i) {
            ElementValuePair pair = this.getElementValuePair(i);
            if (!pair.getName().equals(name)) continue;
            return pair.getElementValue();
        }
        return null;
    }

    public TypeDecl type() {
        ASTNode$State state = this.state();
        return this.getAccess().type();
    }

    public boolean isMetaAnnotation() {
        ASTNode$State state = this.state();
        return this.hostType().isAnnotationDecl();
    }

    @Override
    public boolean isRuntimeVisible() {
        ASTNode$State state = this.state();
        Annotation a = this.decl().annotation(this.lookupType("java.lang.annotation", "Retention"));
        if (a == null) {
            return false;
        }
        ElementConstantValue value = (ElementConstantValue)a.getElementValuePair(0).getElementValue();
        Variable v = value.getExpr().varDecl();
        return v != null && v.name().equals("RUNTIME");
    }

    @Override
    public boolean isRuntimeInvisible() {
        ASTNode$State state = this.state();
        Annotation a = this.decl().annotation(this.lookupType("java.lang.annotation", "Retention"));
        if (a == null) {
            return true;
        }
        ElementConstantValue value = (ElementConstantValue)a.getElementValuePair(0).getElementValue();
        Variable v = value.getExpr().varDecl();
        return v != null && v.name().equals("CLASS");
    }

    public TypeDecl lookupType(String packageName, String typeName) {
        ASTNode$State state = this.state();
        TypeDecl lookupType_String_String_value = this.getParent().Define_TypeDecl_lookupType(this, null, packageName, typeName);
        return lookupType_String_String_value;
    }

    public boolean mayUseAnnotationTarget(String name) {
        ASTNode$State state = this.state();
        boolean mayUseAnnotationTarget_String_value = this.getParent().Define_boolean_mayUseAnnotationTarget(this, null, name);
        return mayUseAnnotationTarget_String_value;
    }

    public BodyDecl enclosingBodyDecl() {
        ASTNode$State state = this.state();
        BodyDecl enclosingBodyDecl_value = this.getParent().Define_BodyDecl_enclosingBodyDecl(this, null);
        return enclosingBodyDecl_value;
    }

    public Annotation lookupAnnotation(TypeDecl typeDecl) {
        ASTNode$State state = this.state();
        Annotation lookupAnnotation_TypeDecl_value = this.getParent().Define_Annotation_lookupAnnotation(this, null, typeDecl);
        return lookupAnnotation_TypeDecl_value;
    }

    public TypeDecl hostType() {
        ASTNode$State state = this.state();
        TypeDecl hostType_value = this.getParent().Define_TypeDecl_hostType(this, null);
        return hostType_value;
    }

    @Override
    public TypeDecl Define_TypeDecl_enclosingAnnotationDecl(ASTNode caller, ASTNode child) {
        if (caller == this.getElementValuePairListNoTransform()) {
            int childIndex = caller.getIndexOfChild(child);
            return this.decl();
        }
        return this.getParent().Define_TypeDecl_enclosingAnnotationDecl(this, caller);
    }

    @Override
    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        if (caller == this.getAccessNoTransform()) {
            return NameType.TYPE_NAME;
        }
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

