/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Timers;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.VoidType;
import soot.baf.DoubleWordType;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Attribute;
import soot.tagkit.Base64;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toolkits.graph.Block;
import soot.util.StringTools;

public abstract class AbstractJasminClass {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJasminClass.class);
    protected Map<Unit, String> unitToLabel;
    protected Map<Local, Integer> localToSlot;
    protected Map<Unit, Integer> subroutineToReturnAddressSlot;
    protected List<String> code;
    protected boolean isEmittingMethodCode;
    protected int labelCount;
    protected boolean isNextGotoAJsr;
    protected int returnAddressSlot;
    protected int currentStackHeight = 0;
    protected int maxStackHeight = 0;
    protected Map<Local, Object> localToGroup;
    protected Map<Object, Integer> groupToColorCount;
    protected Map<Local, Integer> localToColor;
    protected Map<Block, Integer> blockToStackHeight = new HashMap<Block, Integer>();
    protected Map<Block, Integer> blockToLogicalStackHeight = new HashMap<Block, Integer>();
    private static Map<Integer, VisibilityAnnotationTag> safeVats = new HashMap<Integer, VisibilityAnnotationTag>();

    public static String slashify(String s2) {
        return s2.replace('.', '/');
    }

    public static int sizeOfType(Type t) {
        if (t instanceof DoubleWordType || t instanceof LongType || t instanceof DoubleType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    public static int argCountOf(SootMethodRef m3) {
        int argCount = 0;
        for (Type t : m3.parameterTypes()) {
            argCount += AbstractJasminClass.sizeOfType(t);
        }
        return argCount;
    }

    public static String jasminDescriptorOf(Type type) {
        TypeSwitch sw = new TypeSwitch(){

            @Override
            public void caseBooleanType(BooleanType t) {
                this.setResult("Z");
            }

            @Override
            public void caseByteType(ByteType t) {
                this.setResult("B");
            }

            @Override
            public void caseCharType(CharType t) {
                this.setResult("C");
            }

            @Override
            public void caseDoubleType(DoubleType t) {
                this.setResult("D");
            }

            @Override
            public void caseFloatType(FloatType t) {
                this.setResult("F");
            }

            @Override
            public void caseIntType(IntType t) {
                this.setResult("I");
            }

            @Override
            public void caseLongType(LongType t) {
                this.setResult("J");
            }

            @Override
            public void caseShortType(ShortType t) {
                this.setResult("S");
            }

            @Override
            public void defaultCase(Type t) {
                throw new RuntimeException("Invalid type: " + t);
            }

            @Override
            public void caseArrayType(ArrayType t) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < t.numDimensions; ++i) {
                    buffer.append("[");
                }
                this.setResult(buffer.toString() + AbstractJasminClass.jasminDescriptorOf(t.baseType));
            }

            @Override
            public void caseRefType(RefType t) {
                this.setResult("L" + t.getClassName().replace('.', '/') + ";");
            }

            @Override
            public void caseVoidType(VoidType t) {
                this.setResult("V");
            }
        };
        type.apply(sw);
        return (String)sw.getResult();
    }

    public static String jasminDescriptorOf(SootMethodRef m3) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (Type t : m3.parameterTypes()) {
            buffer.append(AbstractJasminClass.jasminDescriptorOf(t));
        }
        buffer.append(")");
        buffer.append(AbstractJasminClass.jasminDescriptorOf(m3.returnType()));
        return buffer.toString();
    }

    protected void emit(String s2) {
        this.okayEmit(s2);
    }

    protected void okayEmit(String s2) {
        if (this.isEmittingMethodCode && !s2.endsWith(":")) {
            this.code.add("    " + s2);
        } else {
            this.code.add(s2);
        }
    }

    private String getVisibilityAnnotationAttr(VisibilityAnnotationTag tag) {
        StringBuffer sb = new StringBuffer();
        if (tag == null) {
            return "";
        }
        if (tag.getVisibility() == 0) {
            sb.append(".runtime_visible_annotation\n");
        } else if (tag.getVisibility() == 1) {
            sb.append(".runtime_invisible_annotation\n");
        } else {
            return "";
        }
        if (tag.hasAnnotations()) {
            for (AnnotationTag annot : tag.getAnnotations()) {
                sb.append(".annotation ");
                sb.append(StringTools.getQuotedStringOf(annot.getType()) + "\n");
                for (AnnotationElem ae : annot.getElems()) {
                    sb.append(this.getElemAttr(ae));
                }
                sb.append(".end .annotation\n");
            }
        }
        sb.append(".end .annotation_attr\n");
        return sb.toString();
    }

    private String getVisibilityParameterAnnotationAttr(VisibilityParameterAnnotationTag tag) {
        StringBuffer sb = new StringBuffer();
        sb.append(".param ");
        if (tag.getKind() == 0) {
            sb.append(".runtime_visible_annotation\n");
        } else {
            sb.append(".runtime_invisible_annotation\n");
        }
        ArrayList<VisibilityAnnotationTag> vis_list = tag.getVisibilityAnnotations();
        if (vis_list != null) {
            for (VisibilityAnnotationTag vat : vis_list) {
                VisibilityAnnotationTag safeVat = vat == null ? this.getSafeVisibilityAnnotationTag(tag.getKind()) : vat;
                sb.append(this.getVisibilityAnnotationAttr(safeVat));
            }
        }
        sb.append(".end .param\n");
        return sb.toString();
    }

    private VisibilityAnnotationTag getSafeVisibilityAnnotationTag(int kind) {
        VisibilityAnnotationTag safeVat = safeVats.get(kind);
        if (safeVat == null) {
            safeVat = new VisibilityAnnotationTag(kind);
            safeVats.put(kind, safeVat);
        }
        return safeVat;
    }

    private String getElemAttr(AnnotationElem elem) {
        StringBuffer result = new StringBuffer(".elem ");
        switch (elem.getKind()) {
            case 'Z': {
                result.append(".bool_kind ");
                result.append("\"" + elem.getName() + "\" ");
                if (elem instanceof AnnotationIntElem) {
                    result.append(((AnnotationIntElem)elem).getValue());
                } else if (((AnnotationBooleanElem)elem).getValue()) {
                    result.append(1);
                } else {
                    result.append(0);
                }
                result.append("\n");
                break;
            }
            case 'S': {
                result.append(".short_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'B': {
                result.append(".byte_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'C': {
                result.append(".char_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'I': {
                result.append(".int_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationIntElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'J': {
                result.append(".long_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationLongElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'F': {
                result.append(".float_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationFloatElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 'D': {
                result.append(".doub_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(((AnnotationDoubleElem)elem).getValue());
                result.append("\n");
                break;
            }
            case 's': {
                result.append(".str_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationStringElem)elem).getValue()));
                result.append("\n");
                break;
            }
            case 'e': {
                result.append(".enum_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationEnumElem)elem).getTypeName()));
                result.append(" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationEnumElem)elem).getConstantName()));
                result.append("\n");
                break;
            }
            case 'c': {
                result.append(".cls_kind ");
                result.append("\"" + elem.getName() + "\" ");
                result.append(StringTools.getQuotedStringOf(((AnnotationClassElem)elem).getDesc()));
                result.append("\n");
                break;
            }
            case '[': {
                result.append(".arr_kind ");
                result.append("\"" + elem.getName() + "\" ");
                AnnotationArrayElem arrayElem = (AnnotationArrayElem)elem;
                result.append("\n");
                for (int i = 0; i < arrayElem.getNumValues(); ++i) {
                    result.append(this.getElemAttr(arrayElem.getValueAt(i)));
                }
                result.append(".end .arr_elem\n");
                break;
            }
            case '@': {
                result.append(".ann_kind ");
                result.append("\"" + elem.getName() + "\"\n");
                AnnotationTag annot = ((AnnotationAnnotationElem)elem).getValue();
                result.append(".annotation ");
                result.append(StringTools.getQuotedStringOf(annot.getType()) + "\n");
                for (AnnotationElem ae : annot.getElems()) {
                    result.append(this.getElemAttr(ae));
                }
                result.append(".end .annotation\n");
                result.append(".end .annot_elem\n");
                break;
            }
            default: {
                throw new RuntimeException("Unknown Elem Attr Kind: " + elem.getKind());
            }
        }
        return result.toString();
    }

    public AbstractJasminClass(SootClass sootClass) {
        InnerClassAttribute ica;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        if (Options.v().verbose()) {
            logger.debug("[" + sootClass.getName() + "] Constructing baf.JasminClass...");
        }
        this.code = new LinkedList<String>();
        int modifiers = sootClass.getModifiers();
        if (sootClass.getTag("SourceFileTag") != null && !Options.v().no_output_source_file_attribute()) {
            String srcName = ((SourceFileTag)sootClass.getTag("SourceFileTag")).getSourceFile();
            if (File.separatorChar == '\\') {
                srcName = srcName.replace('\\', '/');
            }
            srcName = StringTools.getEscapedStringOf(srcName);
            if (!Options.v().android_jars().isEmpty() && !srcName.isEmpty() && Character.isDigit(srcName.charAt(0))) {
                srcName = "n_" + srcName;
            }
            srcName = srcName.replace(" ", "-");
            if (!(srcName = srcName.replace("\"", "")).isEmpty()) {
                this.emit(".source " + srcName);
            }
        }
        if (Modifier.isInterface(modifiers)) {
            this.emit(".interface " + Modifier.toString(modifiers -= 512) + " " + AbstractJasminClass.slashify(sootClass.getName()));
        } else {
            this.emit(".class " + Modifier.toString(modifiers) + " " + AbstractJasminClass.slashify(sootClass.getName()));
        }
        if (sootClass.hasSuperclass()) {
            this.emit(".super " + AbstractJasminClass.slashify(sootClass.getSuperclass().getName()));
        } else {
            this.emit(".no_super");
        }
        this.emit("");
        for (SootClass inter : sootClass.getInterfaces()) {
            this.emit(".implements " + AbstractJasminClass.slashify(inter.getName()));
        }
        for (Tag tag : sootClass.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".class_attribute " + tag.getName() + " \"" + new String(Base64.encode(((Attribute)tag).getValue())) + "\"");
        }
        if (sootClass.hasTag("SyntheticTag") || Modifier.isSynthetic(sootClass.getModifiers())) {
            this.emit(".synthetic\n");
        }
        if ((ica = (InnerClassAttribute)sootClass.getTag("InnerClassAttribute")) != null && ica.getSpecs().size() > 0 && !Options.v().no_output_inner_classes_attribute()) {
            this.emit(".inner_class_attr ");
            for (InnerClassTag ict : ((InnerClassAttribute)sootClass.getTag("InnerClassAttribute")).getSpecs()) {
                this.emit(".inner_class_spec_attr \"" + ict.getInnerClass() + "\" \"" + ict.getOuterClass() + "\" \"" + ict.getShortName() + "\" " + Modifier.toString(ict.getAccessFlags()) + " .end .inner_class_spec_attr");
            }
            this.emit(".end .inner_class_attr\n");
        }
        if (sootClass.hasTag("EnclosingMethodTag")) {
            String encMeth = ".enclosing_method_attr ";
            EnclosingMethodTag eMethTag = (EnclosingMethodTag)sootClass.getTag("EnclosingMethodTag");
            encMeth = encMeth + "\"" + eMethTag.getEnclosingClass() + "\" ";
            encMeth = encMeth + "\"" + eMethTag.getEnclosingMethod() + "\" ";
            encMeth = encMeth + "\"" + eMethTag.getEnclosingMethodSig() + "\"\n";
            this.emit(encMeth);
        }
        if (sootClass.hasTag("DeprecatedTag")) {
            this.emit(".deprecated\n");
        }
        if (sootClass.hasTag("SignatureTag")) {
            String sigAttr = ".signature_attr ";
            SignatureTag sigTag = (SignatureTag)sootClass.getTag("SignatureTag");
            sigAttr = sigAttr + "\"" + sigTag.getSignature() + "\"\n";
            this.emit(sigAttr);
        }
        for (Tag t : sootClass.getTags()) {
            if (!t.getName().equals("VisibilityAnnotationTag")) continue;
            this.emit(this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t));
        }
        for (SootField field : sootClass.getFields()) {
            ConstantValueTag val;
            String fieldString = ".field " + Modifier.toString(field.getModifiers()) + " \"" + field.getName() + "\" " + AbstractJasminClass.jasminDescriptorOf(field.getType());
            if (field.hasTag("StringConstantValueTag")) {
                fieldString = fieldString + " = ";
                fieldString = fieldString + StringTools.getQuotedStringOf(((StringConstantValueTag)field.getTag("StringConstantValueTag")).getStringValue());
            } else if (field.hasTag("IntegerConstantValueTag")) {
                fieldString = fieldString + " = ";
                fieldString = fieldString + ((IntegerConstantValueTag)field.getTag("IntegerConstantValueTag")).getIntValue();
            } else if (field.hasTag("LongConstantValueTag")) {
                fieldString = fieldString + " = ";
                fieldString = fieldString + ((LongConstantValueTag)field.getTag("LongConstantValueTag")).getLongValue();
            } else if (field.hasTag("FloatConstantValueTag")) {
                fieldString = fieldString + " = ";
                val = (FloatConstantValueTag)field.getTag("FloatConstantValueTag");
                fieldString = fieldString + this.floatToString(((FloatConstantValueTag)val).getFloatValue());
            } else if (field.hasTag("DoubleConstantValueTag")) {
                fieldString = fieldString + " = ";
                val = (DoubleConstantValueTag)field.getTag("DoubleConstantValueTag");
                fieldString = fieldString + this.doubleToString(((DoubleConstantValueTag)val).getDoubleValue());
            }
            if (field.hasTag("SyntheticTag") || Modifier.isSynthetic(field.getModifiers())) {
                fieldString = fieldString + " .synthetic";
            }
            fieldString = fieldString + "\n";
            if (field.hasTag("DeprecatedTag")) {
                fieldString = fieldString + ".deprecated\n";
            }
            if (field.hasTag("SignatureTag")) {
                fieldString = fieldString + ".signature_attr ";
                SignatureTag sigTag = (SignatureTag)field.getTag("SignatureTag");
                fieldString = fieldString + "\"" + sigTag.getSignature() + "\"\n";
            }
            for (Tag t : field.getTags()) {
                if (!t.getName().equals("VisibilityAnnotationTag")) continue;
                fieldString = fieldString + this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t);
            }
            this.emit(fieldString);
            for (Tag tag : field.getTags()) {
                if (!(tag instanceof Attribute)) continue;
                this.emit(".field_attribute " + tag.getName() + " \"" + new String(Base64.encode(((Attribute)tag).getValue())) + "\"");
            }
        }
        if (sootClass.getFieldCount() != 0) {
            this.emit("");
        }
        Iterator<SootMethod> methodIt = sootClass.methodIterator();
        while (methodIt.hasNext()) {
            this.emitMethod(methodIt.next());
            this.emit("");
        }
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
    }

    protected void assignColorsToLocals(Body body) {
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Assigning colors to locals...");
        }
        if (Options.v().time()) {
            Timers.v().packTimer.start();
        }
        this.localToGroup = new HashMap<Local, Object>(body.getLocalCount() * 2 + 1, 0.7f);
        this.groupToColorCount = new HashMap<Object, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToColor = new HashMap<Local, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local l : body.getLocals()) {
            PrimType g2 = AbstractJasminClass.sizeOfType(l.getType()) == 1 ? IntType.v() : LongType.v();
            this.localToGroup.put(l, g2);
            if (this.groupToColorCount.containsKey(g2)) continue;
            this.groupToColorCount.put(g2, new Integer(0));
        }
        for (Stmt s2 : body.getUnits()) {
            if (!(s2 instanceof IdentityStmt) || !(((IdentityStmt)s2).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s2).getLeftOp();
            Object group = this.localToGroup.get(l);
            int count = this.groupToColorCount.get(group);
            this.localToColor.put(l, new Integer(count));
            this.groupToColorCount.put(group, new Integer(++count));
        }
    }

    protected void emitMethod(SootMethod method) {
        if (method.isPhantom()) {
            return;
        }
        this.emit(".method " + Modifier.toString(method.getModifiers()) + " " + method.getName() + AbstractJasminClass.jasminDescriptorOf(method.makeRef()));
        for (SootClass exceptClass : method.getExceptions()) {
            this.emit(".throws " + exceptClass.getName());
        }
        if (method.hasTag("SyntheticTag") || Modifier.isSynthetic(method.getModifiers())) {
            this.emit(".synthetic");
        }
        if (method.hasTag("DeprecatedTag")) {
            this.emit(".deprecated");
        }
        if (method.hasTag("SignatureTag")) {
            String sigAttr = ".signature_attr ";
            SignatureTag sigTag = (SignatureTag)method.getTag("SignatureTag");
            sigAttr = sigAttr + "\"" + sigTag.getSignature() + "\"";
            this.emit(sigAttr);
        }
        if (method.hasTag("AnnotationDefaultTag")) {
            String annotDefAttr = ".annotation_default ";
            AnnotationDefaultTag annotDefTag = (AnnotationDefaultTag)method.getTag("AnnotationDefaultTag");
            annotDefAttr = annotDefAttr + this.getElemAttr(annotDefTag.getDefaultVal());
            annotDefAttr = annotDefAttr + ".end .annotation_default";
            this.emit(annotDefAttr);
        }
        for (Tag t : method.getTags()) {
            if (t.getName().equals("VisibilityAnnotationTag")) {
                this.emit(this.getVisibilityAnnotationAttr((VisibilityAnnotationTag)t));
            }
            if (!t.getName().equals("VisibilityParameterAnnotationTag")) continue;
            this.emit(this.getVisibilityParameterAnnotationAttr((VisibilityParameterAnnotationTag)t));
        }
        if (method.isConcrete()) {
            if (!method.hasActiveBody()) {
                throw new RuntimeException("method: " + method.getName() + " has no active body!");
            }
            this.emitMethodBody(method);
        }
        this.emit(".end method");
        for (Tag tag : method.getTags()) {
            if (!(tag instanceof Attribute)) continue;
            this.emit(".method_attribute " + tag.getName() + " \"" + new String(Base64.encode(tag.getValue())) + "\"");
        }
    }

    protected abstract void emitMethodBody(SootMethod var1);

    public void print(PrintWriter out) {
        for (String s2 : this.code) {
            out.println(s2);
        }
    }

    protected String doubleToString(DoubleConstant v) {
        String s2 = v.toString();
        if (s2.equals("#Infinity")) {
            s2 = "+DoubleInfinity";
        } else if (s2.equals("#-Infinity")) {
            s2 = "-DoubleInfinity";
        } else if (s2.equals("#NaN")) {
            s2 = "+DoubleNaN";
        }
        return s2;
    }

    protected String doubleToString(double d) {
        String doubleString = new Double(d).toString();
        if (doubleString.equals("NaN")) {
            return "+DoubleNaN";
        }
        if (doubleString.equals("Infinity")) {
            return "+DoubleInfinity";
        }
        if (doubleString.equals("-Infinity")) {
            return "-DoubleInfinity";
        }
        return doubleString;
    }

    protected String floatToString(FloatConstant v) {
        String s2 = v.toString();
        if (s2.equals("#InfinityF")) {
            s2 = "+FloatInfinity";
        } else if (s2.equals("#-InfinityF")) {
            s2 = "-FloatInfinity";
        } else if (s2.equals("#NaNF")) {
            s2 = "+FloatNaN";
        }
        return s2;
    }

    protected String floatToString(float d) {
        String floatString = new Float(d).toString();
        if (floatString.equals("NaN")) {
            return "+FloatNaN";
        }
        if (floatString.equals("Infinity")) {
            return "+FloatInfinity";
        }
        if (floatString.equals("-Infinity")) {
            return "-FloatInfinity";
        }
        return floatString;
    }
}

