/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.Catch;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

public class CopyPropagator
extends DataFlow {
    public CopyPropagator(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, true);
    }

    public DataFlow.Item createInitialItem(FlowGraph graph, Term node) {
        return new DataFlowItem();
    }

    public DataFlow.Item confluence(List inItems, Term node, FlowGraph graph) {
        DataFlowItem result = null;
        Iterator it = inItems.iterator();
        while (it.hasNext()) {
            DataFlowItem inItem = (DataFlowItem)it.next();
            if (result == null) {
                result = new DataFlowItem(inItem);
                continue;
            }
            result.intersect(inItem);
        }
        return result;
    }

    private void killDecl(DataFlowItem dfi, Stmt stmt) {
        if (stmt instanceof LocalDecl) {
            dfi.kill(((LocalDecl)stmt).localInstance());
        }
    }

    protected DataFlowItem flow(DataFlow.Item in, FlowGraph graph, Term t) {
        DataFlowItem result = new DataFlowItem((DataFlowItem)in);
        if (t instanceof Assign) {
            Assign n = (Assign)t;
            Assign.Operator op = n.operator();
            Expr left = n.left();
            Expr right = n.right();
            if (left instanceof Local) {
                LocalInstance to = ((Local)left).localInstance();
                result.kill(to);
                if (right instanceof Local && op == Assign.ASSIGN) {
                    LocalInstance from = ((Local)right).localInstance();
                    result.add(from, to);
                }
            }
        } else if (t instanceof Unary) {
            Unary n = (Unary)t;
            Unary.Operator op = n.operator();
            Expr expr = n.expr();
            if (expr instanceof Local && (op == Unary.POST_INC || op == Unary.POST_DEC || op == Unary.PRE_INC || op == Unary.PRE_DEC)) {
                result.kill(((Local)expr).localInstance());
            }
        } else if (t instanceof LocalDecl) {
            LocalDecl n = (LocalDecl)t;
            LocalInstance to = n.localInstance();
            result.kill(to);
            if (!n.flags().isFinal() && n.init() instanceof Local) {
                LocalInstance from = ((Local)n.init()).localInstance();
                result.add(from, to);
            }
        } else if (t instanceof Block) {
            Block n = (Block)t;
            Iterator it = n.statements().iterator();
            while (it.hasNext()) {
                this.killDecl(result, (Stmt)it.next());
            }
        } else if (t instanceof Loop) {
            if (t instanceof For) {
                For n = (For)t;
                Iterator it = n.inits().iterator();
                while (it.hasNext()) {
                    this.killDecl(result, (Stmt)it.next());
                }
            }
            this.killDecl(result, ((Loop)t).body());
        } else if (t instanceof Catch) {
            result.kill(((Catch)t).formal().localInstance());
        } else if (t instanceof If) {
            If n = (If)t;
            this.killDecl(result, n.consequent());
            this.killDecl(result, n.alternative());
        }
        return result;
    }

    public Map flow(DataFlow.Item in, FlowGraph graph, Term t, Set succEdgeKeys) {
        return CopyPropagator.itemToMap(this.flow(in, graph, t), succEdgeKeys);
    }

    public void post(FlowGraph graph, Term root) throws SemanticException {
        if (Report.should_report("cfg", 2)) {
            this.dumpFlowGraph(graph, root);
        }
    }

    public void check(FlowGraph graph, Term n, DataFlow.Item inItem, Map outItems) throws SemanticException {
        throw new InternalCompilerError("CopyPropagator.check should never be called.");
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof Local) {
            FlowGraph g2 = this.currentFlowGraph();
            if (g2 == null) {
                return n;
            }
            Local l = (Local)n;
            Collection peers = g2.peers(l);
            if (peers == null || peers.isEmpty()) {
                return n;
            }
            ArrayList<DataFlow.Item> items = new ArrayList<DataFlow.Item>();
            Iterator it = peers.iterator();
            while (it.hasNext()) {
                FlowGraph.Peer p = (FlowGraph.Peer)it.next();
                if (p.inItem() == null) continue;
                items.add(p.inItem());
            }
            DataFlowItem in = (DataFlowItem)this.confluence(items, l, g2);
            if (in == null) {
                return n;
            }
            LocalInstance root = in.getRoot(l.localInstance());
            if (root == null) {
                return n;
            }
            return l.name(root.name()).localInstance(root);
        }
        if (n instanceof Unary) {
            return old;
        }
        if (n instanceof Assign) {
            Assign oldAssign = (Assign)old;
            Assign newAssign = (Assign)n;
            return newAssign.left(oldAssign.left());
        }
        return n;
    }

    protected static class DataFlowItem
    extends DataFlow.Item {
        private Map map;

        protected DataFlowItem() {
            this.map = new HashMap();
        }

        protected DataFlowItem(DataFlowItem dfi) {
            this.map = new HashMap(dfi.map.size());
            Iterator it = dfi.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                LocalInstance li = (LocalInstance)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (ci.from == null) continue;
                this.add(ci.from.li, li);
            }
        }

        protected void add(LocalInstance from, LocalInstance to) {
            CopyInfo ciFrom;
            CopyInfo ciTo;
            boolean newTo;
            boolean bl = newTo = !this.map.containsKey(to);
            if (newTo) {
                ciTo = new CopyInfo(to);
                this.map.put(to, ciTo);
            } else {
                ciTo = (CopyInfo)this.map.get(to);
            }
            if (this.map.containsKey(from)) {
                ciFrom = (CopyInfo)this.map.get(from);
            } else {
                ciFrom = new CopyInfo(from);
                this.map.put(from, ciFrom);
                ciFrom.root = ciFrom;
            }
            if (ciTo.from != null) {
                throw new InternalCompilerError("Error while copying dataflow item during copy propagation.");
            }
            ciFrom.to.add(ciTo);
            ciTo.from = ciFrom;
            if (newTo) {
                ciTo.root = ciFrom.root;
            } else {
                ciTo.setRoot(ciFrom.root);
            }
        }

        protected void intersect(DataFlowItem dfi) {
            Map.Entry e;
            boolean modified = false;
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                LocalInstance li = (LocalInstance)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (!dfi.map.containsKey(li)) {
                    modified = true;
                    it.remove();
                    if (ci.from != null) {
                        ci.from.to.remove(ci);
                    }
                    Iterator i = ci.to.iterator();
                    while (i.hasNext()) {
                        CopyInfo toCI = (CopyInfo)i.next();
                        toCI.from = null;
                    }
                    continue;
                }
                if (ci.from == null) continue;
                CopyInfo otherCI = (CopyInfo)dfi.map.get(li);
                CopyInfo otherCIfrom = (CopyInfo)dfi.map.get(ci.from.li);
                if (otherCIfrom != null && otherCI.root == otherCIfrom.root) continue;
                modified = true;
                ci.from.to.remove(ci);
                ci.from = null;
            }
            if (!modified) {
                return;
            }
            it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                e = it.next();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (ci.from != null) continue;
                if (ci.to.isEmpty()) {
                    it.remove();
                    continue;
                }
                ci.setRoot(ci);
            }
        }

        public void kill(LocalInstance var) {
            if (!this.map.containsKey(var)) {
                return;
            }
            CopyInfo ci = (CopyInfo)this.map.get(var);
            this.map.remove(var);
            if (ci.from != null) {
                ci.from.to.remove(ci);
            }
            Iterator it = ci.to.iterator();
            while (it.hasNext()) {
                CopyInfo toCI = (CopyInfo)it.next();
                toCI.from = ci.from;
                if (ci.from == null) {
                    toCI.setRoot(toCI);
                    continue;
                }
                ci.from.to.add(toCI);
            }
        }

        public LocalInstance getRoot(LocalInstance var) {
            if (!this.map.containsKey(var)) {
                return null;
            }
            return ((CopyInfo)this.map.get((Object)var)).root.li;
        }

        private void die() {
            throw new InternalCompilerError("Copy propagation dataflow item consistency error.");
        }

        private void consistencyCheck() {
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                LocalInstance li = (LocalInstance)e.getKey();
                CopyInfo ci = (CopyInfo)e.getValue();
                if (li != ci.li) {
                    this.die();
                }
                if (!this.map.containsKey(ci.root.li)) {
                    this.die();
                }
                if (this.map.get(ci.root.li) != ci.root) {
                    this.die();
                }
                if (ci.from == null) {
                    if (ci.root != ci) {
                        this.die();
                    }
                } else {
                    if (!this.map.containsKey(ci.from.li)) {
                        this.die();
                    }
                    if (this.map.get(ci.from.li) != ci.from) {
                        this.die();
                    }
                    if (ci.from.root != ci.root) {
                        this.die();
                    }
                    if (!ci.from.to.contains(ci)) {
                        this.die();
                    }
                }
                Iterator i = ci.to.iterator();
                while (i.hasNext()) {
                    CopyInfo toCI = (CopyInfo)i.next();
                    if (!this.map.containsKey(toCI.li)) {
                        this.die();
                    }
                    if (this.map.get(toCI.li) != toCI) {
                        this.die();
                    }
                    if (toCI.root != ci.root) {
                        this.die();
                    }
                    if (toCI.from == ci) continue;
                    this.die();
                }
            }
        }

        public int hashCode() {
            int result = 0;
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                result = 31 * result + e.getKey().hashCode();
                result = 31 * result + e.getValue().hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataFlowItem)) {
                return false;
            }
            DataFlowItem dfi = (DataFlowItem)o;
            return ((Object)this.map).equals(dfi.map);
        }

        public String toString() {
            String result = "";
            boolean first = true;
            Iterator it = this.map.values().iterator();
            while (it.hasNext()) {
                CopyInfo ci = (CopyInfo)it.next();
                if (ci.from == null) continue;
                if (!first) {
                    result = result + ", ";
                }
                if (ci.root != ci.from) {
                    result = result + ci.root.li + " ->* ";
                }
                result = result + ci.from.li + " -> " + ci.li;
                first = false;
            }
            return "[" + result + "]";
        }

        protected static class CopyInfo {
            final LocalInstance li;
            CopyInfo from;
            Set to;
            CopyInfo root;

            protected CopyInfo(LocalInstance li) {
                if (li == null) {
                    throw new InternalCompilerError("Null local instance encountered during copy propagation.");
                }
                this.li = li;
                this.from = null;
                this.to = new HashSet();
                this.root = this;
            }

            protected void setRoot(CopyInfo root) {
                ArrayList<CopyInfo> worklist = new ArrayList<CopyInfo>();
                worklist.add(this);
                while (worklist.size() > 0) {
                    CopyInfo ci = (CopyInfo)worklist.remove(worklist.size() - 1);
                    worklist.addAll(ci.to);
                    ci.root = root;
                }
            }

            public boolean equals(Object o) {
                if (!(o instanceof CopyInfo)) {
                    return false;
                }
                CopyInfo ci = (CopyInfo)o;
                return this.li == ci.li && (this.from == null ? ci.from == null : ci.from != null && this.from.li == ci.from.li) && this.root.li == ci.root.li;
            }

            public int hashCode() {
                return this.li.hashCode() + 31 * (this.from == null ? 0 : this.from.li.hashCode() + 31 * this.root.li.hashCode());
            }
        }
    }
}

