/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.StringUtil;

public class PackageContextResolver
implements Resolver {
    protected Package p;
    protected TypeSystem ts;
    protected Resolver cr;

    public PackageContextResolver(TypeSystem ts, Package p, Resolver cr) {
        this.ts = ts;
        this.p = p;
        this.cr = cr;
    }

    public Package package_() {
        return this.p;
    }

    public Resolver outer() {
        return this.cr;
    }

    public Named find(String name) throws SemanticException {
        if (!StringUtil.isNameShort(name)) {
            throw new InternalCompilerError("Cannot lookup qualified name " + name);
        }
        if (this.cr == null) {
            return this.ts.createPackage(this.p, name);
        }
        try {
            return this.cr.find(this.p.fullName() + "." + name);
        }
        catch (NoClassException e) {
            if (!e.getClassName().equals(this.p.fullName() + "." + name)) {
                throw e;
            }
            return this.ts.createPackage(this.p, name);
        }
    }

    public String toString() {
        return "(package-context " + this.p.toString() + ")";
    }
}

