/*
 * Decompiled with CFR 0.152.
 */
package pathexpression;

import java.util.Objects;
import pathexpression.Epsilon;
import pathexpression.IRegEx;

public class RegEx<V>
implements IRegEx<V> {
    public static <V> IRegEx<V> union(IRegEx<V> a, IRegEx<V> b) {
        assert (a != null);
        assert (b != null);
        return RegEx.simplify(new Union<V>(a, b));
    }

    public static <V> IRegEx<V> concatenate(IRegEx<V> a, IRegEx<V> b) {
        assert (a != null);
        assert (b != null);
        return RegEx.simplify(new Concatenate<V>(a, b));
    }

    public static <V> IRegEx<V> reverse(IRegEx<V> a) {
        assert (a != null);
        if (a instanceof EmptySet || a instanceof Epsilon || a instanceof Plain) {
            return a;
        }
        if (a instanceof Concatenate) {
            Concatenate concatenate = (Concatenate)a;
            return RegEx.concatenate(RegEx.reverse(concatenate.getSecond()), RegEx.reverse(concatenate.getFirst()));
        }
        if (a instanceof Union) {
            Union union = (Union)a;
            return RegEx.union(RegEx.reverse(union.getFirst()), RegEx.reverse(union.getSecond()));
        }
        if (a instanceof Star) {
            Star star = (Star)a;
            return RegEx.star(RegEx.reverse(star.getPlain()));
        }
        throw new IllegalStateException("Cannot reverse this regular expression: " + a);
    }

    public static <V> boolean containsEpsilon(IRegEx<V> regex) {
        if (regex instanceof Union) {
            Union con = (Union)regex;
            if (RegEx.containsEpsilon(con.getFirst())) {
                return true;
            }
            return RegEx.containsEpsilon(con.getSecond());
        }
        return regex instanceof Epsilon;
    }

    public static <V> IRegEx<V> star(IRegEx<V> reg) {
        return RegEx.simplify(new Star<V>(reg));
    }

    private static <V> IRegEx<V> simplify(IRegEx<V> in) {
        if (in instanceof Union) {
            Union u = (Union)in;
            if (u.getFirst() instanceof EmptySet) {
                return u.getSecond();
            }
            if (u.getSecond() instanceof EmptySet) {
                return u.getFirst();
            }
            if (u.getFirst().equals(u.getSecond())) {
                return u.getFirst();
            }
            if (u.getFirst() instanceof Epsilon) {
                return u.getSecond();
            }
            if (u.getSecond() instanceof Epsilon) {
                return u.getFirst();
            }
        }
        if (in instanceof Concatenate) {
            Concatenate c = (Concatenate)in;
            IRegEx first = c.getFirst();
            IRegEx second = c.getSecond();
            if (first instanceof EmptySet) {
                return first;
            }
            if (second instanceof EmptySet) {
                return second;
            }
            if (first instanceof Epsilon) {
                return c.getSecond();
            }
            if (second instanceof Epsilon) {
                return c.getFirst();
            }
        }
        if (in instanceof Star) {
            Star star = (Star)in;
            if (star.getPlain() instanceof EmptySet) {
                return star.getPlain();
            }
            if (star.getPlain() instanceof Epsilon) {
                return star.getPlain();
            }
        }
        return in;
    }

    public static class EmptySet<V>
    implements IRegEx<V> {
        public String toString() {
            return "EMPTY";
        }

        public boolean equals(Object obj) {
            return obj instanceof EmptySet;
        }
    }

    public static class Plain<V>
    implements IRegEx<V> {
        public V v;

        public Plain(V v) {
            assert (v != null);
            this.v = v;
        }

        public String toString() {
            return Objects.toString(this.v, "null");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.v == null ? 0 : this.v.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Plain other = (Plain)obj;
            return !(this.v == null ? other.v != null : !this.v.equals(other.v));
        }
    }

    public static class Star<V>
    implements IRegEx<V> {
        public IRegEx<V> a;

        public Star(IRegEx<V> a) {
            assert (a != null);
            this.a = a;
        }

        public String toString() {
            return "[" + Objects.toString(this.a, "null") + "]* ";
        }

        public IRegEx<V> getPlain() {
            return this.a;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Star other = (Star)obj;
            return !(this.a == null ? other.a != null : !this.a.equals(other.a));
        }
    }

    public static class Concatenate<V>
    implements IRegEx<V> {
        public IRegEx<V> b;
        public IRegEx<V> a;

        public Concatenate(IRegEx<V> a, IRegEx<V> b) {
            assert (a != null);
            assert (b != null);
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "(" + Objects.toString(this.a, "null") + " \u00b7 " + Objects.toString(this.b, "null") + ")";
        }

        public IRegEx<V> getFirst() {
            return this.a;
        }

        public IRegEx<V> getSecond() {
            return this.b;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Concatenate other = (Concatenate)obj;
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            return !(this.b == null ? other.b != null : !this.b.equals(other.b));
        }
    }

    public static class Union<V>
    implements IRegEx<V> {
        public IRegEx<V> b;
        public IRegEx<V> a;

        public Union(IRegEx<V> a, IRegEx<V> b) {
            assert (a != null);
            assert (b != null);
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "{" + Objects.toString(this.a, "null") + " U " + Objects.toString(this.b, "null") + "}";
        }

        public IRegEx<V> getFirst() {
            return this.a;
        }

        public IRegEx<V> getSecond() {
            return this.b;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.hashCode(this.a, this.b);
            return result;
        }

        private int hashCode(IRegEx<V> a, IRegEx<V> b) {
            if (a == null && b == null) {
                return 1;
            }
            if (a == null) {
                return b.hashCode();
            }
            if (b == null) {
                return a.hashCode();
            }
            return a.hashCode() + b.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Union other = (Union)obj;
            if (this.matches(this.a, other.a)) {
                return this.matches(this.b, other.b);
            }
            if (this.matches(this.a, other.b)) {
                return this.matches(this.b, other.a);
            }
            return false;
        }

        private boolean matches(IRegEx<V> a, IRegEx<V> b) {
            if (a == null) {
                return b == null;
            }
            return a.equals(b);
        }
    }
}

