/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.UnexpectedClassInfoException;

public class EClassifierInfos {
    private final Map<Triple<String, String, String>, EClassifierInfo> infoMap;
    private final List<EClassifierInfos> parents;
    private final Grammar grammar;

    public List<EClassifierInfos> getParents() {
        return this.parents;
    }

    public EClassifierInfos(Grammar grammar) {
        this.grammar = grammar;
        this.infoMap = Maps.newLinkedHashMap();
        this.parents = Lists.newArrayList();
    }

    public void addParent(EClassifierInfos parent) {
        this.parents.add(parent);
    }

    public boolean addInfo(TypeRef typeRef, EClassifierInfo metatypeInfo) {
        if (typeRef.getMetamodel() == null || typeRef.getClassifier() == null) {
            throw new NullPointerException();
        }
        return this.addInfo(typeRef.getMetamodel(), typeRef.getClassifier().getName(), metatypeInfo);
    }

    public boolean addInfo(AbstractMetamodelDeclaration alias, String name, EClassifierInfo metatypeInfo) {
        return this.infoMap.put(this.getKey(alias, name), metatypeInfo) == null;
    }

    private Triple<String, String, String> getKey(AbstractMetamodelDeclaration metamodelDecl, String name) {
        if (metamodelDecl == null || name == null) {
            throw new NullPointerException("metamodelDecl: " + metamodelDecl + " / name: " + name);
        }
        return Tuples.create(metamodelDecl.getEPackage().getNsURI(), Strings.emptyIfNull(metamodelDecl.getAlias()), name);
    }

    public EClassifierInfo getInfo(TypeRef typeRef) {
        if (typeRef.getClassifier() == null) {
            return null;
        }
        EClassifierInfo result = this.getInfo(typeRef.getMetamodel(), typeRef.getClassifier().getName());
        if (result == null) {
            Grammar declaringGrammar = GrammarUtil.getGrammar(typeRef);
            if (this.grammar.equals(declaringGrammar)) {
                return result;
            }
            for (EClassifierInfos parent : this.parents) {
                result = parent.getInfo(typeRef);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public EClassifierInfo getInfoOrNull(TypeRef typeRef) {
        EClassifierInfo result = this.getInfo(typeRef);
        if (result != null) {
            return result;
        }
        for (EClassifierInfos parent : this.parents) {
            result = parent.getInfoOrNull(typeRef);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public EClassifierInfo getInfo(AbstractMetamodelDeclaration alias, String name) {
        Triple<String, String, String> key = this.getKey(alias, name);
        return this.getInfo(key);
    }

    private EClassifierInfo getInfo(Triple<String, String, String> qualifiedName) {
        return this.infoMap.get(qualifiedName);
    }

    public EClassifierInfo getInfo(EClassifier eClassifier) {
        for (EClassifierInfo info : this.infoMap.values()) {
            if (!info.getEClassifier().equals(eClassifier)) continue;
            return info;
        }
        throw new NullPointerException("cannot find type info for classifier '" + eClassifier.getName() + "'");
    }

    public EClassifierInfo getInfoOrNull(EClassifier eClassifier) {
        if (eClassifier == null) {
            return null;
        }
        for (EClassifierInfo info : this.infoMap.values()) {
            if (!info.getEClassifier().equals(eClassifier)) continue;
            return info;
        }
        for (EClassifierInfos parent : this.parents) {
            EClassifierInfo result = parent.getInfoOrNull(eClassifier);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EClassifierInfo getCompatibleType(EClassifierInfo infoA, EClassifierInfo infoB) {
        if (infoA.equals(infoB)) {
            return infoA;
        }
        if (infoA.getEClassifier() instanceof EDataType || infoB.getEClassifier() instanceof EDataType) {
            throw new IllegalArgumentException("Simple Datatypes (lexer rules or keywords) do not have a common supertype (" + infoA + ", " + infoB + ")");
        }
        EClassifier compatibleType = EcoreUtil2.getCompatibleType(infoA.getEClassifier(), infoB.getEClassifier(), this.grammar);
        return this.getInfoOrNull(compatibleType);
    }

    public EClassifierInfo getCompatibleTypeOf(Collection<EClassifierInfo> types) {
        Iterator<EClassifierInfo> i = types.iterator();
        if (!i.hasNext()) {
            throw new IllegalArgumentException("Empty set of types cannot have a compatible type.");
        }
        EClassifierInfo result = i.next();
        while (i.hasNext()) {
            result = this.getCompatibleType(result, i.next());
        }
        if (result == null) {
            return this.getInfoOrNull(GrammarUtil.findEObject(this.grammar));
        }
        return result;
    }

    public List<EClassifierInfo.EClassInfo> getAllEClassInfos() {
        ArrayList<EClassifierInfo.EClassInfo> result = new ArrayList<EClassifierInfo.EClassInfo>();
        for (EClassifierInfo classifier : this.infoMap.values()) {
            if (!(classifier instanceof EClassifierInfo.EClassInfo)) continue;
            result.add((EClassifierInfo.EClassInfo)classifier);
        }
        return Collections.unmodifiableList(result);
    }

    public List<EClassifierInfo.EClassInfo> getSuperTypeInfos(EClassifierInfo.EClassInfo subTypeInfo) throws UnexpectedClassInfoException {
        ArrayList<EClassifierInfo.EClassInfo> result = new ArrayList<EClassifierInfo.EClassInfo>();
        EList<EClass> superTypes = subTypeInfo.getEClass().getESuperTypes();
        for (int i = 0; i < superTypes.size(); ++i) {
            EClassifierInfo info;
            URI proxyURI;
            EClass superType = (EClass)superTypes.get(i);
            if (superType.eIsProxy() && (proxyURI = EcoreUtil.getURI(superType)).isPlatformResource()) {
                String platformString = proxyURI.toPlatformString(true);
                URI platformPluginURI = URI.createPlatformPluginURI(platformString, true).appendFragment(proxyURI.fragment());
                EObject secondAttempt = subTypeInfo.getEClass().eResource().getResourceSet().getEObject(platformPluginURI, true);
                if (secondAttempt instanceof EClass) {
                    superType = (EClass)secondAttempt;
                    superTypes.set(i, superType);
                }
            }
            if ((info = this.getInfoOrNull(superType)) != null) {
                if (info instanceof EClassifierInfo.EClassInfo) {
                    result.add((EClassifierInfo.EClassInfo)info);
                    continue;
                }
                throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, info, null);
            }
            if (superType.eIsProxy()) {
                throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, null, "Cannot load all supertypes of  '" + subTypeInfo.getEClass().getName() + "'");
            }
            if (!this.isPackageKnown(superType.getEPackage().getNsURI())) continue;
            throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, null, "Cannot find info for type '" + superType.getName() + "'");
        }
        return result;
    }

    private boolean isPackageKnown(String nsURI) {
        for (Triple<String, String, String> key : this.infoMap.keySet()) {
            if (!((String)key.getFirst()).equals(nsURI)) continue;
            return true;
        }
        for (EClassifierInfos parent : this.parents) {
            if (!parent.isPackageKnown(nsURI)) continue;
            return true;
        }
        return false;
    }
}

