/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.xtext.SuperCallScope;

public class XtextScopeProvider
extends AbstractScopeProvider {
    @Inject
    private IResourceDescription.Manager resourceDescriptionManager;
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IScope getScope(final EObject context, EReference reference) {
        if (reference == XtextPackage.eINSTANCE.getTypeRef_Classifier()) {
            if (!(context instanceof TypeRef)) return this.createReferencedPackagesScope(GrammarUtil.getGrammar(context));
            TypeRef typeRef = (TypeRef)context;
            AbstractMetamodelDeclaration metaModel = typeRef.getMetamodel();
            if (metaModel == null) return this.createReferencedPackagesScope(GrammarUtil.getGrammar(context));
            EPackage pack = metaModel.getEPackage();
            if (pack == null) return IScope.NULLSCOPE;
            return this.createClassifierScope(Collections.singletonList(pack));
        }
        if (reference == XtextPackage.eINSTANCE.getEnumLiteralDeclaration_EnumLiteral()) {
            EnumRule rule = GrammarUtil.containingEnumRule(context);
            if (rule.getType() == null || rule.getType().getClassifier() == null || !(rule.getType().getClassifier() instanceof EEnum)) return IScope.NULLSCOPE;
            return this.createEnumLiteralsScope((EEnum)rule.getType().getClassifier());
        }
        if (reference == XtextPackage.eINSTANCE.getGrammar_UsedGrammars()) {
            return this.globalScopeProvider.getScope(context.eResource(), reference, new Predicate<IEObjectDescription>(){

                @Override
                public boolean apply(IEObjectDescription input) {
                    return !input.getEObjectURI().equals(EcoreUtil.getURI(context));
                }
            });
        }
        if (reference == XtextPackage.eINSTANCE.getRuleCall_Rule()) {
            return this.createScope(context.eResource(), reference.getEReferenceType(), (IScope)new SuperCallScope(context));
        }
        if (reference == XtextPackage.eINSTANCE.getParameterReference_Parameter()) {
            ParserRule rule = GrammarUtil.containingParserRule(context);
            if (rule != null) return Scopes.scopeFor(rule.getParameters());
            return IScope.NULLSCOPE;
        }
        if (reference != XtextPackage.eINSTANCE.getNamedArgument_Parameter()) return this.createScope(context.eResource(), reference.getEReferenceType(), IScope.NULLSCOPE);
        RuleCall ruleCall = EcoreUtil2.getContainerOfType(context, RuleCall.class);
        if (ruleCall == null) {
            return IScope.NULLSCOPE;
        }
        AbstractRule referencedRule = ruleCall.getRule();
        if (!(referencedRule instanceof ParserRule)) return IScope.NULLSCOPE;
        return Scopes.scopeFor(((ParserRule)referencedRule).getParameters());
    }

    protected IScope createEnumLiteralsScope(EEnum eEnum) {
        return new SimpleScope(IScope.NULLSCOPE, Iterables.transform(eEnum.getELiterals(), new Function<EEnumLiteral, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(EEnumLiteral param) {
                return EObjectDescription.create(QualifiedName.create(param.getName()), (EObject)param);
            }
        }));
    }

    protected IScope createClassifierScope(final List<EPackage> packages) {
        return new SimpleScope(IScope.NULLSCOPE, FluentIterable.from(packages).transformAndConcat(EPackage::getEClassifiers).transform(classifier -> EObjectDescription.create(QualifiedName.create(classifier.getName()), (EObject)classifier))){

            @Override
            protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
                if (name.getSegmentCount() == 1) {
                    EClassifier candidate = null;
                    for (EPackage pack : packages) {
                        EClassifier classifier = pack.getEClassifier(name.getFirstSegment());
                        if (classifier == null) continue;
                        if (candidate != null) {
                            return null;
                        }
                        candidate = classifier;
                    }
                    if (candidate != null) {
                        return EObjectDescription.create(name, candidate);
                    }
                }
                return null;
            }
        };
    }

    protected IScope createReferencedPackagesScope(Grammar g2) {
        ArrayList<EPackage> allPackages = new ArrayList<EPackage>();
        for (AbstractMetamodelDeclaration decl : g2.getMetamodelDeclarations()) {
            if (decl.getEPackage() == null) continue;
            allPackages.add(decl.getEPackage());
        }
        return this.createClassifierScope(allPackages);
    }

    protected IScope createScope(Resource resource, EClass type, IScope parent) {
        if (resource.getContents().size() < 1) {
            throw new IllegalArgumentException("resource is not as expected: contents.size == " + resource.getContents().size() + " but expected: >= 1");
        }
        EObject firstContent = (EObject)resource.getContents().get(0);
        if (!(firstContent instanceof Grammar)) {
            return parent;
        }
        return this.createScope((Grammar)firstContent, type, parent);
    }

    protected IScope createScope(Grammar grammar, EClass type, IScope current) {
        if (EcorePackage.Literals.EPACKAGE == type) {
            return this.createEPackageScope(grammar);
        }
        if (AbstractMetamodelDeclaration.class.isAssignableFrom(type.getInstanceClass())) {
            return new SimpleScope(IScope.NULLSCOPE, Iterables.transform(grammar.getMetamodelDeclarations(), new Function<AbstractMetamodelDeclaration, IEObjectDescription>(){

                @Override
                public IEObjectDescription apply(AbstractMetamodelDeclaration from) {
                    String name = from.getAlias() != null ? from.getAlias() : "";
                    return EObjectDescription.create(QualifiedName.create(name), (EObject)from);
                }
            }));
        }
        List<Grammar> allGrammars = this.getAllGrammars(grammar);
        for (int i = allGrammars.size() - 1; i >= 0; --i) {
            current = this.doCreateScope(allGrammars.get(i), type, current);
        }
        return current;
    }

    protected IScope doCreateScope(Grammar grammar, EClass type, IScope parent) {
        IResourceDescription resourceDescription = this.resourceDescriptionManager.getResourceDescription(grammar.eResource());
        return SelectableBasedScope.createScope(parent, resourceDescription, type, false);
    }

    protected List<Grammar> getAllGrammars(Grammar grammar) {
        ArrayList<Grammar> result = Lists.newArrayList(grammar);
        result.addAll(GrammarUtil.allUsedGrammars(grammar));
        return result;
    }

    protected IScope createEPackageScope(Grammar grammar, IScope parent) {
        return new SimpleScope(parent, Iterables.transform(Iterables.filter(grammar.getMetamodelDeclarations(), new Predicate<AbstractMetamodelDeclaration>(){

            @Override
            public boolean apply(AbstractMetamodelDeclaration input) {
                return input.getEPackage() != null;
            }
        }), new Function<AbstractMetamodelDeclaration, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(AbstractMetamodelDeclaration from) {
                return EObjectDescription.create(QualifiedName.create(from.getEPackage().getNsURI()), (EObject)from.getEPackage());
            }
        }));
    }

    protected IScope createEPackageScope(Grammar grammar) {
        List<Grammar> allGrammars = this.getAllGrammars(grammar);
        IScope current = new SimpleScope(IScope.NULLSCOPE, Iterables.transform(EPackage.Registry.INSTANCE.keySet(), new Function<String, IEObjectDescription>(){

            @Override
            public IEObjectDescription apply(String from) {
                InternalEObject proxyPackage = (InternalEObject)((Object)EcoreFactory.eINSTANCE.createEPackage());
                proxyPackage.eSetProxyURI(URI.createURI(from));
                return EObjectDescription.create(QualifiedName.create(from), (EObject)proxyPackage, Collections.singletonMap("nsURI", "true"));
            }
        }));
        for (int i = allGrammars.size() - 1; i >= 0; --i) {
            current = this.createEPackageScope(allGrammars.get(i), current);
        }
        return current;
    }
}

