/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.override;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.override.BottomResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideTester;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.ContextualVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.typesystem.util.StandardTypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

@Singleton
public class OverrideHelper {
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private OverrideTester overrideTester;

    public LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, ITypeReferenceOwner owner, IVisibilityHelper visibilityHelper) {
        TypeParameterSubstitutor<?> substitutor;
        if (operation.getVisibility() == JvmVisibility.PRIVATE || !InferredTypeIndicator.isInferred(operation.getReturnType())) {
            return null;
        }
        ParameterizedTypeReference declaringType = owner.newParameterizedTypeReference(operation.getDeclaringType());
        JvmOperation overriddenOperation = this.findOverriddenOperation(operation, declaringType, substitutor = this.createSubstitutor(owner, declaringType), owner, visibilityHelper);
        if (overriddenOperation != null) {
            return substitutor.substitute(owner.toLightweightTypeReference(overriddenOperation.getReturnType()));
        }
        return null;
    }

    public LightweightTypeReference getReturnTypeOfOverriddenOperation(JvmOperation operation, LightweightTypeReference context) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE || !InferredTypeIndicator.isInferred(operation.getReturnType())) {
            return null;
        }
        BottomResolvedOperation resolvedOperation = new BottomResolvedOperation(operation, context, this.overrideTester);
        List<IResolvedOperation> overriddenMethods = resolvedOperation.getOverriddenAndImplementedMethods();
        if (overriddenMethods.isEmpty()) {
            return null;
        }
        LightweightTypeReference result = overriddenMethods.get(0).getResolvedReturnType();
        return result;
    }

    protected JvmOperation findOverriddenOperation(JvmOperation operation, LightweightTypeReference declaringType, TypeParameterSubstitutor<?> substitutor, ITypeReferenceOwner owner, IVisibilityHelper visibilityHelper) {
        int parameterSize = operation.getParameters().size();
        List<LightweightTypeReference> superTypes = declaringType.getSuperTypes();
        for (LightweightTypeReference superType : superTypes) {
            JvmDeclaredType declaredSuperType;
            if (!(superType.getType() instanceof JvmDeclaredType) || (declaredSuperType = (JvmDeclaredType)superType.getType()) == null) continue;
            Iterable<JvmFeature> equallyNamedFeatures = declaredSuperType.findAllFeaturesByName(operation.getSimpleName());
            for (JvmFeature feature : equallyNamedFeatures) {
                JvmOperation candidate;
                if (!(feature instanceof JvmOperation) || parameterSize != (candidate = (JvmOperation)feature).getParameters().size() || !visibilityHelper.isVisible(feature)) continue;
                boolean matchesSignature = true;
                for (int i = 0; i < parameterSize && matchesSignature; ++i) {
                    JvmFormalParameter parameter = (JvmFormalParameter)operation.getParameters().get(i);
                    JvmFormalParameter candidateParameter = (JvmFormalParameter)candidate.getParameters().get(i);
                    matchesSignature = this.isMatchesSignature(parameter, candidateParameter, substitutor, owner);
                }
                if (!matchesSignature) continue;
                return candidate;
            }
        }
        return null;
    }

    protected boolean isMatchesSignature(JvmFormalParameter parameter, JvmFormalParameter candidateParameter, TypeParameterSubstitutor<?> substitutor, ITypeReferenceOwner owner) {
        JvmTypeReference parameterType = parameter.getParameterType();
        if (parameterType == null || parameterType.getType() == null) {
            return false;
        }
        String identifier = parameterType.getIdentifier();
        LightweightTypeReference candidateParameterType = substitutor.substitute(owner.toLightweightTypeReference(candidateParameter.getParameterType()));
        return identifier.equals(candidateParameterType.getJavaIdentifier());
    }

    protected TypeParameterSubstitutor<?> createSubstitutor(ITypeReferenceOwner owner, LightweightTypeReference declaringType) {
        Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> parameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(declaringType);
        StandardTypeParameterSubstitutor substitutor = new StandardTypeParameterSubstitutor(parameterMapping, owner);
        return substitutor;
    }

    public JvmOperation findOverriddenOperation(JvmOperation operation) {
        if (operation.getVisibility() == JvmVisibility.PRIVATE) {
            return null;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, operation.eResource().getResourceSet());
        LightweightTypeReference declaringType = owner.toLightweightTypeReference(operation.getDeclaringType());
        TypeParameterSubstitutor<?> substitutor = this.createSubstitutor(owner, declaringType);
        return this.findOverriddenOperation(operation, declaringType, substitutor, owner, new ContextualVisibilityHelper(this.visibilityHelper, declaringType));
    }

    public ResolvedFeatures getResolvedFeatures(JvmDeclaredType type) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, type.eResource().getResourceSet());
        LightweightTypeReference contextType = owner.toLightweightTypeReference(type);
        return this.getResolvedFeatures(contextType);
    }

    public ResolvedFeatures getResolvedFeatures(JvmDeclaredType type, JavaVersion targetVersion) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, type.eResource().getResourceSet());
        LightweightTypeReference contextType = owner.toLightweightTypeReference(type);
        return this.getResolvedFeatures(contextType, targetVersion);
    }

    public ResolvedFeatures getResolvedFeatures(JvmTypeReference contextType) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, contextType.eResource().getResourceSet());
        return this.getResolvedFeatures(owner.toLightweightTypeReference(contextType));
    }

    public ResolvedFeatures getResolvedFeatures(JvmTypeReference contextType, JavaVersion targetVersion) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, contextType.eResource().getResourceSet());
        return this.getResolvedFeatures(owner.toLightweightTypeReference(contextType), targetVersion);
    }

    public ResolvedFeatures getResolvedFeatures(LightweightTypeReference contextType) {
        return new ResolvedFeatures(contextType, this.overrideTester);
    }

    public ResolvedFeatures getResolvedFeatures(LightweightTypeReference contextType, JavaVersion targetVersion) {
        return new ResolvedFeatures(contextType, this.overrideTester, targetVersion);
    }
}

